/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.character;

import java.io.IOException;
import org.gdstash.db.DBSkill;
import org.gdstash.file.GDReader;
import org.gdstash.file.GDWriter;

public class GDCharSkill {
    private static final String PATTERN_MASTERY = "records/skills/playerclass(.*)/_classtraining_class(.*).dbr";
    private String name;
    private String autoCastSkill;
    private String autoCastController;
    private int level;
    private int devotionLevel;
    private int experience;
    private int active;
    private byte enabled;
    private byte unknown1;
    private byte unknown2;
    private DBSkill dbSkill;

    public String getID() {
        return this.name;
    }

    public int getLevel() {
        if (this.isDevotion()) {
            if (this.level == 0) {
                return 0;
            }
            return this.devotionLevel;
        }
        return this.level;
    }

    public int getSkillLevel() {
        return this.level;
    }

    public int getDevotionLevel() {
        return this.devotionLevel;
    }

    public int getMaxLevel() {
        if (this.dbSkill == null) {
            return 0;
        }
        return this.dbSkill.getMaxLevel();
    }

    public boolean isMastery() {
        if (this.dbSkill == null) {
            return false;
        }
        return this.dbSkill.isMastery();
    }

    public boolean isDevotion() {
        if (this.dbSkill == null) {
            return false;
        }
        return this.dbSkill.isDevotion();
    }

    public boolean isEnabled() {
        return this.enabled == 1;
    }

    public void setLevel(int level) {
        if (this.isDevotion()) {
            if (this.devotionLevel == level) {
                return;
            }
            this.devotionLevel = level > this.dbSkill.getMaxLevel() ? this.dbSkill.getMaxLevel() : level;
            level = this.devotionLevel > 0 ? 1 : 0;
            this.experience = this.dbSkill.getXPForLevel(this.devotionLevel);
        } else {
            this.level = level;
        }
    }

    public void read() throws IOException {
        this.name = GDReader.readEncString();
        this.level = GDReader.readEncInt(true);
        this.enabled = GDReader.readEncByte();
        this.devotionLevel = GDReader.readEncInt(true);
        this.experience = GDReader.readEncInt(true);
        this.active = GDReader.readEncInt(true);
        this.unknown1 = GDReader.readEncByte();
        this.unknown2 = GDReader.readEncByte();
        this.autoCastSkill = GDReader.readEncString();
        this.autoCastController = GDReader.readEncString();
        if (this.name != null) {
            this.dbSkill = DBSkill.get(this.name);
        }
    }

    public void write() throws IOException {
        GDWriter.writeString(this.name);
        GDWriter.writeInt(this.level);
        GDWriter.writeByte(this.enabled);
        GDWriter.writeInt(this.devotionLevel);
        GDWriter.writeInt(this.experience);
        GDWriter.writeInt(this.active);
        GDWriter.writeByte(this.unknown1);
        GDWriter.writeByte(this.unknown2);
        GDWriter.writeString(this.autoCastSkill);
        GDWriter.writeString(this.autoCastController);
    }

    public int getByteSize() {
        int size = 0;
        size += 4;
        if (this.name != null) {
            size += this.name.length();
        }
        size += 4;
        ++size;
        size += 4;
        size += 4;
        size += 4;
        ++size;
        ++size;
        size += 4;
        if (this.autoCastSkill != null) {
            size += this.autoCastSkill.length();
        }
        size += 4;
        if (this.autoCastController != null) {
            size += this.autoCastController.length();
        }
        return size;
    }
}

