/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.character;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.character.GDChar;
import org.gdstash.character.GDCharItemSkill;
import org.gdstash.character.GDCharSkill;
import org.gdstash.file.GDReader;
import org.gdstash.file.GDWriter;
import org.gdstash.util.GDMsgFormatter;

public class GDCharSkillList {
    private static final int VERSION = 5;
    private static final int BLOCK = 8;
    private int version;
    private List<GDCharSkill> charSkills = new LinkedList<GDCharSkill>();
    private List<GDCharItemSkill> itemSkills = new LinkedList<GDCharItemSkill>();
    private int masteriesAllowed;
    private int skillReclamationPointsUsed;
    private int devotionReclamationPointsUsed;
    private boolean changed;

    public int getSkillReclaimPoints() {
        return this.skillReclamationPointsUsed;
    }

    public int getDevotionReclaimPoints() {
        return this.devotionReclamationPointsUsed;
    }

    public List<GDCharSkill> getMasteries() {
        LinkedList<GDCharSkill> masteries = new LinkedList<GDCharSkill>();
        if (this.charSkills != null) {
            for (GDCharSkill skill : this.charSkills) {
                if (!skill.isMastery()) continue;
                masteries.add(skill);
            }
        }
        return masteries;
    }

    public List<GDCharSkill> getDevotions() {
        LinkedList<GDCharSkill> devotions = new LinkedList<GDCharSkill>();
        if (this.charSkills != null) {
            for (GDCharSkill skill : this.charSkills) {
                if (!skill.isDevotion() || skill.getSkillLevel() <= 0) continue;
                devotions.add(skill);
            }
        }
        return devotions;
    }

    public int getSkillMaxLevel(String skillID) {
        int maxLevel = 0;
        if (this.charSkills != null) {
            for (GDCharSkill skill : this.charSkills) {
                if (!skill.getID().equals(skillID)) continue;
                maxLevel = skill.getMaxLevel();
                break;
            }
        }
        return maxLevel;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setSkillReclaimPoints(int skillReclamationPointsUsed) {
        this.skillReclamationPointsUsed = skillReclamationPointsUsed;
        this.changed = true;
    }

    public void setDevotionReclaimPoints(int devotionReclamationPointsUsed) {
        this.devotionReclamationPointsUsed = devotionReclamationPointsUsed;
        this.changed = true;
    }

    public void setSkillLevel(GDChar.SkillInfo[] infos) {
        if (infos == null) {
            return;
        }
        block0: for (int i = 0; i < infos.length; ++i) {
            for (GDCharSkill skill : this.charSkills) {
                if (!skill.getID().equals(infos[i].id)) continue;
                skill.setLevel(infos[i].points);
                continue block0;
            }
        }
        this.changed = true;
    }

    public void setMasteriesAllowed(int num) {
        this.masteriesAllowed = num;
    }

    public void read() throws IOException {
        Object skill;
        int i;
        int val = 0;
        GDReader.Block block = new GDReader.Block();
        val = GDReader.readBlockStart(block);
        if (val != 8) {
            throw new IOException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"));
        }
        this.version = GDReader.readEncInt(true);
        if (this.version != 5) {
            throw new IOException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"));
        }
        this.charSkills.clear();
        val = GDReader.readEncInt(true);
        for (i = 0; i < val; ++i) {
            skill = new GDCharSkill();
            ((GDCharSkill)skill).read();
            this.charSkills.add((GDCharSkill)skill);
        }
        this.masteriesAllowed = GDReader.readEncInt(true);
        this.skillReclamationPointsUsed = GDReader.readEncInt(true);
        this.devotionReclamationPointsUsed = GDReader.readEncInt(true);
        this.itemSkills.clear();
        val = GDReader.readEncInt(true);
        for (i = 0; i < val; ++i) {
            skill = new GDCharItemSkill();
            ((GDCharItemSkill)skill).read();
            this.itemSkills.add((GDCharItemSkill)skill);
        }
        GDReader.readBlockEnd(block);
        this.changed = false;
    }

    public void write() throws IOException {
        GDReader.Block block = new GDReader.Block();
        GDWriter.writeBlockStart(block, 8);
        GDWriter.writeInt(this.version);
        int val = this.charSkills.size();
        GDWriter.writeInt(val);
        for (GDCharSkill gDCharSkill : this.charSkills) {
            if (gDCharSkill == null) continue;
            gDCharSkill.write();
        }
        GDWriter.writeInt(this.masteriesAllowed);
        GDWriter.writeInt(this.skillReclamationPointsUsed);
        GDWriter.writeInt(this.devotionReclamationPointsUsed);
        val = this.itemSkills.size();
        GDWriter.writeInt(val);
        for (GDCharItemSkill gDCharItemSkill : this.itemSkills) {
            if (gDCharItemSkill == null) continue;
            gDCharItemSkill.write();
        }
        GDWriter.writeBlockEnd(block);
        this.changed = false;
    }

    public int getByteSize() {
        int size = 0;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        for (GDCharSkill gDCharSkill : this.charSkills) {
            if (gDCharSkill == null) continue;
            size += gDCharSkill.getByteSize();
        }
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        for (GDCharItemSkill gDCharItemSkill : this.itemSkills) {
            if (gDCharItemSkill == null) continue;
            size += gDCharItemSkill.getByteSize();
        }
        return size += 4;
    }
}

