/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.character;

import org.gdstash.character.GDCharHeader;
import org.gdstash.character.GDCharInfo;
import org.gdstash.db.DBEngineTagText;

public class GDCharSummary {
    private String charName;
    private byte sex;
    private String classID;
    private int level;
    private boolean hardcore;
    private boolean isInMainQuest;
    private String className;

    public GDCharSummary(GDCharHeader header, GDCharInfo info) {
        this.charName = header.getCharName();
        this.sex = header.getSex();
        this.classID = header.getClassID();
        this.level = header.getLevel();
        this.hardcore = header.isHardcore();
        this.isInMainQuest = info.isInMainQuest();
        this.className = this.parseClassName();
    }

    public String getCharName() {
        return this.charName;
    }

    public byte getSex() {
        return this.sex;
    }

    public String getClassName() {
        return this.className;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean isHardcore() {
        return this.hardcore;
    }

    public boolean isInMainQuest() {
        return this.isInMainQuest;
    }

    private String parseClassName() {
        DBEngineTagText tt = null;
        String s = "???";
        if (this.classID != null) {
            tt = DBEngineTagText.get(this.classID);
        }
        if (tt != null) {
            s = this.sex == 1 ? tt.getText(0) : tt.getText(1);
        }
        return s;
    }

    public void updateClassName() {
        this.className = this.parseClassName();
    }
}

