/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.character;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.file.GDReader;
import org.gdstash.file.GDWriter;
import org.gdstash.util.GDMsgFormatter;

public class GDCharTutorialList {
    private static final int VERSION = 1;
    private static final int BLOCK = 15;
    private int version;
    private List<Integer> pages = new LinkedList<Integer>();

    public void addTutorial(int page) {
        boolean found = false;
        for (int i : this.pages) {
            if (i != page) continue;
            found = true;
            break;
        }
        if (!found) {
            this.pages.add(page);
        }
    }

    public void read() throws IOException {
        int val = 0;
        GDReader.Block block = new GDReader.Block();
        val = GDReader.readBlockStart(block);
        if (val != 15) {
            throw new IOException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"));
        }
        this.version = GDReader.readEncInt(true);
        if (this.version != 1) {
            throw new IOException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"));
        }
        this.pages.clear();
        val = GDReader.readEncInt(true);
        for (int i = 0; i < val; ++i) {
            int page = GDReader.readEncInt(true);
            this.pages.add(new Integer(page));
        }
        GDReader.readBlockEnd(block);
    }

    public void write() throws IOException {
        GDReader.Block block = new GDReader.Block();
        GDWriter.writeBlockStart(block, 15);
        GDWriter.writeInt(this.version);
        int val = this.pages.size();
        GDWriter.writeInt(val);
        for (Integer i : this.pages) {
            int page = i;
            GDWriter.writeInt(page);
        }
        GDWriter.writeBlockEnd(block);
    }

    public int getByteSize() {
        int size = 0;
        size += 4;
        size += 4;
        size += 4;
        size += 4;
        size += 4 * this.pages.size();
        return size += 4;
    }
}

