/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.character;

import java.io.IOException;
import org.gdstash.file.GDReader;
import org.gdstash.file.GDWriter;

public class GDCharUID {
    private byte[] uid;

    public GDCharUID() {
        this.uid = new byte[16];
    }

    public GDCharUID(byte[] uid) {
        this.uid = uid;
        if (uid.length != 16) {
            this.uid = new byte[16];
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != GDCharUID.class) {
            return false;
        }
        GDCharUID guid = (GDCharUID)o;
        for (int i = 0; i < this.uid.length; ++i) {
            if (this.uid[i] > guid.uid[i]) {
                return false;
            }
            if (this.uid[i] >= guid.uid[i]) continue;
            return false;
        }
        return true;
    }

    public void read() throws IOException {
        for (int i = 0; i < this.uid.length; ++i) {
            this.uid[i] = GDReader.readEncByte();
        }
    }

    public void write() throws IOException {
        for (int i = 0; i < this.uid.length; ++i) {
            GDWriter.writeByte(this.uid[i]);
        }
    }

    public static int getByteSize() {
        return 16;
    }

    public void println() {
        String s = "";
        for (int i = 0; i < this.uid.length; ++i) {
            String b = Byte.toString(this.uid[i]);
            while (b.length() < 4) {
                b = " " + b;
            }
            s = i == 0 ? b : s + ", " + b;
        }
        System.out.println(s);
    }
}

