/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.gdstash.db.DBSkill;
import org.gdstash.db.DBSkillBonus;
import org.gdstash.db.DBStat;
import org.gdstash.db.DBStatBonusRace;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.description.BonusDetail;
import org.gdstash.description.DetailComposer;
import org.gdstash.file.ARZDecompress;
import org.gdstash.file.ARZRecord;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBAffix
implements Comparable<DBAffix> {
    public static final String TABLE_NAME = "GD_AFFIX";
    public static final String FIELD_ID = "AFFIX_ID";
    private static final int ROW_AFFIX_ID = 1;
    private static final int ROW_RARITY = 2;
    private static final int ROW_NAME_MS = 3;
    private static final int ROW_NAME_FS = 4;
    private static final int ROW_NAME_NS = 5;
    private static final int ROW_NAME_MP = 6;
    private static final int ROW_NAME_FP = 7;
    private static final int ROW_NAME_NP = 8;
    private static final int ROW_REQ_LEVEL = 9;
    private static final int ROW_TYPE = 10;
    private static final int ROW_CONVERT_IN = 11;
    private static final int ROW_CONVERT_OUT = 12;
    private static final int ROW_OFFENSIVE_CHANCE = 13;
    private static final int ROW_RETALIATION_CHANCE = 14;
    private static final int ROW_LOOT_RANDOM_COST = 15;
    private static final int ROW_PET_AFFIX_ID = 16;
    private static final int ROW_ITEM_SKILL_ID = 17;
    private static final int ROW_RNG_PERCENT = 18;
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_PREFIX = 1;
    public static final int TYPE_SUFFIX = 2;
    public static final int TYPE_MODIFIER = 3;
    public static final int TYPE_COMPLETION = 4;
    public static final String HTML_COLOR_LEGENDARY = "<font color = \"#320064\">";
    public static final String HTML_COLOR_EPIC = "<font color = \"#002864\">";
    public static final String HTML_COLOR_RARE = "<font color = \"#00460A\">";
    public static final String HTML_COLOR_MAGIC = "<font color = \"#B48200\">";
    public static final String HTML_COLOR_QUEST = "<font color = \"#320064\">";
    public static final String HTML_COLOR_END = "</font>";
    private static List<DBAffix> listBuffer = null;
    private static List<DBAffix> listPrefix = null;
    private static List<DBAffix> listSuffix = null;
    private static ConcurrentHashMap<String, DBAffix> hashBuffer = new ConcurrentHashMap();
    private static boolean bufferComplete = false;
    private String affixID;
    private String nameMS;
    private String nameFS;
    private String nameNS;
    private String nameMP;
    private String nameFP;
    private String nameNP;
    private String rarity;
    private int reqLevel;
    private int type;
    private String convertIn;
    private String convertOut;
    private int offensiveChance;
    private int retaliationChance;
    private int lootRandomCost;
    private String petAffixID;
    private String itemSkillID;
    private int rngPercent;
    private List<DBStat> stats;
    private List<DBStatBonusRace> statBonusRaces;
    private List<DBSkillBonus> bonuses;
    private DBAffix dbPetAffix;
    private DBSkill dbPetSkill;
    private DBSkill dbItemSkill;
    private String strDescription;

    public DBAffix() {
        this.affixID = null;
        this.nameMS = null;
        this.nameFS = null;
        this.nameNS = null;
        this.nameMP = null;
        this.nameFP = null;
        this.nameNP = null;
        this.rarity = null;
        this.reqLevel = 0;
        this.type = -1;
        this.convertIn = null;
        this.convertOut = null;
        this.offensiveChance = 0;
        this.retaliationChance = 0;
        this.lootRandomCost = 0;
        this.petAffixID = null;
        this.itemSkillID = null;
        this.statBonusRaces = new LinkedList<DBStatBonusRace>();
        this.stats = new LinkedList<DBStat>();
        this.bonuses = new LinkedList<DBSkillBonus>();
        this.dbPetAffix = null;
        this.dbPetSkill = null;
        this.dbItemSkill = null;
        this.rngPercent = 0;
        this.strDescription = null;
    }

    private DBAffix(ARZRecord record) {
        this.affixID = record.getFileName();
        this.determineAffixType(record.getFileName());
        this.setLootRandomName(record.getLootRandomName());
        this.rarity = record.getRarity();
        this.reqLevel = record.getRequiredLevel();
        this.convertIn = record.getConversionIn();
        this.convertOut = record.getConversionOut();
        this.offensiveChance = record.getOffensiveChance();
        this.retaliationChance = record.getRetaliationChance();
        this.lootRandomCost = record.getLootRandomCost();
        this.petAffixID = record.getPetBonusID();
        this.itemSkillID = record.getItemSkillID();
        this.statBonusRaces = record.getDBStatBonusRaceList();
        this.stats = record.getDBStatList();
        this.bonuses = record.dbSkillBonuses;
        this.dbPetAffix = null;
        this.dbPetSkill = null;
        this.dbItemSkill = null;
        this.rngPercent = record.getRNGPercent();
        this.strDescription = null;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!o.getClass().equals(DBAffix.class)) {
            return false;
        }
        DBAffix affix = (DBAffix)o;
        return affix.affixID.equals(this.affixID);
    }

    public int hashCode() {
        return this.affixID.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(DBAffix affix) {
        int aRarity;
        if (this.type < affix.type) {
            return -1;
        }
        if (this.type > affix.type) {
            return 1;
        }
        int oRarity = this.getRarityInt();
        if (oRarity < (aRarity = affix.getRarityInt())) {
            return -1;
        }
        if (oRarity > aRarity) {
            return 1;
        }
        if (this.reqLevel < affix.reqLevel) {
            return -1;
        }
        if (this.reqLevel > affix.reqLevel) {
            return 1;
        }
        if (this.nameMS == null) {
            if (affix.nameMS != null) return -1;
            if (this.affixID == null) {
                if (affix.affixID == null) return 0;
                return -1;
            }
            if (affix.affixID != null) return this.affixID.compareTo(affix.affixID);
            return 1;
        }
        if (affix.nameMS != null) return this.nameMS.compareTo(affix.nameMS);
        return 1;
    }

    public String getAffixID() {
        return this.affixID;
    }

    public String getGenderText(int code) {
        String name = null;
        switch (code) {
            case 0: {
                name = this.nameMS;
                break;
            }
            case 1: {
                name = this.nameFS;
                break;
            }
            case 2: {
                name = this.nameNS;
                break;
            }
            case 3: {
                name = this.nameMP;
                break;
            }
            case 4: {
                name = this.nameFP;
                break;
            }
            case 5: {
                name = this.nameNP;
                break;
            }
            default: {
                name = this.nameMS;
            }
        }
        return name;
    }

    public String getRarity() {
        return this.rarity;
    }

    public int getRequiredlevel() {
        return this.reqLevel;
    }

    public int getAffixType() {
        return this.type;
    }

    public int getOffensiveChance() {
        return this.offensiveChance;
    }

    public int getRetaliationChance() {
        return this.retaliationChance;
    }

    public String getConvertIn() {
        return this.convertIn;
    }

    public String getConvertOut() {
        return this.convertOut;
    }

    public int getConvertPerc() {
        DBStat stat = DBStat.getDBStat(this.stats, "conversionPercentage", 1);
        if (stat == null) {
            return 0;
        }
        return stat.getStatMin();
    }

    public int getLootRandomCost() {
        return this.lootRandomCost;
    }

    public List<DBStat> getStatList() {
        return this.stats;
    }

    public List<DBSkillBonus> getSkillBonusList() {
        return this.bonuses;
    }

    public DBAffix getPetAffix() {
        return this.dbPetAffix;
    }

    public DBSkill getPetSkill() {
        return this.dbPetSkill;
    }

    public String getItemSkillID() {
        return this.itemSkillID;
    }

    public DBSkill getItemSkill() {
        return this.dbItemSkill;
    }

    public int getTotalAttCount() {
        int total = 0;
        for (DBStat stat : this.stats) {
            if (stat.getStatMin() > 0) {
                ++total;
            }
            if (stat.getStatModifier() > 0) {
                ++total;
            }
            if (stat.getDurationModifier() > 0) {
                ++total;
            }
            if (stat.getMaxResist() <= 0) continue;
            ++total;
        }
        if (this.statBonusRaces != null && !this.statBonusRaces.isEmpty()) {
            total += this.statBonusRaces.size();
        }
        return total;
    }

    private int getRarityInt() {
        if (this.rarity == null) {
            return -1;
        }
        if (this.rarity.equals("Broken")) {
            return 1;
        }
        if (this.rarity.equals("Magical")) {
            return 2;
        }
        if (this.rarity.equals("Rare")) {
            return 3;
        }
        if (this.rarity.equals("Epic")) {
            return 4;
        }
        if (this.rarity.equals("Legendary")) {
            return 5;
        }
        return -1;
    }

    public boolean matchesCriteria(SelectionCriteria criteria) {
        if (criteria.isInitial()) {
            return true;
        }
        boolean filtered = false;
        if (!criteria.itemRarity.isEmpty()) {
            if (!criteria.itemRarity.contains(this.rarity)) {
                return false;
            }
            filtered = true;
        }
        if (criteria.dmgConversionTo != null && criteria.dmgConversionTo.equals(this.convertOut)) {
            return true;
        }
        if (criteria.petBonus && (this.dbPetAffix != null || this.dbPetSkill != null)) {
            return true;
        }
        if (criteria.statInfos == null) {
            return filtered;
        }
        if (criteria.statInfos.isEmpty()) {
            return filtered;
        }
        if (this.stats == null) {
            return false;
        }
        for (SelectionCriteria.StatInfo info : criteria.statInfos) {
            for (DBStat stat : this.stats) {
                if (!stat.getStatType().equals(info.statType)) continue;
                if (info.flat == info.percentage) {
                    if (info.maxResist) {
                        if (info.flat) {
                            if (stat.getStatMin() > 0) {
                                return true;
                            }
                            if (stat.getStatModifier() > 0) {
                                return true;
                            }
                        }
                        if (stat.getMaxResist() > 0) {
                            return true;
                        }
                    } else {
                        if (stat.getStatMin() > 0) {
                            return true;
                        }
                        if (stat.getStatModifier() > 0) {
                            return true;
                        }
                    }
                } else {
                    if (info.flat && stat.getStatMin() > 0) {
                        return true;
                    }
                    if (info.percentage && stat.getStatModifier() > 0) {
                        return true;
                    }
                }
                if (!info.maxResist || stat.getMaxResist() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private void setLootRandomName(String lootRandomName) {
        String text = GDStashFrame.arcList.getTag("tags_items.txt", lootRandomName);
        if (text != null) {
            String[] genders = ARZDecompress.getGenderTexts(text);
            this.setGenderNames(genders);
        }
    }

    private void setGenderNames(String[] genders) {
        this.nameMS = genders[0];
        this.nameFS = genders[1];
        this.nameNS = genders[2];
        this.nameMP = genders[3];
        this.nameFP = genders[4];
        this.nameNP = genders[5];
    }

    private void determineAffixType(String filename) {
        this.type = -1;
        if (filename.contains("prefix")) {
            this.type = 1;
        }
        if (filename.contains("suffix")) {
            this.type = 2;
        }
        if (filename.contains("crafting")) {
            this.type = 3;
        }
        if (filename.contains("completion")) {
            this.type = 4;
        }
    }

    public static void clearBuffer() {
        hashBuffer.clear();
        bufferComplete = false;
        if (GDStashFrame.dbConfig != null) {
            DBAffix.fillBuffer();
        }
    }

    public static void createTables() throws SQLException {
        String dropTable = "DROP TABLE GD_AFFIX";
        String createTable = "CREATE TABLE GD_AFFIX (AFFIX_ID VARCHAR(256) NOT NULL, RARITY         VARCHAR(32), NAME_MS        VARCHAR(128), NAME_FS        VARCHAR(128), NAME_NS        VARCHAR(128), NAME_MP        VARCHAR(128), NAME_FP        VARCHAR(128), NAME_NP        VARCHAR(128), REQ_LEVEL      INTEGER, TYPE           INTEGER, CONVERT_IN     VARCHAR(16), CONVERT_OUT    VARCHAR(16), OFFENSE_PRC    INTEGER, RETAL_PRC      INTEGER, LOOT_RAND_COST INTEGER, PET_AFFIX_ID   VARCHAR(256), ITEM_SKILL_ID  VARCHAR(256), RNG_PERCENT    INTEGER, PRIMARY KEY (AFFIX_ID))";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (Statement st = conn.createStatement();){
                if (GDDBUtil.tableExists(conn, TABLE_NAME)) {
                    st.execute(dropTable);
                }
                if (GDDBUtil.tableExists(conn, "GD_AFFIX_CHAR")) {
                    st.execute("DROP TABLE GD_AFFIX_CHAR");
                }
                if (GDDBUtil.tableExists(conn, "GD_AFFIX_CHARRACES")) {
                    st.execute("DROP TABLE GD_AFFIX_CHARRACES");
                }
                if (GDDBUtil.tableExists(conn, "GD_AFFIX_DAMAGE")) {
                    st.execute("DROP TABLE GD_AFFIX_DAMAGE");
                }
                st.execute(createTable);
                st.close();
                conn.commit();
                DBStat.createAffixTable(conn);
                DBStatBonusRace.createAffixTable(conn);
                DBSkillBonus.createAffixTable(conn);
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_CREATE_TABLE", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void delete(String affixID) throws SQLException {
        String deleteEntry = "DELETE FROM GD_AFFIX WHERE AFFIX_ID = ?";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(deleteEntry);){
                ps.setString(1, affixID);
                ps.executeUpdate();
                ps.close();
                DBStat.deleteAffix(conn, affixID);
                DBStatBonusRace.deleteAffix(conn, affixID);
                DBSkillBonus.deleteAffix(conn, affixID);
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{affixID, TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_DEL_TABLE_BY_ID", args);
                GDMsgLogger.addError(msg);
                GDMsgLogger.addError(ex);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void insert(ARZRecord record) throws SQLException {
        DBAffix affix = new DBAffix(record);
        String insert = "INSERT INTO GD_AFFIX VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(insert);){
                ps.setString(1, affix.affixID);
                ps.setString(2, affix.rarity);
                ps.setString(3, affix.nameMS);
                ps.setString(4, affix.nameFS);
                ps.setString(5, affix.nameNS);
                ps.setString(6, affix.nameMP);
                ps.setString(7, affix.nameFP);
                ps.setString(8, affix.nameNP);
                ps.setInt(9, affix.reqLevel);
                ps.setInt(10, affix.type);
                ps.setString(11, affix.convertIn);
                ps.setString(12, affix.convertOut);
                ps.setInt(13, affix.offensiveChance);
                ps.setInt(14, affix.retaliationChance);
                ps.setInt(15, affix.lootRandomCost);
                ps.setString(16, affix.petAffixID);
                ps.setString(17, affix.itemSkillID);
                ps.setInt(18, affix.rngPercent);
                ps.executeUpdate();
                ps.close();
                conn.commit();
                DBStat.insertAffix(conn, affix.affixID, affix.stats);
                DBStatBonusRace.insertAffix(conn, affix.affixID, affix.statBonusRaces);
                DBSkillBonus.insertAffix(conn, affix.affixID, affix.bonuses);
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{record.getFileName(), TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_INS_TABLE_BY_ID", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void insertMod(ARZRecord record) throws SQLException {
        DBAffix affix = DBAffix.get(record.getFileName());
        if (affix != null) {
            DBAffix.delete(record.getFileName());
        }
        DBAffix.insert(record);
    }

    public static DBAffix get(String affixID) {
        DBAffix affix = null;
        affix = hashBuffer.get(affixID);
        if (bufferComplete) {
            return affix;
        }
        if (affix == null) {
            affix = DBAffix.getDB(affixID);
        }
        return affix;
    }

    private static DBAffix getDB(String affixID) {
        DBAffix affix = null;
        String command = "SELECT * FROM GD_AFFIX WHERE AFFIX_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, affixID);
            try (ResultSet rs = ps.executeQuery();){
                List<DBAffix> list = DBAffix.wrap(rs);
                affix = list.isEmpty() ? null : list.get(0);
                conn.commit();
            }
            catch (SQLException ex) {
                affix = null;
                throw ex;
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{affixID, TABLE_NAME};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return affix;
    }

    public static List<DBAffix> getByAffixIDs(List<String> affixIDs) {
        LinkedList<DBAffix> list = new LinkedList<DBAffix>();
        for (String affixID : affixIDs) {
            DBAffix affix = DBAffix.get(affixID);
            if (affix == null) continue;
            list.add(affix);
        }
        return list;
    }

    private static List<DBAffix> getAll() {
        LinkedList<DBAffix> list = new LinkedList();
        String command = "SELECT * FROM GD_AFFIX";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);
             ResultSet rs = ps.executeQuery();){
            list = DBAffix.wrap(rs);
            conn.commit();
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{"<all>", TABLE_NAME};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return list;
    }

    private void createBonusRaceStats(DBStat stat) {
        if (stat == null) {
            return;
        }
        if (this.statBonusRaces == null) {
            return;
        }
        if (this.statBonusRaces.isEmpty()) {
            return;
        }
        this.stats.remove(stat);
        List<DBStat> list = DBStat.createStatsFromRaceBonusList(stat, this.statBonusRaces);
        this.stats.addAll(list);
    }

    private static List<DBAffix> wrap(ResultSet rs) throws SQLException {
        LinkedList<DBAffix> list = new LinkedList<DBAffix>();
        while (rs.next()) {
            DBAffix affix = new DBAffix();
            affix.affixID = rs.getString(1);
            DBAffix buff = hashBuffer.get(affix.affixID);
            if (buff != null) {
                list.add(buff);
                continue;
            }
            affix.rarity = rs.getString(2);
            affix.nameMS = rs.getString(3);
            affix.nameFS = rs.getString(4);
            affix.nameNS = rs.getString(5);
            affix.nameMP = rs.getString(6);
            affix.nameFP = rs.getString(7);
            affix.nameNP = rs.getString(8);
            affix.reqLevel = rs.getInt(9);
            affix.type = rs.getInt(10);
            affix.convertIn = rs.getString(11);
            affix.convertOut = rs.getString(12);
            affix.offensiveChance = rs.getInt(13);
            affix.retaliationChance = rs.getInt(14);
            affix.lootRandomCost = rs.getInt(15);
            affix.petAffixID = rs.getString(16);
            affix.itemSkillID = rs.getString(17);
            affix.rngPercent = rs.getInt(18);
            affix.stats = DBStat.getAffix(affix.affixID);
            Collections.sort(affix.stats);
            DBStat stat = DBStat.getByType(affix.stats, "racialBonusPercentDamage", 1);
            if (stat != null) {
                affix.statBonusRaces = DBStatBonusRace.getAffix(affix.affixID);
                affix.createBonusRaceStats(stat);
            }
            affix.bonuses = DBSkillBonus.getAffix(affix.affixID);
            if (affix.petAffixID != null) {
                if (affix.petAffixID.startsWith("records/items/lootaffixes/")) {
                    affix.dbPetAffix = DBAffix.get(affix.petAffixID);
                }
                if (affix.petAffixID.startsWith("records/skills/itemskills/")) {
                    affix.dbPetSkill = DBSkill.get(affix.petAffixID);
                }
            }
            if (affix.itemSkillID != null) {
                affix.dbItemSkill = DBSkill.get(affix.itemSkillID);
            }
            list.add(affix);
            hashBuffer.put(affix.affixID, affix);
        }
        return list;
    }

    public static void fillBuffer() {
        if (bufferComplete) {
            return;
        }
        listBuffer = DBAffix.getAll();
        listPrefix = new LinkedList<DBAffix>();
        listSuffix = new LinkedList<DBAffix>();
        for (DBAffix affix : listBuffer) {
            if (affix.getAffixType() == 1) {
                listPrefix.add(affix);
            }
            if (affix.getAffixType() != 2) continue;
            listSuffix.add(affix);
        }
        Collections.sort(listPrefix, new AffixComparator());
        Collections.sort(listSuffix, new AffixComparator());
        bufferComplete = true;
    }

    public static List<DBAffix> getFullAffixList() {
        DBAffix.fillBuffer();
        return listBuffer;
    }

    public static List<DBAffix> getPrefixList() {
        DBAffix.fillBuffer();
        return listPrefix;
    }

    public static List<DBAffix> getSuffixList() {
        DBAffix.fillBuffer();
        return listSuffix;
    }

    public DetailComposer getBonusComposer(String prefix) {
        String pref;
        BonusDetail bonus;
        DetailComposer composer = new DetailComposer();
        if (this.stats != null && !this.stats.isEmpty()) {
            for (DBStat stat : this.stats) {
                bonus = stat.getBonusDetail(null, 1, prefix);
                composer.add(bonus);
            }
        }
        if (this.bonuses != null && !this.bonuses.isEmpty()) {
            for (DBSkillBonus skillBonus : this.bonuses) {
                bonus = skillBonus.getBonusDetail();
                composer.add(bonus);
            }
        }
        if (this.dbPetAffix != null) {
            pref = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_PREFIX_PET");
            DetailComposer comp = this.dbPetAffix.getBonusComposer(pref);
            composer.add(comp);
        }
        if (this.dbPetSkill != null) {
            pref = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_PREFIX_PET");
            List<DBStat> stats = DBStat.getByLevel(this.dbPetSkill.getStatList(), 1);
            if (stats != null && !stats.isEmpty()) {
                for (DBStat stat : stats) {
                    BonusDetail bonus2 = stat.getBonusDetail(null, 1, pref);
                    composer.add(bonus2);
                }
            }
        }
        if (this.dbItemSkill != null) {
            BonusDetail bonus3 = this.dbItemSkill.getBonusDetail();
            composer.add(bonus3);
        }
        return composer;
    }

    private String getString(String prefix) {
        DetailComposer composer = this.getBonusComposer(null);
        if (this.nameMS != null) {
            composer.preText = this.nameMS;
        } else {
            boolean found = false;
            String search = null;
            if (!found) {
                search = "records/items/lootaffixes/crafting/";
                found = this.affixID.startsWith(search);
            }
            if (found) {
                if (this.affixID.equals("records/items/lootaffixes/crafting/ad05_pierceresist.dbr") || this.affixID.equals("records/items/lootaffixes/crafting/ad06_protection.dbr") || this.affixID.equals("records/items/lootaffixes/crafting/ao01_physicaldmg.dbr")) {
                    composer.preText = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "SMITH_ANGRIM");
                }
                if (this.affixID.equals("records/items/lootaffixes/crafting/ac04_energyregen.dbr") || this.affixID.equals("records/items/lootaffixes/crafting/ad08_elementalresist.dbr") || this.affixID.equals("records/items/lootaffixes/crafting/ao05_elementaldmg.dbr")) {
                    composer.preText = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "SMITH_DUNCAN");
                }
                if (this.affixID.equals("records/items/lootaffixes/crafting/ad09_aetherresist.dbr") || this.affixID.equals("records/items/lootaffixes/crafting/ad10_chaosresist.dbr") || this.affixID.equals("records/items/lootaffixes/crafting/ac01_health.dbr")) {
                    composer.preText = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "SMITH_BLACK_LEGION");
                }
                if (this.affixID.equals("records/items/lootaffixes/crafting/ad01_fireresist.dbr") || this.affixID.equals("records/items/lootaffixes/crafting/ao11_firedmg.dbr") || this.affixID.equals("records/items/lootaffixes/crafting/ao13_lightningdmg.dbr")) {
                    composer.preText = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "SMITH_KYMONS_CHOSEN");
                }
                if (this.affixID.equals("records/items/lootaffixes/crafting/ad02_coldresist.dbr") || this.affixID.equals("records/items/lootaffixes/crafting/ao12_colddmg.dbr") || this.affixID.equals("records/items/lootaffixes/crafting/ao07_vitalitydmg.dbr")) {
                    composer.preText = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "SMITH_DEATHS_VIGIL");
                }
                if (this.affixID.equals("records/items/lootaffixes/crafting/ac04_energyregen.dbr") || this.affixID.equals("records/items/lootaffixes/crafting/ad07_bleedresist.dbr") || this.affixID.equals("records/items/lootaffixes/crafting/ad12_vitalityresist.dbr")) {
                    composer.preText = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "SMITH_NECROPOLIS");
                }
                if (this.affixID.equals("records/items/lootaffixes/crafting/ac02_healthregen.dbr") || this.affixID.equals("records/items/lootaffixes/crafting/ad08_da.dbr") || this.affixID.equals("records/items/lootaffixes/crafting/ao14_oa.dbr")) {
                    composer.preText = GDMsgFormatter.getString(GDMsgFormatter.rbGD, "SMITH_TYRANTS_HOLD");
                }
            }
        }
        Object[] args = new Object[]{String.format("%03d", this.reqLevel)};
        String msg = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_LEVEL_NUM", args);
        composer.preText = composer.preText == null ? "[" + msg : composer.preText + " [" + msg;
        String s = composer.getAffixText();
        if (this.rarity != null && (this.type == 1 || this.type == 2)) {
            if (this.rarity.equals("Magical")) {
                s = "<html><font color = \"#B48200\">" + s + HTML_COLOR_END + "</html>";
            }
            if (this.rarity.equals("Rare")) {
                s = "<html><font color = \"#00460A\">" + s + HTML_COLOR_END + "</html>";
            }
            if (this.rarity.equals("Epic")) {
                s = "<html><font color = \"#002864\">" + s + HTML_COLOR_END + "</html>";
            }
            if (this.rarity.equals("Legendary")) {
                s = "<html><font color = \"#320064\">" + s + HTML_COLOR_END + "</html>";
            }
        }
        return s;
    }

    public void resetDescription() {
        this.strDescription = null;
    }

    public String toString() {
        if (this.strDescription == null) {
            this.strDescription = this.getString(null);
        }
        return this.strDescription;
    }

    public static class AffixComparator
    implements Comparator<DBAffix> {
        @Override
        public int compare(DBAffix a1, DBAffix a2) {
            int r2;
            if (a1 == null) {
                if (a2 != null) {
                    return 1;
                }
                return 0;
            }
            if (a2 == null && a1 != null) {
                return -1;
            }
            int r1 = a1.getRarityInt();
            if (r1 != (r2 = a2.getRarityInt())) {
                return r2 - r1;
            }
            return a1.toString().toUpperCase(GDMsgFormatter.locale).compareTo(a2.toString().toUpperCase(GDMsgFormatter.locale));
        }

        @Override
        public boolean equals(Object obj) {
            return obj.getClass().equals(AffixComparator.class);
        }
    }
}

