/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.file.ARZRecord;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBAffixSet {
    private static ConcurrentHashMap<String, DBAffixSet> hashBuffer = new ConcurrentHashMap();
    public static final String TABLE_NAME = "GD_AFFIXSET";
    private static final int ROW_AFFIXSET_ID = 1;
    private static final int ROW_INDEX = 2;
    private static final int ROW_LEVEL_MIN = 3;
    private static final int ROW_LEVEL_MAX = 4;
    private static final int ROW_AFFIX_ID = 5;
    protected String affixSetID;
    protected List<DBEntry> affixes;

    public DBAffixSet() {
        this.affixes = new LinkedList<DBEntry>();
    }

    private DBAffixSet(ARZRecord record) {
        this.affixSetID = record.getFileName();
        this.affixes = record.getAffixSetRandomizerList();
    }

    public String getAffixSetID() {
        return this.affixSetID;
    }

    public List<DBEntry> getAffixEntries() {
        return this.affixes;
    }

    public static void clearBuffer() {
        hashBuffer.clear();
    }

    public static void createTables() throws SQLException {
        String dropTable = "DROP TABLE GD_AFFIXSET";
        String createTable = "CREATE TABLE GD_AFFIXSET (AFFIXSET_ID VARCHAR(256) NOT NULL, INDEX       INTEGER NOT NULL, LEVEL_MIN   INTEGER, LEVEL_MAX   INTEGER, AFFIX_ID    VARCHAR(256) NOT NULL, PRIMARY KEY (AFFIXSET_ID, INDEX))";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (Statement st = conn.createStatement();){
                if (GDDBUtil.tableExists(conn, TABLE_NAME)) {
                    st.execute(dropTable);
                }
                st.execute(createTable);
                st.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_CREATE_TABLE", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void delete(String affixSetID) throws SQLException {
        String deleteEntry = "DELETE FROM GD_AFFIXSET WHERE AFFIXSET_ID = ?";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(deleteEntry);){
                ps.setString(1, affixSetID);
                ps.executeUpdate();
                ps.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{affixSetID, TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_DEL_TABLE_BY_ID", args);
                GDMsgLogger.addError(msg);
                GDMsgLogger.addError(ex);
                throw ex;
            }
        }
    }

    public static void insert(ARZRecord record) throws SQLException {
        DBAffixSet affixSet = new DBAffixSet(record);
        if (affixSet.affixes == null) {
            return;
        }
        if (affixSet.affixes.isEmpty()) {
            return;
        }
        String insert = "INSERT INTO GD_AFFIXSET VALUES (?,?,?,?,?)";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(insert);){
                for (DBEntry entry : affixSet.affixes) {
                    if (entry.affixID == null) continue;
                    ps.setString(1, affixSet.affixSetID);
                    ps.setInt(2, entry.index);
                    ps.setInt(3, entry.levelMin);
                    ps.setInt(4, entry.levelMax);
                    ps.setString(5, entry.affixID);
                    ps.executeUpdate();
                    ps.clearParameters();
                }
                ps.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{record.getFileName(), TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_INS_TABLE_BY_ID", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void insertMod(ARZRecord record) throws SQLException {
        DBAffixSet entry = DBAffixSet.get(record.getFileName());
        if (entry != null) {
            DBAffixSet.delete(record.getFileName());
        }
        DBAffixSet.insert(record);
    }

    public static DBAffixSet get(String affixSetID) {
        DBAffixSet set = null;
        set = hashBuffer.get(affixSetID);
        if (set == null && (set = DBAffixSet.getDB(affixSetID)) != null) {
            hashBuffer.put(set.affixSetID, set);
        }
        return set;
    }

    private static DBAffixSet getDB(String affixSetID) {
        DBAffixSet set = null;
        String command = "SELECT * FROM GD_AFFIXSET WHERE AFFIXSET_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, affixSetID);
            try (ResultSet rs = ps.executeQuery();){
                List<DBAffixSet> list = DBAffixSet.wrap(rs);
                set = list.isEmpty() ? null : list.get(0);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{affixSetID, TABLE_NAME};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return set;
    }

    public static List<DBAffixSet> getByAffixSetIDs(List<String> affixSetIDs) {
        LinkedList<DBAffixSet> list = new LinkedList<DBAffixSet>();
        for (String affixSetID : affixSetIDs) {
            DBAffixSet set = DBAffixSet.get(affixSetID);
            if (set == null) continue;
            list.add(set);
        }
        return list;
    }

    public static List<DBAffixSet> getCompletionAffixes() {
        List<DBAffixSet> list = null;
        String command = "SELECT * FROM GD_AFFIXSET WHERE AFFIXSET_ID LIKE 'records/items/lootaffixes/completion%'";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);
             ResultSet rs = ps.executeQuery();){
            list = DBAffixSet.wrap(rs);
            conn.commit();
        }
        catch (SQLException ex) {
            GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_READ_AFFIXSET_CRAFT"));
            GDMsgLogger.addError(ex);
        }
        return list;
    }

    public static List<DBAffixSet> getCraftingAffixes() {
        List<DBAffixSet> list = null;
        String command = "SELECT * FROM GD_AFFIXSET WHERE AFFIXSET_ID LIKE 'records/items/lootaffixes/crafting%'";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);
             ResultSet rs = ps.executeQuery();){
            list = DBAffixSet.wrap(rs);
            conn.commit();
        }
        catch (SQLException ex) {
            GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_READ_AFFIXSET_CRAFT"));
            GDMsgLogger.addError(ex);
        }
        return list;
    }

    private static List<DBAffixSet> wrap(ResultSet rs) throws SQLException {
        LinkedList<DBAffixSet> list = new LinkedList<DBAffixSet>();
        boolean found = false;
        while (rs.next()) {
            DBAffixSet set = null;
            DBEntry entry = new DBEntry();
            String id = rs.getString(1);
            entry.index = rs.getInt(2);
            entry.levelMin = rs.getInt(3);
            entry.levelMax = rs.getInt(4);
            entry.affixID = rs.getString(5);
            found = false;
            for (DBAffixSet as : list) {
                if (as == null || as.affixSetID == null || !as.affixSetID.equals(id)) continue;
                found = true;
                as.affixes.add(entry);
                break;
            }
            if (found) continue;
            set = new DBAffixSet();
            set.affixSetID = id;
            set.affixes.add(entry);
            list.add(set);
        }
        return list;
    }

    public List<String> getAffixIDs() {
        LinkedList<String> list = new LinkedList<String>();
        if (this.affixes == null) {
            return list;
        }
        for (DBEntry entry : this.affixes) {
            if (entry == null || entry.affixID == null) continue;
            list.add(entry.affixID);
        }
        return list;
    }

    public static class DBEntry {
        private int index;
        private int levelMin;
        private int levelMax;
        private String affixID;

        public int getIndex() {
            return this.index;
        }

        public int getMinLevel() {
            return this.levelMin;
        }

        public int getMaxLevel() {
            return this.levelMax;
        }

        public String getAffixID() {
            return this.affixID;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public void setMinLevel(int levelMin) {
            this.levelMin = levelMin;
        }

        public void setMaxLevel(int levelMax) {
            this.levelMax = levelMax;
        }

        public void setAffixID(String affixID) {
            this.affixID = affixID;
        }
    }
}

