/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.util.GDLog;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBConfig
implements Cloneable {
    public static final String TABLE_NAME = "INFO_CONFIG";
    private static final int ROW_ID = 1;
    private static final int ROW_CONFIG_VER = 2;
    private static final int ROW_CONFIG_INIT = 3;
    private static final int ROW_GDDB_VER = 4;
    private static final int ROW_GDDB_INIT = 5;
    private static final int ROW_GD_LOCAL = 6;
    private static final int ROW_MOD_STANDALONE = 7;
    private static final int ROW_NAME_PART_POS1 = 8;
    private static final int ROW_NAME_PART_POS2 = 9;
    private static final int ROW_NAME_PART_POS3 = 10;
    private static final int ROW_NAME_PART_POS4 = 11;
    private static final int ROW_NAME_PART_POS5 = 12;
    public static final int NAME_PART_NONE = 0;
    public static final int NAME_PART_PREFIX = 1;
    public static final int NAME_PART_QUALITY = 2;
    public static final int NAME_PART_STYLE = 3;
    public static final int NAME_PART_NAME = 4;
    public static final int NAME_PART_SUFFIX = 5;
    public String configVer = "1.0.8";
    public boolean configInit = false;
    public String gddbVer = "1.1.0h";
    public boolean gddbInit = false;
    public String gdLocal = "";
    public boolean modStandalone = false;
    public int namePart1 = 1;
    public int namePart2 = 2;
    public int namePart3 = 3;
    public int namePart4 = 4;
    public int namePart5 = 5;

    public Object clone() {
        DBConfig config = new DBConfig();
        config.configVer = this.configVer;
        config.configInit = this.configInit;
        config.gddbVer = this.gddbVer;
        config.gddbInit = this.gddbInit;
        config.gdLocal = this.gdLocal;
        config.modStandalone = this.modStandalone;
        config.namePart1 = this.namePart1;
        config.namePart2 = this.namePart2;
        config.namePart3 = this.namePart3;
        config.namePart4 = this.namePart4;
        config.namePart5 = this.namePart5;
        return config;
    }

    public static void createTable() throws SQLException {
        String dropTable = "DROP TABLE INFO_CONFIG";
        String createTable = "CREATE TABLE INFO_CONFIG (ID             VARCHAR(8)   NOT NULL, CONFIG_VER     VARCHAR(8)   NOT NULL, CONFIG_INIT    BOOLEAN, GDDB_VER       VARCHAR(8)   NOT NULL, GDDB_INIT      BOOLEAN, GD_LOCAL       VARCHAR(128), MOD_STANDALONE BOOLEAN, NAME_PART1     INTEGER, NAME_PART2     INTEGER, NAME_PART3     INTEGER, NAME_PART4     INTEGER, NAME_PART5     INTEGER, PRIMARY KEY (ID))";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (Statement st = conn.createStatement();){
                DBConfig config = null;
                if (GDDBUtil.tableExists(conn, TABLE_NAME)) {
                    config = DBConfig.rescueConfig();
                    st.execute(dropTable);
                }
                st.execute(createTable);
                st.close();
                conn.commit();
                if (config != null) {
                    DBConfig.restoreConfig(config);
                }
            }
            catch (SQLException ex) {
                conn.rollback();
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    private static void insert(DBConfig config) throws SQLException {
        String insert = "INSERT INTO INFO_CONFIG VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(insert);){
                ps.setString(1, "DEFAULT");
                ps.setString(2, config.configVer);
                ps.setBoolean(3, config.configInit);
                ps.setString(4, config.gddbVer);
                ps.setBoolean(5, config.gddbInit);
                ps.setString(6, config.gdLocal);
                ps.setBoolean(7, config.modStandalone);
                ps.setInt(8, config.namePart1);
                ps.setInt(9, config.namePart2);
                ps.setInt(10, config.namePart3);
                ps.setInt(11, config.namePart4);
                ps.setInt(12, config.namePart5);
                ps.executeUpdate();
                ps.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_SAVE_CONFIG"));
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static DBConfig get() {
        DBConfig config = new DBConfig();
        String command = "SELECT * FROM INFO_CONFIG WHERE ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, "DEFAULT");
            try (ResultSet rs = ps.executeQuery();){
                List<DBConfig> list = DBConfig.wrap(rs);
                config = list.isEmpty() ? null : list.get(0);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_READ_CONFIG"));
            GDMsgLogger.addError(ex);
            config = DBConfig.rescueConfig();
        }
        return config;
    }

    private static List<DBConfig> wrap(ResultSet rs) throws SQLException {
        LinkedList<DBConfig> list = new LinkedList<DBConfig>();
        while (rs.next()) {
            DBConfig config = new DBConfig();
            config.configVer = rs.getString(2);
            config.configInit = rs.getBoolean(3);
            config.gddbVer = rs.getString(4);
            config.gddbInit = rs.getBoolean(5);
            config.gdLocal = rs.getString(6);
            config.modStandalone = rs.getBoolean(7);
            config.namePart1 = rs.getInt(8);
            config.namePart2 = rs.getInt(9);
            config.namePart3 = rs.getInt(10);
            config.namePart4 = rs.getInt(11);
            config.namePart5 = rs.getInt(12);
            list.add(config);
        }
        return list;
    }

    private static DBConfig rescueConfig() {
        DBConfig config = new DBConfig();
        String id = DBConfig.getConfigID();
        if (id == null) {
            return null;
        }
        config.configVer = DBConfig.getConfigVersion();
        config.configInit = DBConfig.getConfigInit();
        config.gddbVer = DBConfig.getGDDBVersion();
        config.gddbInit = DBConfig.getGDDBInit();
        config.gdLocal = DBConfig.getGDLocal();
        config.modStandalone = DBConfig.getLoadVanilla();
        return config;
    }

    private static void restoreConfig(DBConfig config) {
        try {
            DBConfig.insert(config);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private static String getStringValue(String fieldname) {
        String str = null;
        boolean found = false;
        String command = "SELECT " + fieldname + " FROM " + TABLE_NAME + " WHERE ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, "DEFAULT");
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    str = rs.getString(1);
                    found = true;
                }
                conn.commit();
            }
        }
        catch (SQLException ex) {
            GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_READ_CONFIG"));
            GDMsgLogger.addError(ex);
        }
        if (!found) {
            str = null;
        }
        return str;
    }

    public static String getConfigID() {
        return DBConfig.getStringValue("ID");
    }

    public static String getConfigVersion() {
        return DBConfig.getStringValue("CONFIG_VER");
    }

    public static String getGDDBVersion() {
        return DBConfig.getStringValue("GDDB_VER");
    }

    public static String getGDLocal() {
        return DBConfig.getStringValue("GD_LOCAL");
    }

    private static int getIntValue(String fieldname) {
        int i = -1;
        boolean found = false;
        String command = "SELECT " + fieldname + " FROM " + TABLE_NAME + " WHERE ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, "DEFAULT");
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    i = rs.getInt(1);
                    found = true;
                }
                conn.commit();
            }
        }
        catch (SQLException ex) {
            GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_READ_CONFIG"));
            GDMsgLogger.addError(ex);
        }
        if (!found) {
            i = -1;
        }
        return i;
    }

    public static boolean getBoolValue(String fieldname, boolean defaultVal) {
        boolean flag = defaultVal;
        boolean found = false;
        String command = "SELECT " + fieldname + " FROM " + TABLE_NAME + " WHERE ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, "DEFAULT");
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    flag = rs.getBoolean(1);
                    found = true;
                }
                conn.commit();
            }
        }
        catch (SQLException ex) {
            GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_READ_CONFIG"));
            GDMsgLogger.addError(ex);
        }
        if (!found) {
            flag = defaultVal;
        }
        return flag;
    }

    public static boolean getConfigInit() {
        return DBConfig.getBoolValue("CONFIG_INIT", false);
    }

    public static boolean getGDDBInit() {
        return DBConfig.getBoolValue("GDDB_INIT", false);
    }

    public static boolean getLoadVanilla() {
        return DBConfig.getBoolValue("MOD_STANDALONE", false);
    }

    public static boolean setVersions(String configVer, String gddbVer) {
        boolean success;
        block34: {
            String command = null;
            success = false;
            try (Connection conn = GDDBData.getConnection();){
                boolean auto = conn.getAutoCommit();
                conn.setAutoCommit(false);
                if (DBConfig.configExists(conn)) {
                    command = "UPDATE INFO_CONFIG SET CONFIG_VER = ?, GDDB_VER = ? WHERE ID = ?";
                    try (PreparedStatement ps = conn.prepareStatement(command);){
                        ps.setString(1, configVer);
                        ps.setString(2, gddbVer);
                        ps.setString(3, "DEFAULT");
                        ps.executeUpdate();
                        ps.close();
                        conn.commit();
                        success = true;
                        break block34;
                    }
                    catch (SQLException ex) {
                        conn.rollback();
                        throw ex;
                    }
                    finally {
                        conn.setAutoCommit(auto);
                    }
                }
                try {
                    DBConfig config = new DBConfig();
                    config.configVer = configVer;
                    config.gddbVer = gddbVer;
                    DBConfig.insert(config);
                    success = true;
                }
                catch (SQLException ex) {
                    success = false;
                    throw ex;
                }
            }
            catch (SQLException ex) {
                GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_SAVE_CONFIG"));
                GDMsgLogger.addError(ex);
            }
        }
        return success;
    }

    public static boolean setConfigInit(String configVer, String gddbVer, boolean init) {
        boolean success;
        block34: {
            String command = null;
            success = false;
            try (Connection conn = GDDBData.getConnection();){
                boolean auto = conn.getAutoCommit();
                conn.setAutoCommit(false);
                if (DBConfig.configExists(conn)) {
                    command = "UPDATE INFO_CONFIG SET CONFIG_INIT = ? WHERE ID = ?";
                    try (PreparedStatement ps = conn.prepareStatement(command);){
                        ps.setBoolean(1, init);
                        ps.setString(2, "DEFAULT");
                        ps.executeUpdate();
                        ps.close();
                        conn.commit();
                        success = true;
                        break block34;
                    }
                    catch (SQLException ex) {
                        conn.rollback();
                        throw ex;
                    }
                    finally {
                        conn.setAutoCommit(auto);
                    }
                }
                try {
                    DBConfig config = new DBConfig();
                    config.configVer = configVer;
                    config.gddbVer = gddbVer;
                    config.configInit = init;
                    DBConfig.insert(config);
                    success = true;
                }
                catch (SQLException ex) {
                    success = false;
                    throw ex;
                }
            }
            catch (SQLException ex) {
                GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_SAVE_CONFIG"));
                GDMsgLogger.addError(ex);
            }
        }
        return success;
    }

    public static boolean setGDDBInit(String configVer, String gddbVer, boolean init) {
        boolean success;
        block34: {
            String command = null;
            success = false;
            try (Connection conn = GDDBData.getConnection();){
                boolean auto = conn.getAutoCommit();
                conn.setAutoCommit(false);
                if (DBConfig.configExists(conn)) {
                    command = "UPDATE INFO_CONFIG SET GDDB_INIT = ? WHERE ID = ?";
                    try (PreparedStatement ps = conn.prepareStatement(command);){
                        ps.setBoolean(1, init);
                        ps.setString(2, "DEFAULT");
                        ps.executeUpdate();
                        ps.close();
                        conn.commit();
                        success = true;
                        break block34;
                    }
                    catch (SQLException ex) {
                        conn.rollback();
                        throw ex;
                    }
                    finally {
                        conn.setAutoCommit(auto);
                    }
                }
                try {
                    DBConfig config = new DBConfig();
                    config.configVer = configVer;
                    config.gddbVer = gddbVer;
                    config.gddbInit = init;
                    DBConfig.insert(config);
                    success = true;
                }
                catch (SQLException ex) {
                    success = false;
                    throw ex;
                }
            }
            catch (SQLException ex) {
                GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_SAVE_CONFIG"));
                GDMsgLogger.addError(ex);
            }
        }
        return success;
    }

    public static boolean setItemNameOrder(String configVer, String gddbVer, String order) {
        if (order == null) {
            return false;
        }
        GDLog tempLog = new GDLog();
        int[] nameOrder = DBConfig.determineItemNameOrder(order, tempLog);
        if (tempLog.containsErrors()) {
            GDMsgLogger.addLog(tempLog);
            return false;
        }
        return DBConfig.writeItemNameOrder(configVer, gddbVer, nameOrder);
    }

    private static int[] determineItemNameOrder(String order, GDLog log) {
        int pos;
        int[] nameOrder = new int[5];
        for (int i = 0; i < nameOrder.length; ++i) {
            nameOrder[i] = 0;
        }
        int posOrder = 0;
        String rest = order;
        while (!rest.isEmpty() && (pos = rest.indexOf("}")) != -1) {
            String sTag = rest.substring(0, pos + 1);
            String sPart = sTag.substring(sTag.length() - 2, sTag.length() - 1);
            try {
                int iPart = Integer.valueOf(sPart);
                if (iPart > 4) {
                    throw new NumberFormatException();
                }
                nameOrder[posOrder] = ++iPart;
                ++posOrder;
            }
            catch (NumberFormatException ex) {
                break;
            }
            rest = rest.substring(pos + 1);
        }
        if (!rest.isEmpty()) {
            Object[] args = new Object[]{order};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_GENDER_TAG", args);
            GDMsgLogger.addError(msg);
            return null;
        }
        return nameOrder;
    }

    private static boolean writeItemNameOrder(String configVer, String gddbVer, int[] order) {
        boolean success;
        block34: {
            String command = null;
            success = false;
            try (Connection conn = GDDBData.getConnection();){
                boolean auto = conn.getAutoCommit();
                conn.setAutoCommit(false);
                if (DBConfig.configExists(conn)) {
                    command = "UPDATE INFO_CONFIG SET NAME_PART1 = ?, NAME_PART2 = ?, NAME_PART3 = ?, NAME_PART4 = ?, NAME_PART5 = ? WHERE ID = ?";
                    try (PreparedStatement ps = conn.prepareStatement(command);){
                        ps.setInt(1, order[0]);
                        ps.setInt(2, order[1]);
                        ps.setInt(3, order[2]);
                        ps.setInt(4, order[3]);
                        ps.setInt(5, order[4]);
                        ps.setString(6, "DEFAULT");
                        ps.executeUpdate();
                        ps.close();
                        conn.commit();
                        success = true;
                        break block34;
                    }
                    catch (SQLException ex) {
                        conn.rollback();
                        throw ex;
                    }
                    finally {
                        conn.setAutoCommit(auto);
                    }
                }
                try {
                    DBConfig config = new DBConfig();
                    config.configVer = configVer;
                    config.gddbVer = gddbVer;
                    config.namePart1 = order[0];
                    config.namePart2 = order[1];
                    config.namePart3 = order[2];
                    config.namePart4 = order[3];
                    config.namePart5 = order[4];
                    DBConfig.insert(config);
                    success = true;
                }
                catch (SQLException ex) {
                    success = false;
                    throw ex;
                }
            }
            catch (SQLException ex) {
                GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_SAVE_CONFIG"));
                GDMsgLogger.addError(ex);
            }
        }
        return success;
    }

    public static boolean setConfigData(String configVer, String gddbVer, DBConfig config) {
        boolean success;
        block34: {
            String command = null;
            success = false;
            try (Connection conn = GDDBData.getConnection();){
                boolean auto = conn.getAutoCommit();
                conn.setAutoCommit(false);
                if (DBConfig.configExists(conn)) {
                    command = "UPDATE INFO_CONFIG SET GD_LOCAL = ?, MOD_STANDALONE = ? WHERE ID = ?";
                    try (PreparedStatement ps = conn.prepareStatement(command);){
                        ps.setString(1, config.gdLocal);
                        ps.setBoolean(2, config.modStandalone);
                        ps.setString(3, "DEFAULT");
                        ps.executeUpdate();
                        ps.close();
                        conn.commit();
                        success = true;
                        break block34;
                    }
                    catch (SQLException ex) {
                        conn.rollback();
                        throw ex;
                    }
                    finally {
                        conn.setAutoCommit(auto);
                    }
                }
                try {
                    DBConfig cfg = new DBConfig();
                    cfg.configVer = configVer;
                    cfg.gddbVer = gddbVer;
                    cfg.gdLocal = config.gdLocal;
                    cfg.modStandalone = config.modStandalone;
                    DBConfig.insert(cfg);
                    success = true;
                }
                catch (SQLException ex) {
                    success = false;
                    throw ex;
                }
            }
            catch (SQLException ex) {
                GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_SAVE_CONFIG"));
                GDMsgLogger.addError(ex);
            }
        }
        return success;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean configExists(Connection conn) throws SQLException {
        String version;
        String select = "SELECT CONFIG_VER FROM INFO_CONFIG WHERE ID = ?";
        boolean found = false;
        if (!GDDBUtil.tableExists(conn, TABLE_NAME)) {
            DBConfig.createTable();
        }
        if ((version = DBConfig.getConfigVersion()) == null || !version.equals("1.0.8")) {
            DBConfig.createTable();
        }
        try (PreparedStatement ps = conn.prepareStatement(select);){
            if (!GDDBUtil.tableExists(conn, TABLE_NAME)) {
                boolean bl = false;
                return bl;
            }
            ps.setString(1, "DEFAULT");
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                found = true;
            }
            conn.commit();
            return found;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return found;
    }
}

