/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.DBConstellationAffinity;
import org.gdstash.db.DBConstellationStar;
import org.gdstash.db.DBItemSet;
import org.gdstash.db.DBSkill;
import org.gdstash.db.DBStat;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.description.BonusDetail;
import org.gdstash.description.BonusInfo;
import org.gdstash.file.ARZRecord;
import org.gdstash.file.GDWriter;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDConstants;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBConstellation
implements Comparable<DBConstellation> {
    private static final String TABLE_NAME = "GDC_CONSTELLATION";
    private static final int ROW_CONSTELLATION_ID = 1;
    private static final int ROW_NAME = 2;
    private static final int ROW_DESCRIPTION = 3;
    private String constellationID;
    private String name;
    private String description;
    private List<DBConstellationAffinity> dbAffinities = new LinkedList<DBConstellationAffinity>();
    private List<DBConstellationStar> dbStars = new LinkedList<DBConstellationStar>();

    public DBConstellation() {
    }

    public DBConstellation(ARZRecord record) {
        this();
        this.constellationID = record.getFileName();
        this.setName(record.getConstellationNameTag());
        this.setDescription(record.getConstellationInfoTag());
        this.dbAffinities = record.getConstellationAffinityList();
        this.dbStars = record.getConstellationStarList();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!o.getClass().equals(DBConstellation.class)) {
            return false;
        }
        DBConstellation constellation = (DBConstellation)o;
        return constellation.constellationID.equals(this.constellationID);
    }

    public int hashCode() {
        return this.constellationID.hashCode();
    }

    @Override
    public int compareTo(DBConstellation o) {
        if (!o.getClass().equals(DBConstellation.class)) {
            Object[] args = new Object[]{DBConstellation.class, o.toString()};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_NOT_OF_TYPE", args);
            throw new ClassCastException(msg);
        }
        DBConstellation constellation = o;
        return this.constellationID.compareTo(constellation.constellationID);
    }

    public String getConstellationID() {
        return this.constellationID;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<DBConstellationAffinity> getAffinityList() {
        return this.dbAffinities;
    }

    public List<DBConstellationStar> getStarList() {
        return this.dbStars;
    }

    private void setName(String name) {
        this.name = GDStashFrame.arcList.getTag("tags_skills.txt", name);
    }

    private void setDescription(String description) {
        this.description = GDStashFrame.arcList.getTag("tags_skills.txt", description);
    }

    public static void createTables() throws SQLException {
        String dropTable = "DROP TABLE GDC_CONSTELLATION";
        String createTable = "CREATE TABLE GDC_CONSTELLATION (CONSTELLATION_ID VARCHAR(256) NOT NULL, NAME             VARCHAR(64), DESCRIPTION      VARCHAR(1024), PRIMARY KEY (CONSTELLATION_ID))";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (Statement st = conn.createStatement();){
                if (GDDBUtil.tableExists(conn, TABLE_NAME)) {
                    st.execute(dropTable);
                }
                st.execute(createTable);
                st.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_CREATE_TABLE", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
        DBConstellationAffinity.createTable();
        DBConstellationStar.createTable();
    }

    public static void delete(String constellationID) throws SQLException {
        String deleteEntry = "DELETE FROM GDC_CONSTELLATION WHERE CONSTELLATION_ID = ?";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(deleteEntry);){
                ps.setString(1, constellationID);
                ps.executeUpdate();
                ps.close();
                DBConstellationAffinity.delete(conn, constellationID);
                DBConstellationStar.delete(conn, constellationID);
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{constellationID, TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_DEL_TABLE_BY_ID", args);
                GDMsgLogger.addError(msg);
                GDMsgLogger.addError(ex);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void insert(ARZRecord record) throws SQLException {
        DBConstellation constellation = new DBConstellation(record);
        if (constellation.getStarList() == null) {
            return;
        }
        if (constellation.getStarList().isEmpty()) {
            return;
        }
        String insert = "INSERT INTO GDC_CONSTELLATION VALUES (?,?,?)";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(insert);){
                ps.setString(1, constellation.constellationID);
                ps.setString(2, constellation.name);
                ps.setString(3, constellation.description);
                ps.executeUpdate();
                ps.close();
                conn.commit();
                DBConstellationAffinity.insert(conn, constellation);
                DBConstellationStar.insert(conn, constellation);
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{constellation.constellationID, TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_INS_TABLE_BY_ID", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void insertMod(ARZRecord record) throws SQLException {
        DBItemSet constellation = DBItemSet.get(record.getFileName());
        if (constellation != null) {
            DBConstellation.delete(record.getFileName());
        }
        DBConstellation.insert(record);
    }

    public static DBConstellation get(String constellationID) {
        DBConstellation constellation = null;
        String command = "SELECT * FROM GDC_CONSTELLATION WHERE CONSTELLATION_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, constellationID);
            try (ResultSet rs = ps.executeQuery();){
                List<DBConstellation> list = DBConstellation.wrap(rs);
                constellation = list.isEmpty() ? null : list.get(0);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{constellationID, TABLE_NAME};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return constellation;
    }

    public static List<DBConstellation> getAll() {
        List<DBConstellation> list = null;
        String command = "SELECT * FROM GDC_CONSTELLATION";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);
             ResultSet rs = ps.executeQuery();){
            list = DBConstellation.wrap(rs);
            conn.commit();
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{"<all>", TABLE_NAME};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return list;
    }

    private static List<DBConstellation> wrap(ResultSet rs) throws SQLException {
        LinkedList<DBConstellation> list = new LinkedList<DBConstellation>();
        while (rs.next()) {
            DBConstellation constellation = new DBConstellation();
            constellation.constellationID = rs.getString(1);
            constellation.name = rs.getString(2);
            constellation.description = rs.getString(3);
            constellation.dbAffinities = DBConstellationAffinity.getByConstellationID(constellation.constellationID);
            constellation.dbStars = DBConstellationStar.getByConstellationID(constellation.constellationID);
            list.add(constellation);
        }
        return list;
    }

    public static void createFile(String filename) {
        List<DBConstellation> list = DBConstellation.getAll();
        String data = "";
        data = data + DBConstellation.getHeaderLine();
        Collections.sort(list);
        for (DBConstellation constellation : list) {
            Collections.sort(constellation.dbAffinities);
            Collections.sort(constellation.dbStars);
            data = data + DBConstellation.getConstellationSummary(constellation);
            for (DBConstellationStar star : constellation.dbStars) {
                data = data + DBConstellation.getStarSummary(constellation, star);
            }
        }
        try {
            GDWriter.write(filename, data);
        }
        catch (Exception ex) {
            GDMsgLogger.addError(ex);
        }
    }

    private static String getHeaderLine() {
        String s = "Constellation\tAscendant\tChaos\tEdlritch\tOrder\tPrimordial\tStar\tBonus Value\tBonus Type\tPet Bonus\t# Stars\tAscendant\tChaos\tEdlritch\tOrder\tPrimordial" + GDConstants.LINE_SEPARATOR;
        return s;
    }

    private static String getConstellationSummary(DBConstellation constellation) {
        String s = constellation.name;
        int tabCount = 0;
        for (DBConstellationAffinity affinity : constellation.dbAffinities) {
            if (!affinity.isRequired()) continue;
            if (affinity.getAffinity().equals("Ascendant")) {
                while (tabCount < 1) {
                    s = s + '\t';
                    ++tabCount;
                }
                s = s + Integer.toString(affinity.getPoints());
            }
            if (affinity.getAffinity().equals("Chaos")) {
                while (tabCount < 2) {
                    s = s + '\t';
                    ++tabCount;
                }
                s = s + Integer.toString(affinity.getPoints());
            }
            if (affinity.getAffinity().equals("Eldritch")) {
                while (tabCount < 3) {
                    s = s + '\t';
                    ++tabCount;
                }
                s = s + Integer.toString(affinity.getPoints());
            }
            if (affinity.getAffinity().equals("Order")) {
                while (tabCount < 4) {
                    s = s + '\t';
                    ++tabCount;
                }
                s = s + Integer.toString(affinity.getPoints());
            }
            if (!affinity.getAffinity().equals("Primordial")) continue;
            while (tabCount < 5) {
                s = s + '\t';
                ++tabCount;
            }
            s = s + Integer.toString(affinity.getPoints());
        }
        while (tabCount < 6) {
            s = s + '\t';
            ++tabCount;
        }
        s = s + "0";
        while (tabCount < 10) {
            s = s + '\t';
            ++tabCount;
        }
        s = s + Integer.toString(constellation.dbStars.size());
        for (DBConstellationAffinity affinity : constellation.dbAffinities) {
            if (affinity.isRequired()) continue;
            if (affinity.getAffinity().equals("Ascendant")) {
                while (tabCount < 11) {
                    s = s + '\t';
                    ++tabCount;
                }
                s = s + Integer.toString(affinity.getPoints());
            }
            if (affinity.getAffinity().equals("Chaos")) {
                while (tabCount < 12) {
                    s = s + '\t';
                    ++tabCount;
                }
                s = s + Integer.toString(affinity.getPoints());
            }
            if (affinity.getAffinity().equals("Eldritch")) {
                while (tabCount < 13) {
                    s = s + '\t';
                    ++tabCount;
                }
                s = s + Integer.toString(affinity.getPoints());
            }
            if (affinity.getAffinity().equals("Order")) {
                while (tabCount < 14) {
                    s = s + '\t';
                    ++tabCount;
                }
                s = s + Integer.toString(affinity.getPoints());
            }
            if (!affinity.getAffinity().equals("Primordial")) continue;
            while (tabCount < 15) {
                s = s + '\t';
                ++tabCount;
            }
            s = s + Integer.toString(affinity.getPoints());
        }
        s = s + GDConstants.LINE_SEPARATOR;
        return s;
    }

    private static String getStarSummary(DBConstellation constellation, DBConstellationStar star) {
        int tc2;
        String s;
        String pre = constellation.name;
        for (int tabCount = 0; tabCount < 6; ++tabCount) {
            pre = pre + '\t';
        }
        pre = pre + Integer.toString(star.getIndex()) + '\t';
        String all = "";
        DBSkill skill = star.getSkill();
        if (skill.isDevotion()) {
            String s2 = pre + skill.getName() + '\t' + "Skill";
            for (int tc22 = tabCount; tc22 < 15; ++tc22) {
                s2 = s2 + '\t';
            }
            all = all + s2 + GDConstants.LINE_SEPARATOR;
        }
        List<DBStat> stats = DBStat.getByLevel(skill.getStatList(), 1);
        List<BonusInfo> infos = BonusDetail.createStatInfos(stats, null);
        for (BonusInfo info : infos) {
            s = pre;
            s = s + info.text + '\t';
            s = s + info.statDesc + '\t';
            for (tc2 = tabCount; tc2 < 15; ++tc2) {
                s = s + '\t';
            }
            all = all + s + GDConstants.LINE_SEPARATOR;
        }
        if (skill.getPetSkill() != null) {
            stats = DBStat.getByLevel(skill.getPetSkill().getStatList(), 1);
            infos = BonusDetail.createStatInfos(stats, null);
            for (BonusInfo info : infos) {
                s = pre;
                s = s + info.text + '\t';
                s = s + info.statDesc + '\t';
                s = s + "Y" + '\t';
                for (tc2 = tabCount; tc2 < 15; ++tc2) {
                    s = s + '\t';
                }
                all = all + s + GDConstants.LINE_SEPARATOR;
            }
        }
        return all;
    }
}

