/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.DBConstellation;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBConstellationAffinity
implements Comparable<DBConstellationAffinity> {
    private static final String TABLE_NAME = "GDC_CONSTELLATION_AFFINITY";
    private static final int ROW_CONSTELLATION_ID = 1;
    private static final int ROW_AFFINITY = 2;
    private static final int ROW_REQUIRED = 3;
    private static final int ROW_POINTS = 4;
    private String constellationID;
    private String affinity;
    private boolean required;
    private int points;
    private int index;

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!o.getClass().equals(DBConstellationAffinity.class)) {
            return false;
        }
        DBConstellationAffinity affinity = (DBConstellationAffinity)o;
        return affinity.constellationID.equals(this.constellationID);
    }

    public int hashCode() {
        int hash = this.constellationID.hashCode();
        hash += this.index;
        if (this.required) {
            hash += 100;
        }
        return hash;
    }

    @Override
    public int compareTo(DBConstellationAffinity o) {
        if (!o.getClass().equals(DBConstellationAffinity.class)) {
            Object[] args = new Object[]{DBConstellationAffinity.class, o.toString()};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_NOT_OF_TYPE", args);
            throw new ClassCastException(msg);
        }
        DBConstellationAffinity affinity = o;
        int comp = this.constellationID.compareTo(affinity.constellationID);
        if (comp != 0) {
            return comp;
        }
        if (this.required) {
            if (!affinity.required) {
                return -1;
            }
        } else if (affinity.required) {
            return 1;
        }
        return this.index - affinity.index;
    }

    public String getAffinity() {
        return this.affinity;
    }

    public boolean isRequired() {
        return this.required;
    }

    public int getPoints() {
        return this.points;
    }

    public int getIndex() {
        return this.index;
    }

    public void setAffinity(String affinity) {
        this.affinity = affinity;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setPoints(int points) {
        this.points = points;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public static void createTable() throws SQLException {
        String dropTable = "DROP TABLE GDC_CONSTELLATION_AFFINITY";
        String createTable = "CREATE TABLE GDC_CONSTELLATION_AFFINITY (CONSTELLATION_ID VARCHAR(256) NOT NULL, AFFINITY         VARCHAR(32) NOT NULL, REQUIRED         BOOLEAN, POINTS           INTEGER, PRIMARY KEY (CONSTELLATION_ID, AFFINITY, REQUIRED))";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (Statement st = conn.createStatement();){
                if (GDDBUtil.tableExists(conn, TABLE_NAME)) {
                    st.execute(dropTable);
                }
                st.execute(createTable);
                st.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void delete(Connection conn, String itemSetID) throws SQLException {
        String deleteEntry = "DELETE FROM GDC_CONSTELLATION_AFFINITY WHERE CONSTELLATION_ID = ?";
        try (PreparedStatement ps = conn.prepareStatement(deleteEntry);){
            ps.setString(1, itemSetID);
            ps.executeUpdate();
            ps.close();
        }
    }

    public static void insert(Connection conn, DBConstellation dbConstellation) throws SQLException {
        if (dbConstellation.getStarList() == null) {
            return;
        }
        if (dbConstellation.getStarList().isEmpty()) {
            return;
        }
        String insert = "INSERT INTO GDC_CONSTELLATION_AFFINITY VALUES (?,?,?,?)";
        try (PreparedStatement ps = conn.prepareStatement(insert);){
            for (DBConstellationAffinity dbAffinity : dbConstellation.getAffinityList()) {
                if (dbAffinity.getAffinity() == null || dbAffinity.getAffinity().isEmpty()) continue;
                ps.setString(1, dbConstellation.getConstellationID());
                ps.setString(2, dbAffinity.getAffinity());
                ps.setBoolean(3, dbAffinity.isRequired());
                ps.setInt(4, dbAffinity.getPoints());
                ps.executeUpdate();
                ps.clearParameters();
            }
            ps.close();
            conn.commit();
        }
    }

    public static List<DBConstellationAffinity> getByConstellationID(String constellationID) {
        List<DBConstellationAffinity> dbAffinities = null;
        String command = "SELECT * FROM GDC_CONSTELLATION_AFFINITY WHERE CONSTELLATION_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, constellationID);
            try (ResultSet rs = ps.executeQuery();){
                dbAffinities = DBConstellationAffinity.wrap(rs);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{constellationID, TABLE_NAME};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return dbAffinities;
    }

    private static List<DBConstellationAffinity> wrap(ResultSet rs) throws SQLException {
        LinkedList<DBConstellationAffinity> list = new LinkedList<DBConstellationAffinity>();
        while (rs.next()) {
            DBConstellationAffinity affinity = new DBConstellationAffinity();
            affinity.constellationID = rs.getString(1);
            affinity.affinity = rs.getString(2);
            affinity.required = rs.getBoolean(3);
            affinity.points = rs.getInt(4);
            list.add(affinity);
        }
        return list;
    }
}

