/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.DBConstellation;
import org.gdstash.db.DBSkill;
import org.gdstash.db.DBSkillButton;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBConstellationStar
implements Comparable<DBConstellationStar> {
    private static final String TABLE_NAME = "GDC_CONSTELLATION_STAR";
    private static final int ROW_CONSTELLATION_ID = 1;
    private static final int ROW_INDEX = 2;
    private static final int ROW_BUTTON_ID = 3;
    private String constellationID;
    private int index;
    private String buttonID;
    private DBSkillButton dbButton;

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!o.getClass().equals(DBConstellationStar.class)) {
            return false;
        }
        DBConstellationStar star = (DBConstellationStar)o;
        return star.constellationID.equals(this.constellationID);
    }

    public int hashCode() {
        int hash = this.constellationID.hashCode();
        return hash += this.index;
    }

    @Override
    public int compareTo(DBConstellationStar o) {
        if (!o.getClass().equals(DBConstellationStar.class)) {
            Object[] args = new Object[]{DBConstellationStar.class, o.toString()};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_NOT_OF_TYPE", args);
            throw new ClassCastException(msg);
        }
        DBConstellationStar star = o;
        int comp = this.constellationID.compareTo(star.constellationID);
        if (comp != 0) {
            return comp;
        }
        return this.index - star.index;
    }

    public String getButtonID() {
        return this.buttonID;
    }

    public int getIndex() {
        return this.index;
    }

    public DBSkillButton getButton() {
        return this.dbButton;
    }

    public DBSkill getSkill() {
        if (this.dbButton == null) {
            return null;
        }
        return this.dbButton.getSkill();
    }

    public void setButtonID(String buttonID) {
        this.buttonID = buttonID;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public static void createTable() throws SQLException {
        String dropTable = "DROP TABLE GDC_CONSTELLATION_STAR";
        String createTable = "CREATE TABLE GDC_CONSTELLATION_STAR (CONSTELLATION_ID VARCHAR(256) NOT NULL, INDEX            INTEGER, BUTTON_ID        VARCHAR(256), PRIMARY KEY (CONSTELLATION_ID, INDEX))";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (Statement st = conn.createStatement();){
                if (GDDBUtil.tableExists(conn, TABLE_NAME)) {
                    st.execute(dropTable);
                }
                st.execute(createTable);
                st.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void delete(Connection conn, String constellationID) throws SQLException {
        String deleteEntry = "DELETE FROM GDC_CONSTELLATION_STAR WHERE CONSTELLATION_ID = ?";
        try (PreparedStatement ps = conn.prepareStatement(deleteEntry);){
            ps.setString(1, constellationID);
            ps.executeUpdate();
            ps.close();
        }
    }

    public static void insert(Connection conn, DBConstellation dbConstellation) throws SQLException {
        if (dbConstellation.getStarList() == null) {
            return;
        }
        if (dbConstellation.getStarList().isEmpty()) {
            return;
        }
        String insert = "INSERT INTO GDC_CONSTELLATION_STAR VALUES (?,?,?)";
        try (PreparedStatement ps = conn.prepareStatement(insert);){
            for (DBConstellationStar dbStar : dbConstellation.getStarList()) {
                if (dbStar.buttonID == null || dbStar.buttonID.isEmpty()) continue;
                ps.setString(1, dbConstellation.getConstellationID());
                ps.setInt(2, dbStar.index);
                ps.setString(3, dbStar.buttonID);
                ps.executeUpdate();
                ps.clearParameters();
            }
            ps.close();
            conn.commit();
        }
    }

    public static List<DBConstellationStar> getByConstellationID(String constellationID) {
        List<DBConstellationStar> list = null;
        String command = "SELECT * FROM GDC_CONSTELLATION_STAR WHERE CONSTELLATION_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, constellationID);
            try (ResultSet rs = ps.executeQuery();){
                list = DBConstellationStar.wrap(rs);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{constellationID, TABLE_NAME};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return list;
    }

    private static List<DBConstellationStar> wrap(ResultSet rs) throws SQLException {
        LinkedList<DBConstellationStar> list = new LinkedList<DBConstellationStar>();
        while (rs.next()) {
            DBConstellationStar star = new DBConstellationStar();
            star.constellationID = rs.getString(1);
            star.index = rs.getInt(2);
            star.buttonID = rs.getString(3);
            if (star.buttonID != null) {
                star.dbButton = DBSkillButton.get(star.buttonID);
            }
            list.add(star);
        }
        return list;
    }
}

