/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.DBFaction;
import org.gdstash.db.DBFactionReputation;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.file.ARZRecord;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBEngineGame {
    private static final String TABLE_NAME = "GDC_GAME";
    private static final int ROW_ID = 1;
    private static final int ROW_FACTION_ALT_NEUTRAL_TAG = 2;
    private static final int ROW_FACTION_ALT_NEUTRAL_TEXT = 3;
    private String factionAltNeutralTag;
    private String factionAltNeutralText;
    protected List<DBFaction> factions;
    protected List<DBFactionReputation> reputations;

    public DBEngineGame() {
        this.factions = new LinkedList<DBFaction>();
        this.reputations = new LinkedList<DBFactionReputation>();
    }

    private DBEngineGame(ARZRecord record) {
        this.setFactionAltNeutralTag(record.getFactionAltNeutralTag());
        this.factions = new LinkedList<DBFaction>();
        this.reputations = record.getFactionReputationList();
    }

    public String getFactionAltNeutralTag() {
        return this.factionAltNeutralTag;
    }

    public String getFactionAltNeutralText() {
        return this.factionAltNeutralText;
    }

    public List<DBFactionReputation> getReputationList() {
        return this.reputations;
    }

    private void setFactionAltNeutralTag(String factionAltNeutralTag) {
        this.factionAltNeutralTag = factionAltNeutralTag;
        this.factionAltNeutralText = factionAltNeutralTag == null ? null : GDStashFrame.arcList.getTag("tags_ui.txt", factionAltNeutralTag);
    }

    public static void createTable() throws SQLException {
        String dropTable = "DROP TABLE GDC_GAME";
        String createTable = "CREATE TABLE GDC_GAME (ID          VARCHAR(8) NOT NULL, FACTION_ALT_NEUTRAL_TAG  VARCHAR(64), FACTION_ALT_NEUTRAL_TEXT VARCHAR(64), PRIMARY KEY (ID))";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (Statement st = conn.createStatement();){
                if (GDDBUtil.tableExists(conn, TABLE_NAME)) {
                    st.execute(dropTable);
                }
                st.execute(createTable);
                st.close();
                conn.commit();
                DBFactionReputation.createTable(conn);
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_CREATE_TABLE", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete() throws SQLException {
        String deleteEntry = "DELETE FROM GDC_GAME WHERE ID = ?";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(deleteEntry);){
                ps.setString(1, "DEFAULT");
                ps.executeUpdate();
                ps.close();
                DBFactionReputation.delete(conn);
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void insert(ARZRecord record) throws SQLException {
        DBEngineGame game = new DBEngineGame(record);
        String insert = "INSERT INTO GDC_GAME VALUES (?,?,?)";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(insert);){
                ps.setString(1, "DEFAULT");
                ps.setString(2, game.getFactionAltNeutralTag());
                ps.setString(3, game.getFactionAltNeutralText());
                ps.executeUpdate();
                ps.close();
                conn.commit();
                Iterator<DBFactionReputation> iter = null;
                for (DBFactionReputation reputation : game.reputations) {
                    DBFactionReputation.insert(conn, record, reputation);
                }
            }
            catch (SQLException ex) {
                conn.rollback();
                GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_IN_GAME_CONFIG"));
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void insertMod(ARZRecord record) throws SQLException {
        DBEngineGame entry = DBEngineGame.get();
        if (entry != null) {
            DBEngineGame.delete();
        }
        DBEngineGame.insert(record);
    }

    public static DBEngineGame get() {
        DBEngineGame game = new DBEngineGame();
        String command = "SELECT * FROM GDC_GAME WHERE ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, "DEFAULT");
            try (ResultSet rs = ps.executeQuery();){
                List<DBEngineGame> list = DBEngineGame.wrap(rs);
                game = list.isEmpty() ? null : list.get(0);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_READ_CONFIG_PLAYER"));
            GDMsgLogger.addError(ex);
            game = null;
        }
        return game;
    }

    private static List<DBEngineGame> wrap(ResultSet rs) throws SQLException {
        List<DBFactionReputation> reputations = DBFactionReputation.get();
        LinkedList<DBEngineGame> list = new LinkedList<DBEngineGame>();
        while (rs.next()) {
            DBEngineGame game = new DBEngineGame();
            game.factionAltNeutralTag = rs.getString(2);
            game.factionAltNeutralText = rs.getString(3);
            game.reputations = reputations;
            list.add(game);
        }
        return list;
    }
}

