/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.file.ARZRecord;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBEngineLevel {
    private static final String TABLE_NAME = "GDC_LEVEL";
    private static final int ROW_LEVEL = 1;
    private static final int ROW_STAT_POINTS = 2;
    private static final int ROW_SKILL_POINTS = 3;
    List<LevelStats> levels;

    public DBEngineLevel() {
        this.levels = new LinkedList<LevelStats>();
    }

    private DBEngineLevel(ARZRecord record) {
        this.levels = record.getLevelStatList();
    }

    public int getStatPointsForRange(int start, int end) {
        int min = start;
        int max = end;
        if (min > max) {
            int temp = min;
            min = max;
            max = temp;
        }
        if (--max > this.levels.size()) {
            max = this.levels.size();
        }
        if (min < 0) {
            min = 0;
        }
        int sum = 0;
        for (LevelStats stats : this.levels) {
            if (stats.level < min) continue;
            sum += stats.statPoints;
            if (stats.level < max) continue;
            break;
        }
        return sum;
    }

    public int getSkillPointsForRange(int start, int end) {
        int min = start;
        int max = end;
        if (min > max) {
            int temp = min;
            min = max;
            max = temp;
        }
        if (--max > this.levels.size()) {
            max = this.levels.size();
        }
        if (min < 0) {
            min = 0;
        }
        int sum = 0;
        for (LevelStats stats : this.levels) {
            if (stats.level < min) continue;
            sum += stats.skillPoints;
            if (stats.level < max) continue;
            break;
        }
        return sum;
    }

    public static void createTable() throws SQLException {
        String dropTable = "DROP TABLE GDC_LEVEL";
        String createTable = "CREATE TABLE GDC_LEVEL (LEVEL        INTEGER NOT NULL, STAT_POINTS  INTEGER, SKILL_POINTS INTEGER, PRIMARY KEY (LEVEL))";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (Statement st = conn.createStatement();){
                if (GDDBUtil.tableExists(conn, TABLE_NAME)) {
                    st.execute(dropTable);
                }
                st.execute(createTable);
                st.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_CREATE_TABLE", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete() throws SQLException {
        String deleteEntry = "DELETE FROM GDC_LEVEL";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(deleteEntry);){
                ps.executeUpdate();
                ps.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void insert(ARZRecord record) throws SQLException {
        if (!record.getFileName().equals("records/creatures/pc/playerlevels.dbr")) {
            return;
        }
        DBEngineLevel player = new DBEngineLevel(record);
        String insert = "INSERT INTO GDC_LEVEL VALUES (?,?,?)";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(insert);){
                for (LevelStats stats : player.levels) {
                    ps.setInt(1, stats.level);
                    ps.setInt(2, stats.statPoints);
                    ps.setInt(3, stats.skillPoints);
                    ps.executeUpdate();
                }
                ps.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_IN_PLAYER_CONFIG"));
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void insertMod(ARZRecord record) throws SQLException {
        DBEngineLevel entry = DBEngineLevel.get();
        if (entry != null) {
            DBEngineLevel.delete();
        }
        DBEngineLevel.insert(record);
    }

    public static DBEngineLevel get() {
        DBEngineLevel level = new DBEngineLevel();
        String command = "SELECT * FROM GDC_LEVEL ORDER BY LEVEL";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);
             ResultSet rs = ps.executeQuery();){
            level.levels = DBEngineLevel.wrap(rs);
            conn.commit();
        }
        catch (SQLException ex) {
            GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_READ_CONFIG_PLAYER"));
            GDMsgLogger.addError(ex);
            level = null;
        }
        return level;
    }

    private static List<LevelStats> wrap(ResultSet rs) throws SQLException {
        LinkedList<LevelStats> list = new LinkedList<LevelStats>();
        while (rs.next()) {
            LevelStats stats = new LevelStats();
            stats.level = rs.getInt(1);
            stats.statPoints = rs.getInt(2);
            stats.skillPoints = rs.getInt(3);
            list.add(stats);
        }
        return list;
    }

    public static class LevelStats {
        private int level;
        private int statPoints;
        private int skillPoints;

        public int getLevel() {
            return this.level;
        }

        public int getStatPoints() {
            return this.statPoints;
        }

        public int getSkillPoints() {
            return this.skillPoints;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public void setStatPoints(int statPoints) {
            this.statPoints = statPoints;
        }

        public void setSkillPoints(int skillPoints) {
            this.skillPoints = skillPoints;
        }
    }
}

