/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.file.ARZRecord;
import org.gdstash.file.GDParseException;
import org.gdstash.util.GDConstants;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBEnginePlayer {
    private static final String TABLE_NAME = "GDC_PLAYER";
    private static final int ROW_ID = 1;
    private static final int ROW_BASE_DEX = 2;
    private static final int ROW_BASE_INT = 3;
    private static final int ROW_BASE_STR = 4;
    private static final int ROW_BASE_LIFE = 5;
    private static final int ROW_BASE_MANA = 6;
    private static final int ROW_INCREMENT_DEX = 7;
    private static final int ROW_INCREMENT_INT = 8;
    private static final int ROW_INCREMENT_STR = 9;
    private static final int ROW_INCREMENT_LIFE = 10;
    private static final int ROW_INCREMENT_MANA = 11;
    private static final int ROW_MAX_LEVEL = 12;
    private static final int ROW_XP_FORMULA = 13;
    private int baseDex;
    private int baseInt;
    private int baseStr;
    private int baseLife;
    private int baseMana;
    private int incDex;
    private int incInt;
    private int incStr;
    private int incLife;
    private int incMana;
    private int maxLevel;
    private String xpFormula;
    private Expression expression;

    public DBEnginePlayer() {
        this.baseDex = 50;
        this.baseInt = 50;
        this.baseStr = 50;
        this.baseLife = 250;
        this.baseMana = 250;
        this.incDex = 8;
        this.incInt = 8;
        this.incStr = 8;
        this.incLife = 20;
        this.incMana = 16;
        this.expression = null;
    }

    private DBEnginePlayer(ARZRecord record) {
        this.baseDex = record.getPlayerBaseDex();
        this.baseInt = record.getPlayerBaseInt();
        this.baseStr = record.getPlayerBaseStr();
        this.baseLife = record.getPlayerBaseLife();
        this.baseMana = record.getPlayerBaseMana();
        this.incDex = record.getPlayerIncDex();
        this.incInt = record.getPlayerIncInt();
        this.incStr = record.getPlayerIncStr();
        this.incLife = record.getPlayerIncLife();
        this.incMana = record.getPlayerIncMana();
        this.maxLevel = record.getPlayerMaxLevel();
        try {
            this.setXPFormula(record.getXPFormula());
        }
        catch (GDParseException ex) {
            GDMsgLogger.addError(ex);
            this.expression = null;
        }
    }

    public int getBaseDex() {
        return this.baseDex;
    }

    public int getBaseInt() {
        return this.baseInt;
    }

    public int getBaseStr() {
        return this.baseStr;
    }

    public int getBaseLife() {
        return this.baseLife;
    }

    public int getBaseMana() {
        return this.baseMana;
    }

    public int getIncDex() {
        return this.incDex;
    }

    public int getIncInt() {
        return this.incInt;
    }

    public int getIncStr() {
        return this.incStr;
    }

    public int getIncLife() {
        return this.incLife;
    }

    public int getIncMana() {
        return this.incMana;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public String getXPFormula() {
        return this.xpFormula;
    }

    private void setXPFormula(String xpFormula) throws GDParseException {
        this.xpFormula = xpFormula;
        if (xpFormula != null) {
            ExpressionBuilder builder = new ExpressionBuilder(xpFormula);
            builder = builder.variables("playerLevel");
            builder = builder.variables("PLAYERLEVEL");
            try {
                this.expression = builder.build();
            }
            catch (Throwable ex) {
                throw new GDParseException(ex.getMessage());
            }
        }
    }

    private void setPlayerLevel(int level) {
        if (this.expression == null) {
            return;
        }
        this.expression.setVariable("playerLevel", level);
        this.expression.setVariable("PLAYERLEVEL", level);
    }

    private double getPlayerXP() {
        if (this.expression == null) {
            return 0.0;
        }
        double value = this.expression.evaluate();
        return value;
    }

    public int getPlayerXPByLevel(int level) {
        int lvl = 1;
        if (level > lvl) {
            lvl = level;
        }
        if (lvl == 1) {
            return 0;
        }
        this.setPlayerLevel(lvl - 1);
        return (int)(this.getPlayerXP() + 0.5);
    }

    public int getPlayerLevelByXP(int xp) {
        int currLevel = 1;
        int currXP = 0;
        while (currXP < xp) {
            this.setPlayerLevel(++currLevel);
            currXP = (int)this.getPlayerXP();
        }
        return currLevel;
    }

    public static void createTable() throws SQLException {
        String dropTable = "DROP TABLE GDC_PLAYER";
        String createTable = "CREATE TABLE GDC_PLAYER (ID          VARCHAR(8) NOT NULL, BASE_DEX    INTEGER, BASE_INT    INTEGER, BASE_STR    INTEGER, BASE_LIFE   INTEGER, BASE_MANA   INTEGER, INC_DEX     INTEGER, INC_INT     INTEGER, INC_STR     INTEGER, INC_LIFE    INTEGER, INC_MANA    INTEGER, MAX_LEVEL   INTEGER, XP_FORMULA  VARCHAR(256), PRIMARY KEY (ID))";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (Statement st = conn.createStatement();){
                if (GDDBUtil.tableExists(conn, TABLE_NAME)) {
                    st.execute(dropTable);
                }
                st.execute(createTable);
                st.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_CREATE_TABLE", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete() throws SQLException {
        String deleteEntry = "DELETE FROM GDC_PLAYER WHERE ID = ?";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(deleteEntry);){
                ps.setString(1, "DEFAULT");
                ps.executeUpdate();
                ps.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void insert(ARZRecord record) throws SQLException {
        DBEnginePlayer player = new DBEnginePlayer(record);
        DBEnginePlayer entry = DBEnginePlayer.get();
        boolean inc = record.getFileName().equals("records/creatures/pc/playerlevels.dbr");
        String sql = null;
        sql = entry == null ? "INSERT INTO GDC_PLAYER VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)" : (inc ? "UPDATE GDC_PLAYER SET INC_DEX = ?, INC_INT = ?, INC_STR = ?, INC_LIFE = ?, INC_MANA = ?, MAX_LEVEL = ?, XP_FORMULA = ? WHERE ID = ?" : "UPDATE GDC_PLAYER SET BASE_DEX = ?, BASE_INT = ?, BASE_STR = ?, BASE_LIFE = ?, BASE_MANA = ? WHERE ID = ?");
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(sql);){
                if (entry == null) {
                    ps.setString(1, "DEFAULT");
                    ps.setInt(2, player.getBaseDex());
                    ps.setInt(3, player.getBaseInt());
                    ps.setInt(4, player.getBaseStr());
                    ps.setInt(5, player.getBaseLife());
                    ps.setInt(6, player.getBaseMana());
                    ps.setInt(7, player.getIncDex());
                    ps.setInt(8, player.getIncInt());
                    ps.setInt(9, player.getIncStr());
                    ps.setInt(10, player.getIncLife());
                    ps.setInt(11, player.getIncMana());
                    ps.setInt(12, player.getMaxLevel());
                    ps.setString(13, player.getXPFormula());
                } else if (inc) {
                    ps.setInt(1, player.getIncDex());
                    ps.setInt(2, player.getIncInt());
                    ps.setInt(3, player.getIncStr());
                    ps.setInt(4, player.getIncLife());
                    ps.setInt(5, player.getIncMana());
                    ps.setInt(6, player.getMaxLevel());
                    ps.setString(7, player.getXPFormula());
                    ps.setString(8, "DEFAULT");
                } else {
                    ps.setInt(1, player.getBaseDex());
                    ps.setInt(2, player.getBaseInt());
                    ps.setInt(3, player.getBaseStr());
                    ps.setInt(4, player.getBaseLife());
                    ps.setInt(5, player.getBaseMana());
                    ps.setString(6, "DEFAULT");
                }
                ps.executeUpdate();
                ps.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_IN_PLAYER_CONFIG"));
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void insertMod(ARZRecord record) throws SQLException {
        DBEnginePlayer entry = DBEnginePlayer.get();
        if (entry != null) {
            DBEnginePlayer.delete();
        }
        DBEnginePlayer.insert(record);
    }

    public static DBEnginePlayer get() {
        DBEnginePlayer player = new DBEnginePlayer();
        String command = "SELECT * FROM GDC_PLAYER WHERE ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, "DEFAULT");
            try (ResultSet rs = ps.executeQuery();){
                List<DBEnginePlayer> list = DBEnginePlayer.wrap(rs);
                player = list.isEmpty() ? null : list.get(0);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_READ_CONFIG_PLAYER"));
            GDMsgLogger.addError(ex);
            player = null;
        }
        return player;
    }

    private static List<DBEnginePlayer> wrap(ResultSet rs) throws SQLException {
        LinkedList<DBEnginePlayer> list = new LinkedList<DBEnginePlayer>();
        while (rs.next()) {
            DBEnginePlayer player = new DBEnginePlayer();
            player.baseDex = rs.getInt(2);
            player.baseInt = rs.getInt(3);
            player.baseStr = rs.getInt(4);
            player.baseLife = rs.getInt(5);
            player.baseMana = rs.getInt(6);
            player.incDex = rs.getInt(7);
            player.incInt = rs.getInt(8);
            player.incStr = rs.getInt(9);
            player.incLife = rs.getInt(10);
            player.incMana = rs.getInt(11);
            player.maxLevel = rs.getInt(12);
            player.xpFormula = rs.getString(13);
            if (player.xpFormula != null) {
                player.xpFormula = player.xpFormula.toUpperCase(GDConstants.LOCALE_US);
            }
            try {
                player.setXPFormula(player.xpFormula);
            }
            catch (GDParseException gDParseException) {
                // empty catch block
            }
            list.add(player);
        }
        return list;
    }
}

