/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.file.ARCList;
import org.gdstash.file.ARZDecompress;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBEngineTagText {
    private static final String TABLE_NAME = "GDC_TAGTEXT";
    private static final String PREFIX_MASTERY_TAG = "tagSkillClassName";
    private static final int MAX_MASTERIES = 30;
    private static final int ROW_TAG = 1;
    private static final int ROW_TEXT_MS = 2;
    private static final int ROW_TEXT_FS = 3;
    private static final int ROW_TEXT_NS = 4;
    private static final int ROW_TEXT_MP = 5;
    private static final int ROW_TEXT_FP = 6;
    private static final int ROW_TEXT_NP = 7;
    private static ConcurrentHashMap<String, DBEngineTagText> hashBuffer = new ConcurrentHashMap();
    private static List<DBEngineTagText> texts = new LinkedList<DBEngineTagText>();
    private String tag;
    private String textMS;
    private String textFS;
    private String textNS;
    private String textMP;
    private String textFP;
    private String textNP;

    public DBEngineTagText() {
        this.tag = null;
        this.textMS = null;
        this.textFS = null;
        this.textNS = null;
        this.textMP = null;
        this.textFP = null;
        this.textNP = null;
    }

    public DBEngineTagText(String tag, String text) {
        this.tag = tag;
        String[] genders = ARZDecompress.getGenderTexts(text);
        this.textMS = genders[0];
        this.textFS = genders[1];
        this.textNS = genders[2];
        this.textMP = genders[3];
        this.textFP = genders[4];
        this.textNP = genders[5];
    }

    public String getTag() {
        return this.tag;
    }

    public String getText(int genderID) {
        String s = null;
        switch (genderID) {
            case 0: {
                s = this.textMS;
                break;
            }
            case 1: {
                s = this.textFS;
                break;
            }
            case 2: {
                s = this.textNS;
                break;
            }
            case 3: {
                s = this.textMP;
                break;
            }
            case 4: {
                s = this.textFP;
                break;
            }
            case 5: {
                s = this.textNP;
                break;
            }
            default: {
                s = "";
            }
        }
        return s;
    }

    public static void clearBuffer() {
        hashBuffer.clear();
    }

    public static void createTable() throws SQLException {
        String dropTable = "DROP TABLE GDC_TAGTEXT";
        String createTable = "CREATE TABLE GDC_TAGTEXT (TAG     VARCHAR(256), TEXT_MS VARCHAR(256), TEXT_FS VARCHAR(256), TEXT_NS VARCHAR(256), TEXT_MP VARCHAR(256), TEXT_FP VARCHAR(256), TEXT_NP VARCHAR(256), PRIMARY KEY (TAG))";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (Statement st = conn.createStatement();){
                if (GDDBUtil.tableExists(conn, TABLE_NAME)) {
                    st.execute(dropTable);
                }
                st.execute(createTable);
                st.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_CREATE_TABLE", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(String tag) throws SQLException {
        String deleteEntry = "DELETE FROM GDC_TAGTEXT WHERE TAG = ?";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(deleteEntry);){
                ps.setString(1, tag);
                ps.executeUpdate();
                ps.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void insert() throws SQLException {
        String insert = "INSERT INTO GDC_TAGTEXT VALUES (?,?,?,?,?,?,?)";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(insert);){
                ps.setString(1, this.tag);
                ps.setString(2, this.textMS);
                ps.setString(3, this.textFS);
                ps.setString(4, this.textNS);
                ps.setString(5, this.textMP);
                ps.setString(6, this.textFP);
                ps.setString(7, this.textNP);
                ps.executeUpdate();
                ps.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_IN_PLAYER_CONFIG"));
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public void insertMod() throws SQLException {
        DBEngineTagText text = DBEngineTagText.get(this.tag);
        if (text != null) {
            DBEngineTagText.delete(this.tag);
        }
        this.insert();
    }

    public static DBEngineTagText get(String tag) {
        DBEngineTagText tt = null;
        tt = hashBuffer.get(tag);
        if (tt == null) {
            tt = DBEngineTagText.getDB(tag);
        }
        return tt;
    }

    private static DBEngineTagText getDB(String tag) {
        DBEngineTagText tt = new DBEngineTagText();
        String command = "SELECT * FROM GDC_TAGTEXT WHERE TAG = ? ";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, tag);
            try (ResultSet rs = ps.executeQuery();){
                List<DBEngineTagText> list = DBEngineTagText.wrap(rs);
                tt = list.isEmpty() ? null : list.get(0);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_READ_CONFIG_PLAYER"));
            GDMsgLogger.addError(ex);
            tt = null;
        }
        return tt;
    }

    private static List<DBEngineTagText> wrap(ResultSet rs) throws SQLException {
        LinkedList<DBEngineTagText> list = new LinkedList<DBEngineTagText>();
        while (rs.next()) {
            DBEngineTagText tt = new DBEngineTagText();
            tt.tag = rs.getString(1);
            DBEngineTagText buff = hashBuffer.get(tt.tag);
            if (buff != null) {
                list.add(buff);
                continue;
            }
            tt.textMS = rs.getString(2);
            tt.textFS = rs.getString(3);
            tt.textNS = rs.getString(4);
            tt.textMP = rs.getString(5);
            tt.textFP = rs.getString(6);
            tt.textNP = rs.getString(7);
            list.add(tt);
            hashBuffer.put(tt.tag, tt);
        }
        return list;
    }

    public static void collectTags(ARCList list) {
        DBEngineTagText tt = null;
        for (int i = 1; i <= 30; ++i) {
            String num1 = String.format("%02d", i);
            String tag1 = PREFIX_MASTERY_TAG + num1;
            String text = list.getTag("tags_skills.txt", tag1);
            if (text == null || text.isEmpty()) continue;
            tt = new DBEngineTagText(tag1, text);
            texts.add(tt);
            for (int j = i + 1; j <= 30; ++j) {
                String num2 = String.format("%02d", j);
                String tag2 = tag1 + num2;
                text = list.getTag("tags_skills.txt", tag2);
                if (text == null || text.isEmpty()) continue;
                tt = new DBEngineTagText(tag2, text);
                texts.add(tt);
            }
        }
    }

    public static void storeTags() {
        for (DBEngineTagText tt : texts) {
            try {
                tt.insertMod();
            }
            catch (SQLException sQLException) {}
        }
        texts.clear();
    }
}

