/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.DBItemCraft;
import org.gdstash.db.DBMerchant;
import org.gdstash.db.DBMerchantTableAlloc;
import org.gdstash.db.DBMerchantTableSetAlloc;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.file.ARZRecord;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBFaction {
    private static final String TABLE_NAME = "GDC_FACTION";
    private static final int ROW_FACTION_ID = 1;
    private static final int ROW_BOUNTY_ENABLED = 2;
    private static final int ROW_QUEST_ENABLED = 3;
    private static final int ROW_FACTION_TAG = 4;
    private static final int ROW_FACTION_TEXT = 5;
    private String factionID;
    private boolean bountyEnabled;
    private boolean questEnabled;
    private String factionTag;
    private String factionText;

    public DBFaction() {
    }

    private DBFaction(ARZRecord record) {
        this.factionID = record.getFileName();
        this.bountyEnabled = record.getFactionBountyEnabled();
        this.questEnabled = record.getFactionQuestEnabled();
        this.setFactionTag(record.getFactionTag());
    }

    public String getFactionID() {
        return this.factionID;
    }

    public boolean isBountyEnabled() {
        return this.bountyEnabled;
    }

    public boolean isQuestEnabled() {
        return this.questEnabled;
    }

    public String getFactionTag() {
        return this.factionTag;
    }

    public String getFactionText() {
        return this.factionText;
    }

    public static String getFactionTextByItemID(String itemID) {
        DBItemCraft craft;
        String tableID = DBMerchantTableAlloc.getTableIDByItemID(itemID);
        if (tableID == null) {
            String s = null;
            int pos = itemID.indexOf("b_");
            if (pos == -1) {
                pos = itemID.indexOf("c_");
            }
            if (pos == -1) {
                pos = itemID.indexOf("d_");
            }
            if (pos != -1) {
                String s1 = itemID.substring(0, pos);
                String s2 = itemID.substring(pos + 2);
                s = s1 + "a_" + s2;
            }
            if (s != null) {
                tableID = DBMerchantTableAlloc.getTableIDByItemID(s);
            }
        }
        if (tableID == null && (craft = DBItemCraft.getByCraftID(itemID)) != null) {
            tableID = DBMerchantTableAlloc.getTableIDByItemID(craft.getItemID());
        }
        if (tableID == null) {
            return null;
        }
        String tableSetID = DBMerchantTableSetAlloc.getTableSetIDByTableID(tableID);
        if (tableSetID == null) {
            return null;
        }
        DBMerchant dbMerchant = DBMerchant.getByTableSetID(tableSetID);
        if (dbMerchant == null) {
            return null;
        }
        if (dbMerchant.getFactionID() == null) {
            return null;
        }
        DBFaction dbFaction = DBFaction.get(dbMerchant.getFactionID());
        if (dbFaction == null) {
            return null;
        }
        return dbFaction.getFactionText();
    }

    private void setFactionTag(String factionTag) {
        this.factionTag = factionTag;
        if (factionTag == null) {
            this.factionText = null;
        } else {
            String tag = "tagFaction" + factionTag;
            this.factionText = GDStashFrame.arcList.getTag("tags_ui.txt", tag);
        }
    }

    public static void createTable() throws SQLException {
        String dropTable = "DROP TABLE GDC_FACTION";
        String createTable = "CREATE TABLE GDC_FACTION (FACTION_ID     VARCHAR(256) NOT NULL, BOUNTY_ENABLED BOOLEAN, QUEST_ENABLED  BOOLEAN, FACTION_TAG    VARCHAR(64), FACTION_TEXT   VARCHAR(128), PRIMARY KEY (FACTION_ID))";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (Statement st = conn.createStatement();){
                if (GDDBUtil.tableExists(conn, TABLE_NAME)) {
                    st.execute(dropTable);
                }
                st.execute(createTable);
                st.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_CREATE_TABLE", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(String factionID) throws SQLException {
        String deleteEntry = "DELETE FROM GDC_FACTION WHERE FACTION_ID = ?";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(deleteEntry);){
                ps.setString(1, factionID);
                ps.executeUpdate();
                ps.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void insert(ARZRecord record) throws SQLException {
        DBFaction faction = new DBFaction(record);
        String insert = "INSERT INTO GDC_FACTION VALUES (?,?,?,?,?)";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(insert);){
                ps.setString(1, faction.factionID);
                ps.setBoolean(2, faction.bountyEnabled);
                ps.setBoolean(3, faction.questEnabled);
                ps.setString(4, faction.factionTag);
                ps.setString(5, faction.factionText);
                ps.executeUpdate();
                ps.clearParameters();
                ps.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_IN_GAME_CONFIG"));
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void insertMod(ARZRecord record) throws SQLException {
        DBFaction entry = DBFaction.get(record.getFileName());
        if (entry != null) {
            DBFaction.delete(record.getFileName());
        }
        DBFaction.insert(record);
    }

    public static DBFaction get(String factionID) {
        DBFaction faction = null;
        String command = "SELECT * FROM GDC_FACTION WHERE FACTION_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, factionID);
            try (ResultSet rs = ps.executeQuery();){
                List<DBFaction> list = DBFaction.wrap(rs);
                faction = list.isEmpty() ? null : list.get(0);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{factionID, TABLE_NAME};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return faction;
    }

    public static List<DBFaction> getAll() {
        List<DBFaction> list = null;
        String command = "SELECT * FROM GDC_FACTION";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);
             ResultSet rs = ps.executeQuery();){
            list = DBFaction.wrap(rs);
            conn.commit();
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{"-", TABLE_NAME};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return list;
    }

    private static List<DBFaction> wrap(ResultSet rs) throws SQLException {
        LinkedList<DBFaction> list = new LinkedList<DBFaction>();
        while (rs.next()) {
            DBFaction faction = new DBFaction();
            faction.factionID = rs.getString(1);
            faction.bountyEnabled = rs.getBoolean(2);
            faction.questEnabled = rs.getBoolean(3);
            faction.factionTag = rs.getString(4);
            faction.factionText = rs.getString(5);
            list.add(faction);
        }
        return list;
    }
}

