/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import org.gdstash.db.DBFormulaSet;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.db.ParameterSet;
import org.gdstash.util.GDConstants;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBFormula {
    private static final String TABLE_NAME = "GD_FORMULA";
    private static final int ROW_FORMULASET_ID = 1;
    private static final int ROW_FORMULA_ID = 2;
    private static final int ROW_FORMULA = 3;
    public static final String FORMULA_COST_ARMOR = "armorCostEquation";
    public static final String FORMULA_COST_JEWELRY = "jewelryCostEquation";
    public static final String FORMULA_COST_OFFHAND = "offhandCostEquation";
    public static final String FORMULA_COST_SHIELD = "shieldCostEquation";
    public static final String FORMULA_COST_MELEE_1H = "weaponCostEquation";
    public static final String FORMULA_COST_MELEE_2H = "weaponMelee2hCostEquation";
    public static final String FORMULA_COST_RANGED_1H = "weaponRangedCostEquation";
    public static final String FORMULA_COST_RANGED_2H = "weaponRanged2hCostEquation";
    public static final String FORMULA_DEX_DAGGER = "daggerDexterityEquation";
    public static final String FORMULA_DEX_RANGED_1H = "ranged1hDexterityEquation";
    public static final String FORMULA_DEX_RANGED_2H = "ranged2hDexterityEquation";
    public static final String FORMULA_DEX_SWORD = "swordDexterityEquation";
    public static final String FORMULA_INT_AMULET = "amuletIntelligenceEquation";
    public static final String FORMULA_INT_CHEST = "chestIntelligenceEquation";
    public static final String FORMULA_INT_DAGGER = "daggerIntelligenceEquation";
    public static final String FORMULA_INT_HEAD = "headIntelligenceEquation";
    public static final String FORMULA_INT_OFFHAND = "offhandIntelligenceEquation";
    public static final String FORMULA_INT_RING = "ringIntelligenceEquation";
    public static final String FORMULA_INT_SCEPTER = "scepterIntelligenceEquation";
    public static final String FORMULA_STR_AXE = "axeStrengthEquation";
    public static final String FORMULA_STR_CHEST = "chestStrengthEquation";
    public static final String FORMULA_STR_FEET = "feetStrengthEquation";
    public static final String FORMULA_STR_HANDS = "handsStrengthEquation";
    public static final String FORMULA_STR_HEAD = "headStrengthEquation";
    public static final String FORMULA_STR_LEGS = "legsStrengthEquation";
    public static final String FORMULA_STR_MACE = "maceStrengthEquation";
    public static final String FORMULA_STR_MELEE_2H = "melee2hStrengthEquation";
    public static final String FORMULA_STR_SCEPTER = "scepterStrengthEquation";
    public static final String FORMULA_STR_SHIELD = "shieldStrengthEquation";
    public static final String FORMULA_STR_SHOULDERS = "shouldersStrengthEquation";
    public static final String FORMULA_STR_BELT = "waistStrengthEquation";
    private String formulaSetID;
    private String formulaID;
    private String formula;
    private Expression expression = null;

    public String getFormulaSetID() {
        return this.formulaSetID;
    }

    public String getFormulaID() {
        return this.formulaID;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormulaSetID(String formulaSetID) {
        this.formulaSetID = formulaSetID;
    }

    public void setFormulaID(String formulaID) {
        this.formulaID = formulaID;
    }

    public void setFormula(String formula) {
        this.formula = formula;
        if (formula != null) {
            ExpressionBuilder builder = new ExpressionBuilder(formula);
            builder = builder.variables("charAttackSpeed", "damageAvgBase", "damageAvgPierceRatio", "defenseAttrArmor", "itemLevel", "itemPrefixCost", "itemSuffixCost", "shieldBlockChance", "shieldBlockDefense", "totalAttCount", "CHARATTACKSPEED", "DAMAGEAVGBASE", "DAMAGEAVGPIERCERATIO", "DEFENSEATTRARMOR", "ITEMLEVEL", "ITEMPREFIXCOST", "ITEMSUFFIXCOST", "SHIELDBLOCKCHANCE", "SHIELDBLOCKDEFENSE", "TOTALATTCOUNT");
            this.expression = builder.build();
        }
    }

    public void setParameterSet(ParameterSet ps) {
        if (this.expression == null) {
            return;
        }
        this.expression.setVariable("charAttackSpeed", ps.getCharAttackSpeed());
        this.expression.setVariable("damageAvgBase", ps.getDamageAvgBase());
        this.expression.setVariable("damageAvgPierceRatio", ps.getDamageAvgPierceRatio());
        this.expression.setVariable("defenseAttrArmor", ps.getDefenseAttrArmor());
        this.expression.setVariable("itemLevel", ps.getItemLevel());
        this.expression.setVariable("itemPrefixCost", ps.getItemPrefixCost());
        this.expression.setVariable("itemSuffixCost", ps.getItemSuffixCost());
        this.expression.setVariable("shieldBlockChance", ps.getShieldBlockChance());
        this.expression.setVariable("shieldBlockDefense", ps.getShieldBlockDefense());
        this.expression.setVariable("totalAttCount", ps.getTotalAttCount());
        this.expression.setVariable("CHARATTACKSPEED", ps.getCharAttackSpeed());
        this.expression.setVariable("DAMAGEAVGBASE", ps.getDamageAvgBase());
        this.expression.setVariable("DAMAGEAVGPIERCERATIO", ps.getDamageAvgPierceRatio());
        this.expression.setVariable("DEFENSEATTRARMOR", ps.getDefenseAttrArmor());
        this.expression.setVariable("ITEMLEVEL", ps.getItemLevel());
        this.expression.setVariable("ITEMPREFIXCOST", ps.getItemPrefixCost());
        this.expression.setVariable("ITEMSUFFIXCOST", ps.getItemSuffixCost());
        this.expression.setVariable("SHIELDBLOCKCHANCE", ps.getShieldBlockChance());
        this.expression.setVariable("SHIELDBLOCKDEFENSE", ps.getShieldBlockDefense());
        this.expression.setVariable("TOTALATTCOUNT", ps.getTotalAttCount());
    }

    public double getValue() {
        if (this.expression == null) {
            return 0.0;
        }
        double value = this.expression.evaluate();
        return value;
    }

    public static void createTable() throws SQLException {
        String dropTable = "DROP TABLE GD_FORMULA";
        String createTable = "CREATE TABLE GD_FORMULA (FORMULASET_ID   VARCHAR(256) NOT NULL, FORMULA_ID      VARCHAR(64), FORMULA         VARCHAR(256), PRIMARY KEY (FORMULASET_ID, FORMULA_ID))";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (Statement st = conn.createStatement();){
                if (GDDBUtil.tableExists(conn, TABLE_NAME)) {
                    st.execute(dropTable);
                }
                st.execute(createTable);
                st.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_CREATE_TABLE", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void delete(Connection conn, String formulaSetID) throws SQLException {
        String deleteEntry = "DELETE FROM GD_FORMULA WHERE FORMULASET_ID = ?";
        try (PreparedStatement ps = conn.prepareStatement(deleteEntry);){
            ps.setString(1, formulaSetID);
            ps.executeUpdate();
            ps.close();
        }
    }

    public static void insert(Connection conn, DBFormulaSet dbFormulaSet) throws SQLException {
        if (dbFormulaSet.getFormulaList() == null) {
            return;
        }
        if (dbFormulaSet.getFormulaList().isEmpty()) {
            return;
        }
        String insert = "INSERT INTO GD_FORMULA VALUES (?,?,?)";
        try (PreparedStatement ps = conn.prepareStatement(insert);){
            for (DBFormula formula : dbFormulaSet.getFormulaList()) {
                ps.setString(1, dbFormulaSet.getFormulaSetID());
                ps.setString(2, formula.formulaID);
                ps.setString(3, formula.formula);
                ps.executeUpdate();
                ps.clearParameters();
            }
            ps.close();
            conn.commit();
        }
    }

    public static List<DBFormula> getByFormulaSetID(String formulaSetID) {
        List<DBFormula> list = null;
        String command = "SELECT * FROM GD_FORMULA WHERE FORMULASET_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, formulaSetID);
            try (ResultSet rs = ps.executeQuery();){
                list = DBFormula.wrap(rs);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{formulaSetID, TABLE_NAME};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return list;
    }

    private static List<DBFormula> wrap(ResultSet rs) throws SQLException {
        LinkedList<DBFormula> list = new LinkedList<DBFormula>();
        while (rs.next()) {
            DBFormula formula = new DBFormula();
            formula.formulaSetID = rs.getString(1);
            formula.formulaID = rs.getString(2);
            formula.formula = rs.getString(3);
            if (formula.formula != null) {
                formula.formula = formula.formula.toUpperCase(GDConstants.LOCALE_US);
            }
            formula.setFormula(formula.formula);
            list.add(formula);
        }
        return list;
    }
}

