/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.gdstash.db.DBItem;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBItemCraft {
    private static final String TABLE_NAME = "GD_ITEM_CRAFT";
    private static final String FIELD_ID = "ITEM_ID";
    private static final int ROW_ITEM_ID = 1;
    private static final int ROW_CRAFT_ID = 2;
    private static ConcurrentHashMap<String, DBItemCraft> hashBuffer = new ConcurrentHashMap();
    private String itemID;
    private String craftID;

    public String getItemID() {
        return this.itemID;
    }

    public String getCraftID() {
        return this.craftID;
    }

    public void setItemID(String itemID) {
        this.itemID = itemID;
    }

    public void setCraftID(String craftID) {
        this.craftID = craftID;
    }

    public static void clearBuffer() {
        hashBuffer.clear();
    }

    public static void createTables(Connection conn) throws SQLException {
        String dropTable = "DROP TABLE GD_ITEM_CRAFT";
        String createTable = "CREATE TABLE GD_ITEM_CRAFT (ITEM_ID VARCHAR(256) NOT NULL, CRAFT_ID     VARCHAR(256), PRIMARY KEY (ITEM_ID))";
        try (Statement st = conn.createStatement();){
            if (GDDBUtil.tableExists(conn, TABLE_NAME)) {
                st.execute(dropTable);
            }
            st.execute(createTable);
            st.close();
            conn.commit();
        }
        catch (SQLException ex) {
            conn.rollback();
            Object[] args = new Object[]{TABLE_NAME};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_CREATE_TABLE", args);
            GDMsgLogger.addError(msg);
            throw ex;
        }
    }

    public static void delete(Connection conn, String itemID) throws SQLException {
        String deleteEntry = "DELETE FROM GD_ITEM_CRAFT WHERE ITEM_ID = ?";
        try (PreparedStatement ps = conn.prepareStatement(deleteEntry);){
            ps.setString(1, itemID);
            ps.executeUpdate();
            ps.close();
        }
    }

    public static void insert(Connection conn, DBItem dbItem) throws SQLException {
        String insertItem = "INSERT INTO GD_ITEM_CRAFT VALUES (?,?)";
        try (PreparedStatement ps = conn.prepareStatement(insertItem);){
            ps.setString(1, dbItem.getItemID());
            ps.setString(2, dbItem.getCraftID());
            ps.executeUpdate();
            ps.close();
            conn.commit();
        }
        catch (SQLException ex) {
            conn.rollback();
            Object[] args = new Object[]{dbItem.getItemID(), TABLE_NAME};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_INS_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            throw ex;
        }
    }

    public static DBItemCraft get(String itemID) {
        DBItemCraft craft = null;
        craft = hashBuffer.get(itemID);
        if (craft == null) {
            craft = DBItemCraft.getDB(itemID);
        }
        return craft;
    }

    private static DBItemCraft getDB(String itemID) {
        DBItemCraft craft = null;
        String command = "SELECT * FROM GD_ITEM_CRAFT WHERE ITEM_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, itemID);
            try (ResultSet rs = ps.executeQuery();){
                List<DBItemCraft> list = DBItemCraft.wrap(rs);
                craft = list.isEmpty() ? null : list.get(0);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{itemID, TABLE_NAME};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return craft;
    }

    public static List<DBItemCraft> getByItemIDs(List<String> itemIDs) {
        LinkedList<DBItemCraft> list = new LinkedList<DBItemCraft>();
        for (String itemID : itemIDs) {
            DBItemCraft craft = DBItemCraft.get(itemID);
            list.add(craft);
        }
        return list;
    }

    public static DBItemCraft getByCraftID(String itemID) {
        DBItemCraft craft = null;
        String command = "SELECT * FROM GD_ITEM_CRAFT WHERE CRAFT_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, itemID);
            try (ResultSet rs = ps.executeQuery();){
                List<DBItemCraft> list = DBItemCraft.wrap(rs);
                craft = list.isEmpty() ? null : list.get(0);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{itemID, TABLE_NAME};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return craft;
    }

    public static boolean isCraftableItemID(String itemID) {
        Object crafts = null;
        boolean craftable = false;
        String command = "SELECT * FROM GD_ITEM_CRAFT WHERE CRAFT_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, itemID);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    craftable = true;
                }
                conn.commit();
            }
            catch (SQLException ex) {
                craftable = false;
                throw ex;
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{itemID, TABLE_NAME};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return craftable;
    }

    private static List<DBItemCraft> wrap(ResultSet rs) throws SQLException {
        LinkedList<DBItemCraft> list = new LinkedList<DBItemCraft>();
        while (rs.next()) {
            DBItemCraft craft = new DBItemCraft();
            craft.itemID = rs.getString(1);
            craft.craftID = rs.getString(2);
            list.add(craft);
            hashBuffer.put(craft.itemID, craft);
        }
        return list;
    }
}

