/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.DBItem;
import org.gdstash.db.DBItemSetAlloc;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.file.ARZRecord;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBItemSet {
    private static final String TABLE_NAME = "GD_ITEMSET";
    private static final int ROW_ITEMSET_ID = 1;
    private static final int ROW_NAME = 2;
    private static final int ROW_DESCRIPTION = 3;
    private String itemSetID;
    private String name;
    private String description;
    private List<String> itemIDs = new LinkedList<String>();
    private String rarity;
    private int reqLevel;

    public DBItemSet() {
    }

    public DBItemSet(ARZRecord record) {
        this();
        this.itemSetID = record.getFileName();
        this.setName(record.getItemSetNameTag());
        this.setDescription(record.getItemSetDescriptionTag());
        this.itemIDs = record.getItemSetItemIDList();
        this.rarity = record.getRarity();
        this.reqLevel = record.getRequiredLevel();
    }

    public String getItemSetID() {
        return this.itemSetID;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getItemIDList() {
        return this.itemIDs;
    }

    private void setName(String name) {
        this.name = GDStashFrame.arcList.getTag("tags_items.txt", name);
    }

    private void setDescription(String description) {
        this.description = GDStashFrame.arcList.getTag("tags_items.txt", description);
    }

    public static void createTables() throws SQLException {
        String dropTable = "DROP TABLE GD_ITEMSET";
        String createTable = "CREATE TABLE GD_ITEMSET (ITEMSET_ID  VARCHAR(256) NOT NULL, NAME        VARCHAR(64), DESCRIPTION VARCHAR(512), PRIMARY KEY (ITEMSET_ID))";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (Statement st = conn.createStatement();){
                if (GDDBUtil.tableExists(conn, TABLE_NAME)) {
                    st.execute(dropTable);
                }
                st.execute(createTable);
                st.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_CREATE_TABLE", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
        DBItemSetAlloc.createTable();
    }

    public static void delete(String itemSetID) throws SQLException {
        String deleteEntry = "DELETE FROM GD_ITEMSET WHERE ITEMSET_ID = ?";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(deleteEntry);){
                ps.setString(1, itemSetID);
                ps.executeUpdate();
                ps.close();
                DBItemSetAlloc.delete(conn, itemSetID);
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{itemSetID, TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_DEL_TABLE_BY_ID", args);
                GDMsgLogger.addError(msg);
                GDMsgLogger.addError(ex);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void insert(ARZRecord record) throws SQLException {
        DBItemSet itemSet = new DBItemSet(record);
        if (itemSet.itemIDs == null) {
            return;
        }
        if (itemSet.itemIDs.isEmpty()) {
            return;
        }
        String insert = "INSERT INTO GD_ITEMSET VALUES (?,?,?)";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(insert);){
                ps.setString(1, itemSet.itemSetID);
                ps.setString(2, itemSet.name);
                ps.setString(3, itemSet.description);
                ps.executeUpdate();
                ps.close();
                conn.commit();
                DBItemSetAlloc.insert(conn, itemSet);
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{record.getFileName(), TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_INS_TABLE_BY_ID", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void insertMod(ARZRecord record) throws SQLException {
        DBItemSet entry = DBItemSet.get(record.getFileName());
        if (entry != null) {
            DBItemSet.delete(record.getFileName());
        }
        DBItemSet.insert(record);
    }

    public static DBItemSet get(String itemSetID) {
        DBItemSet set = new DBItemSet();
        String command = "SELECT * FROM GD_ITEMSET WHERE ITEMSET_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, itemSetID);
            try (ResultSet rs = ps.executeQuery();){
                List<DBItemSet> list = DBItemSet.wrap(rs);
                set = list.isEmpty() ? null : list.get(0);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{itemSetID, TABLE_NAME};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return set;
    }

    public static List<DBItemSet> getAll() {
        List<DBItemSet> list = null;
        String command = "SELECT * FROM GD_ITEMSET ORDER BY NAME";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);
             ResultSet rs = ps.executeQuery();){
            list = DBItemSet.wrap(rs);
            conn.commit();
        }
        catch (SQLException ex) {
            GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_READ_ITEMSET_ALL"));
            GDMsgLogger.addError(ex);
        }
        return list;
    }

    private static List<DBItemSet> wrap(ResultSet rs) throws SQLException {
        LinkedList<DBItemSet> list = new LinkedList<DBItemSet>();
        while (rs.next()) {
            DBItemSet set = new DBItemSet();
            set.itemSetID = rs.getString(1);
            set.name = rs.getString(2);
            set.description = rs.getString(3);
            set.itemIDs = DBItemSetAlloc.getByItemSetID(set.itemSetID);
            String rarity = null;
            boolean matchRarity = true;
            int reqLevel = 0;
            boolean matchLevel = true;
            if (set.itemIDs != null) {
                List<DBItem> items = DBItem.getByItemIDs(set.itemIDs);
                for (DBItem item : items) {
                    if (item == null) continue;
                    if (rarity == null) {
                        rarity = item.getRarity();
                    } else {
                        boolean bl = matchRarity = matchRarity && rarity.equals(item.getRarity());
                    }
                    if (reqLevel == 0) {
                        reqLevel = item.getRequiredlevel();
                        continue;
                    }
                    matchLevel = reqLevel == item.getRequiredlevel();
                }
                if (matchRarity) {
                    set.rarity = rarity;
                }
                if (matchLevel) {
                    set.reqLevel = reqLevel;
                }
            }
            list.add(set);
        }
        return list;
    }

    public String toString() {
        String s = this.name;
        if (this.reqLevel != 0) {
            Object[] args = new Object[]{String.format("%03d", this.reqLevel)};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_LEVEL_NUM", args);
            s = s + " [" + msg + "]";
        }
        if (this.rarity != null) {
            if (this.rarity.equals("Epic")) {
                s = "<html><font color = \"#002864\">" + s + "</font>" + "</html>";
            }
            if (this.rarity.equals("Legendary")) {
                s = "<html><font color = \"#320064\">" + s + "</font>" + "</html>";
            }
        }
        return s;
    }
}

