/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.gdstash.db.DBAffix;
import org.gdstash.db.DBAffixSet;
import org.gdstash.db.DBItem;
import org.gdstash.db.DBLootTableAffixSetAlloc;
import org.gdstash.db.DBLootTableItemAlloc;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.file.ARZRecord;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBLootTable {
    private static final String TABLE_NAME = "GD_LOOTTABLE_HD";
    private static final int ROW_TABLE_ID = 1;
    private static final int ROW_NPRE_NSUF = 2;
    private static final int ROW_NPRE_RSUF = 3;
    private static final int ROW_RPRE_NSUF = 4;
    private static final int ROW_RPRE_RSUF = 5;
    private static ConcurrentHashMap<String, DBLootTable> hashBuffer = new ConcurrentHashMap();
    private String tableID;
    private boolean nPre_nSuf;
    private boolean nPre_rSuf;
    private boolean rPre_nSuf;
    private boolean rPre_rSuf;
    private List<DBLootTableItemAlloc> items;
    private List<DBLootTableAffixSetAlloc> affixSets;
    private List<DBAffix> magicPrefixes;
    private List<DBAffix> rarePrefixes;
    private List<DBAffix> magicSuffixes;
    private List<DBAffix> rareSuffixes;
    private List<String> itemIDs;

    public DBLootTable() {
        this.items = new LinkedList<DBLootTableItemAlloc>();
        this.affixSets = new LinkedList<DBLootTableAffixSetAlloc>();
    }

    private DBLootTable(ARZRecord record) {
        this.tableID = record.getFileName();
        this.nPre_nSuf = record.getTableNormalPrefixSuffix();
        this.nPre_rSuf = record.getTableNormalPrefixRareSuffix();
        this.rPre_nSuf = record.getTableRarePrefixNormalSuffix();
        this.rPre_rSuf = record.getTableRarePrefixSuffix();
        this.items = record.getTableItemAllocList();
        this.affixSets = record.getTableAffixSetAllocList();
    }

    public String getTableID() {
        return this.tableID;
    }

    public boolean isMagicPrefixMagicSuffixAllowed() {
        return this.nPre_nSuf;
    }

    public boolean isMagicPrefixRareSuffixAllowed() {
        return this.nPre_rSuf;
    }

    public boolean isRarePrefixMagicSuffixAllowed() {
        return this.rPre_nSuf;
    }

    public boolean isRarePrefixRareSuffixAllowed() {
        return this.rPre_rSuf;
    }

    public List<DBLootTableItemAlloc> getItemAllocList() {
        return this.items;
    }

    public List<DBLootTableAffixSetAlloc> getAffixSetAllocList() {
        return this.affixSets;
    }

    public List<String> getItemIDs() {
        LinkedList<String> list = new LinkedList<String>();
        if (this.items == null) {
            return list;
        }
        for (DBLootTableItemAlloc item : this.items) {
            if (item == null || item.getItemID() == null) continue;
            list.add(item.getItemID());
        }
        return list;
    }

    public List<String> getAffixSetIDs() {
        LinkedList<String> list = new LinkedList<String>();
        if (this.affixSets == null) {
            return list;
        }
        for (DBLootTableAffixSetAlloc set : this.affixSets) {
            if (set == null || set.getAffixSetID() == null) continue;
            list.add(set.getAffixSetID());
        }
        return list;
    }

    public static void clearBuffer() {
        hashBuffer.clear();
    }

    public static void createTables() throws SQLException {
        String dropTable = "DROP TABLE GD_LOOTTABLE_HD";
        String createTable = "CREATE TABLE GD_LOOTTABLE_HD (TABLE_ID    VARCHAR(256) NOT NULL, NPRE_NSUF   BOOLEAN, NPRE_RSUF   BOOLEAN, RPRE_NSUF   BOOLEAN, RPRE_RSUF   BOOLEAN, PRIMARY KEY (TABLE_ID))";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (Statement st = conn.createStatement();){
                if (GDDBUtil.tableExists(conn, TABLE_NAME)) {
                    st.execute(dropTable);
                }
                st.execute(createTable);
                st.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_CREATE_TABLE", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
        DBLootTableItemAlloc.createTable();
        DBLootTableAffixSetAlloc.createTable();
    }

    public static void delete(String tableID) throws SQLException {
        String deleteEntry = "DELETE FROM GD_LOOTTABLE_HD WHERE TABLE_ID = ?";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(deleteEntry);){
                ps.setString(1, tableID);
                ps.executeUpdate();
                ps.close();
                DBLootTableItemAlloc.delete(conn, tableID);
                DBLootTableAffixSetAlloc.delete(conn, tableID);
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{tableID, TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_DEL_TABLE_BY_ID", args);
                GDMsgLogger.addError(msg);
                GDMsgLogger.addError(ex);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void insert(ARZRecord record) throws SQLException {
        DBLootTable table = new DBLootTable(record);
        if (table.items == null) {
            return;
        }
        if (table.items.isEmpty()) {
            return;
        }
        if (table.affixSets == null) {
            return;
        }
        if (table.affixSets.isEmpty()) {
            return;
        }
        String insert = "INSERT INTO GD_LOOTTABLE_HD VALUES (?,?,?,?,?)";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(insert);){
                ps.setString(1, table.tableID);
                ps.setBoolean(2, table.nPre_nSuf);
                ps.setBoolean(3, table.nPre_rSuf);
                ps.setBoolean(4, table.rPre_nSuf);
                ps.setBoolean(5, table.rPre_rSuf);
                ps.executeUpdate();
                ps.close();
                conn.commit();
                DBLootTableItemAlloc.insert(conn, table);
                DBLootTableAffixSetAlloc.insert(conn, table);
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{record.getFileName(), TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_INS_TABLE_BY_ID", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void insertMod(ARZRecord record) throws SQLException {
        DBLootTable entry = DBLootTable.get(record.getFileName());
        if (entry != null) {
            DBLootTable.delete(record.getFileName());
        }
        DBLootTable.insert(record);
    }

    public static DBLootTable get(String tableID) {
        DBLootTable table = null;
        table = hashBuffer.get(tableID);
        if (table == null && (table = DBLootTable.getDB(tableID)) != null) {
            hashBuffer.put(table.tableID, table);
        }
        return table;
    }

    private static DBLootTable getDB(String tableID) {
        DBLootTable table = null;
        String command = "SELECT * FROM GD_LOOTTABLE_HD WHERE TABLE_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, tableID);
            try (ResultSet rs = ps.executeQuery();){
                List<DBLootTable> list = DBLootTable.wrap(rs);
                table = list.isEmpty() ? null : list.get(0);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{tableID, TABLE_NAME};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return table;
    }

    public static List<DBLootTable> getByItemID(String itemID) {
        LinkedList<DBLootTable> list = new LinkedList<DBLootTable>();
        List<DBLootTableItemAlloc> items = null;
        items = DBLootTableItemAlloc.getByItemID(itemID);
        if (items == null) {
            return list;
        }
        if (items.isEmpty()) {
            return list;
        }
        for (DBLootTableItemAlloc item : items) {
            DBLootTable table = DBLootTable.get(item.getTableID());
            if (table == null) continue;
            list.add(table);
        }
        return list;
    }

    private static List<DBLootTable> wrap(ResultSet rs) throws SQLException {
        LinkedList<DBLootTable> list = new LinkedList<DBLootTable>();
        boolean found = false;
        while (rs.next()) {
            DBLootTable table = new DBLootTable();
            table.tableID = rs.getString(1);
            table.nPre_nSuf = rs.getBoolean(2);
            table.nPre_rSuf = rs.getBoolean(3);
            table.rPre_nSuf = rs.getBoolean(4);
            table.rPre_rSuf = rs.getBoolean(5);
            table.items = DBLootTableItemAlloc.getByTableID(table.tableID);
            table.affixSets = DBLootTableAffixSetAlloc.getByTableID(table.tableID);
            table.groupAffixes();
            list.add(table);
        }
        return list;
    }

    public List<DBAffix> getAllAffixes() {
        LinkedList<DBAffix> list = new LinkedList<DBAffix>();
        for (DBAffix affix : this.rarePrefixes) {
            list.add(affix);
        }
        for (DBAffix affix : this.magicPrefixes) {
            list.add(affix);
        }
        for (DBAffix affix : this.rareSuffixes) {
            list.add(affix);
        }
        for (DBAffix affix : this.magicSuffixes) {
            list.add(affix);
        }
        return list;
    }

    public List<DBAffix> getMagicPrefixes() {
        return this.magicPrefixes;
    }

    public List<DBAffix> getRarePrefixes() {
        return this.rarePrefixes;
    }

    public List<DBAffix> getMagicSuffixes() {
        return this.magicSuffixes;
    }

    public List<DBAffix> getRareSuffixes() {
        return this.rareSuffixes;
    }

    public List<DBAffix> getFilterPrefixesForSuffix(DBAffix suffix, List<DBAffix> filterPrefixes) {
        LinkedList<DBAffix> filter;
        block14: {
            block13: {
                filter = new LinkedList<DBAffix>();
                Iterator<DBAffix> iter = null;
                if (suffix == null) {
                    for (DBAffix affix : this.rarePrefixes) {
                        if (!filterPrefixes.contains(affix)) continue;
                        filter.add(affix);
                    }
                    for (DBAffix affix : this.magicPrefixes) {
                        if (!filterPrefixes.contains(affix)) continue;
                        filter.add(affix);
                    }
                    return filter;
                }
                if (suffix.getAffixType() != 2) {
                    return filter;
                }
                if (!suffix.getRarity().equals("Rare")) break block13;
                if (!this.rareSuffixes.contains(suffix)) {
                    return filter;
                }
                if (this.rPre_rSuf) {
                    for (DBAffix affix : this.rarePrefixes) {
                        if (!filterPrefixes.contains(affix)) continue;
                        filter.add(affix);
                    }
                }
                if (!this.nPre_rSuf) break block14;
                for (DBAffix affix : this.magicPrefixes) {
                    if (!filterPrefixes.contains(affix)) continue;
                    filter.add(affix);
                }
                break block14;
            }
            if (!this.magicSuffixes.contains(suffix)) {
                return filter;
            }
            if (this.rPre_nSuf) {
                for (DBAffix affix : this.rarePrefixes) {
                    if (!filterPrefixes.contains(affix)) continue;
                    filter.add(affix);
                }
            }
            if (this.nPre_nSuf) {
                for (DBAffix affix : this.magicPrefixes) {
                    if (!filterPrefixes.contains(affix)) continue;
                    filter.add(affix);
                }
            }
        }
        return filter;
    }

    public List<DBAffix> getFilterSuffixesForPrefix(DBAffix prefix, List<DBAffix> filterSuffixes) {
        LinkedList<DBAffix> filter;
        block14: {
            block13: {
                filter = new LinkedList<DBAffix>();
                Iterator<DBAffix> iter = null;
                if (prefix == null) {
                    for (DBAffix affix : this.rareSuffixes) {
                        if (!filterSuffixes.contains(affix)) continue;
                        filter.add(affix);
                    }
                    for (DBAffix affix : this.magicSuffixes) {
                        if (!filterSuffixes.contains(affix)) continue;
                        filter.add(affix);
                    }
                    return filter;
                }
                if (prefix.getAffixType() != 1) {
                    return filter;
                }
                if (!prefix.getRarity().equals("Rare")) break block13;
                if (!this.rarePrefixes.contains(prefix)) {
                    return filter;
                }
                if (this.rPre_rSuf) {
                    for (DBAffix affix : this.rareSuffixes) {
                        if (!filterSuffixes.contains(affix)) continue;
                        filter.add(affix);
                    }
                }
                if (!this.rPre_nSuf) break block14;
                for (DBAffix affix : this.magicSuffixes) {
                    if (!filterSuffixes.contains(affix)) continue;
                    filter.add(affix);
                }
                break block14;
            }
            if (!this.magicPrefixes.contains(prefix)) {
                return filter;
            }
            if (this.nPre_rSuf) {
                for (DBAffix affix : this.rareSuffixes) {
                    if (!filterSuffixes.contains(affix)) continue;
                    filter.add(affix);
                }
            }
            if (this.nPre_nSuf) {
                for (DBAffix affix : this.magicSuffixes) {
                    if (!filterSuffixes.contains(affix)) continue;
                    filter.add(affix);
                }
            }
        }
        return filter;
    }

    public boolean containsItem(DBItem item) {
        return this.itemIDs.contains(item.getItemID());
    }

    public static void mixAffixes(List<DBAffix> allAffixes, List<DBAffix> addAffixes) {
        for (DBAffix affix : addAffixes) {
            if (allAffixes.contains(affix)) continue;
            allAffixes.add(affix);
        }
    }

    private void groupAffixes() {
        this.magicPrefixes = new LinkedList<DBAffix>();
        this.rarePrefixes = new LinkedList<DBAffix>();
        this.magicSuffixes = new LinkedList<DBAffix>();
        this.rareSuffixes = new LinkedList<DBAffix>();
        this.itemIDs = this.getItemIDs();
        for (DBLootTableAffixSetAlloc as : this.affixSets) {
            List<DBAffixSet.DBEntry> asEntries = as.getAffixEntries();
            if (asEntries == null) continue;
            for (DBAffixSet.DBEntry asEntry : asEntries) {
                DBAffix affix;
                String affixID;
                if (asEntry == null || (affixID = asEntry.getAffixID()) == null || (affix = DBAffix.get(affixID)) == null) continue;
                String rarity = affix.getRarity();
                int type = affix.getAffixType();
                if (type == 1) {
                    if (rarity.equals("Magical") && !this.magicPrefixes.contains(affix)) {
                        this.magicPrefixes.add(affix);
                    }
                    if (rarity.equals("Rare") && !this.rarePrefixes.contains(affix)) {
                        this.rarePrefixes.add(affix);
                    }
                    if (rarity.equals("Epic") && !this.magicPrefixes.contains(affix)) {
                        this.magicPrefixes.add(affix);
                    }
                    if (rarity.equals("Legendary") && !this.magicPrefixes.contains(affix)) {
                        this.magicPrefixes.add(affix);
                    }
                }
                if (type != 2) continue;
                if (rarity.equals("Magical") && !this.magicSuffixes.contains(affix)) {
                    this.magicSuffixes.add(affix);
                }
                if (rarity.equals("Rare") && !this.rareSuffixes.contains(affix)) {
                    this.rareSuffixes.add(affix);
                }
                if (rarity.equals("Epic") && !this.magicSuffixes.contains(affix)) {
                    this.magicSuffixes.add(affix);
                }
                if (!rarity.equals("Legendary") || this.magicSuffixes.contains(affix)) continue;
                this.magicSuffixes.add(affix);
            }
        }
    }
}

