/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.DBAffixSet;
import org.gdstash.db.DBLootTable;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBLootTableAffixSetAlloc {
    private static final String TABLE_NAME = "GD_LOOTTABLE_AFFIXSET";
    private static final int ROW_TABLE_ID = 1;
    private static final int ROW_TYPE = 2;
    private static final int ROW_INDEX = 3;
    private static final int ROW_LEVEL_MIN = 4;
    private static final int ROW_LEVEL_MAX = 5;
    private static final int ROW_AFFIXSET_ID = 6;
    public static final int TYPE_PREFIX_NORMAL = 1;
    public static final int TYPE_SUFFIX_NORMAL = 2;
    public static final int TYPE_PREFIX_RARE = 3;
    public static final int TYPE_SUFFIX_RARE = 4;
    private String tableID;
    private int type;
    private int index;
    private int levelMin;
    private int levelMax;
    private String affixSetID;
    private DBAffixSet affixSet;

    public String getTableID() {
        return this.tableID;
    }

    public int getAffixType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public int getMinLevel() {
        return this.levelMin;
    }

    public int getMaxLevel() {
        return this.levelMax;
    }

    public String getAffixSetID() {
        return this.affixSetID;
    }

    public List<DBAffixSet.DBEntry> getAffixEntries() {
        if (this.affixSet == null) {
            return null;
        }
        return this.affixSet.getAffixEntries();
    }

    public void setTableID(String tableID) {
        this.tableID = tableID;
    }

    public void setAffixType(int type) {
        this.type = type;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setMinLevel(int levelMin) {
        this.levelMin = levelMin;
    }

    public void setMaxLevel(int levelMax) {
        this.levelMax = levelMax;
    }

    public void setAffixSetID(String affixSetID) {
        this.affixSetID = affixSetID;
    }

    public static void createTable() throws SQLException {
        String dropTable = "DROP TABLE GD_LOOTTABLE_AFFIXSET";
        String createTable = "CREATE TABLE GD_LOOTTABLE_AFFIXSET (TABLE_ID    VARCHAR(256) NOT NULL, TYPE        INTEGER, INDEX       INTEGER, LEVEL_MIN   INTEGER, LEVEL_MAX   INTEGER, AFFIXSET_ID VARCHAR(256) NOT NULL, PRIMARY KEY (TABLE_ID, TYPE, INDEX))";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (Statement st = conn.createStatement();){
                if (GDDBUtil.tableExists(conn, TABLE_NAME)) {
                    st.execute(dropTable);
                }
                st.execute(createTable);
                st.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_CREATE_TABLE", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void delete(Connection conn, String tableID) throws SQLException {
        String deleteEntry = "DELETE FROM GD_LOOTTABLE_AFFIXSET WHERE TABLE_ID = ?";
        try (PreparedStatement ps = conn.prepareStatement(deleteEntry);){
            ps.setString(1, tableID);
            ps.executeUpdate();
            ps.close();
        }
    }

    public static void insert(Connection conn, DBLootTable dbTable) throws SQLException {
        if (dbTable.getAffixSetAllocList() == null) {
            return;
        }
        if (dbTable.getAffixSetAllocList().isEmpty()) {
            return;
        }
        String insert = "INSERT INTO GD_LOOTTABLE_AFFIXSET VALUES (?,?,?,?,?,?)";
        try (PreparedStatement ps = conn.prepareStatement(insert);){
            for (DBLootTableAffixSetAlloc affixSet : dbTable.getAffixSetAllocList()) {
                if (affixSet.affixSetID == null) continue;
                ps.setString(1, dbTable.getTableID());
                ps.setInt(2, affixSet.type);
                ps.setInt(3, affixSet.index);
                ps.setInt(4, affixSet.levelMin);
                ps.setInt(5, affixSet.levelMax);
                ps.setString(6, affixSet.affixSetID);
                ps.executeUpdate();
                ps.clearParameters();
            }
            ps.close();
            conn.commit();
        }
    }

    public static List<DBLootTableAffixSetAlloc> getByTableID(String tableID) {
        List<DBLootTableAffixSetAlloc> list = null;
        String command = "SELECT * FROM GD_LOOTTABLE_AFFIXSET WHERE TABLE_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, tableID);
            try (ResultSet rs = ps.executeQuery();){
                list = DBLootTableAffixSetAlloc.wrap(rs);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{tableID, TABLE_NAME};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return list;
    }

    private static List<DBLootTableAffixSetAlloc> wrap(ResultSet rs) throws SQLException {
        LinkedList<DBLootTableAffixSetAlloc> list = new LinkedList<DBLootTableAffixSetAlloc>();
        while (rs.next()) {
            DBLootTableAffixSetAlloc set = new DBLootTableAffixSetAlloc();
            set.tableID = rs.getString(1);
            set.type = rs.getInt(2);
            set.index = rs.getInt(3);
            set.levelMin = rs.getInt(4);
            set.levelMax = rs.getInt(5);
            set.affixSetID = rs.getString(6);
            if (set.affixSetID != null) {
                set.affixSet = DBAffixSet.get(set.affixSetID);
            }
            list.add(set);
        }
        return list;
    }
}

