/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.DBLootTable;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBLootTableItemAlloc {
    private static final String TABLE_NAME = "GD_LOOTTABLE_ITEM";
    private static final int ROW_TABLE_ID = 1;
    private static final int ROW_ITEM_ID = 2;
    private String tableID;
    private String itemID;

    public DBLootTableItemAlloc() {
        this.tableID = null;
        this.itemID = null;
    }

    public DBLootTableItemAlloc(String tableID, String itemID) {
        this.tableID = tableID;
        this.itemID = itemID;
    }

    public String getTableID() {
        return this.tableID;
    }

    public String getItemID() {
        return this.itemID;
    }

    public static void createTable() throws SQLException {
        String dropTable = "DROP TABLE GD_LOOTTABLE_ITEM";
        String createTable = "CREATE TABLE GD_LOOTTABLE_ITEM (TABLE_ID    VARCHAR(256) NOT NULL, ITEM_ID     VARCHAR(256) NOT NULL, PRIMARY KEY (TABLE_ID, ITEM_ID))";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (Statement st = conn.createStatement();){
                if (GDDBUtil.tableExists(conn, TABLE_NAME)) {
                    st.execute(dropTable);
                }
                st.execute(createTable);
                st.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_CREATE_TABLE", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void delete(Connection conn, String tableID) throws SQLException {
        String deleteEntry = "DELETE FROM GD_LOOTTABLE_ITEM WHERE TABLE_ID = ?";
        try (PreparedStatement ps = conn.prepareStatement(deleteEntry);){
            ps.setString(1, tableID);
            ps.executeUpdate();
            ps.close();
        }
    }

    public static void insert(Connection conn, DBLootTable dbTable) throws SQLException {
        if (dbTable.getItemAllocList() == null) {
            return;
        }
        if (dbTable.getItemAllocList().isEmpty()) {
            return;
        }
        String insert = "INSERT INTO GD_LOOTTABLE_ITEM VALUES (?,?)";
        try (PreparedStatement ps = conn.prepareStatement(insert);){
            for (DBLootTableItemAlloc item : dbTable.getItemAllocList()) {
                try {
                    ps.setString(1, dbTable.getTableID());
                    ps.setString(2, item.itemID);
                    ps.executeUpdate();
                }
                catch (SQLIntegrityConstraintViolationException ex) {
                    if (ex.getSQLState().equals("23505")) {
                        Object[] args = new Object[]{dbTable.getTableID()};
                        String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_LOOT_ITEM_DUPLICATE", args);
                        GDMsgLogger.addWarning(msg);
                        GDMsgLogger.addWarning(ex);
                    }
                    throw ex;
                }
                ps.clearParameters();
            }
            ps.close();
            conn.commit();
        }
    }

    public static List<DBLootTableItemAlloc> getByTableID(String tableID) {
        List<DBLootTableItemAlloc> items = null;
        String command = "SELECT * FROM GD_LOOTTABLE_ITEM WHERE TABLE_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, tableID);
            try (ResultSet rs = ps.executeQuery();){
                items = DBLootTableItemAlloc.wrap(rs);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{tableID, TABLE_NAME};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return items;
    }

    public static List<DBLootTableItemAlloc> getByItemID(String itemID) {
        List<DBLootTableItemAlloc> items = null;
        String command = "SELECT * FROM GD_LOOTTABLE_ITEM WHERE ITEM_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, itemID);
            try (ResultSet rs = ps.executeQuery();){
                items = DBLootTableItemAlloc.wrap(rs);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{itemID, TABLE_NAME};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return items;
    }

    public static boolean isCraftableItemID(String itemID) {
        List<DBLootTableItemAlloc> items = null;
        boolean craftable = false;
        String command = "SELECT * FROM GD_LOOTTABLE_ITEM WHERE ITEM_ID = ? AND TABLE_ID LIKE 'records/items/loottables/%/tdyn_craft%.dbr'";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, itemID);
            try (ResultSet rs = ps.executeQuery();){
                items = DBLootTableItemAlloc.wrap(rs);
                craftable = !items.isEmpty();
                conn.commit();
            }
            catch (SQLException ex) {
                craftable = false;
                throw ex;
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{itemID, TABLE_NAME};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return craftable;
    }

    private static List<DBLootTableItemAlloc> wrap(ResultSet rs) throws SQLException {
        LinkedList<DBLootTableItemAlloc> list = new LinkedList<DBLootTableItemAlloc>();
        boolean found = false;
        while (rs.next()) {
            DBLootTableItemAlloc item = new DBLootTableItemAlloc();
            item.tableID = rs.getString(1);
            item.itemID = rs.getString(2);
            list.add(item);
        }
        return list;
    }
}

