/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.gdstash.db.DBLootTableSetAlloc;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.file.ARZRecord;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBLootTableSet {
    private static final String TABLE_NAME = "GD_LOOTTABLESET_HD";
    private static final int ROW_TABLESET_ID = 1;
    private static ConcurrentHashMap<String, DBLootTableSet> hashBuffer = new ConcurrentHashMap();
    private String tableSetID;
    private List<DBLootTableSetAlloc> entries;

    public DBLootTableSet() {
        this.entries = new LinkedList<DBLootTableSetAlloc>();
    }

    private DBLootTableSet(ARZRecord record) {
        this.tableSetID = record.getFileName();
        this.entries = record.getTableSetAllocList();
    }

    public String getTableSetID() {
        return this.tableSetID;
    }

    public List<DBLootTableSetAlloc> getAllocList() {
        return this.entries;
    }

    public static void clearBuffer() {
        hashBuffer.clear();
    }

    public static void createTables() throws SQLException {
        String dropTable = "DROP TABLE GD_LOOTTABLESET_HD";
        String createTable = "CREATE TABLE GD_LOOTTABLESET_HD (TABLESET_ID VARCHAR(256) NOT NULL, PRIMARY KEY (TABLESET_ID))";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (Statement st = conn.createStatement();){
                if (GDDBUtil.tableExists(conn, TABLE_NAME)) {
                    st.execute(dropTable);
                }
                st.execute(createTable);
                st.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_CREATE_TABLE", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
        DBLootTableSetAlloc.createTable();
    }

    public static void delete(String tableSetID) throws SQLException {
        String deleteEntry = "DELETE FROM GD_LOOTTABLESET_HD WHERE TABLESET_ID = ?";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(deleteEntry);){
                ps.setString(1, tableSetID);
                ps.executeUpdate();
                ps.close();
                DBLootTableSetAlloc.delete(conn, tableSetID);
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{tableSetID, TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_DEL_TABLE_BY_ID", args);
                GDMsgLogger.addError(msg);
                GDMsgLogger.addError(ex);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void insert(ARZRecord record) throws SQLException {
        DBLootTableSet tableSet = new DBLootTableSet(record);
        if (tableSet.entries == null) {
            return;
        }
        if (tableSet.entries.isEmpty()) {
            return;
        }
        String insert = "INSERT INTO GD_LOOTTABLESET_HD VALUES (?)";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(insert);){
                ps.setString(1, record.getFileName());
                ps.executeUpdate();
                ps.close();
                conn.commit();
                DBLootTableSetAlloc.insert(conn, tableSet);
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{record.getFileName(), TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_INS_TABLE_BY_ID", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void insertMod(ARZRecord record) throws SQLException {
        DBLootTableSet entry = DBLootTableSet.get(record.getFileName());
        if (entry != null) {
            DBLootTableSet.delete(record.getFileName());
        }
        DBLootTableSet.insert(record);
    }

    public static DBLootTableSet get(String tableSetID) {
        DBLootTableSet set = null;
        set = hashBuffer.get(tableSetID);
        if (set == null && (set = DBLootTableSet.getDB(tableSetID)) != null) {
            hashBuffer.put(set.tableSetID, set);
        }
        return set;
    }

    private static DBLootTableSet getDB(String tableSetID) {
        DBLootTableSet set = null;
        String command = "SELECT * FROM GD_LOOTTABLESET_HD WHERE TABLESET_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, tableSetID);
            try (ResultSet rs = ps.executeQuery();){
                List<DBLootTableSet> list = DBLootTableSet.wrap(rs);
                set = list.isEmpty() ? null : list.get(0);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{tableSetID, TABLE_NAME};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return set;
    }

    public static List<DBLootTableSet> getByTableID(String tableID) {
        List<DBLootTableSet> list = null;
        String command = "SELECT * FROM GD_LOOTTABLESET_HD WHERE TABLE_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, tableID);
            try (ResultSet rs = ps.executeQuery();){
                list = DBLootTableSet.wrap(rs);
                conn.commit();
            }
            catch (SQLException ex) {
                list = null;
                throw ex;
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{tableID, TABLE_NAME};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return list;
    }

    private static List<DBLootTableSet> wrap(ResultSet rs) throws SQLException {
        LinkedList<DBLootTableSet> list = new LinkedList<DBLootTableSet>();
        while (rs.next()) {
            DBLootTableSet set = new DBLootTableSet();
            set.tableSetID = rs.getString(1);
            set.entries = DBLootTableSetAlloc.getByTableSetID(set.tableSetID);
            list.add(set);
        }
        return list;
    }
}

