/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.file.ARZRecord;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBMerchant {
    private static final String TABLE_NAME = "GDC_MERCHANT";
    private static final int ROW_MERCHANT_ID = 1;
    private static final int ROW_FACTION_ID = 2;
    private static final int ROW_TABLESET_ID = 3;
    private String merchantID;
    private String factionID;
    private String tableSetID;

    public DBMerchant() {
    }

    private DBMerchant(ARZRecord record) {
        this.merchantID = record.getFileName();
        this.factionID = record.getMerchantFactionID();
        this.tableSetID = record.getMerchantTableSetID();
    }

    public String getMerchantID() {
        return this.merchantID;
    }

    public String getFactionID() {
        return this.factionID;
    }

    public String getTableSetID() {
        return this.tableSetID;
    }

    public static void createTables() throws SQLException {
        String dropTable = "DROP TABLE GDC_MERCHANT";
        String createTable = "CREATE TABLE GDC_MERCHANT (MERCHANT_ID    VARCHAR(256) NOT NULL, FACTION_ID     VARCHAR(256), TABLESET_ID    VARCHAR(256), PRIMARY KEY (MERCHANT_ID))";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (Statement st = conn.createStatement();){
                if (GDDBUtil.tableExists(conn, TABLE_NAME)) {
                    st.execute(dropTable);
                }
                st.execute(createTable);
                st.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_CREATE_TABLE", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void delete(String merchantID) throws SQLException {
        String deleteEntry = "DELETE FROM GDC_MERCHANT WHERE MERCHANT_ID = ?";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(deleteEntry);){
                ps.setString(1, merchantID);
                ps.executeUpdate();
                ps.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{merchantID, TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_DEL_TABLE_BY_ID", args);
                GDMsgLogger.addError(msg);
                GDMsgLogger.addError(ex);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void insert(ARZRecord record) throws SQLException {
        DBMerchant merchant = new DBMerchant(record);
        String insert = "INSERT INTO GDC_MERCHANT VALUES (?,?,?)";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(insert);){
                ps.setString(1, merchant.merchantID);
                ps.setString(2, merchant.factionID);
                ps.setString(3, merchant.tableSetID);
                ps.executeUpdate();
                ps.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{record.getFileName(), TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_INS_TABLE_BY_ID", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void insertMod(ARZRecord record) throws SQLException {
        DBMerchant entry = DBMerchant.get(record.getFileName());
        if (entry != null) {
            DBMerchant.delete(record.getFileName());
        }
        DBMerchant.insert(record);
    }

    public static DBMerchant get(String merchantID) {
        DBMerchant merchant = new DBMerchant();
        String command = "SELECT * FROM GDC_MERCHANT WHERE MERCHANT_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, merchantID);
            try (ResultSet rs = ps.executeQuery();){
                List<DBMerchant> list = DBMerchant.wrap(rs);
                merchant = list.isEmpty() ? null : list.get(0);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{merchantID, TABLE_NAME};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return merchant;
    }

    public static DBMerchant getByTableSetID(String tableSetID) {
        DBMerchant merchant = new DBMerchant();
        String command = "SELECT * FROM GDC_MERCHANT WHERE TABLESET_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, tableSetID);
            try (ResultSet rs = ps.executeQuery();){
                List<DBMerchant> list = DBMerchant.wrap(rs);
                merchant = list.isEmpty() ? null : list.get(0);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{tableSetID, TABLE_NAME};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return merchant;
    }

    private static List<DBMerchant> wrap(ResultSet rs) throws SQLException {
        LinkedList<DBMerchant> list = new LinkedList<DBMerchant>();
        while (rs.next()) {
            DBMerchant merchant = new DBMerchant();
            merchant.merchantID = rs.getString(1);
            merchant.factionID = rs.getString(2);
            merchant.tableSetID = rs.getString(3);
            list.add(merchant);
        }
        return list;
    }
}

