/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.DBMerchantTableAlloc;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.file.ARZRecord;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBMerchantTable {
    private static final String TABLE_NAME = "GDC_MERCHANTTABLE";
    private static final int ROW_TABLE_ID = 1;
    private String tableID;
    private List<String> itemIDs = new LinkedList<String>();

    public DBMerchantTable() {
    }

    private DBMerchantTable(ARZRecord record) {
        this();
        this.tableID = record.getFileName();
        this.itemIDs = record.getMerchantTableItemIDList();
    }

    public String getMerchantTableID() {
        return this.tableID;
    }

    public List<String> getItemIDList() {
        return this.itemIDs;
    }

    public static void createTables() throws SQLException {
        String dropTable = "DROP TABLE GDC_MERCHANTTABLE";
        String createTable = "CREATE TABLE GDC_MERCHANTTABLE (TABLE_ID    VARCHAR(256) NOT NULL, PRIMARY KEY (TABLE_ID))";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (Statement st = conn.createStatement();){
                if (GDDBUtil.tableExists(conn, TABLE_NAME)) {
                    st.execute(dropTable);
                }
                st.execute(createTable);
                st.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_CREATE_TABLE", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
        DBMerchantTableAlloc.createTable();
    }

    public static void delete(String tableID) throws SQLException {
        String deleteEntry = "DELETE FROM GDC_MERCHANTTABLE WHERE TABLE_ID = ?";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(deleteEntry);){
                ps.setString(1, tableID);
                ps.executeUpdate();
                ps.close();
                DBMerchantTableAlloc.delete(conn, tableID);
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{tableID, TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_DEL_TABLE_BY_ID", args);
                GDMsgLogger.addError(msg);
                GDMsgLogger.addError(ex);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void insert(ARZRecord record) throws SQLException {
        DBMerchantTable merchantTable = new DBMerchantTable(record);
        if (merchantTable.itemIDs == null) {
            return;
        }
        if (merchantTable.itemIDs.isEmpty()) {
            return;
        }
        String insert = "INSERT INTO GDC_MERCHANTTABLE VALUES (?)";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(insert);){
                ps.setString(1, merchantTable.tableID);
                ps.executeUpdate();
                ps.close();
                conn.commit();
                DBMerchantTableAlloc.insert(conn, merchantTable);
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{record.getFileName(), TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_INS_TABLE_BY_ID", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void insertMod(ARZRecord record) throws SQLException {
        DBMerchantTable entry = DBMerchantTable.get(record.getFileName());
        if (entry != null) {
            DBMerchantTable.delete(record.getFileName());
        }
        DBMerchantTable.insert(record);
    }

    public static DBMerchantTable get(String tableID) {
        DBMerchantTable table = new DBMerchantTable();
        String command = "SELECT * FROM GDC_MERCHANTTABLE WHERE TABLE_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, tableID);
            try (ResultSet rs = ps.executeQuery();){
                List<DBMerchantTable> list = DBMerchantTable.wrap(rs);
                table = list.isEmpty() ? null : list.get(0);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{tableID, TABLE_NAME};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return table;
    }

    private static List<DBMerchantTable> wrap(ResultSet rs) throws SQLException {
        LinkedList<DBMerchantTable> list = new LinkedList<DBMerchantTable>();
        while (rs.next()) {
            DBMerchantTable table = new DBMerchantTable();
            table.tableID = rs.getString(1);
            table.itemIDs = DBMerchantTableAlloc.getByMerchantTableID(table.tableID);
            list.add(table);
        }
        return list;
    }
}

