/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.DBMerchantTable;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBMerchantTableAlloc {
    private static final String TABLE_NAME = "GDC_MERCHANTTABLE_ALLOC";
    private static final int ROW_TABLE_ID = 1;
    private static final int ROW_ITEM_ID = 2;
    private String tableID;
    private String itemID;

    public static void createTable() throws SQLException {
        String dropTable = "DROP TABLE GDC_MERCHANTTABLE_ALLOC";
        String createTable = "CREATE TABLE GDC_MERCHANTTABLE_ALLOC (TABLE_ID  VARCHAR(256) NOT NULL, ITEM_ID   VARCHAR(256) NOT NULL, PRIMARY KEY (TABLE_ID, ITEM_ID))";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (Statement st = conn.createStatement();){
                if (GDDBUtil.tableExists(conn, TABLE_NAME)) {
                    st.execute(dropTable);
                }
                st.execute(createTable);
                st.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void delete(Connection conn, String tableID) throws SQLException {
        String deleteEntry = "DELETE FROM GDC_MERCHANTTABLE_ALLOC WHERE TABLE_ID = ?";
        try (PreparedStatement ps = conn.prepareStatement(deleteEntry);){
            ps.setString(1, tableID);
            ps.executeUpdate();
            ps.close();
        }
    }

    public static void insert(Connection conn, DBMerchantTable dbMerchantTable) throws SQLException {
        if (dbMerchantTable.getItemIDList() == null) {
            return;
        }
        if (dbMerchantTable.getItemIDList().isEmpty()) {
            return;
        }
        String insert = "INSERT INTO GDC_MERCHANTTABLE_ALLOC VALUES (?,?)";
        try (PreparedStatement ps = conn.prepareStatement(insert);){
            for (String item : dbMerchantTable.getItemIDList()) {
                ps.setString(1, dbMerchantTable.getMerchantTableID());
                ps.setString(2, item);
                ps.executeUpdate();
                ps.clearParameters();
            }
            ps.close();
            conn.commit();
        }
    }

    public static List<String> getByMerchantTableID(String tableID) {
        List<String> itemIDs = null;
        String command = "SELECT * FROM GDC_MERCHANTTABLE_ALLOC WHERE TABLE_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, tableID);
            try (ResultSet rs = ps.executeQuery();){
                itemIDs = DBMerchantTableAlloc.wrap(rs);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{tableID, TABLE_NAME};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return itemIDs;
    }

    public static String getTableIDByItemID(String itemID) {
        List<String> list = null;
        String tableID = null;
        String command = "SELECT * FROM GDC_MERCHANTTABLE_ALLOC WHERE ITEM_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, itemID);
            try (ResultSet rs = ps.executeQuery();){
                list = DBMerchantTableAlloc.wrapTableIDs(rs);
                tableID = list.isEmpty() ? null : list.get(0);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{itemID, TABLE_NAME};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return tableID;
    }

    private static List<String> wrap(ResultSet rs) throws SQLException {
        LinkedList<String> list = new LinkedList<String>();
        boolean found = false;
        while (rs.next()) {
            String itemID = rs.getString(2);
            list.add(itemID);
        }
        return list;
    }

    private static List<String> wrapTableIDs(ResultSet rs) throws SQLException {
        LinkedList<String> list = new LinkedList<String>();
        boolean found = false;
        while (rs.next()) {
            String tableID = rs.getString(1);
            list.add(tableID);
        }
        return list;
    }
}

