/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.DBMerchantTableSetAlloc;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.file.ARZRecord;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBMerchantTableSet {
    private static final String TABLE_NAME = "GDC_MERCHANTTABLESET";
    private static final int ROW_TABLESET_ID = 1;
    private String tableSetID;
    private List<String> tableIDs;

    public DBMerchantTableSet() {
        this.tableIDs = new LinkedList<String>();
    }

    private DBMerchantTableSet(ARZRecord record) {
        this.tableSetID = record.getFileName();
        this.tableIDs = record.getMerchantTableIDList();
    }

    public String getMerchantTableSetID() {
        return this.tableSetID;
    }

    public List<String> getTableIDList() {
        return this.tableIDs;
    }

    public static void createTables() throws SQLException {
        String dropTable = "DROP TABLE GDC_MERCHANTTABLESET";
        String createTable = "CREATE TABLE GDC_MERCHANTTABLESET (TABLESET_ID       VARCHAR(256) NOT NULL, PRIMARY KEY (TABLESET_ID))";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (Statement st = conn.createStatement();){
                if (GDDBUtil.tableExists(conn, TABLE_NAME)) {
                    st.execute(dropTable);
                }
                st.execute(createTable);
                st.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_CREATE_TABLE", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
        DBMerchantTableSetAlloc.createTable();
    }

    public static void delete(String tableSetID) throws SQLException {
        String deleteEntry = "DELETE FROM GDC_MERCHANTTABLESET WHERE TABLE_ID = ?";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(deleteEntry);){
                ps.setString(1, tableSetID);
                ps.executeUpdate();
                ps.close();
                DBMerchantTableSetAlloc.delete(conn, tableSetID);
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{tableSetID, TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_DEL_TABLE_BY_ID", args);
                GDMsgLogger.addError(msg);
                GDMsgLogger.addError(ex);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void insert(ARZRecord record) throws SQLException {
        DBMerchantTableSet merchantTableSet = new DBMerchantTableSet(record);
        if (merchantTableSet.tableIDs == null) {
            return;
        }
        if (merchantTableSet.tableIDs.isEmpty()) {
            return;
        }
        String insert = "INSERT INTO GDC_MERCHANTTABLESET VALUES (?)";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(insert);){
                ps.setString(1, merchantTableSet.tableSetID);
                ps.executeUpdate();
                ps.close();
                conn.commit();
                DBMerchantTableSetAlloc.insert(conn, merchantTableSet);
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{record.getFileName(), TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_INS_TABLE_BY_ID", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void insertMod(ARZRecord record) throws SQLException {
        DBMerchantTableSet entry = DBMerchantTableSet.get(record.getFileName());
        if (entry != null) {
            DBMerchantTableSet.delete(record.getFileName());
        }
        DBMerchantTableSet.insert(record);
    }

    public static DBMerchantTableSet get(String tableSetID) {
        DBMerchantTableSet tableSet = new DBMerchantTableSet();
        String command = "SELECT * FROM GDC_MERCHANTTABLESET WHERE TABLESET_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, tableSetID);
            try (ResultSet rs = ps.executeQuery();){
                List<DBMerchantTableSet> list = DBMerchantTableSet.wrap(rs);
                tableSet = list.isEmpty() ? null : list.get(0);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{tableSetID, TABLE_NAME};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return tableSet;
    }

    private static List<DBMerchantTableSet> wrap(ResultSet rs) throws SQLException {
        LinkedList<DBMerchantTableSet> list = new LinkedList<DBMerchantTableSet>();
        while (rs.next()) {
            DBMerchantTableSet tableSet = new DBMerchantTableSet();
            tableSet.tableSetID = rs.getString(1);
            tableSet.tableIDs = DBMerchantTableSetAlloc.getByMerchantTableSetID(tableSet.tableSetID);
            list.add(tableSet);
        }
        return list;
    }
}

