/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.DBMerchantTableSet;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBMerchantTableSetAlloc {
    private static final String TABLE_NAME = "GDC_MERCHANTTABLESET_ALLOC";
    private static final int ROW_TABLESET_ID = 1;
    private static final int ROW_TABLE_ID = 2;
    private String tableSetID;
    private String tableID;

    public static void createTable() throws SQLException {
        String dropTable = "DROP TABLE GDC_MERCHANTTABLESET_ALLOC";
        String createTable = "CREATE TABLE GDC_MERCHANTTABLESET_ALLOC (TABLESET_ID  VARCHAR(256) NOT NULL, TABLE_ID     VARCHAR(256) NOT NULL, PRIMARY KEY (TABLESET_ID, TABLE_ID))";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (Statement st = conn.createStatement();){
                if (GDDBUtil.tableExists(conn, TABLE_NAME)) {
                    st.execute(dropTable);
                }
                st.execute(createTable);
                st.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void delete(Connection conn, String tableSetID) throws SQLException {
        String deleteEntry = "DELETE FROM GDC_MERCHANTTABLESET_ALLOC WHERE TABLESET_ID = ?";
        try (PreparedStatement ps = conn.prepareStatement(deleteEntry);){
            ps.setString(1, tableSetID);
            ps.executeUpdate();
            ps.close();
        }
    }

    public static void insert(Connection conn, DBMerchantTableSet dbMerchantTableSet) throws SQLException {
        if (dbMerchantTableSet.getTableIDList() == null) {
            return;
        }
        if (dbMerchantTableSet.getTableIDList().isEmpty()) {
            return;
        }
        String insert = "INSERT INTO GDC_MERCHANTTABLESET_ALLOC VALUES (?,?)";
        try (PreparedStatement ps = conn.prepareStatement(insert);){
            for (String table : dbMerchantTableSet.getTableIDList()) {
                ps.setString(1, dbMerchantTableSet.getMerchantTableSetID());
                ps.setString(2, table);
                ps.executeUpdate();
                ps.clearParameters();
            }
            ps.close();
            conn.commit();
        }
    }

    public static List<String> getByMerchantTableSetID(String tableSetID) {
        List<String> tableIDs = null;
        String command = "SELECT * FROM GDC_MERCHANTTABLESET_ALLOC WHERE TABLE_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, tableSetID);
            try (ResultSet rs = ps.executeQuery();){
                tableIDs = DBMerchantTableSetAlloc.wrap(rs);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{tableSetID, TABLE_NAME};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return tableIDs;
    }

    public static String getTableSetIDByTableID(String tableID) {
        List<String> list = null;
        Object tableSetID = null;
        String command = "SELECT * FROM GDC_MERCHANTTABLESET_ALLOC WHERE TABLE_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, tableID);
            try (ResultSet rs = ps.executeQuery();){
                list = DBMerchantTableSetAlloc.wrapTableSetIDs(rs);
                tableID = list.isEmpty() ? null : list.get(0);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{tableID, TABLE_NAME};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return tableID;
    }

    private static List<String> wrap(ResultSet rs) throws SQLException {
        LinkedList<String> list = new LinkedList<String>();
        boolean found = false;
        while (rs.next()) {
            String tableID = rs.getString(2);
            list.add(tableID);
        }
        return list;
    }

    private static List<String> wrapTableSetIDs(ResultSet rs) throws SQLException {
        LinkedList<String> list = new LinkedList<String>();
        boolean found = false;
        while (rs.next()) {
            String tableSetID = rs.getString(1);
            list.add(tableSetID);
        }
        return list;
    }
}

