/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.gdstash.db.DBSkillExperience;
import org.gdstash.db.DBStat;
import org.gdstash.db.DBStatBonusRace;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.description.BonusDetail;
import org.gdstash.file.ARZRecord;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBSkill {
    public static final String TABLE_NAME = "GD_SKILL";
    public static final String FIELD_ID = "SKILL_ID";
    public static final String TEMPLATE_MASTERY = "database/templates/skill_mastery.tpl";
    private static final int ROW_SKILL_ID = 1;
    private static final int ROW_NAME = 2;
    private static final int ROW_DESCRIPTION = 3;
    private static final int ROW_MASTERY = 4;
    private static final int ROW_DEVOTION = 5;
    private static final int ROW_BONUS_INC = 6;
    private static final int ROW_BUFF_SKILL_ID = 7;
    private static final int ROW_PET_SKILL_ID = 8;
    private static final int ROW_CONVERT_IN = 9;
    private static final int ROW_CONVERT_OUT = 10;
    public static final String TRIGGER_ENEMY_KILL = "OnKill";
    public static final String TRIGGER_ENEMY_HIT = "AttackEnemy";
    public static final String TRIGGER_ENEMY_CRIT = "AttackEnemyCrit";
    public static final String TRIGGER_SELF_HIT = "HitByEnemy";
    public static final String TRIGGER_SELF_CRIT = "HitByCrit";
    public static final String TRIGGER_SELF_HIT_RANGE = "HitByProjectile";
    public static final String TRIGGER_SELF_HIT_MELEE = "HitByMelee";
    public static final String TRIGGER_SELF_BLOCK = "Block";
    public static final String TRIGGER_SELF_LOW_HEALTH = "LowHealth";
    private static ConcurrentHashMap<String, DBSkill> hashBuffer = new ConcurrentHashMap();
    private String skillID;
    private String name;
    private String description;
    private boolean mastery;
    private boolean devotion;
    private boolean bonusIncrement;
    private String buffSkillID;
    private String petSkillID;
    private String convertIn;
    private String convertOut;
    private List<Integer> xpLevels;
    private List<DBStat> stats;
    private List<DBStatBonusRace> statBonusRaces;
    private DBSkill dbBuffSkill;
    private DBSkill dbPetSkill;
    private int numXPLevels;

    public DBSkill() {
        this.skillID = null;
        this.name = null;
        this.mastery = false;
        this.devotion = false;
        this.bonusIncrement = false;
        this.buffSkillID = null;
        this.petSkillID = null;
        this.convertIn = null;
        this.convertOut = null;
        this.numXPLevels = 0;
        this.xpLevels = null;
        this.stats = new LinkedList<DBStat>();
    }

    public DBSkill(String name) {
        this();
        this.name = name;
    }

    private DBSkill(ARZRecord record) {
        this.skillID = record.getFileName();
        this.name = record.getSkillName();
        this.description = record.getSkillDescription();
        this.mastery = record.isMastery();
        this.devotion = record.isDevotion();
        this.bonusIncrement = record.hasSkillBonusIncrement();
        this.buffSkillID = record.getSkillBuffID();
        this.petSkillID = record.getPetBonusID();
        this.convertIn = record.getConversionIn();
        this.convertOut = record.getConversionOut();
        this.xpLevels = record.getSkillXPLevelList();
        this.numXPLevels = this.xpLevels.size();
        this.stats = record.getDBStatList();
        this.statBonusRaces = record.getDBStatBonusRaceList();
    }

    public String getSkillID() {
        return this.skillID;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        if (this.dbBuffSkill != null) {
            return this.dbBuffSkill.getDescription();
        }
        return this.description;
    }

    public boolean isMastery() {
        return this.mastery;
    }

    public boolean isDevotion() {
        return this.devotion;
    }

    public boolean hasBonusIncrement() {
        return this.bonusIncrement;
    }

    public int getMaxLevel() {
        if (this.dbBuffSkill != null) {
            return this.dbBuffSkill.numXPLevels;
        }
        return this.numXPLevels;
    }

    public int getXPForLevel(int level) {
        List<Integer> list = null;
        list = this.dbBuffSkill != null ? this.dbBuffSkill.xpLevels : this.xpLevels;
        int lvl = 1;
        int xp = 0;
        for (Integer val : list) {
            xp = val;
            if (lvl == level) break;
            ++lvl;
        }
        return xp;
    }

    public int getManaCost(int index) {
        if (this.dbBuffSkill != null) {
            return this.dbBuffSkill.getManaCost(index);
        }
        DBStat stat = DBStat.getDBStat(this.stats, "skillManaCost", index);
        if (stat == null) {
            return 0;
        }
        return stat.getStatMin();
    }

    public int getCooldownTime(int index) {
        if (this.dbBuffSkill != null) {
            return this.dbBuffSkill.getCooldownTime(index);
        }
        DBStat stat = DBStat.getDBStat(this.stats, "skillCooldownTime", index);
        if (stat == null) {
            return 0;
        }
        return stat.getStatMin();
    }

    public int getActiveDuration(int index) {
        if (this.dbBuffSkill != null) {
            return this.dbBuffSkill.getActiveDuration(index);
        }
        DBStat stat = DBStat.getDBStat(this.stats, "skillActiveDuration", index);
        if (stat == null) {
            return 0;
        }
        return stat.getStatMin();
    }

    public int getTriggerLifePerc(int index) {
        if (this.dbBuffSkill != null) {
            return this.dbBuffSkill.getTriggerLifePerc(index);
        }
        DBStat stat = DBStat.getDBStat(this.stats, "lifeMonitorPercent", index);
        if (stat == null) {
            return 0;
        }
        return stat.getStatMin();
    }

    public int getWeaponDamagePerc(int index) {
        if (this.dbBuffSkill != null) {
            return this.dbBuffSkill.getWeaponDamagePerc(index);
        }
        DBStat stat = DBStat.getDBStat(this.stats, "weaponDamagePct", index);
        if (stat == null) {
            return 0;
        }
        return stat.getStatMin();
    }

    public List<DBStat> getStatList() {
        if (this.dbBuffSkill != null) {
            return this.dbBuffSkill.getStatList();
        }
        return this.stats;
    }

    public String getBuffSkillID() {
        return this.buffSkillID;
    }

    public DBSkill getBuffSkill() {
        return this.dbBuffSkill;
    }

    public String getPetSkillID() {
        return this.petSkillID;
    }

    public DBSkill getPetSkill() {
        return this.dbPetSkill;
    }

    public static void clearBuffer() {
        hashBuffer.clear();
    }

    public static void createTables() throws SQLException {
        String dropTable = "DROP TABLE GD_SKILL";
        String createTable = "CREATE TABLE GD_SKILL (SKILL_ID  VARCHAR(256) NOT NULL, NAME              VARCHAR(128), DESCRIPTION       VARCHAR(1024), MASTERY           BOOLEAN, DEVOTION          BOOLEAN, BONUS_INCREMENT   BOOLEAN, BUFF_SKILL_ID     VARCHAR(256), PET_SKILL_ID      VARCHAR(256), CONVERT_IN        VARCHAR(16), CONVERT_OUT       VARCHAR(16), PRIMARY KEY (SKILL_ID))";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (Statement st = conn.createStatement();){
                if (GDDBUtil.tableExists(conn, TABLE_NAME)) {
                    st.execute(dropTable);
                }
                if (GDDBUtil.tableExists(conn, "GD_SKILL_CHAR")) {
                    st.execute("DROP TABLE GD_SKILL_CHAR");
                }
                if (GDDBUtil.tableExists(conn, "GD_SKILL_CHARRACES")) {
                    st.execute("DROP TABLE GD_SKILL_CHARRACES");
                }
                if (GDDBUtil.tableExists(conn, "GD_SKILL_DAMAGE")) {
                    st.execute("DROP TABLE GD_SKILL_DAMAGE");
                }
                st.execute(createTable);
                st.close();
                conn.commit();
                DBStat.createSkillTable(conn);
                DBStatBonusRace.createSkillTable(conn);
                DBSkillExperience.createTable(conn);
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_CREATE_TABLE", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void delete(String skillID) throws SQLException {
        String deleteEntry = "DELETE FROM GD_SKILL WHERE SKILL_ID = ?";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(deleteEntry);){
                ps.setString(1, skillID);
                ps.executeUpdate();
                ps.close();
                DBStat.deleteSkill(conn, skillID);
                DBStatBonusRace.deleteSkill(conn, skillID);
                DBSkillExperience.delete(conn, skillID);
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{skillID, TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_DEL_TABLE_BY_ID", args);
                GDMsgLogger.addError(msg);
                GDMsgLogger.addError(ex);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void insert(ARZRecord record) throws SQLException {
        DBSkill skill = new DBSkill(record);
        String insert = "INSERT INTO GD_SKILL VALUES (?,?,?,?,?,?,?,?,?,?)";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(insert);){
                ps.setString(1, skill.skillID);
                ps.setString(2, skill.name);
                ps.setString(3, skill.description);
                ps.setBoolean(4, skill.mastery);
                ps.setBoolean(5, skill.devotion);
                ps.setBoolean(6, skill.bonusIncrement);
                ps.setString(7, skill.buffSkillID);
                ps.setString(8, skill.petSkillID);
                ps.setString(9, skill.convertIn);
                ps.setString(10, skill.convertOut);
                ps.executeUpdate();
                ps.close();
                conn.commit();
                DBStat.insertSkill(conn, skill.skillID, skill.stats);
                DBStatBonusRace.insertSkill(conn, skill.skillID, skill.statBonusRaces);
                DBSkillExperience.insert(conn, skill.skillID, skill.xpLevels);
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{record.getFileName(), TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_INS_TABLE_BY_ID", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void insertMod(ARZRecord record) throws SQLException {
        DBSkill entry = DBSkill.get(record.getFileName());
        if (entry != null) {
            DBSkill.delete(record.getFileName());
        }
        DBSkill.insert(record);
    }

    public static DBSkill get(String skillID) {
        DBSkill skill = null;
        skill = hashBuffer.get(skillID);
        if (skill == null && (skill = DBSkill.getDB(skillID)) != null) {
            hashBuffer.put(skill.skillID, skill);
        }
        return skill;
    }

    public static List<DBSkill> getBonusSkills() {
        String command = "SELECT SKILL_ID FROM GD_SKILL WHERE BONUS_INCREMENT = true ORDER BY MASTERY DESC, NAME ASC";
        LinkedList<DBSkill> skills = new LinkedList<DBSkill>();
        LinkedList<String> skillIDs = new LinkedList<String>();
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String s = rs.getString(1);
                    skillIDs.add(s);
                }
            }
            conn.commit();
            for (String skillID : skillIDs) {
                DBSkill skill = DBSkill.get(skillID);
                skills.add(skill);
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{"-", TABLE_NAME};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return skills;
    }

    private static DBSkill getDB(String skillID) {
        DBSkill skill = null;
        String command = "SELECT * FROM GD_SKILL WHERE SKILL_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, skillID);
            try (ResultSet rs = ps.executeQuery();){
                List<DBSkill> list = DBSkill.wrap(rs);
                skill = list.isEmpty() ? null : list.get(0);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{skillID, TABLE_NAME};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return skill;
    }

    private void createBonusRaceStats(DBStat stat) {
        if (stat == null) {
            return;
        }
        if (this.statBonusRaces == null) {
            return;
        }
        if (this.statBonusRaces.isEmpty()) {
            return;
        }
        this.stats.remove(stat);
        List<DBStat> list = DBStat.createStatsFromRaceBonusList(stat, this.statBonusRaces);
        this.stats.addAll(list);
    }

    private static List<DBSkill> wrap(ResultSet rs) throws SQLException {
        LinkedList<DBSkill> list = new LinkedList<DBSkill>();
        while (rs.next()) {
            DBSkill skill = new DBSkill();
            skill.skillID = rs.getString(1);
            skill.name = rs.getString(2);
            skill.description = rs.getString(3);
            skill.mastery = rs.getBoolean(4);
            skill.devotion = rs.getBoolean(5);
            skill.bonusIncrement = rs.getBoolean(6);
            skill.buffSkillID = rs.getString(7);
            skill.petSkillID = rs.getString(8);
            skill.convertIn = rs.getString(9);
            skill.convertOut = rs.getString(10);
            skill.xpLevels = DBSkillExperience.getBySkillID(skill.skillID);
            skill.numXPLevels = skill.xpLevels.size();
            skill.stats = DBStat.getSkill(skill.skillID);
            Collections.sort(skill.stats);
            DBStat stat = DBStat.getByType(skill.stats, "racialBonusPercentDamage", 1);
            if (stat != null) {
                skill.statBonusRaces = DBStatBonusRace.getSkill(skill.skillID);
                skill.createBonusRaceStats(stat);
            }
            if (skill.buffSkillID != null && !skill.buffSkillID.equals(skill.skillID)) {
                skill.dbBuffSkill = DBSkill.get(skill.buffSkillID);
            }
            if (skill.petSkillID != null && !skill.petSkillID.equals(skill.skillID)) {
                skill.dbPetSkill = DBSkill.get(skill.petSkillID);
            }
            list.add(skill);
        }
        return list;
    }

    public BonusDetail getBonusDetail() {
        BonusDetail bonus = new BonusDetail(this);
        return bonus;
    }

    public String toString() {
        String s = this.name;
        if (this.isMastery()) {
            s = s + " (" + GDMsgFormatter.getString(GDMsgFormatter.rbGD, "TXT_MASTERY") + ")";
        }
        return s;
    }
}

