/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.DBConstellationAffinity;
import org.gdstash.db.DBConstellationStar;
import org.gdstash.db.DBSkill;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.file.ARZRecord;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBSkillButton {
    private static final String TABLE_NAME = "GDC_BUTTON_SKILL";
    private static final int ROW_BUTTON_ID = 1;
    private static final int ROW_SKILL_ID = 2;
    private String buttonID = null;
    private String skillID = null;
    private DBSkill dbSkill = null;

    public DBSkillButton() {
    }

    public DBSkillButton(ARZRecord record) {
        this();
        this.buttonID = record.getFileName();
        this.skillID = record.getButtonSkillID();
    }

    public String getButtonID() {
        return this.buttonID;
    }

    public String getSkillID() {
        return this.skillID;
    }

    public DBSkill getSkill() {
        return this.dbSkill;
    }

    public void setButtonID(String buttonID) {
        this.buttonID = buttonID;
    }

    public void setSkillID(String skillID) {
        this.skillID = skillID;
    }

    public static void createTable() throws SQLException {
        String dropTable = "DROP TABLE GDC_BUTTON_SKILL";
        String createTable = "CREATE TABLE GDC_BUTTON_SKILL (BUTTON_ID        VARCHAR(256) NOT NULL, SKILL_ID         VARCHAR(256), PRIMARY KEY (BUTTON_ID))";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (Statement st = conn.createStatement();){
                if (GDDBUtil.tableExists(conn, TABLE_NAME)) {
                    st.execute(dropTable);
                }
                st.execute(createTable);
                st.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void delete(String buttonID) throws SQLException {
        String deleteEntry = "DELETE FROM GDC_BUTTON_SKILL WHERE BUTTON_ID = ?";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(deleteEntry);){
                ps.setString(1, buttonID);
                ps.executeUpdate();
                ps.close();
                DBConstellationAffinity.delete(conn, buttonID);
                DBConstellationStar.delete(conn, buttonID);
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{buttonID, TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_DEL_TABLE_BY_ID", args);
                GDMsgLogger.addError(msg);
                GDMsgLogger.addError(ex);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void insert(ARZRecord record) throws SQLException {
        DBSkillButton button = new DBSkillButton(record);
        String insert = "INSERT INTO GDC_BUTTON_SKILL VALUES (?,?)";
        try (Connection conn = GDDBData.getConnection();){
            boolean auto = conn.getAutoCommit();
            conn.setAutoCommit(false);
            try (PreparedStatement ps = conn.prepareStatement(insert);){
                ps.setString(1, button.buttonID);
                ps.setString(2, button.skillID);
                ps.executeUpdate();
                ps.close();
                conn.commit();
            }
            catch (SQLException ex) {
                conn.rollback();
                Object[] args = new Object[]{button.buttonID, TABLE_NAME};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_INS_TABLE_BY_ID", args);
                GDMsgLogger.addError(msg);
                throw ex;
            }
            finally {
                conn.setAutoCommit(auto);
            }
        }
    }

    public static void insertMod(ARZRecord record) throws SQLException {
        DBSkillButton button = new DBSkillButton(record);
        if (button != null) {
            DBSkillButton.delete(record.getFileName());
        }
        DBSkillButton.insert(record);
    }

    public static DBSkillButton get(String buttonID) {
        DBSkillButton button = null;
        String command = "SELECT * FROM GDC_BUTTON_SKILL WHERE BUTTON_ID = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, buttonID);
            try (ResultSet rs = ps.executeQuery();){
                List<DBSkillButton> list = DBSkillButton.wrap(rs);
                button = list.isEmpty() ? null : list.get(0);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{buttonID, TABLE_NAME};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return button;
    }

    private static List<DBSkillButton> wrap(ResultSet rs) throws SQLException {
        LinkedList<DBSkillButton> list = new LinkedList<DBSkillButton>();
        while (rs.next()) {
            DBSkillButton button = new DBSkillButton();
            button.buttonID = rs.getString(1);
            button.skillID = rs.getString(2);
            if (button.skillID != null) {
                button.dbSkill = DBSkill.get(button.skillID);
            }
            list.add(button);
        }
        return list;
    }
}

