/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBSkillExperience {
    private static final String TABLE_NAME = "GD_SKILL_EXPERIENCE";
    private static final int ROW_SKILL_ID = 1;
    private static final int ROW_EXPERIENCE = 2;

    public static void createTable(Connection conn) throws SQLException {
        String dropTable = "DROP TABLE GD_SKILL_EXPERIENCE";
        String createTable = "CREATE TABLE GD_SKILL_EXPERIENCE (SKILL_ID     VARCHAR(256) NOT NULL, EXPERIENCE   INTEGER, PRIMARY KEY ( SKILL_ID, EXPERIENCE))";
        try (Statement st = conn.createStatement();){
            if (GDDBUtil.tableExists(conn, TABLE_NAME)) {
                st.execute(dropTable);
            }
            st.execute(createTable);
            st.close();
            conn.commit();
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{TABLE_NAME};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_CREATE_TABLE", args);
            GDMsgLogger.addError(msg);
            throw ex;
        }
    }

    public static void delete(Connection conn, String skillID) throws SQLException {
        String deleteEntry = "DELETE FROM GD_SKILL_EXPERIENCE WHERE SKILL_ID = ?";
        try (PreparedStatement ps = conn.prepareStatement(deleteEntry);){
            ps.setString(1, skillID);
            ps.executeUpdate();
            ps.close();
        }
    }

    public static void insert(Connection conn, String skillID, List<Integer> xpLevels) throws SQLException {
        String insert = "INSERT INTO GD_SKILL_EXPERIENCE VALUES (?,?)";
        if (xpLevels == null) {
            return;
        }
        if (xpLevels.isEmpty()) {
            return;
        }
        try (PreparedStatement ps = conn.prepareStatement(insert);){
            for (Integer i : xpLevels) {
                ps.setString(1, skillID);
                ps.setInt(2, i);
                ps.executeUpdate();
                ps.clearParameters();
            }
            ps.close();
            conn.commit();
        }
    }

    public static List<Integer> getBySkillID(String skillID) {
        List<Integer> list = new LinkedList<Integer>();
        String command = "SELECT * FROM GD_SKILL_EXPERIENCE WHERE SKILL_ID = ? ORDER BY EXPERIENCE";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, skillID);
            try (ResultSet rs = ps.executeQuery();){
                list = DBSkillExperience.wrap(rs);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{skillID, TABLE_NAME};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return list;
    }

    private static List<Integer> wrap(ResultSet rs) throws SQLException {
        LinkedList<Integer> list = new LinkedList<Integer>();
        while (rs.next()) {
            int i = rs.getInt(2);
            Integer val = new Integer(i);
            list.add(val);
        }
        return list;
    }
}

