/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.GDDBData;
import org.gdstash.db.GDDBUtil;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBStatBonusRace
implements Cloneable {
    private static final String TABLE_NAME_ITEM = "GD_ITEM_RACES";
    private static final String TABLE_NAME_AFFIX = "GD_AFFIX_RACES";
    private static final String TABLE_NAME_SKILL = "GD_SKILL_RACES";
    private static final String FIELD_ID_ITEM = "ITEM_ID";
    private static final String FIELD_ID_AFFIX = "AFFIX_ID";
    private static final String FIELD_ID_SKILL = "SKILL_ID";
    private static final int ROW_ITEM_ID = 1;
    private static final int ROW_RACE_TAG = 2;
    private static final int ROW_RACE_NAME = 3;
    private String itemID;
    private String raceTag;
    private String raceName;

    public DBStatBonusRace() {
        this.itemID = null;
        this.raceTag = null;
        this.raceName = null;
    }

    public DBStatBonusRace(DBStatBonusRace race) {
        this.itemID = race.itemID;
        this.raceTag = race.raceTag;
        this.raceName = race.raceName;
    }

    public DBStatBonusRace clone() {
        DBStatBonusRace race = new DBStatBonusRace(this);
        return race;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!o.getClass().equals(DBStatBonusRace.class)) {
            return false;
        }
        DBStatBonusRace br = (DBStatBonusRace)o;
        return this.raceTag.equals(br.raceTag);
    }

    public String getID() {
        return this.itemID;
    }

    public String getRaceTag() {
        if (this.raceTag == null) {
            return null;
        }
        if (this.raceTag.startsWith("tag")) {
            return this.raceTag;
        }
        return "tag" + this.raceTag;
    }

    public String getRaceName() {
        return this.raceName;
    }

    public void setID(String itemID) {
        this.itemID = itemID;
    }

    public void setRaceTag(String raceTag) {
        this.raceTag = raceTag;
    }

    public void setRaceName(String raceName) {
        this.raceName = raceName;
    }

    public static void createItemTable(Connection conn) throws SQLException {
        DBStatBonusRace.createTable(conn, TABLE_NAME_ITEM, FIELD_ID_ITEM);
    }

    public static void createAffixTable(Connection conn) throws SQLException {
        DBStatBonusRace.createTable(conn, TABLE_NAME_AFFIX, FIELD_ID_AFFIX);
    }

    public static void createSkillTable(Connection conn) throws SQLException {
        DBStatBonusRace.createTable(conn, TABLE_NAME_SKILL, FIELD_ID_SKILL);
    }

    private static void createTable(Connection conn, String tabName, String idName) throws SQLException {
        String dropTable = "DROP TABLE " + tabName;
        String createTable = "CREATE TABLE " + tabName + " (" + idName + " VARCHAR(256) NOT NULL, RACE_TAG           VARCHAR(64), RACE_NAME          VARCHAR(64), PRIMARY KEY (" + idName + ", RACE_TAG))";
        try (Statement st = conn.createStatement();){
            if (GDDBUtil.tableExists(conn, tabName)) {
                st.execute(dropTable);
            }
            st.execute(createTable);
            st.close();
            conn.commit();
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{tabName};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_CREATE_TABLE", args);
            GDMsgLogger.addError(msg);
            throw ex;
        }
    }

    public static void deleteItem(Connection conn, String id) throws SQLException {
        DBStatBonusRace.delete(conn, TABLE_NAME_ITEM, FIELD_ID_ITEM, id);
    }

    public static void deleteAffix(Connection conn, String id) throws SQLException {
        DBStatBonusRace.delete(conn, TABLE_NAME_AFFIX, FIELD_ID_AFFIX, id);
    }

    public static void deleteSkill(Connection conn, String id) throws SQLException {
        DBStatBonusRace.delete(conn, TABLE_NAME_SKILL, FIELD_ID_SKILL, id);
    }

    private static void delete(Connection conn, String tabName, String idName, String itemID) throws SQLException {
        String deleteEntry = "DELETE FROM " + tabName + " WHERE " + idName + " = ?";
        try (PreparedStatement ps = conn.prepareStatement(deleteEntry);){
            ps.setString(1, itemID);
            ps.executeUpdate();
            ps.close();
        }
    }

    public static void insertItem(Connection conn, String id, List<DBStatBonusRace> races) throws SQLException {
        DBStatBonusRace.insert(conn, TABLE_NAME_ITEM, id, races);
    }

    public static void insertAffix(Connection conn, String id, List<DBStatBonusRace> races) throws SQLException {
        DBStatBonusRace.insert(conn, TABLE_NAME_AFFIX, id, races);
    }

    public static void insertSkill(Connection conn, String id, List<DBStatBonusRace> races) throws SQLException {
        DBStatBonusRace.insert(conn, TABLE_NAME_SKILL, id, races);
    }

    private static void insert(Connection conn, String tabName, String id, List<DBStatBonusRace> races) throws SQLException {
        String insert = "INSERT INTO " + tabName + " VALUES (?,?,?)";
        if (races == null) {
            return;
        }
        if (races.isEmpty()) {
            return;
        }
        try (PreparedStatement ps = conn.prepareStatement(insert);){
            for (DBStatBonusRace race : races) {
                ps.setString(1, id);
                ps.setString(2, race.raceTag);
                ps.setString(3, race.raceName);
                ps.executeUpdate();
                ps.clearParameters();
            }
            ps.close();
            conn.commit();
        }
    }

    public static List<DBStatBonusRace> getItem(String id) throws SQLException {
        return DBStatBonusRace.get(TABLE_NAME_ITEM, FIELD_ID_ITEM, id);
    }

    public static List<DBStatBonusRace> getAffix(String id) throws SQLException {
        return DBStatBonusRace.get(TABLE_NAME_AFFIX, FIELD_ID_AFFIX, id);
    }

    public static List<DBStatBonusRace> getSkill(String id) throws SQLException {
        return DBStatBonusRace.get(TABLE_NAME_SKILL, FIELD_ID_SKILL, id);
    }

    private static List<DBStatBonusRace> get(String tableName, String fieldName, String id) {
        List<DBStatBonusRace> list = new LinkedList<DBStatBonusRace>();
        String command = "SELECT * FROM " + tableName + " WHERE " + fieldName + " = ?";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);){
            ps.setString(1, id);
            try (ResultSet rs = ps.executeQuery();){
                list = DBStatBonusRace.wrap(rs);
                conn.commit();
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{id, tableName};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return list;
    }

    private static List<DBStatBonusRace> wrap(ResultSet rs) throws SQLException {
        LinkedList<DBStatBonusRace> list = new LinkedList<DBStatBonusRace>();
        while (rs.next()) {
            DBStatBonusRace race = new DBStatBonusRace();
            race.itemID = rs.getString(1);
            race.raceTag = rs.getString(2);
            race.raceName = rs.getString(3);
            list.add(race);
        }
        return list;
    }
}

