/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.GDDBData;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DBViewItemSkill
implements Comparable<DBViewItemSkill> {
    private static final int ROW_SKILL_ID = 1;
    private static final int ROW_NAME = 2;
    private String skillID = null;
    private String name = null;

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!o.getClass().equals(DBViewItemSkill.class)) {
            return false;
        }
        DBViewItemSkill skill = (DBViewItemSkill)o;
        return this.skillID.equals(skill.skillID);
    }

    public int hashCode() {
        return this.skillID.hashCode();
    }

    @Override
    public int compareTo(DBViewItemSkill skill) {
        if (skill == null) {
            return -1;
        }
        return this.name.compareTo(skill.name);
    }

    public String getSkillID() {
        return this.skillID;
    }

    public String getName() {
        return this.name;
    }

    public static List<DBViewItemSkill> getItemSkills() {
        boolean found;
        LinkedList<DBViewItemSkill> list = new LinkedList<DBViewItemSkill>();
        List<DBViewItemSkill> itemList = DBViewItemSkill.getSkillsFromItem();
        List<DBViewItemSkill> affixList = DBViewItemSkill.getSkillsFromAffix();
        if (itemList != null) {
            for (DBViewItemSkill skill : itemList) {
                if (skill == null || skill.name == null) continue;
                found = false;
                for (DBViewItemSkill itemSkill : list) {
                    if (!itemSkill.skillID.equals(skill.skillID)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                list.add(skill);
            }
        }
        if (affixList != null) {
            for (DBViewItemSkill skill : affixList) {
                if (skill == null || skill.name == null) continue;
                found = false;
                for (DBViewItemSkill itemSkill : list) {
                    if (!itemSkill.skillID.equals(skill.skillID)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                list.add(skill);
            }
        }
        Collections.sort(list);
        return list;
    }

    private static List<DBViewItemSkill> getSkillsFromItem() {
        List<DBViewItemSkill> list = null;
        String command = "SELECT DISTINCT GD_SKILL.SKILL_ID, GD_SKILL.NAME FROM GD_ITEM, GD_SKILL WHERE GD_ITEM.ITEM_SKILL_ID IS NOT NULL AND GD_ITEM.ITEM_SKILL_ID = GD_SKILL.SKILL_ID ORDER BY GD_SKILL.NAME";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);
             ResultSet rs = ps.executeQuery();){
            list = DBViewItemSkill.wrap(rs);
            conn.commit();
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{"-", "DBViewItemSkill"};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return list;
    }

    private static List<DBViewItemSkill> getSkillsFromAffix() {
        List<DBViewItemSkill> list = null;
        String command = "SELECT DISTINCT GD_SKILL.SKILL_ID, GD_SKILL.NAME FROM GD_AFFIX, GD_SKILL WHERE GD_AFFIX.ITEM_SKILL_ID IS NOT NULL AND GD_AFFIX.ITEM_SKILL_ID = GD_SKILL.SKILL_ID ORDER BY GD_SKILL.NAME";
        try (Connection conn = GDDBData.getConnection();
             PreparedStatement ps = conn.prepareStatement(command);
             ResultSet rs = ps.executeQuery();){
            list = DBViewItemSkill.wrap(rs);
            conn.commit();
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{"-", "DBViewItemSkill"};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_READ_TABLE_BY_ID", args);
            GDMsgLogger.addError(msg);
            GDMsgLogger.addError(ex);
        }
        return list;
    }

    private static List<DBViewItemSkill> wrap(ResultSet rs) throws SQLException {
        LinkedList<DBViewItemSkill> list = new LinkedList<DBViewItemSkill>();
        while (rs.next()) {
            DBViewItemSkill skill = new DBViewItemSkill();
            skill.skillID = rs.getString(1);
            skill.name = rs.getString(2);
            list.add(skill);
        }
        return list;
    }

    public String toString() {
        return this.name;
    }
}

