/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import org.gdstash.db.DBAffix;
import org.gdstash.db.DBAffixSet;
import org.gdstash.db.DBConfig;
import org.gdstash.db.DBConstellation;
import org.gdstash.db.DBEngineGame;
import org.gdstash.db.DBEngineLevel;
import org.gdstash.db.DBEnginePlayer;
import org.gdstash.db.DBEngineTagText;
import org.gdstash.db.DBFaction;
import org.gdstash.db.DBFormulaSet;
import org.gdstash.db.DBItem;
import org.gdstash.db.DBItemCraft;
import org.gdstash.db.DBItemSet;
import org.gdstash.db.DBLootTable;
import org.gdstash.db.DBLootTableSet;
import org.gdstash.db.DBMerchant;
import org.gdstash.db.DBMerchantTable;
import org.gdstash.db.DBMerchantTableSet;
import org.gdstash.db.DBSkill;
import org.gdstash.db.DBSkillButton;
import org.gdstash.db.DBStashItem;
import org.gdstash.db.GDDBUtil;
import org.gdstash.file.ARZRecord;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDConstants;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class GDDBData {
    public static final String DERBY_LANG_DUPLICATE_KEY_CONSTRAINT = "23505";
    private static final String oldURL = "jdbc:derby:db;";
    private static final int DERBY_TRACE_NONE = 0;
    private static final int DERBY_TRACE_CONNECTION_CALLS = 1;
    private static final int DERBY_TRACE_STATEMENT_CALLS = 2;
    private static final int DERBY_TRACE_RESULT_SET_CALLS = 4;
    private static final int DERBY_TRACE_DRIVER_CONFIGURATION = 16;
    private static final int DERBY_TRACE_CONNECTS = 32;
    private static final int DERBY_TRACE_PROTOCOL_FLOWS = 64;
    private static final int DERBY_TRACE_RESULT_SET_META_DATA = 128;
    private static final int DERBY_TRACE_PARAMETER_META_DATA = 256;
    private static final int DERBY_TRACE_DIAGNOSTICS = 512;
    private static final int DERBY_TRACE_ALL = -1;
    private static String dbURL = null;
    private static String mod = null;

    private static void fillDBUrl(String mod) {
        String dbDir = null;
        dbDir = mod == null ? "db" : (mod.isEmpty() ? "db" : "db_" + mod);
        String dir = GDConstants.USER_HOME + GDConstants.FILE_SEPARATOR + "GDStash" + GDConstants.FILE_SEPARATOR + dbDir;
        dbURL = "jdbc:derby:" + dir + ";";
    }

    public static boolean doesExist() {
        GDDBData.fillDBUrl(null);
        return GDDBUtil.doesExist(dbURL);
    }

    public static boolean doesExist(String mod) {
        GDDBData.fillDBUrl(mod);
        return GDDBUtil.doesExist(dbURL);
    }

    public static Connection getConnection() throws SQLException {
        String mod = null;
        if (GDStashFrame.iniConfig != null && GDStashFrame.iniConfig.sectHistory != null) {
            mod = GDStashFrame.iniConfig.sectHistory.lastMod;
        }
        return GDDBData.getConnection(mod);
    }

    private static Connection getConnection(String mod) throws SQLException {
        GDDBData.fillDBUrl(mod);
        String url = dbURL + "create=true";
        Connection conn = DriverManager.getConnection(url);
        conn.setAutoCommit(false);
        return conn;
    }

    public static Connection getOldConnection() throws SQLException {
        String url = "jdbc:derby:db;create=false";
        Connection conn = DriverManager.getConnection(url);
        conn.setAutoCommit(false);
        return conn;
    }

    public static void closeConnections() {
        if (dbURL != null) {
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void createConfigTables() throws SQLException {
        try (Connection conn = GDDBData.getConnection();){
            if (GDDBUtil.tableExists(conn, "INFO_CONFIG")) {
                String version = DBConfig.getConfigVersion();
                if (version == null || !version.equals("1.0.8")) {
                    DBConfig.createTable();
                }
            } else {
                DBConfig.createTable();
            }
            if (!GDDBUtil.tableExists(conn, "STASH_ITEM_V7")) {
                DBStashItem.createTable();
            }
            conn.commit();
        }
    }

    public static boolean createDataTables() {
        boolean success = false;
        try {
            DBItem.createTables();
            DBItemSet.createTables();
            DBAffix.createTables();
            DBAffixSet.createTables();
            DBFormulaSet.createTables();
            DBLootTable.createTables();
            DBLootTableSet.createTables();
            DBSkill.createTables();
            DBConstellation.createTables();
            DBSkillButton.createTable();
            DBEngineGame.createTable();
            DBFaction.createTable();
            DBMerchant.createTables();
            DBMerchantTableSet.createTables();
            DBMerchantTable.createTables();
            DBEnginePlayer.createTable();
            DBEngineLevel.createTable();
            DBEngineTagText.createTable();
            success = true;
        }
        catch (Exception ex) {
            GDMsgLogger.addError(ex);
        }
        return success;
    }

    public static void clearBuffers() {
        DBAffix.clearBuffer();
        DBAffixSet.clearBuffer();
        DBFormulaSet.clearBuffer();
        DBItem.clearBuffer();
        DBItemCraft.clearBuffer();
        DBLootTable.clearBuffer();
        DBLootTableSet.clearBuffer();
        DBSkill.clearBuffer();
        DBEngineTagText.clearBuffer();
    }

    public static boolean insertData(ARZRecord[] records) {
        boolean success = false;
        try {
            GDDBData.insertRecords(records);
            success = true;
        }
        catch (Exception ex) {
            GDMsgLogger.addError(ex);
        }
        return success;
    }

    private static void insertRecords(ARZRecord[] records) throws SQLException {
        for (int i = 0; i < records.length; ++i) {
            if (records[i] == null) continue;
            try {
                boolean processed = false;
                if (records[i].isConstellation()) {
                    DBConstellation.insert(records[i]);
                    processed = true;
                }
                if (records[i].isSkillButton()) {
                    DBSkillButton.insert(records[i]);
                    processed = true;
                }
                if (records[i].isGameEngine()) {
                    DBEngineGame.insert(records[i]);
                    processed = true;
                }
                if (records[i].isFaction()) {
                    DBFaction.insert(records[i]);
                    processed = true;
                }
                if (records[i].isMerchant()) {
                    DBMerchant.insert(records[i]);
                    processed = true;
                }
                if (records[i].isMerchantTableSet()) {
                    DBMerchantTableSet.insert(records[i]);
                    processed = true;
                }
                if (records[i].isMerchantTable()) {
                    DBMerchantTable.insert(records[i]);
                    processed = true;
                }
                if (records[i].isPlayerEngine()) {
                    DBEnginePlayer.insert(records[i]);
                    DBEngineLevel.insert(records[i]);
                    processed = true;
                }
                if (records[i].isAffix()) {
                    DBAffix.insert(records[i]);
                    processed = true;
                }
                if (records[i].isAffixSet()) {
                    DBAffixSet.insert(records[i]);
                    processed = true;
                }
                if (records[i].isItemSet()) {
                    DBItemSet.insert(records[i]);
                    processed = true;
                }
                if (records[i].isLootTable()) {
                    DBLootTable.insert(records[i]);
                    processed = true;
                }
                if (records[i].isLootTableSet()) {
                    DBLootTableSet.insert(records[i]);
                    processed = true;
                }
                if (records[i].isFormulaSet()) {
                    DBFormulaSet.insert(records[i]);
                    processed = true;
                }
                if (records[i].isSkill()) {
                    DBSkill.insert(records[i]);
                    processed = true;
                }
                if (processed || records[i].getFileDescription() != null && records[i].getFileDescription().startsWith("BASE")) continue;
                if (records[i].getItemName() == null) {
                    if (records[i].getItemNameTag() == null) continue;
                    Object[] args = new Object[]{records[i].getItemNameTag(), "tags_items.txt"};
                    String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_NOT_FOUND", args);
                    GDMsgLogger.addWarning(msg);
                    continue;
                }
                if (records[i].getBitmapID() == null || records[i].getBitmap() == null) continue;
                DBItem.insert(records[i]);
                continue;
            }
            catch (Exception ex) {
                GDMsgLogger.addError(ex);
            }
        }
        GDDBData.clearBuffers();
        if (GDMsgLogger.errorsInLog()) {
            throw new SQLException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_DB_IMPORT"));
        }
    }

    public static boolean insertModData(ARZRecord[] records) {
        boolean success = false;
        try {
            GDDBData.insertModRecords(records);
            success = true;
        }
        catch (Exception ex) {
            GDMsgLogger.addError(ex);
        }
        return success;
    }

    private static void insertModRecords(ARZRecord[] records) throws SQLException {
        for (int i = 0; i < records.length; ++i) {
            if (records[i] == null) continue;
            try {
                boolean processed = false;
                if (records[i].isGameEngine()) {
                    DBEngineGame.insertMod(records[i]);
                    processed = true;
                }
                if (records[i].isFaction()) {
                    DBFaction.insertMod(records[i]);
                    processed = true;
                }
                if (records[i].isPlayerEngine()) {
                    DBEnginePlayer.insertMod(records[i]);
                    DBEngineLevel.insertMod(records[i]);
                    processed = true;
                }
                if (records[i].isAffix()) {
                    DBAffix.insertMod(records[i]);
                    processed = true;
                }
                if (records[i].isAffixSet()) {
                    DBAffixSet.insertMod(records[i]);
                    processed = true;
                }
                if (records[i].isItemSet()) {
                    DBItemSet.insertMod(records[i]);
                    processed = true;
                }
                if (records[i].isLootTable()) {
                    DBLootTable.insertMod(records[i]);
                    processed = true;
                }
                if (records[i].isLootTableSet()) {
                    DBLootTableSet.insertMod(records[i]);
                    processed = true;
                }
                if (records[i].isFormulaSet()) {
                    DBFormulaSet.insertMod(records[i]);
                    processed = true;
                }
                if (records[i].isSkill()) {
                    DBSkill.insertMod(records[i]);
                    processed = true;
                }
                if (processed || records[i].getFileDescription() != null && records[i].getFileDescription().startsWith("BASE")) continue;
                if (records[i].getItemName() == null) {
                    if (records[i].getItemNameTag() == null) continue;
                    Object[] args = new Object[]{records[i].getItemNameTag(), "tags_items.txt"};
                    String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_NOT_FOUND", args);
                    GDMsgLogger.addWarning(msg);
                    continue;
                }
                if (records[i].getBitmapID() == null || records[i].getBitmap() == null) continue;
                DBItem.insertMod(records[i]);
                continue;
            }
            catch (SQLException ex) {
                GDMsgLogger.addError(ex);
            }
        }
        GDDBData.clearBuffers();
        if (GDMsgLogger.errorsInLog()) {
            throw new SQLException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_DB_IMPORT"));
        }
    }

    public static boolean updateStash() {
        boolean success = false;
        try {
            boolean updated = false;
            if (GDDBUtil.doesExist(oldURL)) {
                if (GDDBUtil.tableExists(GDDBData.getOldConnection(), "STASH_ITEM")) {
                    GDDBData.moveStash(GDDBData.getOldConnection(), GDDBData.getConnection(), "STASH_ITEM");
                    updated = true;
                } else if (GDDBUtil.tableExists(GDDBData.getOldConnection(), "STASH_ITEM_V2")) {
                    GDDBData.moveStash(GDDBData.getOldConnection(), GDDBData.getConnection(), "STASH_ITEM_V2");
                    updated = true;
                } else if (GDDBUtil.tableExists(GDDBData.getOldConnection(), "STASH_ITEM_V3")) {
                    GDDBData.moveStash(GDDBData.getOldConnection(), GDDBData.getConnection(), "STASH_ITEM_V3");
                    updated = true;
                }
            }
            if (!updated) {
                if (GDDBUtil.tableExists("STASH_ITEM")) {
                    GDDBData.convertStash("STASH_ITEM");
                } else if (GDDBUtil.tableExists("STASH_ITEM_V2")) {
                    GDDBData.convertStash("STASH_ITEM_V2");
                } else if (GDDBUtil.tableExists("STASH_ITEM_V3")) {
                    GDDBData.convertStash("STASH_ITEM_V3");
                } else if (GDDBUtil.tableExists("STASH_ITEM_V4")) {
                    GDDBData.convertStash("STASH_ITEM_V4");
                } else if (GDDBUtil.tableExists("STASH_ITEM_V5")) {
                    GDDBData.convertStash("STASH_ITEM_V5");
                } else if (GDDBUtil.tableExists("STASH_ITEM_V6")) {
                    GDDBData.convertStash("STASH_ITEM_V6");
                } else {
                    GDDBData.updateDependent();
                }
            }
            success = !GDMsgLogger.errorsInLog();
        }
        catch (SQLException ex) {
            GDMsgLogger.addError(ex);
        }
        catch (Exception ex) {
            GDMsgLogger.addError(ex);
        }
        return success;
    }

    private static void updateDependent() throws SQLException {
        if (GDDBUtil.tableExists("STASH_ITEM_V7")) {
            List<DBStashItem> items = DBStashItem.getAll();
            DBStashItem.updateDependentFields(items);
        }
    }

    private static void convertStash(String tableName) throws SQLException {
        if (GDDBUtil.tableExists(tableName)) {
            List<DBStashItem> items = DBStashItem.getAllOld(GDDBData.getConnection(), tableName);
            DBStashItem.convertStash(tableName, items);
            DBStashItem.dropOldStash(GDDBData.getConnection(), tableName);
        }
    }

    private static void moveStash(Connection connOld, Connection connNew, String tableName) throws SQLException {
        if (GDDBUtil.tableExists(connOld, tableName)) {
            List<DBStashItem> items = DBStashItem.getAllOld(connOld, tableName);
            DBStashItem.moveStash(connOld, connNew, tableName, items);
            DBStashItem.dropOldStash(connOld, tableName);
        }
    }
}

