/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.gdstash.db.GDDBData;

public class GDDBUtil {
    public static boolean doesExist(String url) {
        boolean exists = false;
        try {
            Connection conn = DriverManager.getConnection(url + "create=false");
            exists = true;
            conn.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return exists;
    }

    public static boolean tableExists(String tablename) throws SQLException {
        boolean found = false;
        try (Connection conn = GDDBData.getConnection();){
            found = GDDBUtil.tableExists(conn, tablename);
            conn.commit();
        }
        return found;
    }

    public static boolean tableExists(Connection conn, String tablename) throws SQLException {
        boolean found = false;
        DatabaseMetaData meta = conn.getMetaData();
        try (ResultSet rs = meta.getTables(null, null, tablename, null);){
            while (rs.next()) {
                String name = rs.getString(3);
                if (!name.equals(tablename)) continue;
                found = true;
                break;
            }
        }
        catch (SQLException ex) {
            found = false;
            throw ex;
        }
        return found;
    }
}

