/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.ItemClass;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.ui.GDStashFrame;

public class ItemCriteriaCombination
implements Cloneable {
    private String itemClass;
    private String armorClass;
    private String artifactClass;
    private String itemRarity;
    private boolean useArmorClass;
    private boolean useArtifactClass;
    private boolean useItemRarity;
    private boolean useSlots;
    private int levelMin;
    private int levelMax;
    private int cunningMax;
    private int physiqueMax;
    private int spiritMax;
    private boolean noEnemyOnly;
    private SelectionCriteria criteria;

    private ItemCriteriaCombination() {
        this.itemClass = null;
        this.armorClass = null;
        this.artifactClass = null;
        this.itemRarity = null;
        this.useArmorClass = false;
        this.useArtifactClass = false;
        this.useItemRarity = false;
        this.useSlots = false;
        this.levelMin = -1;
        this.levelMax = -1;
        this.cunningMax = -1;
        this.physiqueMax = -1;
        this.spiritMax = -1;
        this.noEnemyOnly = true;
        this.criteria = null;
    }

    private ItemCriteriaCombination(ItemCriteriaCombination combo) {
        this.itemClass = combo.itemClass;
        this.armorClass = combo.armorClass;
        this.artifactClass = combo.artifactClass;
        this.itemRarity = combo.itemRarity;
        this.useArmorClass = combo.useArmorClass;
        this.useArtifactClass = combo.useArtifactClass;
        this.useItemRarity = combo.useItemRarity;
        this.useSlots = combo.useSlots;
        this.levelMin = combo.levelMin;
        this.levelMax = combo.levelMax;
        this.cunningMax = combo.cunningMax;
        this.physiqueMax = combo.physiqueMax;
        this.spiritMax = combo.spiritMax;
        this.noEnemyOnly = combo.noEnemyOnly;
        this.criteria = combo.criteria;
    }

    public ItemCriteriaCombination(SelectionCriteria criteria) {
        this();
        this.levelMin = criteria.levelMin;
        this.levelMax = criteria.levelMax;
        this.cunningMax = criteria.cunningMax;
        this.physiqueMax = criteria.physiqueMax;
        this.spiritMax = criteria.spiritMax;
        this.noEnemyOnly = criteria.noEnemyOnly;
        this.criteria = criteria;
    }

    public ItemCriteriaCombination clone() {
        ItemCriteriaCombination combo = new ItemCriteriaCombination(this);
        return combo;
    }

    public String getItemClass() {
        return this.itemClass;
    }

    public String getArmorClass() {
        return this.armorClass;
    }

    public String getArtifactClass() {
        return this.artifactClass;
    }

    public String getItemRarity() {
        return this.itemRarity;
    }

    public boolean usesArmorClass() {
        return this.useArmorClass;
    }

    public boolean usesArtifactClass() {
        return this.useArtifactClass;
    }

    public boolean usesItemRarity() {
        return this.useItemRarity;
    }

    public boolean usesSlots() {
        return this.useSlots;
    }

    public int getMinLevel() {
        return this.levelMin;
    }

    public int getMaxLevel() {
        return this.levelMax;
    }

    public int getMaxCunning() {
        return this.cunningMax;
    }

    public int getMaxPhysique() {
        return this.physiqueMax;
    }

    public int getMaxSpirit() {
        return this.spiritMax;
    }

    public boolean isNoEnemyOnly() {
        return this.noEnemyOnly;
    }

    private void init() {
        this.useArmorClass = false;
        if (!this.criteria.armorClass.isEmpty() && ItemClass.isArmor(this.itemClass)) {
            this.useArmorClass = true;
        }
        this.useArtifactClass = false;
        if (!this.criteria.artifactClass.isEmpty() && ItemClass.isArtifact(this.itemClass)) {
            this.useArtifactClass = true;
        }
        this.useItemRarity = false;
        if (!this.criteria.itemRarity.isEmpty() && ItemClass.hasRarity(this.itemClass)) {
            this.useItemRarity = true;
        }
        this.useSlots = false;
        if (ItemClass.hasSlots(this.itemClass)) {
            this.useSlots = true;
        }
    }

    public void setItemClass(String itemClass) {
        if (itemClass == null) {
            this.itemClass = null;
            return;
        }
        if (itemClass.isEmpty()) {
            this.itemClass = null;
            return;
        }
        this.itemClass = itemClass;
        this.init();
    }

    public void setArmorClass(String armorClass) {
        if (armorClass == null) {
            this.armorClass = null;
            return;
        }
        if (armorClass.isEmpty()) {
            this.armorClass = null;
            return;
        }
        this.armorClass = armorClass;
    }

    public void setArtifactClass(String artifactClass) {
        if (artifactClass == null) {
            this.artifactClass = null;
            return;
        }
        if (artifactClass.isEmpty()) {
            this.artifactClass = null;
            return;
        }
        this.artifactClass = artifactClass;
    }

    public void setItemRarity(String itemRarity) {
        if (itemRarity == null) {
            this.itemRarity = null;
            return;
        }
        if (itemRarity.isEmpty()) {
            this.itemRarity = null;
            return;
        }
        this.itemRarity = itemRarity;
    }

    public String determineItemParameters() {
        String param = this.itemClass;
        if (this.useItemRarity) {
            param = param + ", " + this.itemRarity;
        }
        if (this.useArmorClass) {
            param = param + ", " + this.armorClass;
        }
        if (this.useArtifactClass) {
            param = param + ", " + this.artifactClass;
        }
        if (this.levelMin != -1) {
            param = param + ", " + Integer.toString(this.levelMin);
        }
        if (this.levelMax != -1) {
            param = param + ", " + Integer.toString(this.levelMax);
        }
        if (this.cunningMax != -1) {
            param = param + ", " + Integer.toString(this.cunningMax);
        }
        if (this.physiqueMax != -1) {
            param = param + ", " + Integer.toString(this.physiqueMax);
        }
        if (this.spiritMax != -1) {
            param = param + ", " + Integer.toString(this.spiritMax);
        }
        return param;
    }

    public String determineItemStatement() {
        String command = "SELECT * FROM GD_ITEM WHERE ITEM_CLASS = ?";
        if (this.useItemRarity) {
            command = command + " AND RARITY = ?";
        }
        if (this.useArmorClass) {
            command = command + " AND ARMOR_CLASS = ?";
        }
        if (this.useArtifactClass) {
            command = command + " AND ARTIFACT_CLASS = ?";
        }
        if (this.levelMin != -1) {
            command = command + " AND REQ_LEVEL >= ?";
        }
        if (this.levelMax != -1) {
            command = command + " AND REQ_LEVEL <= ?";
        }
        if (this.cunningMax != -1) {
            command = command + " AND REQ_DEX <= ?";
        }
        if (this.physiqueMax != -1) {
            command = command + " AND REQ_STR <= ?";
        }
        if (this.spiritMax != -1) {
            command = command + " AND REQ_INT <= ?";
        }
        if (this.noEnemyOnly) {
            command = command + " AND ENEMY_ONLY = ?";
        }
        command = command + this.determineSlotConditions(null);
        return command;
    }

    public String determineItemIDStatement() {
        String command = "SELECT ITEM_ID FROM GD_ITEM WHERE ITEM_CLASS = ?";
        if (this.useItemRarity) {
            command = command + " AND RARITY = ?";
        }
        if (this.useArmorClass) {
            command = command + " AND ARMOR_CLASS = ?";
        }
        if (this.useArtifactClass) {
            command = command + " AND ARTIFACT_CLASS = ?";
        }
        if (this.levelMin != -1) {
            command = command + " AND REQ_LEVEL >= ?";
        }
        if (this.levelMax != -1) {
            command = command + " AND REQ_LEVEL <= ?";
        }
        if (this.cunningMax != -1) {
            command = command + " AND REQ_DEX <= ?";
        }
        if (this.physiqueMax != -1) {
            command = command + " AND REQ_STR <= ?";
        }
        if (this.spiritMax != -1) {
            command = command + " AND REQ_INT <= ?";
        }
        if (this.noEnemyOnly) {
            command = command + " AND ENEMY_ONLY = ?";
        }
        command = command + this.determineSlotConditions(null);
        return command;
    }

    public String determineStashIDItemStatement(boolean isHardcore) {
        String command = "SELECT S.STASH_ID FROM STASH_ITEM_V7 S, GD_ITEM I WHERE S.ITEM_ID = I.ITEM_ID AND I.ITEM_CLASS = ?";
        if (!GDStashFrame.iniConfig.sectRestrict.transferSCHC) {
            command = isHardcore ? command + " AND S.HARDCORE = true" : command + " AND S.HARDCORE = false";
        }
        if (this.useItemRarity) {
            command = command + " AND I.RARITY = ?";
        }
        if (this.useArmorClass) {
            command = command + " AND I.ARMOR_CLASS = ?";
        }
        if (this.useArtifactClass) {
            command = command + " AND I.ARTIFACT_CLASS = ?";
        }
        if (this.levelMin != -1) {
            command = command + " AND I.REQ_LEVEL >= ?";
        }
        if (this.levelMax != -1) {
            command = command + " AND I.REQ_LEVEL <= ?";
        }
        if (this.cunningMax != -1) {
            command = command + " AND I.REQ_DEX <= ?";
        }
        if (this.physiqueMax != -1) {
            command = command + " AND I.REQ_STR <= ?";
        }
        if (this.spiritMax != -1) {
            command = command + " AND I.REQ_INT <= ?";
        }
        if (this.noEnemyOnly) {
            command = command + " AND I.ENEMY_ONLY = ?";
        }
        command = command + this.determineSlotConditions("I.");
        return command;
    }

    public int fillItemStatement(PreparedStatement ps) throws SQLException {
        ps.clearParameters();
        int nextPos = 1;
        ps.setString(nextPos, this.itemClass);
        ++nextPos;
        if (this.useItemRarity) {
            ps.setString(nextPos, this.itemRarity);
            ++nextPos;
        }
        if (this.useArmorClass) {
            ps.setString(nextPos, this.armorClass);
            ++nextPos;
        }
        if (this.useArtifactClass) {
            ps.setString(nextPos, this.artifactClass);
            ++nextPos;
        }
        if (this.levelMin != -1) {
            ps.setInt(nextPos, this.levelMin);
            ++nextPos;
        }
        if (this.levelMax != -1) {
            ps.setInt(nextPos, this.levelMax);
            ++nextPos;
        }
        if (this.cunningMax != -1) {
            ps.setInt(nextPos, this.cunningMax);
            ++nextPos;
        }
        if (this.physiqueMax != -1) {
            ps.setInt(nextPos, this.physiqueMax);
            ++nextPos;
        }
        if (this.spiritMax != -1) {
            ps.setInt(nextPos, this.spiritMax);
            ++nextPos;
        }
        if (this.noEnemyOnly) {
            ps.setBoolean(nextPos, false);
            ++nextPos;
        }
        return nextPos;
    }

    public String determineSlotConditions(String prefix) {
        String command = "";
        if (!this.useSlots) {
            return command;
        }
        boolean firstSlot = true;
        if (this.criteria.slotAxe1H) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_AXE_1H = true" : command + prefix + "SLOT_AXE_1H = true";
        }
        if (this.criteria.slotAxe2H) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_AXE_2H = true" : command + prefix + "SLOT_AXE_2H = true";
        }
        if (this.criteria.slotDagger1H) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_DAGGER_1H = true" : command + prefix + "SLOT_DAGGER_1H = true";
        }
        if (this.criteria.slotMace1H) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_MACE_1H = true" : command + prefix + "SLOT_MACE_1H = true";
        }
        if (this.criteria.slotMace2H) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_MACE_2H = true" : command + prefix + "SLOT_MACE_2H = true";
        }
        if (this.criteria.slotScepter1H) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_SCEPTER_1H = true" : command + prefix + "SLOT_SCEPTER_1H = true";
        }
        if (this.criteria.slotSpear1H) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_SPEAR_2H = true" : command + prefix + "SLOT_SPEAR_2H = true";
        }
        if (this.criteria.slotStaff2H) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_STAFF_2H = true" : command + prefix + "SLOT_STAFF_2H = true";
        }
        if (this.criteria.slotSword1H) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_SWORD_1H = true" : command + prefix + "SLOT_SWORD_1H = true";
        }
        if (this.criteria.slotSword2H) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_SWORD_2H = true" : command + prefix + "SLOT_SWORD_2H = true";
        }
        if (this.criteria.slotRanged1H) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_RANGED_1H = true" : command + prefix + "SLOT_RANGED_1H = true";
        }
        if (this.criteria.slotRanged2H) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_RANGED_2H = true" : command + prefix + "SLOT_RANGED_2H = true";
        }
        if (this.criteria.slotShield) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_SHIELD = true" : command + prefix + "SLOT_SHIELD = true";
        }
        if (this.criteria.slotOffhand) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_OFFHAND = true" : command + prefix + "SLOT_OFFHAND = true";
        }
        if (this.criteria.slotAmulet) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_AMULET = true" : command + prefix + "SLOT_AMULET = true";
        }
        if (this.criteria.slotBelt) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_BELT = true" : command + prefix + "SLOT_BELT = true";
        }
        if (this.criteria.slotMedal) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_MEDAL = true" : command + prefix + "SLOT_MEDAL = true";
        }
        if (this.criteria.slotRing) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_RING = true" : command + prefix + "SLOT_RING = true";
        }
        if (this.criteria.slotHead) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_HEAD = true" : command + prefix + "SLOT_HEAD = true";
        }
        if (this.criteria.slotShoulders) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_SHOULDERS = true" : command + prefix + "SLOT_SHOULDERS = true";
        }
        if (this.criteria.slotChest) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_CHEST = true" : command + prefix + "SLOT_CHEST = true";
        }
        if (this.criteria.slotHands) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_HANDS = true" : command + prefix + "SLOT_HANDS = true";
        }
        if (this.criteria.slotLegs) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_LEGS = true" : command + prefix + "SLOT_LEGS = true";
        }
        if (this.criteria.slotFeet) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_FEET = true" : command + prefix + "SLOT_FEET = true";
        }
        if (!firstSlot) {
            command = command + " )";
        }
        return command;
    }

    public List<ItemCriteriaCombination> createItemCombinations() {
        LinkedList<ItemCriteriaCombination> list = new LinkedList<ItemCriteriaCombination>();
        ItemCriteriaCombination combo = new ItemCriteriaCombination(this);
        boolean found = false;
        if (combo.usesItemRarity()) {
            Iterator<String> iterIR = this.criteria.itemRarity.iterator();
            while (iterIR.hasNext()) {
                combo.setItemRarity(iterIR.next());
                if (combo.usesArmorClass()) {
                    Iterator<String> iterAC = this.criteria.armorClass.iterator();
                    while (iterAC.hasNext()) {
                        combo.setArmorClass(iterAC.next());
                        list.add(combo.clone());
                    }
                    found = true;
                }
                if (found) continue;
                list.add(combo.clone());
            }
        } else {
            Iterator<String> iterAC;
            if (combo.usesArmorClass()) {
                iterAC = this.criteria.armorClass.iterator();
                while (iterAC.hasNext()) {
                    combo.setArmorClass(iterAC.next());
                    list.add(combo.clone());
                }
                found = true;
            }
            if (combo.usesArtifactClass()) {
                iterAC = this.criteria.artifactClass.iterator();
                while (iterAC.hasNext()) {
                    combo.setArtifactClass(iterAC.next());
                    list.add(combo.clone());
                }
                found = true;
            }
            if (!found) {
                list.add(combo.clone());
            }
        }
        return list;
    }

    public List<ItemCriteriaCombination> createAffixCombinations() {
        LinkedList<ItemCriteriaCombination> list = new LinkedList<ItemCriteriaCombination>();
        ItemCriteriaCombination combo = new ItemCriteriaCombination(this);
        if (combo.usesItemRarity()) {
            Iterator<String> iterIR = this.criteria.itemRarity.iterator();
            while (iterIR.hasNext()) {
                combo.setItemRarity(iterIR.next());
                list.add(combo.clone());
            }
        } else {
            list.add(combo.clone());
        }
        return list;
    }
}

