/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.util.GDLog;
import org.gdstash.util.GDMsgFormatter;

public class SelectionCriteria {
    public static int SELECTION_MODE_ITEM = 1;
    public static int SELECTION_MODE_COMPONENT = 2;
    public static int SELECTION_MODE_AFFIX = 3;
    public int selMode = SELECTION_MODE_ITEM;
    public List<String> itemIDs = null;
    public List<String> itemClass = new LinkedList<String>();
    public List<String> armorClass = new LinkedList<String>();
    public List<String> artifactClass = new LinkedList<String>();
    public List<String> itemRarity = new LinkedList<String>();
    public List<String> itemStyle = new LinkedList<String>();
    public String itemName = null;
    public String bonusSkill = null;
    public boolean allSkills = false;
    public String itemSkill = null;
    public String prefixID = null;
    public String suffixID = null;
    public int levelMin = -1;
    public int levelMax = -1;
    public int cunningMax = -1;
    public int physiqueMax = -1;
    public int spiritMax = -1;
    public String dmgConversionTo;
    public boolean noEnemyOnly = true;
    public DamageClassInfo dmgClassInfo = new DamageClassInfo();
    public FieldInfo fieldInfo = new FieldInfo();
    public List<StatInfo> statInfos = new LinkedList<StatInfo>();
    public boolean slotAxe1H = false;
    public boolean slotAxe2H = false;
    public boolean slotDagger1H = false;
    public boolean slotMace1H = false;
    public boolean slotMace2H = false;
    public boolean slotScepter1H = false;
    public boolean slotSpear1H;
    public boolean slotStaff2H;
    public boolean slotSword1H = false;
    public boolean slotSword2H = false;
    public boolean slotRanged1H = false;
    public boolean slotRanged2H = false;
    public boolean slotShield = false;
    public boolean slotOffhand = false;
    public boolean slotAmulet = false;
    public boolean slotBelt = false;
    public boolean slotMedal = false;
    public boolean slotRing = false;
    public boolean slotHead = false;
    public boolean slotShoulders = false;
    public boolean slotChest = false;
    public boolean slotHands = false;
    public boolean slotLegs = false;
    public boolean slotFeet = false;
    public boolean petBonus = false;

    public void checkCriteria(GDLog log) {
        if (this.selMode != SELECTION_MODE_AFFIX && (this.itemIDs == null || this.itemIDs.isEmpty()) && (this.itemClass == null || this.itemClass.isEmpty())) {
            log.addError(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_SEL_ITEM_TYPE"));
        }
        if ((this.dmgClassInfo.defense || this.dmgClassInfo.offense || this.dmgClassInfo.retaliation) && (this.statInfos == null || this.statInfos.isEmpty())) {
            log.addError(GDMsgFormatter.getString(GDMsgFormatter.rbUI, "ERR_SEL_DMG_COMBI"));
        }
    }

    public boolean isInitial() {
        if (this.itemIDs != null && !this.itemIDs.isEmpty()) {
            return false;
        }
        if (this.itemClass != null && !this.itemClass.isEmpty()) {
            return false;
        }
        if (this.armorClass != null && !this.armorClass.isEmpty()) {
            return false;
        }
        if (this.artifactClass != null && !this.artifactClass.isEmpty()) {
            return false;
        }
        if (this.itemRarity != null && !this.itemRarity.isEmpty()) {
            return false;
        }
        if (this.itemStyle != null && !this.itemStyle.isEmpty()) {
            return false;
        }
        if (this.itemName != null) {
            return false;
        }
        if (this.bonusSkill != null) {
            return false;
        }
        if (this.allSkills) {
            return false;
        }
        if (this.itemSkill != null) {
            return false;
        }
        if (this.prefixID != null) {
            return false;
        }
        if (this.suffixID != null) {
            return false;
        }
        if (this.levelMin > -1) {
            return false;
        }
        if (this.levelMax > -1) {
            return false;
        }
        if (this.cunningMax > -1) {
            return false;
        }
        if (this.physiqueMax > -1) {
            return false;
        }
        if (this.spiritMax > -1) {
            return false;
        }
        if (this.dmgConversionTo != null) {
            return false;
        }
        if (this.statInfos != null && !this.statInfos.isEmpty()) {
            return false;
        }
        if (this.slotAxe1H) {
            return false;
        }
        if (this.slotAxe2H) {
            return false;
        }
        if (this.slotDagger1H) {
            return false;
        }
        if (this.slotMace1H) {
            return false;
        }
        if (this.slotMace2H) {
            return false;
        }
        if (this.slotScepter1H) {
            return false;
        }
        if (this.slotSpear1H) {
            return false;
        }
        if (this.slotStaff2H) {
            return false;
        }
        if (this.slotSword1H) {
            return false;
        }
        if (this.slotSword2H) {
            return false;
        }
        if (this.slotRanged1H) {
            return false;
        }
        if (this.slotShield) {
            return false;
        }
        if (this.slotOffhand) {
            return false;
        }
        if (this.slotAmulet) {
            return false;
        }
        if (this.slotBelt) {
            return false;
        }
        if (this.slotMedal) {
            return false;
        }
        if (this.slotRing) {
            return false;
        }
        if (this.slotHead) {
            return false;
        }
        if (this.slotShoulders) {
            return false;
        }
        if (this.slotChest) {
            return false;
        }
        if (this.slotHands) {
            return false;
        }
        if (this.slotLegs) {
            return false;
        }
        if (this.slotFeet) {
            return false;
        }
        return !this.petBonus;
    }

    public boolean isDamageClassUsed() {
        return this.dmgClassInfo.defense || this.dmgClassInfo.offense || this.dmgClassInfo.retaliation;
    }

    public boolean isStatTypeUsed() {
        return !this.statInfos.isEmpty();
    }

    public boolean isSkillBonusUsed() {
        return this.bonusSkill != null;
    }

    public boolean isAllSkillsUsed() {
        return this.allSkills;
    }

    public boolean isItemSkillsUsed() {
        return this.itemSkill != null;
    }

    public boolean isPrefixUsed() {
        return this.prefixID != null;
    }

    public boolean isSuffixUsed() {
        return this.suffixID != null;
    }

    public void condense() {
        LinkedList<StatInfo> list = new LinkedList<StatInfo>();
        Iterator<StatInfo> iter = this.statInfos.iterator();
        while (iter.hasNext()) {
            StatInfo info = iter.next();
            boolean found = false;
            Iterator itList = list.iterator();
            while (iter.hasNext()) {
                StatInfo condensed = (StatInfo)itList.next();
                if (!condensed.statType.equals(info.statType)) continue;
                found = true;
                condensed.flat = condensed.flat || info.flat;
                condensed.percentage = condensed.percentage || info.percentage;
                condensed.maxResist = condensed.maxResist || info.maxResist;
            }
            if (found) continue;
            list.add(info);
        }
        this.statInfos = list;
    }

    private static List<String> determineDamageTypes(DamageClassInfo dmgClassInfo, int statType) {
        LinkedList<String> list = new LinkedList<String>();
        if (statType == 301) {
            if (dmgClassInfo.defense) {
                list.add("defensivePoison");
            }
            if (dmgClassInfo.offense) {
                list.add("offensiveBasePoison");
                list.add("offensivePoison");
            }
            if (dmgClassInfo.retaliation) {
                list.add("retaliationPoison");
            }
        }
        if (statType == 302) {
            if (dmgClassInfo.defense) {
                list.add("defensiveAether");
            }
            if (dmgClassInfo.offense) {
                list.add("offensiveBaseAether");
                list.add("offensiveAether");
            }
            if (dmgClassInfo.retaliation) {
                list.add("retaliationAether");
            }
        }
        if (statType == 303) {
            if (dmgClassInfo.defense) {
                list.add("defensiveChaos");
            }
            if (dmgClassInfo.offense) {
                list.add("offensiveBaseChaos");
                list.add("offensiveChaos");
            }
            if (dmgClassInfo.retaliation) {
                list.add("retaliationChaos");
            }
        }
        if (statType == 304) {
            if (dmgClassInfo.defense) {
                list.add("defensiveCold");
            }
            if (dmgClassInfo.offense) {
                list.add("offensiveBaseCold");
                list.add("offensiveCold");
            }
            if (dmgClassInfo.retaliation) {
                list.add("retaliationCold");
            }
        }
        if (statType == 305) {
            if (dmgClassInfo.defense) {
                list.add("defensiveElemental");
                list.add("defensiveElementalResistance");
            }
            if (dmgClassInfo.offense) {
                list.add("offensiveElemental");
            }
            if (dmgClassInfo.retaliation) {
                list.add("retaliationElemental");
            }
        }
        if (statType == 306) {
            if (dmgClassInfo.defense) {
                list.add("defensiveFire");
            }
            if (dmgClassInfo.offense) {
                list.add("offensiveBaseFire");
                list.add("offensiveFire");
            }
            if (dmgClassInfo.retaliation) {
                list.add("retaliationFire");
            }
        }
        if (statType == 307) {
            if (dmgClassInfo.defense) {
                list.add("defensiveLife");
            }
            if (dmgClassInfo.offense) {
                list.add("offensiveBaseLife");
                list.add("offensiveLife");
            }
            if (dmgClassInfo.retaliation) {
                list.add("retaliationLife");
            }
        }
        if (statType == 308) {
            if (dmgClassInfo.defense) {
                list.add("defensiveLightning");
            }
            if (dmgClassInfo.offense) {
                list.add("offensiveBaseLightning");
                list.add("offensiveLightning");
            }
            if (dmgClassInfo.retaliation) {
                list.add("retaliationLightning");
            }
        }
        if (statType == 309) {
            if (dmgClassInfo.defense) {
                list.add("defensivePhysical");
            }
            if (dmgClassInfo.offense) {
                list.add("offensivePhysical");
                list.add("offensiveBonusPhysical");
            }
            if (dmgClassInfo.retaliation) {
                list.add("retaliationPhysical");
            }
        }
        if (statType == 310) {
            if (dmgClassInfo.defense) {
                list.add("defensivePierce");
            }
            if (dmgClassInfo.offense) {
                list.add("offensivePierce");
            }
            if (dmgClassInfo.retaliation) {
                list.add("retaliationPierce");
            }
        }
        if (statType == 401) {
            if (dmgClassInfo.defense && !list.contains("defensivePoison")) {
                list.add("defensivePoison");
            }
            if (dmgClassInfo.offense) {
                list.add("offensiveSlowPoison");
            }
            if (dmgClassInfo.retaliation) {
                list.add("retaliationSlowPoison");
            }
        }
        if (statType == 404) {
            if (dmgClassInfo.defense && !list.contains("defensiveCold")) {
                list.add("defensiveCold");
            }
            if (dmgClassInfo.offense) {
                list.add("offensiveSlowCold");
            }
            if (dmgClassInfo.retaliation) {
                list.add("retaliationSlowCold");
            }
        }
        if (statType == 406) {
            if (dmgClassInfo.defense && !list.contains("defensiveFire")) {
                list.add("defensiveFire");
            }
            if (dmgClassInfo.offense) {
                list.add("offensiveSlowFire");
            }
            if (dmgClassInfo.retaliation) {
                list.add("retaliationSlowFire");
            }
        }
        if (statType == 407) {
            if (dmgClassInfo.defense && !list.contains("defensiveLife")) {
                list.add("defensiveLife");
            }
            if (dmgClassInfo.offense) {
                list.add("offensiveSlowLife");
            }
            if (dmgClassInfo.retaliation) {
                list.add("retaliationSlowLife");
            }
        }
        if (statType == 408) {
            if (dmgClassInfo.defense && !list.contains("defensiveLightning")) {
                list.add("defensiveLightning");
            }
            if (dmgClassInfo.offense) {
                list.add("offensiveSlowLightning");
            }
            if (dmgClassInfo.retaliation) {
                list.add("retaliationSlowLightning");
            }
        }
        if (statType == 409) {
            if (dmgClassInfo.defense && !list.contains("defensivePhysical")) {
                list.add("defensivePhysical");
            }
            if (dmgClassInfo.offense) {
                list.add("offensiveSlowPhysical");
            }
            if (dmgClassInfo.retaliation) {
                list.add("retaliationSlowPhysical");
            }
        }
        if (statType == 410) {
            if (dmgClassInfo.defense) {
                list.add("defensiveBleeding");
            }
            if (dmgClassInfo.offense) {
                list.add("offensiveSlowBleeding");
            }
            if (dmgClassInfo.retaliation) {
                list.add("retaliationSlowBleeding");
            }
        }
        if (statType == 501) {
            if (dmgClassInfo.defense && !list.contains("defensiveAll")) {
                list.add("defensiveAll");
            }
            if (dmgClassInfo.offense) {
                list.add("offensiveTotalDamage");
            }
            if (dmgClassInfo.retaliation) {
                list.add("retaliationTotalDamage");
            }
        }
        if (statType == 502 && dmgClassInfo.offense) {
            list.add("offensiveCritDamage");
        }
        if (statType == 503 && dmgClassInfo.offense) {
            list.add("offensiveLifeLeech");
        }
        if (statType == 504 && (dmgClassInfo.defense || dmgClassInfo.offense) && !list.contains("defensiveReflect")) {
            list.add("defensiveReflect");
        }
        if (statType == 505) {
            if ((dmgClassInfo.defense || dmgClassInfo.offense) && !list.contains("offensiveSlowAttackSpeed")) {
                list.add("offensiveSlowAttackSpeed");
            }
            if (dmgClassInfo.retaliation) {
                list.add("retaliationSlowAttackSpeed");
            }
        }
        if (statType == 506 && (dmgClassInfo.defense || dmgClassInfo.offense) && !list.contains("offensiveSlowTotalSpeed")) {
            list.add("offensiveSlowTotalSpeed");
        }
        if (statType == 507) {
            if ((dmgClassInfo.defense || dmgClassInfo.offense) && !list.contains("offensiveSlowDefensiveAbility")) {
                list.add("offensiveSlowDefensiveAbility");
            }
            if (dmgClassInfo.retaliation) {
                list.add("retaliationSlowDefensiveAbility");
            }
        }
        if (statType == 508) {
            if ((dmgClassInfo.defense || dmgClassInfo.offense) && !list.contains("offensiveSlowOffensiveAbility")) {
                list.add("offensiveSlowOffensiveAbility");
            }
            if (dmgClassInfo.retaliation) {
                list.add("retaliationSlowOffensiveAbility");
            }
        }
        if (statType == 509 && (dmgClassInfo.defense || dmgClassInfo.offense) && !list.contains("offensiveTotalResistanceReductionAbsolute")) {
            list.add("offensiveTotalResistanceReductionAbsolute");
        }
        if (statType == 510 && (dmgClassInfo.defense || dmgClassInfo.offense) && !list.contains("offensiveTotalResistanceReductionPercent")) {
            list.add("offensiveTotalResistanceReductionPercent");
        }
        if (statType == 511 && (dmgClassInfo.defense || dmgClassInfo.offense) && !list.contains("offensivePhysicalResistanceReductionAbsolute")) {
            list.add("offensivePhysicalResistanceReductionAbsolute");
        }
        if (statType == 512 && (dmgClassInfo.defense || dmgClassInfo.offense) && !list.contains("offensivePhysicalResistanceReductionPercent")) {
            list.add("offensivePhysicalResistanceReductionPercent");
        }
        if (statType == 513 && (dmgClassInfo.defense || dmgClassInfo.offense) && !list.contains("offensiveElementalResistanceReductionAbsolute")) {
            list.add("offensiveElementalResistanceReductionAbsolute");
        }
        if (statType == 514 && (dmgClassInfo.defense || dmgClassInfo.offense) && !list.contains("offensiveElementalResistanceReductionPercent")) {
            list.add("offensiveElementalResistanceReductionPercent");
        }
        return list;
    }

    private static List<StatInfo> determineStatInfos(FieldInfo fieldInfo, List<String> statTypes) {
        LinkedList<StatInfo> infos = new LinkedList<StatInfo>();
        boolean flagsFilled = fieldInfo.flat || fieldInfo.percentage || fieldInfo.maxResist;
        for (String statType : statTypes) {
            StatInfo info = new StatInfo();
            info.statType = statType;
            info.flat = fieldInfo.flat;
            info.percentage = fieldInfo.percentage;
            info.maxResist = fieldInfo.maxResist;
            if (!flagsFilled) {
                info.flat = true;
                info.percentage = true;
            }
            infos.add(info);
        }
        return infos;
    }

    public static void addStatInfos(SelectionCriteria criteria, int statType) {
        List<String> statTypes = SelectionCriteria.determineDamageTypes(criteria.dmgClassInfo, statType);
        List<StatInfo> infos = SelectionCriteria.determineStatInfos(criteria.fieldInfo, statTypes);
        criteria.statInfos.addAll(infos);
    }

    public static class FieldInfo {
        public boolean flat = false;
        public boolean percentage = false;
        public boolean maxResist = false;
    }

    public static class DamageClassInfo {
        public boolean offense = false;
        public boolean defense = false;
        public boolean retaliation = false;
    }

    public static class StatInfo {
        public String statType = null;
        public boolean flat = false;
        public boolean percentage = false;
        public boolean maxResist = false;
    }
}

