/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db.criteria;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.ItemClass;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.db.criteria.CriteriaCombination;
import org.gdstash.util.GDMsgFormatter;

public class AbstractItemCombination
implements CriteriaCombination,
Cloneable {
    private String itemClass;
    private String armorClass;
    private String artifactClass;
    private String itemRarity;
    private boolean useArmorClass;
    private boolean useArtifactClass;
    private boolean useItemRarity;
    private boolean useItemName;
    private boolean useBonusSkill;
    private boolean useAllSkills;
    private boolean useItemSkill;
    private boolean usePrefix;
    private boolean useSuffix;
    private boolean useConversion;
    private boolean useSlots;
    private boolean petBonus;
    private String itemName;
    private String bonusSkill;
    private boolean allSkills;
    private String itemSkill;
    private String prefixID;
    private String suffixID;
    private int levelMin;
    private int levelMax;
    private int cunningMax;
    private int physiqueMax;
    private int spiritMax;
    public String dmgConversionTo;
    private boolean noEnemyOnly;
    private SelectionCriteria criteria;

    public AbstractItemCombination() {
        this.itemClass = null;
        this.armorClass = null;
        this.artifactClass = null;
        this.itemRarity = null;
        this.useArmorClass = false;
        this.useArtifactClass = false;
        this.useItemRarity = false;
        this.useItemName = false;
        this.useBonusSkill = false;
        this.useAllSkills = false;
        this.useItemSkill = false;
        this.usePrefix = false;
        this.useSuffix = false;
        this.useConversion = false;
        this.useSlots = false;
        this.petBonus = false;
        this.itemName = null;
        this.levelMin = -1;
        this.levelMax = -1;
        this.cunningMax = -1;
        this.physiqueMax = -1;
        this.spiritMax = -1;
        this.dmgConversionTo = null;
        this.noEnemyOnly = true;
        this.criteria = null;
    }

    public AbstractItemCombination(AbstractItemCombination combo) {
        this.itemClass = combo.itemClass;
        this.armorClass = combo.armorClass;
        this.artifactClass = combo.artifactClass;
        this.itemRarity = combo.itemRarity;
        this.useArmorClass = combo.useArmorClass;
        this.useArtifactClass = combo.useArtifactClass;
        this.useItemRarity = combo.useItemRarity;
        this.useItemName = combo.useItemName;
        this.useBonusSkill = combo.useBonusSkill;
        this.useAllSkills = combo.useAllSkills;
        this.useItemSkill = combo.useItemSkill;
        this.usePrefix = combo.usePrefix;
        this.useSuffix = combo.useSuffix;
        this.useConversion = combo.useConversion;
        this.useSlots = combo.useSlots;
        this.petBonus = combo.petBonus;
        this.itemName = combo.itemName;
        this.bonusSkill = combo.bonusSkill;
        this.itemSkill = combo.itemSkill;
        this.prefixID = combo.prefixID;
        this.suffixID = combo.suffixID;
        this.levelMin = combo.levelMin;
        this.levelMax = combo.levelMax;
        this.cunningMax = combo.cunningMax;
        this.physiqueMax = combo.physiqueMax;
        this.spiritMax = combo.spiritMax;
        this.dmgConversionTo = combo.dmgConversionTo;
        this.noEnemyOnly = combo.noEnemyOnly;
        this.criteria = combo.criteria;
    }

    public AbstractItemCombination(SelectionCriteria criteria) {
        this();
        this.setItemName(criteria.itemName);
        this.setBonusSkill(criteria.bonusSkill);
        this.setItemSkill(criteria.itemSkill);
        this.setPrefixID(criteria.prefixID);
        this.setSuffixID(criteria.suffixID);
        this.allSkills = criteria.allSkills;
        this.levelMin = criteria.levelMin;
        this.levelMax = criteria.levelMax;
        this.cunningMax = criteria.cunningMax;
        this.physiqueMax = criteria.physiqueMax;
        this.spiritMax = criteria.spiritMax;
        this.dmgConversionTo = criteria.dmgConversionTo;
        this.noEnemyOnly = criteria.noEnemyOnly;
        this.petBonus = criteria.petBonus;
        this.criteria = criteria;
    }

    @Override
    public AbstractItemCombination clone() {
        AbstractItemCombination combo = new AbstractItemCombination(this);
        return combo;
    }

    public String getItemClass() {
        return this.itemClass;
    }

    public String getArmorClass() {
        return this.armorClass;
    }

    public String getArtifactClass() {
        return this.artifactClass;
    }

    public String getItemRarity() {
        return this.itemRarity;
    }

    @Override
    public boolean usesArmorClass() {
        return this.useArmorClass;
    }

    @Override
    public boolean usesArtifactClass() {
        return this.useArtifactClass;
    }

    @Override
    public boolean usesItemRarity() {
        return this.useItemRarity;
    }

    @Override
    public boolean usesItemName() {
        return this.useItemName;
    }

    public boolean usesBonusSkill() {
        return this.useBonusSkill;
    }

    public boolean usesAllSkills() {
        return this.useAllSkills;
    }

    public boolean usesItemSkill() {
        return this.useItemSkill;
    }

    public boolean usesPrefix() {
        return this.usePrefix;
    }

    public boolean usesSuffix() {
        return this.useSuffix;
    }

    public boolean usesConversion() {
        return this.useConversion;
    }

    public boolean usesSlots() {
        return this.useSlots;
    }

    public boolean usesPetBonus() {
        return this.petBonus;
    }

    public String getItemName() {
        return this.itemName;
    }

    public String getBonusSkillID() {
        return this.bonusSkill;
    }

    public boolean isAllSkills() {
        return this.allSkills;
    }

    public String getItemSkillID() {
        return this.itemSkill;
    }

    public String getPrefixID() {
        return this.prefixID;
    }

    public String getSuffixID() {
        return this.suffixID;
    }

    public int getMinLevel() {
        return this.levelMin;
    }

    public int getMaxLevel() {
        return this.levelMax;
    }

    public int getMaxCunning() {
        return this.cunningMax;
    }

    public int getMaxPhysique() {
        return this.physiqueMax;
    }

    public int getMaxSpirit() {
        return this.spiritMax;
    }

    public String getDamageConvertedTo() {
        return this.dmgConversionTo;
    }

    public boolean isNoEnemyOnly() {
        return this.noEnemyOnly;
    }

    public List<String> getItemRarities() {
        if (this.criteria == null) {
            return new LinkedList<String>();
        }
        return this.criteria.itemRarity;
    }

    public List<String> getArmorClasses() {
        if (this.criteria == null) {
            return new LinkedList<String>();
        }
        return this.criteria.armorClass;
    }

    public List<String> getArtifactClasses() {
        if (this.criteria == null) {
            return new LinkedList<String>();
        }
        return this.criteria.artifactClass;
    }

    private void init() {
        this.useArmorClass = false;
        if (!this.criteria.armorClass.isEmpty() && this.isArmor()) {
            this.useArmorClass = true;
        }
        this.useArtifactClass = false;
        if (!this.criteria.artifactClass.isEmpty() && this.isArtifact()) {
            this.useArtifactClass = true;
        }
        this.useItemRarity = false;
        if (!this.criteria.itemRarity.isEmpty() && ItemClass.hasRarity(this.itemClass)) {
            this.useItemRarity = true;
        }
        this.useItemName = false;
        if (this.criteria.itemName != null && !this.criteria.itemName.isEmpty()) {
            this.useItemName = true;
        }
        this.useBonusSkill = false;
        if (this.criteria.bonusSkill != null && !this.criteria.bonusSkill.isEmpty()) {
            this.useBonusSkill = true;
        }
        this.useAllSkills = this.criteria.allSkills;
        this.useItemSkill = false;
        if (this.criteria.itemSkill != null && !this.criteria.itemSkill.isEmpty()) {
            this.useItemSkill = true;
        }
        this.usePrefix = false;
        if (this.criteria.prefixID != null && !this.criteria.prefixID.isEmpty()) {
            this.usePrefix = true;
        }
        this.useSuffix = false;
        if (this.criteria.suffixID != null && !this.criteria.suffixID.isEmpty()) {
            this.useSuffix = true;
        }
        this.useConversion = false;
        if (this.criteria.dmgConversionTo != null && !this.criteria.dmgConversionTo.isEmpty()) {
            this.useConversion = true;
        }
        this.useSlots = false;
        if (this.hasSlots()) {
            this.useSlots = true;
        }
    }

    private boolean isArmor() {
        if (this.itemClass == null) {
            return false;
        }
        return this.itemClass.equals("ArmorProtective_Head") || this.itemClass.equals("ArmorProtective_Shoulders") || this.itemClass.equals("ArmorProtective_Chest") || this.itemClass.equals("ArmorProtective_Hands") || this.itemClass.equals("ArmorProtective_Legs") || this.itemClass.equals("ArmorProtective_Feet");
    }

    private boolean isArtifact() {
        if (this.itemClass == null) {
            return false;
        }
        return this.itemClass.equals("ItemArtifact");
    }

    private boolean hasSlots() {
        if (this.itemClass == null) {
            return false;
        }
        return this.itemClass.equals("ItemRelic") || this.itemClass.equals("ItemEnchantment");
    }

    public static List<String> wrapString(ResultSet rs, int pos) throws SQLException {
        LinkedList<String> list = new LinkedList<String>();
        String executedQuery = rs.getStatement().toString();
        while (rs.next()) {
            String s = rs.getString(pos);
            if (s == null || s.isEmpty()) continue;
            list.add(s);
        }
        return list;
    }

    public static List<Integer> wrapInteger(ResultSet rs, int pos) throws SQLException {
        LinkedList<Integer> list = new LinkedList<Integer>();
        while (rs.next()) {
            int i = rs.getInt(pos);
            Integer iI = new Integer(i);
            list.add(iI);
        }
        return list;
    }

    public String determineSlotConditions(String prefix) {
        String command = "";
        if (!this.useSlots) {
            return command;
        }
        boolean firstSlot = true;
        if (this.criteria.slotAxe1H) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_AXE_1H = true" : command + prefix + "SLOT_AXE_1H = true";
        }
        if (this.criteria.slotAxe2H) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_AXE_2H = true" : command + prefix + "SLOT_AXE_2H = true";
        }
        if (this.criteria.slotDagger1H) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_DAGGER_1H = true" : command + prefix + "SLOT_DAGGER_1H = true";
        }
        if (this.criteria.slotMace1H) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_MACE_1H = true" : command + prefix + "SLOT_MACE_1H = true";
        }
        if (this.criteria.slotMace2H) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_MACE_2H = true" : command + prefix + "SLOT_MACE_2H = true";
        }
        if (this.criteria.slotScepter1H) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_SCEPTER_1H = true" : command + prefix + "SLOT_SCEPTER_1H = true";
        }
        if (this.criteria.slotSpear1H) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_SPEAR_2H = true" : command + prefix + "SLOT_SPEAR_2H = true";
        }
        if (this.criteria.slotStaff2H) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_STAFF_2H = true" : command + prefix + "SLOT_STAFF_2H = true";
        }
        if (this.criteria.slotSword1H) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_SWORD_1H = true" : command + prefix + "SLOT_SWORD_1H = true";
        }
        if (this.criteria.slotSword2H) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_SWORD_2H = true" : command + prefix + "SLOT_SWORD_2H = true";
        }
        if (this.criteria.slotRanged1H) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_RANGED_1H = true" : command + prefix + "SLOT_RANGED_1H = true";
        }
        if (this.criteria.slotRanged2H) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_RANGED_2H = true" : command + prefix + "SLOT_RANGED_2H = true";
        }
        if (this.criteria.slotShield) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_SHIELD = true" : command + prefix + "SLOT_SHIELD = true";
        }
        if (this.criteria.slotOffhand) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_OFFHAND = true" : command + prefix + "SLOT_OFFHAND = true";
        }
        if (this.criteria.slotAmulet) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_AMULET = true" : command + prefix + "SLOT_AMULET = true";
        }
        if (this.criteria.slotBelt) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_BELT = true" : command + prefix + "SLOT_BELT = true";
        }
        if (this.criteria.slotMedal) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_MEDAL = true" : command + prefix + "SLOT_MEDAL = true";
        }
        if (this.criteria.slotRing) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_RING = true" : command + prefix + "SLOT_RING = true";
        }
        if (this.criteria.slotHead) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_HEAD = true" : command + prefix + "SLOT_HEAD = true";
        }
        if (this.criteria.slotShoulders) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_SHOULDERS = true" : command + prefix + "SLOT_SHOULDERS = true";
        }
        if (this.criteria.slotChest) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_CHEST = true" : command + prefix + "SLOT_CHEST = true";
        }
        if (this.criteria.slotHands) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_HANDS = true" : command + prefix + "SLOT_HANDS = true";
        }
        if (this.criteria.slotLegs) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_LEGS = true" : command + prefix + "SLOT_LEGS = true";
        }
        if (this.criteria.slotFeet) {
            if (firstSlot) {
                firstSlot = false;
                command = command + " AND ( ";
            } else {
                command = command + " OR ";
            }
            command = prefix == null ? command + "SLOT_FEET = true" : command + prefix + "SLOT_FEET = true";
        }
        if (!firstSlot) {
            command = command + " )";
        }
        return command;
    }

    @Override
    public void setItemClass(String itemClass) {
        this.itemClass = itemClass;
        if (itemClass != null && itemClass.isEmpty()) {
            this.itemClass = null;
        }
        this.init();
    }

    @Override
    public void setArmorClass(String armorClass) {
        this.armorClass = armorClass;
        if (armorClass != null && armorClass.isEmpty()) {
            this.armorClass = null;
        }
    }

    @Override
    public void setArtifactClass(String artifactClass) {
        this.artifactClass = artifactClass;
        if (artifactClass != null && artifactClass.isEmpty()) {
            this.artifactClass = null;
        }
    }

    @Override
    public void setItemRarity(String itemRarity) {
        this.itemRarity = itemRarity;
        if (itemRarity != null && itemRarity.isEmpty()) {
            this.itemRarity = null;
        }
    }

    @Override
    public void setItemName(String itemName) {
        this.itemName = itemName;
        if (itemName != null && itemName.isEmpty()) {
            this.itemName = null;
        }
    }

    public void setBonusSkill(String bonusSkill) {
        this.bonusSkill = bonusSkill;
        if (bonusSkill != null && bonusSkill.isEmpty()) {
            this.bonusSkill = null;
        }
    }

    public void setItemSkill(String itemSkill) {
        this.itemSkill = itemSkill;
        if (itemSkill != null && itemSkill.isEmpty()) {
            this.itemSkill = null;
        }
    }

    public void setPrefixID(String prefixID) {
        this.prefixID = prefixID;
        if (prefixID != null && prefixID.isEmpty()) {
            this.prefixID = null;
        }
    }

    public void setSuffixID(String suffixID) {
        this.suffixID = suffixID;
        if (suffixID != null && suffixID.isEmpty()) {
            this.suffixID = null;
        }
    }

    @Override
    public SelectionCriteria getCriteria() {
        return this.criteria;
    }

    @Override
    public String determineLevel1Statement(boolean isHardcore, String charName) {
        boolean statFilled;
        String command = "SELECT I.ITEM_ID FROM GD_ITEM I";
        boolean bl = statFilled = !this.getCriteria().statInfos.isEmpty();
        if (this.getCriteria().isSkillBonusUsed()) {
            command = command + ", " + "GD_ITEM_SKILLS" + " ISK";
        }
        if (statFilled) {
            command = command + ", " + "GD_ITEM_STAT" + " IST";
        }
        command = command + " WHERE ";
        if (this.getCriteria().isSkillBonusUsed()) {
            command = command + "I.ITEM_ID = ISK.ITEM_ID AND ";
        }
        if (statFilled) {
            command = command + "I.ITEM_ID = IST.ITEM_ID AND ";
        }
        command = command + "I.ITEM_CLASS = ?";
        if (this.usesItemRarity()) {
            command = command + " AND I.RARITY = ?";
        }
        if (this.usesArmorClass()) {
            command = command + " AND I.ARMOR_CLASS = ?";
        }
        if (this.usesArtifactClass()) {
            command = command + " AND I.ARTIFACT_CLASS = ?";
        }
        if (this.usesItemName()) {
            command = command + " AND UPPER(I.NAME_FULL) LIKE ?";
        }
        if (this.usesBonusSkill()) {
            command = command + " AND ISK.BONUS_ENTITY = ? AND ISK.BONUS_VALUE > 0";
        }
        if (this.usesAllSkills()) {
            command = command + " AND I.PLUS_ALLSKILLS > 0";
        }
        if (this.usesItemSkill()) {
            command = command + " AND I.ITEM_SKILL_ID = ?";
        }
        if (this.getMinLevel() != -1) {
            command = command + " AND I.REQ_LEVEL >= ?";
        }
        if (this.getMaxLevel() != -1) {
            command = command + " AND I.REQ_LEVEL <= ?";
        }
        if (this.getMaxCunning() != -1) {
            command = command + " AND I.REQ_DEX <= ?";
        }
        if (this.getMaxPhysique() != -1) {
            command = command + " AND I.REQ_STR <= ?";
        }
        if (this.getMaxSpirit() != -1) {
            command = command + " AND I.REQ_INT <= ?";
        }
        if (this.usesPetBonus()) {
            command = command + " AND I.PET_BONUS_SKILL_ID IS NOT NULL";
        }
        if (this.usesConversion()) {
            command = command + " AND I.CONVERT_OUT = ?";
        }
        if (this.isNoEnemyOnly()) {
            command = command + " AND I.ENEMY_ONLY = ?";
        }
        command = command + this.determineSlotConditions("I.");
        return command;
    }

    @Override
    public List<CriteriaCombination> createLevel1Combinations(CriteriaCombination cc) {
        CriteriaCombination combo = cc.clone();
        LinkedList<CriteriaCombination> list = new LinkedList<CriteriaCombination>();
        Iterator<String> iterIC = this.getCriteria().itemClass.iterator();
        while (iterIC.hasNext()) {
            Iterator<String> iterAC;
            combo.setItemClass(iterIC.next());
            boolean found = false;
            if (combo.usesItemRarity()) {
                Iterator<String> iterIR = this.getItemRarities().iterator();
                while (iterIR.hasNext()) {
                    combo.setItemRarity(iterIR.next());
                    if (combo.usesArmorClass()) {
                        Iterator<String> iterAC2 = this.getArmorClasses().iterator();
                        while (iterAC2.hasNext()) {
                            combo.setArmorClass(iterAC2.next());
                            list.add(combo.clone());
                        }
                        found = true;
                    }
                    if (found) continue;
                    list.add(combo.clone());
                }
                continue;
            }
            if (combo.usesArmorClass()) {
                iterAC = this.getArmorClasses().iterator();
                while (iterAC.hasNext()) {
                    combo.setArmorClass(iterAC.next());
                    list.add(combo.clone());
                }
                found = true;
            }
            if (combo.usesArtifactClass()) {
                iterAC = this.getArtifactClasses().iterator();
                while (iterAC.hasNext()) {
                    combo.setArtifactClass(iterAC.next());
                    list.add(combo.clone());
                }
                found = true;
            }
            if (found) continue;
            list.add(combo.clone());
        }
        return list;
    }

    @Override
    public int fillLevel1Statement(PreparedStatement ps) throws SQLException {
        ps.clearParameters();
        int nextPos = 1;
        ps.setString(nextPos, this.getItemClass());
        ++nextPos;
        if (this.usesItemRarity()) {
            ps.setString(nextPos, this.getItemRarity());
            ++nextPos;
        }
        if (this.usesArmorClass()) {
            ps.setString(nextPos, this.getArmorClass());
            ++nextPos;
        }
        if (this.usesArtifactClass()) {
            ps.setString(nextPos, this.getArtifactClass());
            ++nextPos;
        }
        if (this.usesItemName()) {
            ps.setString(nextPos, this.getItemName().toUpperCase(GDMsgFormatter.locale));
            ++nextPos;
        }
        if (this.usesBonusSkill()) {
            ps.setString(nextPos, this.getBonusSkillID());
            ++nextPos;
        }
        if (this.usesItemSkill()) {
            ps.setString(nextPos, this.getItemSkillID());
            ++nextPos;
        }
        if (this.getMinLevel() != -1) {
            ps.setInt(nextPos, this.getMinLevel());
            ++nextPos;
        }
        if (this.getMaxLevel() != -1) {
            ps.setInt(nextPos, this.getMaxLevel());
            ++nextPos;
        }
        if (this.getMaxCunning() != -1) {
            ps.setInt(nextPos, this.getMaxCunning());
            ++nextPos;
        }
        if (this.getMaxPhysique() != -1) {
            ps.setInt(nextPos, this.getMaxPhysique());
            ++nextPos;
        }
        if (this.getMaxSpirit() != -1) {
            ps.setInt(nextPos, this.getMaxSpirit());
            ++nextPos;
        }
        if (this.usesConversion()) {
            ps.setString(nextPos, this.getDamageConvertedTo());
            ++nextPos;
        }
        if (this.isNoEnemyOnly()) {
            ps.setBoolean(nextPos, false);
            ++nextPos;
        }
        return nextPos;
    }

    @Override
    public String determineLevel1Parameters() {
        String param = this.getItemClass();
        if (this.usesItemRarity()) {
            param = param + ", " + this.getItemRarity();
        }
        if (this.usesArmorClass()) {
            param = param + ", " + this.getArmorClass();
        }
        if (this.usesArtifactClass()) {
            param = param + ", " + this.getArtifactClass();
        }
        if (this.usesItemName()) {
            param = param + ", " + this.getItemName();
        }
        if (this.usesBonusSkill()) {
            param = param + ", " + this.getBonusSkillID();
        }
        if (this.usesItemSkill()) {
            param = param + ", " + this.getItemSkillID();
        }
        if (this.getMinLevel() != -1) {
            param = param + ", " + Integer.toString(this.getMinLevel());
        }
        if (this.getMaxLevel() != -1) {
            param = param + ", " + Integer.toString(this.getMaxLevel());
        }
        if (this.getMaxCunning() != -1) {
            param = param + ", " + Integer.toString(this.getMaxCunning());
        }
        if (this.getMaxPhysique() != -1) {
            param = param + ", " + Integer.toString(this.getMaxPhysique());
        }
        if (this.getMaxSpirit() != -1) {
            param = param + ", " + Integer.toString(this.getMaxSpirit());
        }
        if (this.isNoEnemyOnly()) {
            param = param + "false";
        }
        return param;
    }

    @Override
    public String determineLevel2Statement(String level1command, SelectionCriteria.StatInfo info) {
        String level2command = level1command;
        if (info != null) {
            level2command = level2command + " AND (IST.STAT_TYPE = ?";
            if (info.flat == info.percentage) {
                level2command = info.maxResist ? (info.flat ? level2command + " AND ((IST.STAT_MIN > 0) OR (IST.MODIFIER > 0) OR (IST.MAX_RESIST > 0))" : level2command + " AND (IST.MAX_RESIST > 0)") : level2command + " AND ((IST.STAT_MIN > 0) OR (IST.MODIFIER > 0))";
            } else {
                if (info.flat) {
                    level2command = level2command + " AND ((IST.STAT_MIN > 0)";
                }
                if (info.percentage) {
                    level2command = level2command + " AND ((IST.MODIFIER > 0)";
                }
                level2command = info.maxResist ? level2command + " OR (IST.MAX_RESIST > 0))" : level2command + ")";
            }
            level2command = level2command + ")";
        }
        return level2command;
    }

    @Override
    public int fillLevel2Statement(PreparedStatement ps, SelectionCriteria.StatInfo info, int nextPos) throws SQLException {
        if (info != null) {
            ps.setString(nextPos, info.statType);
            ++nextPos;
        }
        return nextPos;
    }

    @Override
    public void addSingleIntCombo(List<Integer> listAll, PreparedStatement ps, String command, SelectionCriteria.StatInfo info) throws SQLException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addSingleStringCombo(List<String> listAll, PreparedStatement ps, String command, SelectionCriteria.StatInfo info) throws SQLException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static void mergeIntList(List<Integer> listAll, List<Integer> list) {
        for (Integer i : list) {
            if (listAll.contains(i)) continue;
            listAll.add(i);
        }
    }

    public static void mergeStringList(List<String> listAll, List<String> list) {
        for (String s : list) {
            if (listAll.contains(s)) continue;
            listAll.add(s);
        }
    }
}

