/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db.criteria;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.GDDBData;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.db.criteria.AbstractItemCombination;
import org.gdstash.db.criteria.CriteriaCombination;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class ItemIDItemCombination
extends AbstractItemCombination {
    public ItemIDItemCombination() {
    }

    public ItemIDItemCombination(ItemIDItemCombination combo) {
        super(combo);
    }

    public ItemIDItemCombination(SelectionCriteria criteria) {
        super(criteria);
    }

    @Override
    public ItemIDItemCombination clone() {
        ItemIDItemCombination combo = new ItemIDItemCombination(this);
        return combo;
    }

    @Override
    public String determineLevel1Statement(boolean isHardcore, String charName) {
        boolean statFilled;
        String command = "SELECT I.ITEM_ID FROM GD_ITEM I";
        boolean bl = statFilled = !this.getCriteria().statInfos.isEmpty();
        if (this.getCriteria().isSkillBonusUsed()) {
            command = command + ", " + "GD_ITEM_SKILLS" + " ISK";
        }
        if (statFilled) {
            command = command + ", " + "GD_ITEM_STAT" + " IST";
        }
        command = command + " WHERE ";
        if (this.getCriteria().isSkillBonusUsed()) {
            command = command + "I.ITEM_ID = ISK.ITEM_ID AND ";
        }
        if (statFilled) {
            command = command + "I.ITEM_ID = IST.ITEM_ID AND ";
        }
        command = command + "I.ITEM_CLASS = ?";
        if (this.usesItemRarity()) {
            command = command + " AND I.RARITY = ?";
        }
        if (this.usesArmorClass()) {
            command = command + " AND I.ARMOR_CLASS = ?";
        }
        if (this.usesArtifactClass()) {
            command = command + " AND I.ARTIFACT_CLASS = ?";
        }
        if (this.usesItemName()) {
            command = command + " AND UPPER(I.NAME_FULL) LIKE ?";
        }
        if (this.usesBonusSkill()) {
            command = command + " AND ISK.BONUS_ENTITY = ? AND ISK.BONUS_VALUE > 0";
        }
        if (this.usesAllSkills()) {
            command = command + " AND I.PLUS_ALLSKILLS > 0";
        }
        if (this.usesItemSkill()) {
            command = command + " AND I.ITEM_SKILL_ID = ?";
        }
        if (this.getMinLevel() != -1) {
            command = command + " AND I.REQ_LEVEL >= ?";
        }
        if (this.getMaxLevel() != -1) {
            command = command + " AND I.REQ_LEVEL <= ?";
        }
        if (this.getMaxCunning() != -1) {
            command = command + " AND I.REQ_DEX <= ?";
        }
        if (this.getMaxPhysique() != -1) {
            command = command + " AND I.REQ_STR <= ?";
        }
        if (this.getMaxSpirit() != -1) {
            command = command + " AND I.REQ_INT <= ?";
        }
        if (this.usesPetBonus()) {
            command = command + " AND I.PET_BONUS_SKILL_ID IS NOT NULL";
        }
        if (this.usesConversion()) {
            command = command + " AND I.CONVERT_OUT = ?";
        }
        if (this.isNoEnemyOnly()) {
            command = command + " AND I.ENEMY_ONLY = ?";
        }
        command = command + this.determineSlotConditions("I.");
        return command;
    }

    @Override
    public void addSingleStringCombo(List<String> listAll, PreparedStatement ps, String command, SelectionCriteria.StatInfo info) throws SQLException, UnsupportedOperationException {
        int nextPos = this.fillLevel1Statement(ps);
        if (info != null) {
            nextPos = this.fillLevel2Statement(ps, info, nextPos);
        }
        try (ResultSet rs = ps.executeQuery();){
            List<String> ids = AbstractItemCombination.wrapString(rs, 1);
            if (ids != null) {
                AbstractItemCombination.mergeStringList(listAll, ids);
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{command, this.determineLevel1Parameters()};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_SELECT_FAILED", args);
            GDMsgLogger.addError(msg);
            throw ex;
        }
    }

    public static List<String> getItemIDs(SelectionCriteria criteria, boolean isHardcore, String charName) {
        ItemIDItemCombination combo = new ItemIDItemCombination(criteria);
        return ItemIDItemCombination.getItemIDs(combo, isHardcore, charName);
    }

    public static List<String> getItemIDs(ItemIDItemCombination combo, boolean isHardcore, String charName) {
        LinkedList<String> listAll = new LinkedList<String>();
        try (Connection conn = GDDBData.getConnection();){
            List<CriteriaCombination> combos = combo.createLevel1Combinations(combo);
            for (CriteriaCombination cc : combos) {
                String command1 = cc.determineLevel1Statement(isHardcore, charName);
                if (cc.getCriteria().statInfos.isEmpty()) {
                    try (PreparedStatement ps = conn.prepareStatement(command1);){
                        cc.addSingleStringCombo(listAll, ps, command1, null);
                    }
                    catch (SQLException ex) {
                        Object[] args = new Object[]{command1};
                        String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_PREPARE_FAILED", args);
                        GDMsgLogger.addError(msg);
                    }
                    conn.commit();
                    continue;
                }
                for (SelectionCriteria.StatInfo info : cc.getCriteria().statInfos) {
                    String command2 = cc.determineLevel2Statement(command1, info);
                    try (PreparedStatement ps = conn.prepareStatement(command2);){
                        cc.addSingleStringCombo(listAll, ps, command2, info);
                    }
                    catch (SQLException ex) {
                        Object[] args = new Object[]{command2};
                        String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_PREPARE_FAILED", args);
                        GDMsgLogger.addError(msg);
                    }
                    conn.commit();
                }
            }
        }
        catch (SQLException ex) {
            GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_DB_CONN_FAILED"));
        }
        return listAll;
    }
}

