/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db.criteria;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.GDDBData;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.db.criteria.AbstractItemCombination;
import org.gdstash.db.criteria.CriteriaCombination;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class StashIDItemCombination
extends AbstractItemCombination {
    public StashIDItemCombination() {
    }

    public StashIDItemCombination(StashIDItemCombination combo) {
        super(combo);
    }

    public StashIDItemCombination(SelectionCriteria criteria) {
        super(criteria);
    }

    @Override
    public StashIDItemCombination clone() {
        StashIDItemCombination combo = new StashIDItemCombination(this);
        return combo;
    }

    @Override
    public String determineLevel1Statement(boolean isHardcore, String charName) {
        boolean statFilled;
        String command = "SELECT S.STASH_ID FROM STASH_ITEM_V7 S";
        boolean bl = statFilled = !this.getCriteria().statInfos.isEmpty();
        if (this.getCriteria().isSkillBonusUsed()) {
            command = command + ", " + "GD_ITEM_SKILLS" + " ISK";
        }
        if (statFilled) {
            command = command + ", " + "GD_ITEM_STAT" + " IST";
        }
        command = command + " WHERE ";
        if (this.getCriteria().isSkillBonusUsed()) {
            command = command + "S.ITEM_ID = ISK.ITEM_ID AND ";
        }
        if (statFilled) {
            command = command + "S.ITEM_ID = IST.ITEM_ID AND ";
        }
        command = command + "S.ITEM_CLASS = ?";
        if (!GDStashFrame.iniConfig.sectRestrict.transferSCHC) {
            command = isHardcore ? command + " AND S.HARDCORE = true" : command + " AND S.HARDCORE = false";
        }
        if (!GDStashFrame.iniConfig.sectRestrict.transferSoulbound && charName != null) {
            command = command + " AND ( S.CHARNAME = '" + charName + "' OR S.CHARNAME = '' )";
        }
        if (this.usesItemRarity()) {
            command = command + " AND S.RARITY = ?";
        }
        if (this.usesArmorClass()) {
            command = command + " AND S.ARMOR_CLASS = ?";
        }
        if (this.usesArtifactClass()) {
            command = command + " AND S.ARTIFACT_CLASS = ?";
        }
        if (this.usesItemName()) {
            command = command + " AND S.NAME LIKE ?";
        }
        if (this.usesBonusSkill()) {
            command = command + " AND ISK.BONUS_ENTITY = ? AND ISK.BONUS_VALUE > 0";
        }
        if (this.usesAllSkills()) {
            command = command + " AND S.PLUS_ALLSKILLS > 0";
        }
        if (this.usesItemSkill()) {
            command = command + " AND S.ITEM_SKILL_ID = ?";
        }
        if (this.usesPrefix()) {
            command = command + " AND S.PREFIX_ID = ?";
        }
        if (this.usesSuffix()) {
            command = command + " AND S.SUFFIX_ID = ?";
        }
        if (this.getMinLevel() != -1) {
            command = command + " AND S.REQ_LEVEL >= ?";
        }
        if (this.getMaxLevel() != -1) {
            command = command + " AND S.REQ_LEVEL <= ?";
        }
        if (this.getMaxCunning() != -1) {
            command = command + " AND S.REQ_DEX <= ?";
        }
        if (this.getMaxPhysique() != -1) {
            command = command + " AND S.REQ_STR <= ?";
        }
        if (this.getMaxSpirit() != -1) {
            command = command + " AND S.REQ_INT <= ?";
        }
        if (this.usesPetBonus()) {
            command = command + " AND S.PET_BONUS_SKILL_ID IS NOT NULL";
        }
        if (this.usesConversion()) {
            command = command + " AND S.CONVERT_OUT = ?";
        }
        if (this.isNoEnemyOnly()) {
            command = command + " AND S.ENEMY_ONLY = ?";
        }
        command = command + this.determineSlotConditions("S.");
        return command;
    }

    @Override
    public int fillLevel1Statement(PreparedStatement ps) throws SQLException {
        ps.clearParameters();
        int nextPos = 1;
        ps.setString(nextPos, this.getItemClass());
        ++nextPos;
        if (this.usesItemRarity()) {
            ps.setString(nextPos, this.getItemRarity());
            ++nextPos;
        }
        if (this.usesArmorClass()) {
            ps.setString(nextPos, this.getArmorClass());
            ++nextPos;
        }
        if (this.usesArtifactClass()) {
            ps.setString(nextPos, this.getArtifactClass());
            ++nextPos;
        }
        if (this.usesItemName()) {
            ps.setString(nextPos, this.getItemName().toUpperCase(GDMsgFormatter.locale));
            ++nextPos;
        }
        if (this.usesBonusSkill()) {
            ps.setString(nextPos, this.getBonusSkillID());
            ++nextPos;
        }
        if (this.usesItemSkill()) {
            ps.setString(nextPos, this.getItemSkillID());
            ++nextPos;
        }
        if (this.usesPrefix()) {
            ps.setString(nextPos, this.getPrefixID());
            ++nextPos;
        }
        if (this.usesSuffix()) {
            ps.setString(nextPos, this.getSuffixID());
            ++nextPos;
        }
        if (this.getMinLevel() != -1) {
            ps.setInt(nextPos, this.getMinLevel());
            ++nextPos;
        }
        if (this.getMaxLevel() != -1) {
            ps.setInt(nextPos, this.getMaxLevel());
            ++nextPos;
        }
        if (this.getMaxCunning() != -1) {
            ps.setInt(nextPos, this.getMaxCunning());
            ++nextPos;
        }
        if (this.getMaxPhysique() != -1) {
            ps.setInt(nextPos, this.getMaxPhysique());
            ++nextPos;
        }
        if (this.getMaxSpirit() != -1) {
            ps.setInt(nextPos, this.getMaxSpirit());
            ++nextPos;
        }
        if (this.usesConversion()) {
            ps.setString(nextPos, this.getDamageConvertedTo());
            ++nextPos;
        }
        if (this.isNoEnemyOnly()) {
            ps.setBoolean(nextPos, false);
            ++nextPos;
        }
        return nextPos;
    }

    @Override
    public void addSingleIntCombo(List<Integer> listAll, PreparedStatement ps, String command, SelectionCriteria.StatInfo info) throws SQLException, UnsupportedOperationException {
        int nextPos = this.fillLevel1Statement(ps);
        if (info != null) {
            nextPos = this.fillLevel2Statement(ps, info, nextPos);
        }
        try (ResultSet rs = ps.executeQuery();){
            List<Integer> ids = AbstractItemCombination.wrapInteger(rs, 1);
            if (ids != null) {
                AbstractItemCombination.mergeIntList(listAll, ids);
            }
        }
        catch (SQLException ex) {
            Object[] args = new Object[]{command, this.determineLevel1Parameters()};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_SELECT_FAILED", args);
            GDMsgLogger.addError(msg);
            throw ex;
        }
    }

    public static List<Integer> getStashIDs(SelectionCriteria criteria, boolean isHardcore, String charName) {
        StashIDItemCombination combo = new StashIDItemCombination(criteria);
        return StashIDItemCombination.getStashIDs(combo, isHardcore, charName);
    }

    public static List<Integer> getStashIDs(StashIDItemCombination combo, boolean isHardcore, String charName) {
        LinkedList<Integer> listAll = new LinkedList<Integer>();
        try (Connection conn = GDDBData.getConnection();){
            List<CriteriaCombination> combos = combo.createLevel1Combinations(combo);
            for (CriteriaCombination cc : combos) {
                String command1 = cc.determineLevel1Statement(isHardcore, charName);
                if (cc.getCriteria().statInfos.isEmpty()) {
                    try (PreparedStatement ps = conn.prepareStatement(command1);){
                        cc.addSingleIntCombo(listAll, ps, command1, null);
                    }
                    catch (SQLException ex) {
                        Object[] args = new Object[]{command1};
                        String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_PREPARE_FAILED", args);
                        GDMsgLogger.addError(msg);
                    }
                    conn.commit();
                    continue;
                }
                for (SelectionCriteria.StatInfo info : cc.getCriteria().statInfos) {
                    String command2 = cc.determineLevel2Statement(command1, info);
                    try (PreparedStatement ps = conn.prepareStatement(command2);){
                        cc.addSingleIntCombo(listAll, ps, command2, info);
                    }
                    catch (SQLException ex) {
                        Object[] args = new Object[]{command2};
                        String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_PREPARE_FAILED", args);
                        GDMsgLogger.addError(msg);
                    }
                    conn.commit();
                }
            }
        }
        catch (SQLException ex) {
            GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_DB_CONN_FAILED"));
        }
        return listAll;
    }
}

