/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db.criteria;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.db.criteria.StashIDItemCombination;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDMsgFormatter;

public class StashIDPrefixCombination
extends StashIDItemCombination {
    public StashIDPrefixCombination() {
    }

    public StashIDPrefixCombination(StashIDPrefixCombination combo) {
        super(combo);
    }

    public StashIDPrefixCombination(SelectionCriteria criteria) {
        super(criteria);
    }

    @Override
    public StashIDPrefixCombination clone() {
        StashIDPrefixCombination combo = new StashIDPrefixCombination(this);
        return combo;
    }

    @Override
    public String determineLevel1Statement(boolean isHardcore, String charName) {
        boolean statFilled;
        String command = "SELECT S.STASH_ID FROM STASH_ITEM_V7 S, GD_AFFIX A";
        boolean bl = statFilled = !this.getCriteria().statInfos.isEmpty();
        if (this.getCriteria().isSkillBonusUsed()) {
            command = command + ", " + "GD_AFFIX_SKILLS" + " ASK";
        }
        if (statFilled) {
            command = command + ", " + "GD_AFFIX_STAT" + " AST";
        }
        command = command + " WHERE ";
        if (this.getCriteria().isSkillBonusUsed()) {
            command = command + "A.AFFIX_ID = ASK.AFFIX_ID AND ";
        }
        if (statFilled) {
            command = command + "A.AFFIX_ID = AST.AFFIX_ID AND ";
        }
        command = command + "S.PREFIX_ID = A.AFFIX_ID AND A.TYPE = 1 AND S.ITEM_CLASS = ?";
        if (!GDStashFrame.iniConfig.sectRestrict.transferSCHC) {
            command = isHardcore ? command + " AND S.HARDCORE = true" : command + " AND S.HARDCORE = false";
        }
        if (!GDStashFrame.iniConfig.sectRestrict.transferSoulbound && charName != null && !charName.isEmpty()) {
            command = command + " AND ( S.CHARNAME = '" + charName + "' OR S.CHARNAME = '' )";
        }
        if (this.usesItemRarity()) {
            command = command + " AND S.RARITY = ?";
        }
        if (this.usesArmorClass()) {
            command = command + " AND S.ARMOR_CLASS = ?";
        }
        if (this.usesArtifactClass()) {
            command = command + " AND S.ARTIFACT_CLASS = ?";
        }
        if (this.usesItemName()) {
            command = command + " AND S.NAME LIKE ?";
        }
        if (this.usesBonusSkill()) {
            command = command + " AND ASK.BONUS_ENTITY = ? AND ASK.BONUS_VALUE > 0";
        }
        if (this.usesAllSkills()) {
            command = command + " AND S.PLUS_ALLSKILLS > 0";
        }
        if (this.usesItemSkill()) {
            command = command + " AND A.ITEM_SKILL_ID = ?";
        }
        if (this.getMinLevel() != -1) {
            command = command + " AND S.REQ_LEVEL >= ?";
        }
        if (this.getMaxLevel() != -1) {
            command = command + " AND S.REQ_LEVEL <= ?";
        }
        if (this.getMaxCunning() != -1) {
            command = command + " AND S.REQ_DEX <= ?";
        }
        if (this.getMaxPhysique() != -1) {
            command = command + " AND S.REQ_STR <= ?";
        }
        if (this.getMaxSpirit() != -1) {
            command = command + " AND S.REQ_INT <= ?";
        }
        if (this.usesPetBonus()) {
            command = command + " AND A.PET_AFFIX_ID IS NOT NULL";
        }
        if (this.usesConversion()) {
            command = command + " AND A.CONVERT_OUT = ?";
        }
        if (this.isNoEnemyOnly()) {
            command = command + " AND S.ENEMY_ONLY = ?";
        }
        command = command + this.determineSlotConditions("S.");
        return command;
    }

    @Override
    public int fillLevel1Statement(PreparedStatement ps) throws SQLException {
        ps.clearParameters();
        int nextPos = 1;
        ps.setString(nextPos, this.getItemClass());
        ++nextPos;
        if (this.usesItemRarity()) {
            ps.setString(nextPos, this.getItemRarity());
            ++nextPos;
        }
        if (this.usesArmorClass()) {
            ps.setString(nextPos, this.getArmorClass());
            ++nextPos;
        }
        if (this.usesArtifactClass()) {
            ps.setString(nextPos, this.getArtifactClass());
            ++nextPos;
        }
        if (this.usesItemName()) {
            ps.setString(nextPos, this.getItemName().toUpperCase(GDMsgFormatter.locale));
            ++nextPos;
        }
        if (this.usesBonusSkill()) {
            ps.setString(nextPos, this.getBonusSkillID());
            ++nextPos;
        }
        if (this.usesItemSkill()) {
            ps.setString(nextPos, this.getItemSkillID());
            ++nextPos;
        }
        if (this.getMinLevel() != -1) {
            ps.setInt(nextPos, this.getMinLevel());
            ++nextPos;
        }
        if (this.getMaxLevel() != -1) {
            ps.setInt(nextPos, this.getMaxLevel());
            ++nextPos;
        }
        if (this.getMaxCunning() != -1) {
            ps.setInt(nextPos, this.getMaxCunning());
            ++nextPos;
        }
        if (this.getMaxPhysique() != -1) {
            ps.setInt(nextPos, this.getMaxPhysique());
            ++nextPos;
        }
        if (this.getMaxSpirit() != -1) {
            ps.setInt(nextPos, this.getMaxSpirit());
            ++nextPos;
        }
        if (this.usesConversion()) {
            ps.setString(nextPos, this.getDamageConvertedTo());
            ++nextPos;
        }
        if (this.isNoEnemyOnly()) {
            ps.setBoolean(nextPos, false);
            ++nextPos;
        }
        return nextPos;
    }

    @Override
    public String determineLevel2Statement(String level1command, SelectionCriteria.StatInfo info) {
        String level2command = level1command;
        if (info != null) {
            level2command = level2command + " AND (AST.STAT_TYPE = ?";
            if (info.flat == info.percentage) {
                level2command = info.maxResist ? (info.flat ? level2command + " AND ((AST.STAT_MIN > 0) OR (AST.MODIFIER > 0) OR (AST.MAX_RESIST > 0))" : level2command + " AND (AST.MAX_RESIST > 0)") : level2command + " AND ((AST.STAT_MIN > 0) OR (AST.MODIFIER > 0))";
            } else {
                if (info.flat) {
                    level2command = level2command + " AND ((AST.STAT_MIN > 0)";
                }
                if (info.percentage) {
                    level2command = level2command + " AND ((AST.MODIFIER > 0)";
                }
                level2command = info.maxResist ? level2command + " OR (AST.MAX_RESIST > 0))" : level2command + ")";
            }
            level2command = level2command + ")";
        }
        return level2command;
    }

    public static List<Integer> getStashIDs(SelectionCriteria criteria, boolean isHardcore, String charName) {
        StashIDPrefixCombination combo = new StashIDPrefixCombination(criteria);
        return StashIDItemCombination.getStashIDs(combo, isHardcore, charName);
    }
}

