/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.db.criteria;

import java.util.List;
import org.gdstash.db.SelectionCriteria;
import org.gdstash.db.criteria.StashIDItemCombination;
import org.gdstash.db.criteria.StashIDPrefixCombination;
import org.gdstash.ui.GDStashFrame;

public class StashIDSuffixCombination
extends StashIDPrefixCombination {
    public StashIDSuffixCombination() {
    }

    public StashIDSuffixCombination(StashIDSuffixCombination combo) {
        super(combo);
    }

    public StashIDSuffixCombination(SelectionCriteria criteria) {
        super(criteria);
    }

    @Override
    public StashIDSuffixCombination clone() {
        StashIDSuffixCombination combo = new StashIDSuffixCombination(this);
        return combo;
    }

    @Override
    public String determineLevel1Statement(boolean isHardcore, String charName) {
        boolean statFilled;
        String command = "SELECT S.STASH_ID FROM STASH_ITEM_V7 S, GD_AFFIX A";
        boolean bl = statFilled = !this.getCriteria().statInfos.isEmpty();
        if (this.getCriteria().isSkillBonusUsed()) {
            command = command + ", " + "GD_AFFIX_SKILLS" + " ASK";
        }
        if (statFilled) {
            command = command + ", " + "GD_AFFIX_STAT" + " AST";
        }
        command = command + " WHERE ";
        if (this.getCriteria().isSkillBonusUsed()) {
            command = command + "A.AFFIX_ID = ASK.AFFIX_ID AND ";
        }
        if (statFilled) {
            command = command + "A.AFFIX_ID = AST.AFFIX_ID AND ";
        }
        command = command + "S.SUFFIX_ID = A.AFFIX_ID AND A.TYPE = 2 AND S.ITEM_CLASS = ?";
        if (!GDStashFrame.iniConfig.sectRestrict.transferSCHC) {
            command = isHardcore ? command + " AND S.HARDCORE = true" : command + " AND S.HARDCORE = false";
        }
        if (!GDStashFrame.iniConfig.sectRestrict.transferSoulbound && charName != null && !charName.isEmpty()) {
            command = command + " AND ( S.CHARNAME = '" + charName + "' OR S.CHARNAME = '' )";
        }
        if (this.usesItemRarity()) {
            command = command + " AND S.RARITY = ?";
        }
        if (this.usesArmorClass()) {
            command = command + " AND S.ARMOR_CLASS = ?";
        }
        if (this.usesArtifactClass()) {
            command = command + " AND S.ARTIFACT_CLASS = ?";
        }
        if (this.usesItemName()) {
            command = command + " AND S.NAME LIKE ?";
        }
        if (this.usesBonusSkill()) {
            command = command + " AND ASK.BONUS_ENTITY = ? AND ASK.BONUS_VALUE > 0";
        }
        if (this.usesAllSkills()) {
            command = command + " AND S.PLUS_ALLSKILLS > 0";
        }
        if (this.usesItemSkill()) {
            command = command + " AND A.ITEM_SKILL_ID = ?";
        }
        if (this.getMinLevel() != -1) {
            command = command + " AND S.REQ_LEVEL >= ?";
        }
        if (this.getMaxLevel() != -1) {
            command = command + " AND S.REQ_LEVEL <= ?";
        }
        if (this.getMaxCunning() != -1) {
            command = command + " AND S.REQ_DEX <= ?";
        }
        if (this.getMaxPhysique() != -1) {
            command = command + " AND S.REQ_STR <= ?";
        }
        if (this.getMaxSpirit() != -1) {
            command = command + " AND S.REQ_INT <= ?";
        }
        if (this.usesPetBonus()) {
            command = command + " AND A.PET_AFFIX_ID IS NOT NULL";
        }
        if (this.usesConversion()) {
            command = command + " AND A.CONVERT_OUT = ?";
        }
        if (this.isNoEnemyOnly()) {
            command = command + " AND S.ENEMY_ONLY = ?";
        }
        command = command + this.determineSlotConditions("S.");
        return command;
    }

    public static List<Integer> getStashIDs(SelectionCriteria criteria, boolean isHardcore, String charName) {
        StashIDSuffixCombination combo = new StashIDSuffixCombination(criteria);
        return StashIDItemCombination.getStashIDs(combo, isHardcore, charName);
    }
}

