/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.description;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.DBSkill;
import org.gdstash.db.DBSkillBonus;
import org.gdstash.db.DBStashItem;
import org.gdstash.db.DBStat;
import org.gdstash.db.DBStatBonusRace;
import org.gdstash.description.BonusInfo;
import org.gdstash.description.TagInfo;
import org.gdstash.description.TagInfoHashMap;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class BonusDetail {
    public static final int TYPE_STAT = 1;
    public static final int TYPE_SKILLBONUS = 2;
    public static final int TYPE_SKILL = 3;
    public Object entity;
    public int type;
    public List<BonusInfo> infos;

    public BonusDetail(DBStashItem item, int detailType, DBStat stat, String prefix) {
        this.entity = stat;
        this.type = 1;
        this.infos = BonusDetail.createStatInfos(item, detailType, stat, prefix);
    }

    public BonusDetail(DBSkillBonus skillBonus) {
        this.entity = skillBonus;
        this.type = 2;
        this.infos = new LinkedList<BonusInfo>();
        this.createSkillBonusInfos();
    }

    public BonusDetail(DBSkill skill) {
        this.entity = skill;
        this.type = 3;
        this.infos = new LinkedList<BonusInfo>();
        this.createSkillInfos();
    }

    private void add(BonusInfo info) {
        if (info == null) {
            return;
        }
        if (info.text != null) {
            this.infos.add(info);
        }
    }

    public static List<BonusInfo> createStatInfos(DBStashItem item, int detailType, DBStat stat, String prefix) {
        if (stat.getStatType() == null) {
            return null;
        }
        TagInfo info = TagInfoHashMap.getInfo(stat.getStatType());
        if (info == null) {
            return null;
        }
        if (info.getTag() != null) {
            return BonusDetail.parseStat(item, detailType, stat, prefix, info, false);
        }
        return null;
    }

    public static List<BonusInfo> createStatInfos(List<DBStat> stats, String prefix) {
        LinkedList<BonusInfo> infos = new LinkedList<BonusInfo>();
        if (stats == null) {
            return null;
        }
        for (DBStat stat : stats) {
            TagInfo info;
            if (stat.getStatType() == null || (info = TagInfoHashMap.getInfo(stat.getStatType())) == null || info.getTag() == null) continue;
            List<BonusInfo> temp = BonusDetail.parseStat(null, 1, stat, prefix, info, true);
            infos.addAll(temp);
        }
        return infos;
    }

    private static String buildText(String tag, List lArgs) {
        Object[] args = new Object[lArgs.size()];
        int i = 0;
        Iterator iter = lArgs.iterator();
        while (iter.hasNext()) {
            args[i] = iter.next();
            ++i;
        }
        String text = GDMsgFormatter.format(GDMsgFormatter.rbGD, tag, args);
        return text;
    }

    private static int adjustValue(DBStashItem item, int detailType, int value) {
        float f;
        int var1;
        int pieces;
        int result = value;
        if (item == null) {
            return result;
        }
        if (detailType == 1 && item.isComponent()) {
            pieces = item.getComponentPieces();
            var1 = item.getVar1();
            if (var1 == 0) {
                var1 = 1;
            }
            if (var1 < pieces) {
                f = result;
                result = (int)(f = (float)((double)(f * (float)var1 / (float)pieces) + 0.5));
                if (result < 1) {
                    result = 1;
                }
            }
        }
        if (detailType == 2 && item.getDBComponent() != null) {
            pieces = item.getComponentPieces();
            var1 = item.getVar1();
            if (var1 == 0) {
                var1 = 1;
            }
            if (var1 < pieces) {
                f = result;
                result = (int)(f = (float)((double)(f * (float)var1 / (float)pieces) + 0.5));
                if (result < 1) {
                    result = 1;
                }
            }
        }
        return result;
    }

    private static List<BonusInfo> fillRaceBonus(DBStashItem item, int detailType, DBStat stat, String prefix, TagInfo tagInfo, boolean blankStat) {
        LinkedList<BonusInfo> infos = new LinkedList<BonusInfo>();
        BonusInfo info = null;
        DBStatBonusRace br = stat.getBonusRace();
        if (br == null) {
            return infos;
        }
        Object[] args = new Object[]{stat.getStatMin(), br.getRaceName()};
        String statDesc = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_UNI_RACE_DAMAGE", args);
        info = new BonusInfo(tagInfo);
        info.prefix = prefix;
        info.dmgPerc = true;
        String tag = "TXT_UNI_RACE_DAMAGE";
        info.text = statDesc;
        infos.add(info);
        return infos;
    }

    private static List<BonusInfo> parseCharStat(DBStashItem item, int detailType, DBStat stat, String prefix, TagInfo tagInfo, boolean blankStat) {
        LinkedList<BonusInfo> infos = new LinkedList<BonusInfo>();
        String tag = null;
        LinkedList<Object> lArgs = null;
        BonusInfo info = null;
        String statDesc = GDMsgFormatter.getString(GDMsgFormatter.rbGD, tagInfo.getTag());
        if (prefix != null) {
            Object[] args = new Object[]{prefix, statDesc};
            statDesc = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_STAT_PREFIX", args);
        }
        if (statDesc.equals("")) {
            return infos;
        }
        if (stat.getStatMin() > 0) {
            lArgs = new LinkedList<Object>();
            if (blankStat) {
                lArgs.add("");
            } else {
                lArgs.add(statDesc);
            }
            lArgs.add(stat.getStatMin());
            info = new BonusInfo(tagInfo);
            info.prefix = prefix;
            info.dmgFlat = true;
            tag = "TXT_OFF_ABS";
            if (tagInfo.isMinAsPerc()) {
                tag = tag + "_PERC";
            }
            info.statDesc = statDesc;
            info.text = BonusDetail.buildText(tag, lArgs);
            infos.add(info);
        }
        if (stat.getStatModifier() > 0) {
            lArgs = new LinkedList();
            if (blankStat) {
                lArgs.add("");
            } else {
                lArgs.add(statDesc);
            }
            lArgs.add(BonusDetail.adjustValue(item, detailType, stat.getStatModifier()));
            info = new BonusInfo(tagInfo);
            info.prefix = prefix;
            info.dmgPerc = true;
            tag = "TXT_OFF_PERC";
            info.statDesc = statDesc;
            info.text = BonusDetail.buildText(tag, lArgs);
            infos.add(info);
        }
        return infos;
    }

    private static List<BonusInfo> parseDefense(DBStashItem item, int detailType, DBStat stat, String prefix, TagInfo tagInfo, boolean blankStat) {
        Object[] args;
        LinkedList<BonusInfo> infos = new LinkedList<BonusInfo>();
        String tag = null;
        LinkedList<Object> lArgs = null;
        BonusInfo info = null;
        String statDesc = GDMsgFormatter.getString(GDMsgFormatter.rbGD, tagInfo.getTag());
        if (prefix != null) {
            args = new Object[]{prefix, statDesc};
            statDesc = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_STAT_PREFIX", args);
        }
        if (stat.getStatMin() > 0) {
            lArgs = new LinkedList<Object>();
            if (blankStat) {
                lArgs.add("");
            } else {
                lArgs.add(statDesc);
            }
            lArgs.add(BonusDetail.adjustValue(item, detailType, stat.getStatMin()));
            info = new BonusInfo(tagInfo);
            info.prefix = prefix;
            info.dmgFlat = true;
            tag = "TXT_DEF_ABS";
            if (tagInfo.isMinAsPerc()) {
                tag = tag + "_PERC";
            }
            if (stat.getStatChance() > 0) {
                lArgs.add(stat.getStatChance());
                tag = tag + "_CHANCE";
                if (tagInfo.getTag().equals("DEF_BLOCK_CHANCE")) {
                    tag = "TXT_DEF_UNI_SHIELD_BLOCK";
                    lArgs.clear();
                    lArgs.add(stat.getStatMin());
                    lArgs.add(stat.getStatChance());
                }
                info.dmgChance = true;
            }
            info.statDesc = statDesc;
            info.text = BonusDetail.buildText(tag, lArgs);
            infos.add(info);
        }
        if (stat.getStatModifier() > 0) {
            lArgs = new LinkedList();
            if (blankStat) {
                lArgs.add("");
            } else {
                lArgs.add(statDesc);
            }
            lArgs.add(BonusDetail.adjustValue(item, detailType, stat.getStatModifier()));
            info = new BonusInfo(tagInfo);
            info.prefix = prefix;
            info.dmgPerc = true;
            tag = "TXT_DEF_PERC";
            info.statDesc = statDesc;
            info.text = BonusDetail.buildText(tag, lArgs);
            infos.add(info);
        }
        if (stat.getMinDuration() > 0) {
            statDesc = GDMsgFormatter.getString(GDMsgFormatter.rbGD, tagInfo.getTag() + "_DOT");
            if (prefix != null) {
                args = new Object[]{prefix, statDesc};
                statDesc = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_STAT_PREFIX", args);
            }
            lArgs = new LinkedList();
            if (blankStat) {
                lArgs.add("");
            } else {
                lArgs.add(statDesc);
            }
            lArgs.add(stat.getMinDuration());
            info = new BonusInfo(tagInfo);
            info.prefix = prefix;
            info.dmgPerc = true;
            tag = "TXT_DEF_DUR";
            info.statDesc = statDesc;
            info.text = BonusDetail.buildText(tag, lArgs);
            infos.add(info);
        }
        if (stat.getMaxResist() > 0) {
            lArgs = new LinkedList();
            if (blankStat) {
                lArgs.add("");
            } else {
                lArgs.add(statDesc);
            }
            lArgs.add(stat.getMaxResist());
            info = new BonusInfo(tagInfo);
            info.prefix = prefix;
            info.dmgPerc = true;
            info.dmgMaxResist = true;
            tag = "TXT_DEF_MAX";
            info.statDesc = statDesc;
            info.text = BonusDetail.buildText(tag, lArgs);
            infos.add(info);
        }
        return infos;
    }

    private static List<BonusInfo> parseOffense(DBStashItem item, int detailType, DBStat stat, String prefix, TagInfo tagInfo, boolean blankStat) {
        LinkedList<BonusInfo> infos = new LinkedList<BonusInfo>();
        String tag = null;
        LinkedList<Object> lArgs = null;
        BonusInfo info = new BonusInfo(tagInfo);
        String statDesc = GDMsgFormatter.getString(GDMsgFormatter.rbGD, tagInfo.getTag());
        if (prefix != null) {
            Object[] args = new Object[]{prefix, statDesc};
            statDesc = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_STAT_PREFIX", args);
        }
        if (statDesc.equals("")) {
            return infos;
        }
        if (stat.getStatMin() > 0) {
            lArgs = new LinkedList<Object>();
            if (blankStat) {
                lArgs.add("");
            } else {
                lArgs.add(statDesc);
            }
            if (stat.getMinDuration() == 0) {
                lArgs.add(BonusDetail.adjustValue(item, detailType, stat.getStatMin()));
            } else if (tagInfo.isMinAsPerc()) {
                lArgs.add(BonusDetail.adjustValue(item, detailType, stat.getStatMin()));
            } else {
                lArgs.add(BonusDetail.adjustValue(item, detailType, stat.getStatMin() * stat.getMinDuration()));
                lArgs.add(BonusDetail.adjustValue(item, detailType, stat.getStatMin()));
            }
            info = new BonusInfo(tagInfo);
            info.prefix = prefix;
            info.dmgGlobal = stat.isGlobal();
            info.dmgXOR = stat.isXOR();
            info.dmgFlat = true;
            tag = "TXT_OFF_ABS";
            if (tagInfo.isMinAsPerc()) {
                tag = tag + "_PERC";
            }
            if (tagInfo.isMinAsDuration()) {
                tag = tag + "_TIME";
            }
            if (stat.getStatMax() > 0) {
                tag = tag + "_RANGE";
                if (stat.getMinDuration() == 0) {
                    lArgs.add(BonusDetail.adjustValue(item, detailType, stat.getStatMax()));
                } else if (tagInfo.isMinAsPerc()) {
                    lArgs.add(BonusDetail.adjustValue(item, detailType, stat.getStatMax()));
                } else {
                    lArgs.add(BonusDetail.adjustValue(item, detailType, stat.getStatMax() * stat.getMinDuration()));
                    lArgs.add(BonusDetail.adjustValue(item, detailType, stat.getStatMax()));
                }
            }
            if (stat.getMinDuration() > 0) {
                tag = tag + "_DUR";
                lArgs.add(stat.getMinDuration());
                info.dmgDuration = true;
            }
            if (stat.getStatChance() > 0) {
                if (stat.isGlobal()) {
                    if (stat.isXOR()) {
                        tag = tag + "_CHANCE";
                        lArgs.add(stat.getStatChance());
                        info.dmgChance = true;
                    }
                } else {
                    tag = tag + "_CHANCE";
                    lArgs.add(stat.getStatChance());
                    info.dmgChance = true;
                }
            }
            info.statDesc = statDesc;
            info.text = BonusDetail.buildText(tag, lArgs);
            infos.add(info);
        }
        if (stat.getStatModifier() > 0) {
            lArgs = new LinkedList();
            if (blankStat) {
                lArgs.add("");
            } else {
                lArgs.add(statDesc);
            }
            lArgs.add(BonusDetail.adjustValue(item, detailType, stat.getStatModifier()));
            info = new BonusInfo(tagInfo);
            info.prefix = prefix;
            info.dmgGlobal = stat.isGlobal();
            info.dmgXOR = stat.isXOR();
            info.dmgPerc = true;
            tag = "TXT_OFF_PERC";
            if (stat.getDurationModifier() > 0) {
                tag = tag + "_DUR";
                lArgs.add(stat.getDurationModifier());
            }
            if (stat.getStatModifierChance() > 0) {
                tag = tag + "_CHANCE";
                lArgs.add(stat.getStatModifierChance());
                info.dmgChance = true;
            }
            info.statDesc = statDesc;
            info.text = BonusDetail.buildText(tag, lArgs);
            infos.add(info);
        }
        return infos;
    }

    private static List<BonusInfo> parseStat(DBStashItem item, int detailType, DBStat stat, String prefix, TagInfo tagInfo, boolean blankStat) {
        if (tagInfo.getTag().equals("TXT_UNI_RACE_DAMAGE")) {
            return BonusDetail.fillRaceBonus(item, detailType, stat, prefix, tagInfo, blankStat);
        }
        int infoType = tagInfo.getInfoType();
        switch (infoType) {
            case 4: {
                return BonusDetail.parseCharStat(item, detailType, stat, prefix, tagInfo, blankStat);
            }
            case 1: {
                return BonusDetail.parseDefense(item, detailType, stat, prefix, tagInfo, blankStat);
            }
            case 2: {
                return BonusDetail.parseOffense(item, detailType, stat, prefix, tagInfo, blankStat);
            }
            case 3: {
                return BonusDetail.parseOffense(item, detailType, stat, prefix, tagInfo, blankStat);
            }
        }
        return null;
    }

    private static BonusInfo getStatInfo(DBStashItem item, int detailType, String statType, String prefix, int value, boolean isPercent) {
        return BonusDetail.getStatInfo(item, detailType, statType, prefix, value, 0, isPercent);
    }

    private static BonusInfo getStatInfo(DBStashItem item, int detailType, String statType, String prefix, int value, int chance, boolean isPercent) {
        Object[] args;
        TagInfo tagInfo = TagInfoHashMap.getInfo(statType);
        if (tagInfo == null) {
            return null;
        }
        BonusInfo info = new BonusInfo(tagInfo);
        String tag = null;
        tag = isPercent ? "TXT_PERC" : "TXT_ABS";
        String stat = GDMsgFormatter.getString(GDMsgFormatter.rbGD, statType);
        if (prefix != null) {
            args = new Object[]{prefix, stat};
            stat = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_STAT_PREFIX", args);
        }
        try {
            if (chance == 0) {
                args = new Object[]{stat, BonusDetail.adjustValue(item, detailType, value)};
                info.text = GDMsgFormatter.format(GDMsgFormatter.rbGD, tag, args);
                info.tag = statType;
                info.prefix = prefix;
                info.bonusPerc = isPercent;
            } else {
                tag = tag + "_CHANCE";
                args = new Object[]{stat, BonusDetail.adjustValue(item, detailType, value), chance};
                info.text = GDMsgFormatter.format(GDMsgFormatter.rbGD, tag, args);
                info.tag = statType;
                info.prefix = prefix;
                info.bonusPerc = isPercent;
            }
        }
        catch (IllegalArgumentException ex) {
            Object[] errargs = new Object[]{tag, "GrimDawn"};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_PROP_TAG_ARGS", errargs);
            GDMsgLogger.addError(msg);
            info = null;
        }
        return info;
    }

    private void createSkillBonusInfos() {
        DBSkillBonus bonus = (DBSkillBonus)this.entity;
        int value = bonus.getValue();
        if (value > 0) {
            BonusInfo info = new BonusInfo();
            Object[] args = new Object[]{value, bonus.getEntityName()};
            info.text = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_SKILL_BONUS", args);
            info.sbMastery = bonus.getSkillBonusType() == 1;
            info.sbPlus = value;
            this.add(info);
        }
    }

    private void createSkillInfos() {
        DBSkill skill = (DBSkill)this.entity;
        String skillName = null;
        if (skill.getName() != null) {
            skillName = skill.getName();
        } else if (skill.getBuffSkill() != null) {
            skillName = skill.getBuffSkill().getName();
        } else if (skill.getPetSkill() != null) {
            skillName = skill.getPetSkill().getName();
        }
        if (skillName != null) {
            BonusInfo info = new BonusInfo();
            Object[] sargs = new Object[]{skillName};
            info.text = GDMsgFormatter.format(GDMsgFormatter.rbGD, "TXT_SKILL_GRANTED", sargs);
            this.add(info);
        }
    }
}

