/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.description;

import org.gdstash.db.DBStat;
import org.gdstash.description.BonusDetail;
import org.gdstash.description.BonusInfo;
import org.gdstash.description.TagInfo;
import org.gdstash.description.TagInfoHashMap;

public class BonusInfoSort {
    public BonusDetail bonus;
    public BonusInfo info;
    public int prio;

    public BonusInfoSort(BonusDetail bonus, BonusInfo info) {
        this.bonus = bonus;
        this.info = info;
        this.prio = info.prio;
    }

    public boolean isBaseStat() {
        return this.info.baseStat;
    }

    public boolean isGlobal() {
        return this.info.dmgGlobal;
    }

    public boolean isXOR() {
        return this.info.dmgXOR;
    }

    public int getInfoType() {
        return this.info.infoType;
    }

    public int getGlobalOffensePerc() {
        if (this.bonus.type != 1) {
            return -1;
        }
        if (this.info.infoType != 2) {
            return -1;
        }
        DBStat stat = (DBStat)this.bonus.entity;
        return stat.getGlobalOffensePerc();
    }

    public int getGlobalRetaliationPerc() {
        if (this.bonus.type != 1) {
            return -1;
        }
        if (this.info.infoType != 3) {
            return -1;
        }
        DBStat stat = (DBStat)this.bonus.entity;
        return stat.getGlobalRetaliationPerc();
    }

    public int getGlobalCategory() {
        if (this.bonus.type != 1) {
            return 0;
        }
        DBStat stat = (DBStat)this.bonus.entity;
        return stat.getGlobalCategory();
    }

    public int getTypeInt() {
        int value = 0;
        switch (this.bonus.type) {
            case 1: {
                value = 30;
                if (this.info.dmgFlat) {
                    value = 105;
                }
                if (this.info.dmgPerc) {
                    value = 104;
                }
                if (this.info.baseStat) {
                    value += 100;
                }
                if (this.info.dmgDuration) {
                    value -= 2;
                }
                if (this.info.dmgChance) {
                    value -= 90;
                }
                if (!this.info.dmgGlobal) break;
                value -= 20;
                break;
            }
            case 3: {
                value = 60;
                break;
            }
            case 2: {
                value = 50;
            }
        }
        return value;
    }

    public String getTag() {
        if (this.info.tag == null) {
            return "";
        }
        return this.info.tag;
    }

    public int getTagInt() {
        int value = 0;
        switch (this.bonus.type) {
            case 1: {
                value = this.getStatTagInt();
                break;
            }
            case 2: {
                break;
            }
        }
        return value;
    }

    public int getInfoTypeInt() {
        int value = 0;
        switch (this.info.infoType) {
            case 1: {
                value = 9;
                break;
            }
            case 2: {
                value = 10;
                break;
            }
            case 3: {
                value = 5;
                break;
            }
            case 4: {
                value = 8;
                break;
            }
            case 5: {
                value = 6;
                break;
            }
            case 6: {
                value = 7;
            }
        }
        return value;
    }

    private int getStatTagInt() {
        if (this.info.tag == null) {
            return -1;
        }
        TagInfo ti = TagInfoHashMap.getInfo(this.info.tag);
        if (ti != null) {
            return ti.getPriority();
        }
        return -1;
    }
}

