/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.description;

public class TagInfo {
    public static final int MIN_CATEGORY_ABSOLUTE = 1;
    public static final int MIN_CATEGORY_PERCENTAGE = 2;
    public static final int MIN_CATEGORY_DURATION = 3;
    public static final String TAG_UNI_RACE_DAMAGE = "TXT_UNI_RACE_DAMAGE";
    private String tag;
    private int infoType;
    private boolean baseStat;
    private int minCat;
    private int prio;
    private boolean rand;
    private int randPrio;

    public TagInfo(String tag, int prio) {
        this(tag, prio, false, 1);
    }

    public TagInfo(String tag, int prio, boolean baseStat) {
        this(tag, prio, baseStat, 1);
    }

    public TagInfo(String tag, int prio, int minCat) {
        this(tag, prio, false, minCat);
    }

    public TagInfo(String tag, int prio, boolean baseStat, int minCat) {
        this.tag = tag;
        this.prio = prio;
        this.baseStat = baseStat;
        this.minCat = minCat;
        this.setFlags();
    }

    private void setFlags() {
        if (this.tag.startsWith("DEF_")) {
            this.infoType = 1;
            this.minCat = 2;
            if (this.tag.equals("DEF_PROTECTION")) {
                this.minCat = 1;
            }
        }
        if (this.tag.startsWith("OFF_")) {
            this.infoType = 2;
        }
        if (this.tag.startsWith("RET_")) {
            this.infoType = 3;
        }
        if (this.tag.startsWith("STAT_")) {
            this.infoType = 4;
        }
    }

    public String getTag() {
        return this.tag;
    }

    public int getPriority() {
        return this.prio;
    }

    public boolean isBaseStat() {
        return this.baseStat;
    }

    public boolean isMinAsPerc() {
        return this.minCat == 2;
    }

    public boolean isMinAsDuration() {
        return this.minCat == 3;
    }

    public int getInfoType() {
        return this.infoType;
    }
}

