/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.file;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.gdstash.file.ARCDecompress;
import org.gdstash.file.ARZRecord;
import org.gdstash.util.GDConstants;

public class ARCList {
    private List<ARCDecompress> listData = new LinkedList<ARCDecompress>();
    private List<ARCDecompress> listText = new LinkedList<ARCDecompress>();

    public ARCList(String dirMod, String[] arcs) {
        File file;
        if (dirMod != null && !dirMod.isEmpty() && (file = new File(dirMod)).exists()) {
            File[] files = null;
            if (file.isDirectory()) {
                files = file.listFiles();
            }
            if (file.isFile()) {
                files = new File[]{file};
            }
            for (int i = 0; i < files.length; ++i) {
                try {
                    ARCDecompress arc;
                    String s = files[i].getCanonicalPath();
                    String t = s.toUpperCase(GDConstants.LOCALE_US);
                    if (t.endsWith(".ZIP") || t.endsWith("TEXT_EN.ARC")) {
                        arc = new ARCDecompress(s);
                        this.listText.add(arc);
                        continue;
                    }
                    if (!t.endsWith(".ARC")) continue;
                    arc = new ARCDecompress(s);
                    this.listData.add(arc);
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        if (arcs != null) {
            for (int i = 0; i < arcs.length; ++i) {
                if (arcs[i] == null) continue;
                String t = arcs[i].toUpperCase(GDConstants.LOCALE_US);
                if (t.endsWith(".ZIP") || t.endsWith("TEXT_EN.ARC")) {
                    ARCDecompress arc = new ARCDecompress(arcs[i]);
                    this.listText.add(arc);
                    continue;
                }
                if (!t.endsWith(".ARC")) continue;
                ARCDecompress arc = new ARCDecompress(arcs[i]);
                this.listData.add(arc);
            }
        }
    }

    public void decompress() {
        for (ARCDecompress arc : this.listText) {
            arc.decompress(null);
        }
    }

    public void fillPictureData(ARZRecord[] records) {
        for (ARCDecompress arc : this.listData) {
            arc.decompress(null);
            arc.fillPictureData(records);
            arc.close();
        }
    }

    public void writeFiles(String dir, boolean writeVanilla) {
        LinkedList<ARCDecompress> list = new LinkedList<ARCDecompress>();
        list.addAll(this.listText);
        list.addAll(this.listData);
        for (ARCDecompress arc : list) {
            String fn = arc.getFileName();
            int pos = fn.indexOf(GDConstants.FILE_SEPARATOR + "mods" + GDConstants.FILE_SEPARATOR);
            if (pos == -1 && !writeVanilla) continue;
            pos = fn.lastIndexOf(GDConstants.FILE_SEPARATOR);
            if (pos == -1) {
                pos = 0;
            }
            String subdir = fn.substring(pos);
            subdir = subdir.substring(0, subdir.length() - 4).toLowerCase();
            arc.writeFiles(dir, subdir);
        }
    }

    public byte[] getTexture(String filename) {
        byte[] texture = null;
        String s = null;
        int pos = filename.indexOf("/");
        if (pos != -1) {
            s = GDConstants.FILE_SEPARATOR + filename.substring(0, pos) + ".";
            s = s.toUpperCase(GDConstants.LOCALE_US);
        }
        for (ARCDecompress arc : this.listData) {
            String fn;
            if (!(s != null ? (pos = (fn = arc.getFileName().toUpperCase(GDConstants.LOCALE_US)).indexOf(s)) != -1 && (texture = arc.getTexture(filename)) != null : (texture = arc.getTexture(filename)) != null)) continue;
            break;
        }
        return texture;
    }

    public BufferedImage getImage(String filename) {
        BufferedImage image = null;
        String s = null;
        int pos = filename.indexOf("/");
        if (pos != -1) {
            s = GDConstants.FILE_SEPARATOR + filename.substring(0, pos) + ".";
            s = s.toUpperCase(GDConstants.LOCALE_US);
        }
        for (ARCDecompress arc : this.listData) {
            String fn;
            if (!(s != null ? (pos = (fn = arc.getFileName().toUpperCase(GDConstants.LOCALE_US)).indexOf(s)) != -1 && (image = arc.getImage(filename)) != null : (image = arc.getImage(filename)) != null)) continue;
            break;
        }
        return image;
    }

    public String getTag(String filename, String tag) {
        ARCDecompress arc;
        if (tag == null) {
            return null;
        }
        String result = null;
        Iterator<ARCDecompress> iter = this.listText.iterator();
        while (iter.hasNext() && (result = (arc = iter.next()).getTag(filename, tag)) == null) {
        }
        return result;
    }
}

