/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.file;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DecimalFormat;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.gdstash.db.DBFormulaSet;
import org.gdstash.db.DBSkillBonus;
import org.gdstash.db.DBStat;
import org.gdstash.db.GDDBData;
import org.gdstash.file.ARZHeader;
import org.gdstash.file.ARZRecord;
import org.gdstash.file.ARZString;
import org.gdstash.file.GDAbstractBuffer;
import org.gdstash.file.GDBuffer;
import org.gdstash.file.GDByteBuffer;
import org.gdstash.file.GDMappedByteBuffer;
import org.gdstash.file.GDParseException;
import org.gdstash.file.GDRandomAccessBuffer;
import org.gdstash.file.GDReader;
import org.gdstash.file.GDWriter;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDConstants;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class ARZDecompress {
    public static final short REC_VALUE_INT = 0;
    public static final short REC_VALUE_FLOAT = 1;
    public static final short REC_VALUE_STRING = 2;
    public static final short REC_VALUE_BOOL = 3;
    private static ARZHeader header;
    private static ARZString[] strings;
    private static ARZRecord[] records;

    public static boolean is64BitVM() {
        String arch = System.getProperty("os.arch");
        return arch.contains("64");
    }

    public static GDBuffer getFileBuffer(File file) {
        GDAbstractBuffer buffer = null;
        if (GDStashFrame.iniConfig.sectDir.bufferType == 1) {
            buffer = new GDMappedByteBuffer(file);
        }
        if (GDStashFrame.iniConfig.sectDir.bufferType == 2) {
            buffer = new GDByteBuffer(file);
        }
        if (buffer == null) {
            buffer = new GDRandomAccessBuffer(file);
        }
        return buffer;
    }

    public static void clear() {
        header = null;
        strings = null;
        records = null;
    }

    public static void decompress(String filename) {
        try {
            File file = new File(filename);
            if (!file.exists()) {
                Object[] args = new Object[]{filename};
                String s = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_FILE_NOT_FOUND", args);
                throw new FileNotFoundException(s);
            }
            if (!file.isFile()) {
                Object[] args = new Object[]{filename};
                String s = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_FILE_NOT_FOUND", args);
                throw new FileNotFoundException(s);
            }
            if (!file.canRead()) {
                Object[] args = new Object[]{filename};
                String s = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_FILE_CANNOT_READ", args);
                throw new IOException(s);
            }
            GDBuffer buffer = ARZDecompress.getFileBuffer(file);
            try {
                header = ARZDecompress.getHeader(buffer);
                strings = ARZDecompress.getStrings(buffer);
                records = ARZDecompress.getRecords(buffer);
                ARZDecompress.extractRecords(buffer);
            }
            catch (IOException ex) {
                throw ex;
            }
            finally {
                buffer.close();
                buffer = null;
            }
        }
        catch (Exception ex) {
            GDMsgLogger.addError(ex);
        }
        GDStashFrame.arcList.fillPictureData(records);
        ARZDecompress.resolveAttrib();
        GDStashFrame.listToLog();
        if (GDMsgLogger.errorsInLog()) {
            GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_DB_EXTRACT_FAIL"));
        }
    }

    private static ARZHeader getHeader(GDBuffer buffer) throws IOException, GDParseException {
        ARZHeader header = new ARZHeader();
        header.unknown = buffer.getShort();
        header.version = buffer.getShort();
        header.rec_start = buffer.getInt();
        header.rec_size = buffer.getInt();
        header.rec_num = buffer.getInt();
        header.str_start = buffer.getInt();
        header.str_size = buffer.getInt();
        if (header.unknown != 2 || header.version != 3) {
            throw new GDParseException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"), 0L);
        }
        return header;
    }

    private static ARZString[] getStrings(GDBuffer buffer) throws IOException {
        buffer.setPosition(ARZDecompress.header.str_start);
        int num = buffer.getInt();
        ARZString[] strings = new ARZString[num];
        for (int i = 0; i < strings.length; ++i) {
            ARZString str;
            strings[i] = str = buffer.getARZString();
        }
        return strings;
    }

    private static ARZRecord[] getRecords(GDBuffer buffer) throws IOException {
        ARZRecord[] records = new ARZRecord[ARZDecompress.header.rec_num];
        buffer.setPosition(ARZDecompress.header.rec_start);
        for (int i = 0; i < records.length; ++i) {
            try {
                ARZRecord rec = new ARZRecord();
                rec.strID = buffer.getInt();
                rec.len_str = buffer.getInt();
                rec.str = buffer.getString(rec.len_str);
                rec.offset = buffer.getInt();
                rec.len_comp = buffer.getInt();
                rec.len_decomp = buffer.getInt();
                rec.filedata = buffer.getBytes8();
                records[i] = rec;
                continue;
            }
            catch (Exception ex) {
                GDMsgLogger.addError(ex);
                ARZDecompress.records[i] = null;
            }
        }
        return records;
    }

    private static void extractRecords(GDBuffer buffer) {
        DecimalFormat formatter = new DecimalFormat("#0.000000");
        LZ4Factory factory = LZ4Factory.fastestInstance();
        LZ4FastDecompressor decomp = factory.fastDecompressor();
        String attrib = null;
        String value = null;
        for (int i = 0; i < records.length; ++i) {
            try {
                if (records[i] == null) continue;
                records[i].setFileName(ARZDecompress.strings[ARZDecompress.records[i].strID].str);
                if (ARZDecompress.records[i].error) {
                    ARZDecompress.records[i] = null;
                    continue;
                }
                if (!ARZRecord.processDir(records[i].getFileName())) {
                    ARZDecompress.records[i] = null;
                    continue;
                }
                ARZDecompress.records[i].storeInDB = true;
                byte[] bComp = buffer.getByteArray(ARZDecompress.records[i].offset + 24, ARZDecompress.records[i].len_comp);
                byte[] bDecomp = new byte[ARZDecompress.records[i].len_decomp];
                decomp.decompress(bComp, bDecomp);
                int offset = 0;
                value = "";
                while (offset < bDecomp.length) {
                    int typeOffset = offset;
                    short varType = GDReader.getUShort(bDecomp, offset);
                    int count = GDReader.getUShort(bDecomp, offset += 2);
                    int strIdx = GDReader.getUInt(bDecomp, offset += 2);
                    offset += 4;
                    for (int j = 0; j < count; ++j) {
                        switch (varType) {
                            case 0: {
                                int valInt = GDReader.getInt(bDecomp, offset);
                                value = String.valueOf(valInt);
                                break;
                            }
                            case 1: {
                                float valFloat = GDReader.getFloat(bDecomp, offset);
                                value = formatter.format(valFloat);
                                break;
                            }
                            case 2: {
                                int valStrIdx = GDReader.getUInt(bDecomp, offset);
                                value = ARZDecompress.strings[valStrIdx].str;
                                break;
                            }
                            case 3: {
                                boolean valBool = GDReader.getBool(bDecomp, offset);
                                if (valBool) {
                                    value = "1";
                                    break;
                                }
                                value = "0";
                                break;
                            }
                            default: {
                                Object[] args = new Object[]{records[i].getFileName(), ARZDecompress.strings[strIdx].str};
                                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_UNKNOWN_VAR_TYPE", args);
                                throw new GDParseException(msg, typeOffset);
                            }
                        }
                        offset += 4;
                        attrib = ARZDecompress.strings[strIdx].str;
                        if (attrib.equals("templateName")) {
                            if (!ARZRecord.processTemplate(value)) {
                                ARZDecompress.records[i] = null;
                                break;
                            }
                            if (!ARZRecord.processFile(records[i].getFileName(), value)) {
                                ARZDecompress.records[i] = null;
                                break;
                            }
                        }
                        ARZDecompress.fillAttrib(attrib, i, value, j);
                    }
                    if (records[i] != null) continue;
                }
                if (records[i] == null || records[i].getTemplate() != null) continue;
                ARZDecompress.records[i] = null;
                continue;
            }
            catch (Exception ex) {
                Object[] args = new Object[]{records[i].getFileName()};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_IN_ENTRY", args);
                GDMsgLogger.addError(msg);
                GDMsgLogger.addError(ex);
                ARZDecompress.records[i] = null;
            }
        }
    }

    private static int parseInt(String s) {
        int pos = s.indexOf(".");
        if (pos == -1) {
            pos = s.indexOf(",");
        }
        int val = 0;
        if (pos == -1) {
            try {
                val = Integer.parseInt(s);
            }
            catch (NumberFormatException ex) {
                val = -1;
            }
        } else {
            val = (int)ARZDecompress.parseFloat(s);
        }
        return val;
    }

    private static float parseFloat(String s) {
        int pos = s.indexOf(",");
        if (pos != -1) {
            s = s.substring(0, pos) + "." + s.substring(pos + 1);
        }
        float val = 0.0f;
        try {
            val = Float.parseFloat(s);
        }
        catch (NumberFormatException ex) {
            val = -1.0f;
        }
        return val;
    }

    private static void fillAttrib(String attrib, int pos, String value, int index) throws GDParseException {
        if (attrib.equals("templateName")) {
            records[pos].setTemplate(value);
            return;
        }
        if (attrib.equals("Class")) {
            records[pos].setRecordClass(value);
            return;
        }
        if (attrib.equals("FileDescription")) {
            records[pos].setFileDescription(value);
            return;
        }
        if (attrib.equals("conversionInType")) {
            records[pos].setConversionIn(value);
            return;
        }
        if (attrib.equals("conversionOutType")) {
            records[pos].setConversionOut(value);
            return;
        }
        if (attrib.equals("itemClassification")) {
            records[pos].setRarity(value);
            return;
        }
        if (attrib.equals("itemSkillName")) {
            records[pos].setItemSkillID(value);
            return;
        }
        if (attrib.equals("itemSkillLevelEq")) {
            int level = ARZDecompress.parseInt(value);
            if (level == -1) {
                level = 1;
            }
            records[pos].setItemSkillLevel(level);
            return;
        }
        if (attrib.equals("levelRequirement")) {
            int level = ARZDecompress.parseInt(value);
            records[pos].setRequiredLevel(level);
            return;
        }
        if (attrib.equals("offensiveGlobalChance")) {
            int chance = ARZDecompress.parseInt(value);
            records[pos].setOffensiveChance(chance);
            return;
        }
        if (attrib.equals("petBonusName")) {
            records[pos].setPetBonusID(value);
            return;
        }
        if (attrib.equals("retaliationGlobalChance")) {
            int chance = ARZDecompress.parseInt(value);
            records[pos].setRetaliationChance(chance);
            return;
        }
        boolean processed = false;
        if (records[pos].isGameEngine() && (processed = ARZDecompress.fillEngineGame(attrib, pos, value))) {
            return;
        }
        if (records[pos].isFaction() && (processed = ARZDecompress.fillFaction(attrib, pos, value))) {
            return;
        }
        if ((records[pos].isMerchant() || records[pos].isMerchantTableSet() || records[pos].isMerchantTable()) && (processed = ARZDecompress.fillMerchant(attrib, pos, value))) {
            return;
        }
        if (records[pos].isPlayerEngine() && (processed = ARZDecompress.fillEnginePlayer(attrib, pos, value, index))) {
            return;
        }
        if ((records[pos].isConstellation() || records[pos].isSkillButton()) && (processed = ARZDecompress.fillAttribConstellation(attrib, pos, value))) {
            return;
        }
        if (records[pos].isSkill() && (processed = ARZDecompress.fillAttribSkill(attrib, pos, value))) {
            return;
        }
        if (records[pos].isAffix() && (processed = ARZDecompress.fillAttribAffix(attrib, pos, value))) {
            return;
        }
        if (records[pos].isAffixSet() && (processed = ARZDecompress.fillAttribAffixSet(attrib, pos, value))) {
            return;
        }
        if (records[pos].isItemSet() && (processed = ARZDecompress.fillAttribItemSet(attrib, pos, value))) {
            return;
        }
        if (records[pos].isLootTable() && (processed = ARZDecompress.fillAttribLootTable(attrib, pos, value))) {
            return;
        }
        if (records[pos].isLootTableSet() && (processed = ARZDecompress.fillAttribLootTableSet(attrib, pos, value))) {
            return;
        }
        if (records[pos].isFormulaSet() && (processed = ARZDecompress.fillAttribFormula(attrib, pos, value))) {
            return;
        }
        processed = ARZDecompress.fillAttribItem(attrib, pos, value);
        if (processed) {
            return;
        }
        processed = ARZDecompress.fillAttribStat(attrib, pos, value, index);
        if (processed) {
            return;
        }
        processed = ARZDecompress.fillAttribSkillBonus(attrib, pos, value);
        if (processed) {
            return;
        }
    }

    private static boolean fillAttribAffix(String attrib, int pos, String value) {
        if (attrib.equals("lootRandomizerCost")) {
            int iVal = 0;
            try {
                iVal = Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                iVal = 0;
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            records[pos].setLootRandomCost(iVal);
            return true;
        }
        if (attrib.equals("lootRandomizerJitter")) {
            int iVal = 0;
            try {
                iVal = (int)ARZDecompress.parseFloat(value);
            }
            catch (NumberFormatException ex) {
                iVal = 0;
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            records[pos].setRNGPercent(iVal);
            return true;
        }
        if (attrib.equals("lootRandomizerName")) {
            records[pos].setLootRandomName(value);
            return true;
        }
        return false;
    }

    private static boolean fillAttribAffixSet(String attrib, int pos, String value) {
        if (attrib.startsWith("randomizerLevelMax")) {
            String s = attrib.substring(18);
            int i = ARZDecompress.parseInt(s);
            int level = ARZDecompress.parseInt(value);
            records[pos].addRandomizerMaxLevelEntry(i, level);
            return true;
        }
        if (attrib.startsWith("randomizerLevelMin")) {
            String s = attrib.substring(18);
            int i = ARZDecompress.parseInt(s);
            int level = ARZDecompress.parseInt(value);
            records[pos].addRandomizerMinLevelEntry(i, level);
            return true;
        }
        if (attrib.startsWith("randomizerName")) {
            String s = attrib.substring(14);
            int i = ARZDecompress.parseInt(s);
            records[pos].addRandomizerAffixIDEntry(i, value);
            return true;
        }
        return false;
    }

    private static boolean fillAttribItem(String attrib, int pos, String value) {
        if (attrib.equals("amulet")) {
            records[pos].setSlotAmulet(value.equals("1"));
            return true;
        }
        if (attrib.equals("armorClassification")) {
            records[pos].setArmorClass(value);
            return true;
        }
        if (attrib.equals("artifactClassification")) {
            records[pos].setArtifactClass(value);
            return true;
        }
        if (attrib.equals("artifactName") || attrib.equals("forcedRandomArtifactName")) {
            if (value == null) {
                return true;
            }
            if (value.isEmpty()) {
                return true;
            }
            if (value.contains("loottable")) {
                return true;
            }
            records[pos].setArtifactID(value);
            return true;
        }
        if (attrib.equals("attributeScalePercent")) {
            int iVal = 0;
            try {
                iVal = (int)ARZDecompress.parseFloat(value);
            }
            catch (NumberFormatException ex) {
                iVal = 0;
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            records[pos].setRNGPercent(iVal);
            return true;
        }
        if (attrib.equals("augmentAllLevel")) {
            int iVal = ARZDecompress.parseInt(value);
            records[pos].setPlusAllSkills(iVal);
            return true;
        }
        if (attrib.equals("axe")) {
            records[pos].setSlotAxe1H(value.equals("1"));
            return true;
        }
        if (attrib.equals("axe2h")) {
            records[pos].setSlotAxe2H(value.equals("1"));
            return true;
        }
        if (attrib.equals("bitmap") || attrib.equals("artifactBitmap") || attrib.equals("artifactFormulaBitmapName") || attrib.equals("noteBitmap") || attrib.equals("relicBitmap") || attrib.equals("fullBitmap")) {
            records[pos].setBitmapID(value);
            return true;
        }
        if (attrib.equals("bonusTableName")) {
            records[pos].setBonusAffixSetID(value);
        }
        if (attrib.equals("chest")) {
            records[pos].setSlotChest(value.equals("1"));
            return true;
        }
        if (attrib.equals("completedRelicLevel")) {
            int iVal = ARZDecompress.parseInt(value);
            records[pos].setComponentPieces(iVal);
            return true;
        }
        if (attrib.equals("dagger")) {
            records[pos].setSlotDagger1H(value.equals("1"));
            return true;
        }
        if (attrib.equals("feet")) {
            records[pos].setSlotFeet(value.equals("1"));
            return true;
        }
        if (attrib.equals("hands")) {
            records[pos].setSlotHands(value.equals("1"));
            return true;
        }
        if (attrib.equals("head")) {
            records[pos].setSlotHead(value.equals("1"));
            return true;
        }
        if (attrib.equals("hidePrefixName")) {
            records[pos].setHidePrefix(value.equals("1"));
            return true;
        }
        if (attrib.equals("hideSuffixName")) {
            records[pos].setHideSuffix(value.equals("1"));
            return true;
        }
        if (attrib.equals("itemCostName")) {
            records[pos].setCostFormulaSetID(value);
            return true;
        }
        if (attrib.equals("itemLevel")) {
            int iVal = ARZDecompress.parseInt(value);
            records[pos].setItemLevel(iVal);
            return true;
        }
        if (attrib.equals("itemNameTag") || attrib.equals("description")) {
            if (value != null && !value.equals("")) {
                records[pos].setItemNameTag(value);
            }
            return true;
        }
        if (attrib.equals("itemQualityTag")) {
            records[pos].setQualityTag(value);
            return true;
        }
        if (attrib.equals("itemSetName")) {
            records[pos].setItemSetID(value);
            return true;
        }
        if (attrib.equals("itemStyleTag")) {
            records[pos].setStyleTag(value);
            return true;
        }
        if (attrib.equals("itemText")) {
            records[pos].setItemDescriptionTag(value);
            return true;
        }
        if (attrib.equals("legs")) {
            records[pos].setSlotLegs(value.equals("1"));
            return true;
        }
        if (attrib.equals("mace")) {
            records[pos].setSlotMace1H(value.equals("1"));
            return true;
        }
        if (attrib.equals("mace2h")) {
            records[pos].setSlotMace2H(value.equals("1"));
            return true;
        }
        if (attrib.equals("maxStackSize")) {
            int iVal = ARZDecompress.parseInt(value);
            records[pos].setMaxStackSize(iVal);
            return true;
        }
        if (attrib.equals("medal")) {
            records[pos].setSlotMedal(value.equals("1"));
            return true;
        }
        if (attrib.equals("offhand")) {
            records[pos].setSlotOffhand(value.equals("1"));
            return true;
        }
        if (attrib.equals("quest")) {
            records[pos].setQuestItem(value.equals("1"));
            return true;
        }
        if (attrib.equals("ranged1h")) {
            records[pos].setSlotRanged1H(value.equals("1"));
            return true;
        }
        if (attrib.equals("ranged2h")) {
            records[pos].setSlotRanged2H(value.equals("1"));
            return true;
        }
        if (attrib.equals("ring")) {
            records[pos].setSlotRing(value.equals("1"));
            return true;
        }
        if (attrib.equals("scepter")) {
            records[pos].setSlotScepter1H(value.equals("1"));
            return true;
        }
        if (attrib.equals("shardBitmap")) {
            records[pos].setShardBitmapID(value);
            return true;
        }
        if (attrib.equals("shield")) {
            records[pos].setSlotShield(value.equals("1"));
            return true;
        }
        if (attrib.equals("shoulders")) {
            records[pos].setSlotShoulders(value.equals("1"));
            return true;
        }
        if (attrib.equals("soulbound")) {
            records[pos].setSoulbound(value.equals("1"));
            return true;
        }
        if (attrib.equals("spear")) {
            records[pos].setSlotSpear2H(value.equals("1"));
            return true;
        }
        if (attrib.equals("staff")) {
            records[pos].setSlotStaff2H(value.equals("1"));
            return true;
        }
        if (attrib.equals("sword")) {
            records[pos].setSlotSword1H(value.equals("1"));
            return true;
        }
        if (attrib.equals("sword2h")) {
            records[pos].setSlotSword2H(value.equals("1"));
            return true;
        }
        if (attrib.equals("waist")) {
            records[pos].setSlotBelt(value.equals("1"));
            return true;
        }
        return false;
    }

    private static boolean fillAttribStat(String attrib, int pos, String value, int index) {
        boolean processed = false;
        if (attrib.startsWith("defensive") && (processed = ARZDecompress.fillAttribStatDefense(attrib, pos, value, index))) {
            return true;
        }
        if (attrib.startsWith("offensive") && (processed = ARZDecompress.fillAttribStatOffense(attrib, pos, value, index))) {
            return true;
        }
        if (attrib.startsWith("retaliation") && (processed = ARZDecompress.fillAttribStatRetaliation(attrib, pos, value, index))) {
            return true;
        }
        processed = ARZDecompress.fillAttribStatChar(attrib, pos, value, index);
        return processed;
    }

    private static boolean fillAttribStatDetails(String attrib, String search, int pos, String value, int index) {
        boolean processed = false;
        int len = search.length();
        int p = attrib.indexOf(search);
        if (p == -1) {
            if (search.equals("retaliationPercentCurrentLife")) {
                p = attrib.indexOf("retaliationPercentcurrentLife");
            }
            if (p == -1) {
                return false;
            }
        }
        String suf = attrib.substring(p + len);
        DBStat stat = records[pos].getCreateDBStat(search, index);
        int val = ARZDecompress.parseInt(value);
        if (suf.equals("Global")) {
            stat.setGlobal(val > 0);
            processed = true;
        }
        if (suf.equals("XOR")) {
            stat.setXOR(val > 0);
            processed = true;
        }
        if (suf.equals("")) {
            stat.setMinDamage(val);
            processed = true;
        }
        if (suf.equals("Min")) {
            stat.setMinDamage(val);
            processed = true;
        }
        if (suf.equals("Max")) {
            stat.setMaxDamage(val);
            processed = true;
        }
        if (suf.equals("Chance")) {
            stat.setDamageChance(val);
            processed = true;
        }
        if (suf.equals("Modifier")) {
            stat.setDamageModifier(val);
            processed = true;
        }
        if (suf.equals("ModifierChance")) {
            stat.setDamageModifierChance(val);
            processed = true;
        }
        if (suf.equals("Duration")) {
            stat.setMinDuration(val);
            processed = true;
        }
        if (suf.equals("DurationMin")) {
            stat.setMinDuration(val);
            processed = true;
        }
        if (suf.equals("DurationMax")) {
            stat.setMaxDuration(val);
            processed = true;
        }
        if (suf.equals("DurationChance")) {
            stat.setDurationChance(val);
            processed = true;
        }
        if (suf.equals("DurationModifier")) {
            stat.setDurationModifier(val);
            processed = true;
        }
        if (suf.equals("DurationModifierChance")) {
            stat.setDurationModifierChance(val);
            processed = true;
        }
        if (suf.equals("MaxResist")) {
            stat.setMaxResist(val);
            processed = true;
        }
        return processed;
    }

    private static boolean fillAttribStatChar(String attrib, int pos, String value, int index) {
        boolean processed = false;
        processed = ARZDecompress.fillAttribStatDetails(attrib, "skillManaCost", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "skillCooldownTime", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "skillActiveDuration", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "lifeMonitorPercent", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "weaponDamagePct", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "characterLightRadius", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "characterDefensiveAbility", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "characterOffensiveAbility", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "characterMana", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "characterManaLimitReserve", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "characterManaLimitReserveReduction", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "characterManaRegen", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "characterLife", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "characterLifeRegen", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "characterConstitution", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "skillLifeBonus", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "skillLifePercent", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "characterDexterity", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "characterStrength", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "characterIntelligence", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "characterAttackSpeed", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "characterSpellCastSpeed", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "characterRunSpeed", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "characterTotalSpeed", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "characterDefensiveBlockRecoveryReduction", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "characterGlobalReqReduction", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "characterEnergyAbsorptionPercent", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "characterIncreasedExperience", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "skillCooldownReduction", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "skillManaCostReduction", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "racialBonusPercentDamage", pos, value, index);
        if (processed) {
            return processed;
        }
        if (attrib.equals("racialBonusRace")) {
            String tag = value;
            if (!tag.startsWith("tag")) {
                tag = "tag" + tag;
            }
            String name = GDStashFrame.arcList.getTag("tags_creatures.txt", tag);
            records[pos].addRace(value, name);
            return true;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "characterDeflectProjectile", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "characterDodgePercent", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "characterArmorStrengthReqReduction", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "characterHuntingDexterityReqReduction", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "characterMeleeDexterityReqReduction", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "characterMeleeStrengthReqReduction", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "characterWeaponStrengthReqReduction", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "conversionPercentage", pos, value, index);
        if (processed) {
            return processed;
        }
        if (!processed) {
            int i = ARZDecompress.parseInt(value);
            ARZDecompress.logTag(attrib, i, records[pos]);
        }
        return processed;
    }

    private static boolean fillAttribStatDefense(String attrib, int pos, String value, int index) {
        boolean processed = false;
        processed = ARZDecompress.fillAttribStatDetails(attrib, "defensiveAbsorption", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "defensiveAether", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "defensiveAll", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "defensiveBleeding", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "defensiveBlock", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "defensiveBlockAmount", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "defensiveBonusProtection", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "defensiveChaos", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "defensiveCold", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "defensiveConfusion", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "defensiveConvert", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "defensiveDisruption", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "defensiveElemental", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "defensiveElementalResistance", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "defensiveFear", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "defensiveFire", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "defensiveFreeze", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "defensiveKnockdown", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "defensiveLife", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "defensiveLightning", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "defensivePercentCurrentLife", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "defensiveManaBurnRatio", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "defensivePetrify", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "defensivePhysical", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "defensivePierce", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "defensivePoison", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "defensiveProtection", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "defensiveReflect", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "defensiveSleep", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "defensiveSlowLifeLeach", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "defensiveSlowManaLeach", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "defensiveStun", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "defensiveTaunt", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "defensiveTotalSpeedResistance", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "defensiveTrap", pos, value, index);
        if (processed) {
            return processed;
        }
        if (!processed) {
            int i = ARZDecompress.parseInt(value);
            ARZDecompress.logTag(attrib, i, records[pos]);
        }
        return processed;
    }

    private static boolean fillAttribStatOffense(String attrib, int pos, String value, int index) {
        boolean processed = false;
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveAether", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveBaseAether", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveBaseChaos", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveBaseCold", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveBaseFire", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveBaseLife", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveBaseLightning", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveBasePoison", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveBonusPhysical", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveChaos", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveCold", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveConfusion", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveConvert", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveCritDamage", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveDamageMult", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveDisruption", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveElemental", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveElementalReductionPercent", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveElementalResistanceReductionAbsolute", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveElementalResistanceReductionPercent", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveFear", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveFire", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveFreeze", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveFumble", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveKnockdown", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveLife", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveLifeLeech", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveLightning", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensivePercentCurrentLife", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveManaBurnDamageRatio", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveManaBurnDrain", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensivePetrify", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensivePhysical", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensivePhysicalReductionPercent", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensivePhysicalResistanceReductionAbsolute", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensivePhysicalResistanceReductionPercent", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensivePierce", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensivePierceRatio", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensivePoison", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveProjectileFumble", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveSleep", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveSlowAttackSpeed", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveSlowBleeding", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveSlowCold", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveSlowDefensiveAbility", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveSlowDefensiveReduction", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveSlowFire", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveSlowLife", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveSlowLifeLeach", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveSlowLightning", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveSlowManaLeach", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveSlowOffensiveAbility", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveSlowOffensiveReduction", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveSlowPhysical", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveSlowPoison", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveSlowRunSpeed", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveSlowTotalSpeed", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveStun", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveTaunt", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveTotalDamage", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveTotalDamageReductionPercent", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveTotalResistanceReductionAbsolute", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveTotalResistanceReductionPercent", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "offensiveTrap", pos, value, index);
        if (processed) {
            return processed;
        }
        if (!processed) {
            int i = ARZDecompress.parseInt(value);
            ARZDecompress.logTag(attrib, i, records[pos]);
        }
        return processed;
    }

    private static boolean fillAttribStatRetaliation(String attrib, int pos, String value, int index) {
        boolean processed = false;
        processed = ARZDecompress.fillAttribStatDetails(attrib, "retaliationAether", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "retaliationChaos", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "retaliationCold", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "retaliationConfusion", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "retaliationConvert", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "retaliationElemental", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "retaliationFear", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "retaliationFire", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "retaliationFreeze", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "retaliationLife", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "retaliationLightning", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "retaliationPercentCurrentLife", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "retaliationPetrify", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "retaliationPhysical", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "retaliationPierce", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "retaliationPierceRatio", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "retaliationPoison", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "retaliationSleep", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "retaliationSlowAttackSpeed", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "retaliationSlowBleeding", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "retaliationSlowCold", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "retaliationSlowDefensiveAbility", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "retaliationSlowFire", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "retaliationSlowLife", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "retaliationSlowLifeLeach", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "retaliationSlowLightning", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "retaliationSlowManaLeach", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "retaliationSlowOffensiveAbility", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "retaliationSlowOffensiveReduction", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "retaliationSlowPhysical", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "retaliationSlowPoison", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "retaliationSlowRunSpeed", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "retaliationStun", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "retaliationTotalDamage", pos, value, index);
        if (processed) {
            return processed;
        }
        processed = ARZDecompress.fillAttribStatDetails(attrib, "retaliationTrap", pos, value, index);
        if (processed) {
            return processed;
        }
        if (!processed) {
            int i = ARZDecompress.parseInt(value);
            ARZDecompress.logTag(attrib, i, records[pos]);
        }
        return processed;
    }

    private static void logTag(String attrib, int value, ARZRecord record) {
        if (value == 0) {
            return;
        }
        if (!(attrib.equals("characterBaseAttackSpeedTag") || attrib.equals("characterAttributeEquations") || attrib.equals("characterGenderProfile") || attrib.equals("characterRacialProfile") || attrib.equals("characterRunSpeed") || attrib.equals("characterRunSpeedJitter") || attrib.equals("characterSpellCastSpeed") || attrib.equals("characterWeapon2HStrengthReqReduction"))) {
            Object[] args = new Object[]{attrib};
            String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_UNKNOWN", args);
            GDStashFrame.messageToList(msg);
        }
    }

    private static boolean fillEngineGame(String attrib, int pos, String value) {
        int i = 0;
        boolean error = false;
        try {
            i = ARZDecompress.parseInt(value);
        }
        catch (NumberFormatException ex) {
            i = 0;
            error = true;
        }
        if (attrib.equals("factionAlternateNeutralTag")) {
            records[pos].setFactionAltNeutralTag(value);
            return true;
        }
        if (attrib.startsWith("factionValue")) {
            String s = attrib.substring(12);
            int index = ARZDecompress.parseInt(s);
            records[pos].addFactionReputationValue(index, i);
            return true;
        }
        if (attrib.startsWith("factionTag")) {
            String s = attrib.substring(10);
            int index = ARZDecompress.parseInt(s);
            records[pos].addFactionReputationStateTag(index, value);
            return true;
        }
        return false;
    }

    private static boolean fillFaction(String attrib, int pos, String value) {
        if (attrib.equals("bountyEnabled")) {
            records[pos].setFactionBountyEnabled(value.equals("1"));
            return true;
        }
        if (attrib.startsWith("questEnabled")) {
            records[pos].setFactionQuestEnabled(value.equals("1"));
            return true;
        }
        if (attrib.startsWith("myFaction")) {
            records[pos].setFactionTag(value);
            return true;
        }
        return false;
    }

    private static boolean fillMerchant(String attrib, int pos, String value) {
        if (attrib.equals("factions")) {
            records[pos].setMerchantFactionID(value);
            return true;
        }
        if (attrib.startsWith("marketFileName")) {
            records[pos].setMerchantTableSetID(value);
            return true;
        }
        if (attrib.startsWith("friendlyNormalTable")) {
            records[pos].addMerchantTableSetTableID(value);
            return true;
        }
        if (attrib.startsWith("respectedNormalTable")) {
            records[pos].addMerchantTableSetTableID(value);
            return true;
        }
        if (attrib.startsWith("honoredNormalTable")) {
            records[pos].addMerchantTableSetTableID(value);
            return true;
        }
        if (attrib.startsWith("reveredNormalTable")) {
            records[pos].addMerchantTableSetTableID(value);
            return true;
        }
        if (attrib.startsWith("marketStaticItems")) {
            records[pos].addMerchantTableItemID(value);
            return true;
        }
        return false;
    }

    private static boolean fillEnginePlayer(String attrib, int pos, String value, int index) throws GDParseException {
        int i = 0;
        boolean error = false;
        try {
            i = ARZDecompress.parseInt(value);
        }
        catch (NumberFormatException ex) {
            i = 0;
            error = true;
        }
        if (attrib.equals("characterDexterity")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            records[pos].setPlayerBaseDex(i);
            return true;
        }
        if (attrib.equals("characterIntelligence")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            records[pos].setPlayerBaseInt(i);
            return true;
        }
        if (attrib.equals("characterLife")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            records[pos].setPlayerBaseLife(i);
            return true;
        }
        if (attrib.equals("characterMana")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            records[pos].setPlayerBaseMana(i);
            return true;
        }
        if (attrib.equals("characterModifierPoints")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            records[pos].addLevelStatPoints(i, index);
            return true;
        }
        if (attrib.equals("characterStrength")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            records[pos].setPlayerBaseStr(i);
            return true;
        }
        if (attrib.equals("dexterityIncrement")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            records[pos].setPlayerIncDex(i);
            return true;
        }
        if (attrib.equals("experienceLevelEquation")) {
            records[pos].setXPFormula(value.toUpperCase(GDConstants.LOCALE_US));
            return true;
        }
        if (attrib.equals("intelligenceIncrement")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            records[pos].setPlayerIncInt(i);
            return true;
        }
        if (attrib.equals("lifeIncrement")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            records[pos].setPlayerIncLife(i);
            return true;
        }
        if (attrib.equals("manaIncrement")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            records[pos].setPlayerIncMana(i);
            return true;
        }
        if (attrib.equals("maxPlayerLevel")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            records[pos].setPlayerMaxLevel(i);
            return true;
        }
        if (attrib.equals("skillModifierPoints")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            records[pos].addLevelSkillPoints(i, index);
            return true;
        }
        if (attrib.equals("strengthIncrement")) {
            if (error) {
                Object[] args = new Object[]{records[pos].getFileName(), attrib, value};
                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_TAG_INVALID_VALUE", args);
                GDMsgLogger.addError(msg);
            }
            records[pos].setPlayerIncStr(i);
            return true;
        }
        return false;
    }

    private static boolean fillAttribConstellation(String attrib, int pos, String value) {
        int i = 0;
        boolean error = false;
        try {
            i = ARZDecompress.parseInt(value);
        }
        catch (NumberFormatException ex) {
            i = 0;
            error = true;
        }
        if (attrib.equals("constellationDisplayTag")) {
            records[pos].setConstellationNameTag(value);
            return true;
        }
        if (attrib.equals("constellationInfoTag")) {
            records[pos].getConstellationInfoTag(value);
            return true;
        }
        if (attrib.startsWith("affinityGivenName")) {
            records[pos].addConstellationAffinityName(attrib, value);
            return true;
        }
        if (attrib.startsWith("affinityRequiredName")) {
            records[pos].addConstellationAffinityName(attrib, value);
            return true;
        }
        if (attrib.startsWith("affinityGiven")) {
            records[pos].addConstellationAffinityPoints(attrib, i);
            return true;
        }
        if (attrib.startsWith("affinityRequired")) {
            records[pos].addConstellationAffinityPoints(attrib, i);
            return true;
        }
        if (attrib.startsWith("devotionButton")) {
            records[pos].addConstellationStar(attrib, value);
            return true;
        }
        if (attrib.equals("skillName")) {
            records[pos].setButtonSkillID(value);
            return true;
        }
        return false;
    }

    private static boolean fillAttribSkill(String attrib, int pos, String value) {
        int i = 0;
        boolean error = false;
        try {
            i = ARZDecompress.parseInt(value);
        }
        catch (NumberFormatException ex) {
            i = 0;
            error = true;
        }
        if (attrib.equals("buffSkillName")) {
            records[pos].setSkillBuffID(value);
            return true;
        }
        if (attrib.equals("petSkillName")) {
            records[pos].setPetBonusID(value);
            return true;
        }
        if (attrib.equals("skillBaseDescription")) {
            records[pos].setSkillDescription(value);
            return true;
        }
        if (attrib.equals("skillDisplayName")) {
            records[pos].setSkillNameTag(value);
            return true;
        }
        if (attrib.equals("skillExperienceLevels")) {
            records[pos].addSkillXPLevel(value);
            return true;
        }
        return false;
    }

    private static boolean fillAttribSkillBonus(String attrib, int pos, String value) {
        if (attrib.startsWith("augmentMasteryName") || attrib.startsWith("augmentSkillName")) {
            String s = null;
            int type = 0;
            if (attrib.startsWith("augmentMasteryName")) {
                s = attrib.substring(18);
                type = 1;
            }
            if (attrib.startsWith("augmentSkillName")) {
                s = attrib.substring(16);
                type = 2;
            }
            int i = ARZDecompress.parseInt(s);
            DBSkillBonus.addEntity(ARZDecompress.records[pos].dbSkillBonuses, i, type, value);
            return true;
        }
        if (attrib.startsWith("augmentMasteryLevel") || attrib.startsWith("augmentSkillLevel")) {
            String s = null;
            int type = 0;
            if (attrib.startsWith("augmentMasteryLevel")) {
                s = attrib.substring(19);
                type = 1;
            }
            if (attrib.startsWith("augmentSkillLevel")) {
                s = attrib.substring(17);
                type = 2;
            }
            int i = ARZDecompress.parseInt(s);
            int iVal = ARZDecompress.parseInt(value);
            DBSkillBonus.addValue(ARZDecompress.records[pos].dbSkillBonuses, i, type, iVal);
            return true;
        }
        return false;
    }

    private static boolean fillAttribItemSet(String attrib, int pos, String value) {
        if (attrib.equals("setDescription")) {
            records[pos].setItemSetDescriptionTag(value);
            return true;
        }
        if (attrib.equals("setMembers")) {
            records[pos].addItemSetItemID(value);
            return true;
        }
        if (attrib.equals("setName")) {
            records[pos].setItemSetNameTag(value);
            return true;
        }
        return false;
    }

    private static boolean fillAttribLootTable(String attrib, int pos, String value) {
        if (attrib.equals("bothPrefixSuffix")) {
            records[pos].setTableNormalPrefixSuffix(ARZDecompress.parseInt(value) > 0);
            return true;
        }
        if (attrib.equals("normalPrefixRareSuffix")) {
            records[pos].setTableNormalPrefixRareSuffix(ARZDecompress.parseInt(value) > 0);
            return true;
        }
        if (attrib.equals("rarePrefixNormalSuffix")) {
            records[pos].setTableRarePrefixNormalSuffix(ARZDecompress.parseInt(value) > 0);
            return true;
        }
        if (attrib.equals("rareBothPrefixSuffix")) {
            records[pos].setTableRarePrefixSuffix(ARZDecompress.parseInt(value) > 0);
            return true;
        }
        if (attrib.startsWith("lootName")) {
            records[pos].addTableItemID(value);
            return true;
        }
        if (attrib.startsWith("prefixTableLevelMax") || attrib.startsWith("suffixTableLevelMax") || attrib.startsWith("rarePrefixTableLevelMax") || attrib.startsWith("rareSuffixTableLevelMax")) {
            String search = "TableLevelMax";
            int len = search.length();
            int p = attrib.indexOf(search);
            String pre = attrib.substring(0, p);
            String num = attrib.substring(p + len);
            int i = ARZDecompress.parseInt(num);
            int type = 0;
            if (pre.equals("prefix")) {
                type = 1;
            }
            if (pre.equals("suffix")) {
                type = 2;
            }
            if (pre.equals("rarePrefix")) {
                type = 3;
            }
            if (pre.equals("rareSuffix")) {
                type = 4;
            }
            int iVal = ARZDecompress.parseInt(value);
            records[pos].addTableMaxLevel(i, type, iVal);
            return true;
        }
        if (attrib.startsWith("prefixTableLevelMin") || attrib.startsWith("suffixTableLevelMin") || attrib.startsWith("rarePrefixTableLevelMin") || attrib.startsWith("rareSuffixTableLevelMin")) {
            String search = "TableLevelMin";
            int len = search.length();
            int p = attrib.indexOf(search);
            String pre = attrib.substring(0, p);
            String num = attrib.substring(p + len);
            int i = ARZDecompress.parseInt(num);
            int type = 0;
            if (pre.equals("prefix")) {
                type = 1;
            }
            if (pre.equals("suffix")) {
                type = 2;
            }
            if (pre.equals("rarePrefix")) {
                type = 3;
            }
            if (pre.equals("rareSuffix")) {
                type = 4;
            }
            int iVal = ARZDecompress.parseInt(value);
            records[pos].addTableMinLevel(i, type, iVal);
            return true;
        }
        if (attrib.startsWith("prefixTableName") || attrib.startsWith("suffixTableName") || attrib.startsWith("rarePrefixTableName") || attrib.startsWith("rareSuffixTableName")) {
            String search = "TableName";
            int len = search.length();
            int p = attrib.indexOf(search);
            String pre = attrib.substring(0, p);
            String num = attrib.substring(p + len);
            int i = ARZDecompress.parseInt(num);
            int type = 0;
            if (pre.equals("prefix")) {
                type = 1;
            }
            if (pre.equals("suffix")) {
                type = 2;
            }
            if (pre.equals("rarePrefix")) {
                type = 3;
            }
            if (pre.equals("rareSuffix")) {
                type = 4;
            }
            records[pos].addTableAffixSetID(i, type, value);
            return true;
        }
        return false;
    }

    private static boolean fillAttribLootTableSet(String attrib, int pos, String value) {
        if (attrib.equals("levels")) {
            int iVal = ARZDecompress.parseInt(value);
            records[pos].addTableSetMinLevel(iVal);
            return true;
        }
        if (attrib.equals("records")) {
            records[pos].addTableSetTableID(value);
            return true;
        }
        return false;
    }

    private static boolean fillAttribFormula(String attrib, int pos, String value) {
        if (attrib.equals("armorCostEquation") || attrib.equals("jewelryCostEquation") || attrib.equals("offhandCostEquation") || attrib.equals("shieldCostEquation") || attrib.equals("weaponCostEquation") || attrib.equals("weaponMelee2hCostEquation") || attrib.equals("weaponRangedCostEquation") || attrib.equals("weaponRanged2hCostEquation") || attrib.equals("daggerDexterityEquation") || attrib.equals("ranged1hDexterityEquation") || attrib.equals("ranged2hDexterityEquation") || attrib.equals("swordDexterityEquation") || attrib.equals("amuletIntelligenceEquation") || attrib.equals("chestIntelligenceEquation") || attrib.equals("daggerIntelligenceEquation") || attrib.equals("headIntelligenceEquation") || attrib.equals("offhandIntelligenceEquation") || attrib.equals("ringIntelligenceEquation") || attrib.equals("scepterIntelligenceEquation") || attrib.equals("axeStrengthEquation") || attrib.equals("chestStrengthEquation") || attrib.equals("feetStrengthEquation") || attrib.equals("handsStrengthEquation") || attrib.equals("headStrengthEquation") || attrib.equals("legsStrengthEquation") || attrib.equals("maceStrengthEquation") || attrib.equals("melee2hStrengthEquation") || attrib.equals("scepterStrengthEquation") || attrib.equals("shieldStrengthEquation") || attrib.equals("shouldersStrengthEquation") || attrib.equals("waistStrengthEquation")) {
            records[pos].addFormulaSetFormula(attrib, value.toUpperCase(GDConstants.LOCALE_US));
            return true;
        }
        return false;
    }

    public static int getGenderCode(String s) {
        int code = -1;
        if (s.equals("[ms]")) {
            code = 0;
        }
        if (s.equals("[mp]")) {
            code = 3;
        }
        if (s.equals("[fs]")) {
            code = 1;
        }
        if (s.equals("[fp]")) {
            code = 4;
        }
        if (s.equals("[ns]")) {
            code = 2;
        }
        if (s.equals("[np]")) {
            code = 5;
        }
        return code;
    }

    public static String[] getGenderTexts(String text) {
        String[] genders = new String[6];
        if (text == null) {
            return genders;
        }
        String remainder = text;
        String gender = null;
        String value = null;
        int code = -1;
        if (remainder.startsWith("|")) {
            remainder = remainder.substring(2);
        }
        if (remainder.startsWith("$")) {
            remainder = remainder.substring(1);
        }
        while (remainder != null) {
            int pos = remainder.indexOf("[");
            if (pos != -1) {
                gender = remainder.substring(pos, pos + 4);
                if ((pos = (remainder = remainder.substring(pos + 4)).indexOf("[")) != -1) {
                    value = remainder.substring(0, pos);
                    remainder = remainder.substring(pos);
                } else {
                    value = remainder;
                    remainder = null;
                }
                code = ARZDecompress.getGenderCode(gender);
                if (code == -1) {
                    code = 0;
                }
                genders[code] = value;
                continue;
            }
            value = remainder;
            remainder = null;
            genders[0] = value;
            genders[1] = value;
            genders[2] = value;
            genders[3] = value;
            genders[4] = value;
            genders[5] = value;
        }
        return genders;
    }

    private static boolean resolveSkillName(ARZRecord record) {
        String skill = null;
        if (record.getPetBonusID() != null) {
            skill = record.getPetBonusID();
        }
        if (record.getSkillBuffID() != null) {
            skill = record.getSkillBuffID();
        }
        if (skill == null) {
            return false;
        }
        for (int i = 0; i < records.length; ++i) {
            if (records[i] == null || records[i].getSkillNameTag() == null || !skill.equals(records[i].getFileName())) continue;
            record.setSkillNameTag(records[i].getSkillNameTag());
            return true;
        }
        return false;
    }

    private static void resolveGrantedSkillName(ARZRecord record) {
        block0: for (DBSkillBonus bonus : record.dbSkillBonuses) {
            if (bonus.getEntity() == null) continue;
            for (int i = 0; i < records.length; ++i) {
                if (records[i] == null || records[i].getSkillName() == null && records[i].getSkillBuffID() == null && records[i].getPetBonusID() == null || !bonus.getEntity().equals(records[i].getFileName())) continue;
                if (records[i].getSkillName() == null) continue block0;
                bonus.setEntityName(records[i].getSkillName());
                continue block0;
            }
        }
    }

    private static void resolveDevotionFlag(ARZRecord record) {
        for (int i = 0; i < records.length; ++i) {
            if (records[i] == null || !record.getSkillBuffID().equals(records[i].getFileName())) continue;
            record.setDevotion(records[i].isDevotion());
            break;
        }
    }

    private static void resolveBonusIncrementFlag(ARZRecord record) {
        block0: for (DBSkillBonus bonus : record.dbSkillBonuses) {
            if (bonus.getEntity() == null || bonus.getValue() < 1) continue;
            for (int i = 0; i < records.length; ++i) {
                if (records[i] == null || !bonus.getEntity().equals(records[i].getFileName())) continue;
                records[i].setSkillBonusIncrement(true);
                continue block0;
            }
        }
    }

    private static void resolveAttrib() {
        int i;
        for (int i2 = 0; i2 < records.length; ++i2) {
            if (records[i2] == null || records[i2].getItemSetID() == null) continue;
            records[i2].setItemSetNameTag(ARZDecompress.getAttribValue(records[i2].getItemSetID(), "itemSetName"));
        }
        boolean changed = true;
        while (changed) {
            changed = false;
            for (i = 0; i < records.length; ++i) {
                if (records[i] == null || !records[i].isSkill() || records[i].getSkillNameTag() != null) continue;
                boolean b = ARZDecompress.resolveSkillName(records[i]);
                changed = changed || b;
            }
        }
        for (i = 0; i < records.length; ++i) {
            if (records[i] == null || ARZDecompress.records[i].dbSkillBonuses == null || ARZDecompress.records[i].dbSkillBonuses.isEmpty()) continue;
            ARZDecompress.resolveGrantedSkillName(records[i]);
            ARZDecompress.resolveBonusIncrementFlag(records[i]);
        }
        for (i = 0; i < records.length; ++i) {
            if (records[i] == null || !records[i].getFileName().startsWith("records/skills/") || records[i].getSkillBuffID() == null) continue;
            ARZDecompress.resolveDevotionFlag(records[i]);
        }
    }

    public static DBFormulaSet getFormulaSet(String formulaSetID) {
        DBFormulaSet set = null;
        for (int i = 0; i < records.length; ++i) {
            if (records[i] == null || !records[i].getFileName().equals(formulaSetID)) continue;
            set = records[i].getDBFormulaSet();
            break;
        }
        return set;
    }

    private static String getAttribValue(String filename, String attrib) {
        String value = null;
        for (int i = 0; i < records.length; ++i) {
            if (records[i] == null || !records[i].getFileName().equals(filename)) continue;
            value = records[i].getItemSetNameTag();
            break;
        }
        return value;
    }

    public static boolean insertData() {
        return GDDBData.insertData(records);
    }

    public static boolean insertModData() {
        return GDDBData.insertModData(records);
    }

    public static void extractRecords(String filename, String dir) {
        try {
            File file = new File(filename);
            if (!file.exists()) {
                Object[] args = new Object[]{filename};
                String s = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_FILE_NOT_FOUND", args);
                throw new FileNotFoundException(s);
            }
            if (!file.isFile()) {
                Object[] args = new Object[]{filename};
                String s = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_FILE_NOT_FOUND", args);
                throw new FileNotFoundException(s);
            }
            if (!file.canRead()) {
                Object[] args = new Object[]{filename};
                String s = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_FILE_CANNOT_READ", args);
                throw new IOException(s);
            }
            GDByteBuffer buffer = new GDByteBuffer(file);
            try {
                header = ARZDecompress.getHeader(buffer);
                strings = ARZDecompress.getStrings(buffer);
                records = ARZDecompress.getRecords(buffer);
                ARZDecompress.recordsToText(buffer, dir);
            }
            catch (IOException ex) {
                throw ex;
            }
            finally {
                buffer.close();
                buffer = null;
            }
        }
        catch (Exception ex) {
            GDMsgLogger.addError(ex);
        }
        if (GDMsgLogger.errorsInLog()) {
            GDMsgLogger.addError(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_DB_EXTRACT_FAIL"));
        }
    }

    private static void recordsToText(GDBuffer buffer, String dir) throws IOException, GDParseException {
        DecimalFormat formatter = new DecimalFormat("#0.000000");
        LZ4Factory factory = LZ4Factory.fastestInstance();
        LZ4FastDecompressor decomp = factory.fastDecompressor();
        for (int i = 0; i < records.length; ++i) {
            if (records[i] == null) continue;
            records[i].setFileName(ARZDecompress.strings[ARZDecompress.records[i].strID].str);
            byte[] bComp = buffer.getByteArray(ARZDecompress.records[i].offset + 24, ARZDecompress.records[i].len_comp);
            byte[] bDecomp = new byte[ARZDecompress.records[i].len_decomp];
            decomp.decompress(bComp, bDecomp);
            String text = "";
            String value = "";
            int offset = 0;
            try {
                while (offset < bDecomp.length) {
                    int typeOffset = offset;
                    short varType = GDReader.getUShort(bDecomp, offset);
                    int count = GDReader.getUShort(bDecomp, offset += 2);
                    int strIdx = GDReader.getUInt(bDecomp, offset += 2);
                    offset += 4;
                    String line = ARZDecompress.strings[strIdx].str + ",";
                    for (int j = 0; j < count; ++j) {
                        switch (varType) {
                            case 0: {
                                int valInt = GDReader.getInt(bDecomp, offset);
                                value = String.valueOf(valInt);
                                break;
                            }
                            case 1: {
                                float valFloat = GDReader.getFloat(bDecomp, offset);
                                value = formatter.format(valFloat);
                                break;
                            }
                            case 2: {
                                int valStrIdx = GDReader.getUInt(bDecomp, offset);
                                value = ARZDecompress.strings[valStrIdx].str;
                                break;
                            }
                            case 3: {
                                boolean valBool = GDReader.getBool(bDecomp, offset);
                                if (valBool) {
                                    value = "1";
                                    break;
                                }
                                value = "0";
                                break;
                            }
                            default: {
                                Object[] args = new Object[]{records[i].getFileName(), ARZDecompress.strings[strIdx].str};
                                String msg = GDMsgFormatter.format(GDMsgFormatter.rbMsg, "ERR_UNKNOWN_VAR_TYPE", args);
                                throw new GDParseException(msg, typeOffset);
                            }
                        }
                        offset += 4;
                        line = line + value;
                        line = j == count - 1 ? line + "," : line + ";";
                    }
                    text = text + line + GDConstants.LINE_SEPARATOR;
                }
            }
            catch (GDParseException ex) {
                GDMsgLogger.addError(ex);
                ARZDecompress.records[i].error = true;
                int pos = records[i].getFileName().lastIndexOf(".");
                if (pos != -1) {
                    records[i].setFileName(records[i].getFileName().substring(0, pos));
                }
                records[i].setFileName(records[i].getFileName() + ".err");
            }
            String osName = GDWriter.getOSFilePath(records[i].getFileName());
            String newName = dir + GDConstants.FILE_SEPARATOR + osName;
            try {
                GDWriter.write(newName, text);
                continue;
            }
            catch (Exception ex) {
                GDMsgLogger.addError(ex);
            }
        }
    }
}

