/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.file;

import java.util.LinkedList;
import java.util.List;
import org.gdstash.db.DBAffixSet;
import org.gdstash.db.DBConstellationAffinity;
import org.gdstash.db.DBConstellationStar;
import org.gdstash.db.DBEngineLevel;
import org.gdstash.db.DBFactionReputation;
import org.gdstash.db.DBFormula;
import org.gdstash.db.DBFormulaSet;
import org.gdstash.db.DBLootTableAffixSetAlloc;
import org.gdstash.db.DBLootTableItemAlloc;
import org.gdstash.db.DBLootTableSetAlloc;
import org.gdstash.db.DBSkillBonus;
import org.gdstash.db.DBStat;
import org.gdstash.db.DBStatBonusRace;
import org.gdstash.db.ItemSlots;
import org.gdstash.file.ARCDecompress;
import org.gdstash.file.ARZDecompress;
import org.gdstash.ui.GDStashFrame;
import org.gdstash.util.GDConstants;

public class ARZRecord {
    public int strID;
    public int len_str;
    public String str;
    public int offset;
    public int len_comp;
    public int len_decomp;
    public byte[] filedata;
    public boolean error = false;
    public boolean storeInDB = false;
    private String fileName;
    private String fileDesc;
    private String recordClass;
    private String template;
    private String factionAltNeutralTag;
    private List<DBFactionReputation> factionReputations;
    private boolean factionBountyEnabled;
    private boolean factionQuestEnabled;
    private String factionTag;
    private String merchantFactionID;
    private String merchantTableSetID;
    private List<String> merchantTableIDs;
    private List<String> merchantItemIDs;
    private int playerBaseDex;
    private int playerBaseInt;
    private int playerBaseStr;
    private int playerBaseLife;
    private int playerBaseMana;
    private int playerIncDex;
    private int playerIncInt;
    private int playerIncStr;
    private int playerIncLife;
    private int playerIncMana;
    private int playerMaxLevel;
    private String xpFormula;
    private List<DBEngineLevel.LevelStats> levelStats;
    private String constellationNameTag;
    private String constellationInfoTag;
    private List<DBConstellationAffinity> constellationAffinities;
    private List<DBConstellationStar> constellationStars;
    private String buttonSkillID;
    private String skillBuffID;
    private String skillDescription;
    private String skillNameTag;
    private String skillName;
    private boolean mastery;
    private boolean devotion = false;
    private boolean bonusIncrement;
    private List<Integer> skillXPLevels;
    private int lootRandomCost;
    private String lootRandomName;
    private String convertIn;
    private String convertOut;
    private String petBonusID;
    private String rarity;
    private int reqLevel;
    private String itemSkillID;
    private int itemSkillLevel;
    private int offensiveChance;
    private int retaliationChance;
    private int rngPercent;
    private List<DBAffixSet.DBEntry> randomizers;
    private String itemSetDescTag;
    private List<String> itemSetItemIDs;
    private String itemSetNameTag;
    private boolean nPre_nSuf;
    private boolean nPre_rSuf;
    private boolean rPre_nSuf;
    private boolean rPre_rSuf;
    private List<DBLootTableItemAlloc> tableItems;
    private List<DBLootTableAffixSetAlloc> tableAffixSets;
    private List<DBLootTableSetAlloc> tableSetAllocs;
    private List<DBFormula> formulaSetFormulas;
    private String armorClass;
    private String artifactClass;
    private String artifactID;
    private String bitmapID;
    private byte[] bitmap;
    private String shardBitmapID;
    private byte[] shardBitmap;
    private String itemNameTag;
    private String itemDescriptionTag;
    private int genderCode;
    private String itemName;
    private String itemDescription;
    private String qualityTag;
    private String styleTag;
    private String itemSetID;
    private String bonusAffixSetID;
    private String costFormulaSetID;
    private boolean soulbound;
    private boolean hidePrefix;
    private boolean hideSuffix;
    private boolean questItem;
    private int itemLevel;
    private int plusAllSkills;
    private int componentPieces;
    private int maxStackSize;
    private ItemSlots slots = new ItemSlots();
    private List<DBStat> dbStats;
    private List<DBStatBonusRace> dbStatBonusRaces;
    public List<DBSkillBonus> dbSkillBonuses;
    private DBFormulaSet dbFormulaSet = null;

    public ARZRecord() {
        this.factionReputations = new LinkedList<DBFactionReputation>();
        this.randomizers = new LinkedList<DBAffixSet.DBEntry>();
        this.itemSetItemIDs = new LinkedList<String>();
        this.tableItems = new LinkedList<DBLootTableItemAlloc>();
        this.tableAffixSets = new LinkedList<DBLootTableAffixSetAlloc>();
        this.tableSetAllocs = new LinkedList<DBLootTableSetAlloc>();
        this.formulaSetFormulas = new LinkedList<DBFormula>();
        this.dbStatBonusRaces = new LinkedList<DBStatBonusRace>();
        this.dbStats = new LinkedList<DBStat>();
        this.dbSkillBonuses = new LinkedList<DBSkillBonus>();
        this.merchantTableIDs = new LinkedList<String>();
        this.merchantItemIDs = new LinkedList<String>();
        this.levelStats = new LinkedList<DBEngineLevel.LevelStats>();
        this.constellationAffinities = new LinkedList<DBConstellationAffinity>();
        this.constellationStars = new LinkedList<DBConstellationStar>();
        this.skillXPLevels = new LinkedList<Integer>();
    }

    public String getFileDescription() {
        return this.fileDesc;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getRecordClass() {
        return this.recordClass;
    }

    public String getTemplate() {
        return this.template;
    }

    public DBFormulaSet getDBFormulaSet() {
        if (this.dbFormulaSet == null) {
            this.dbFormulaSet = new DBFormulaSet(this);
        }
        return this.dbFormulaSet;
    }

    public List<DBStat> getDBStatList() {
        return this.dbStats;
    }

    public List<DBStatBonusRace> getDBStatBonusRaceList() {
        return this.dbStatBonusRaces;
    }

    public List<DBFactionReputation> getFactionReputationList() {
        return this.factionReputations;
    }

    public String getFactionAltNeutralTag() {
        return this.factionAltNeutralTag;
    }

    public boolean getFactionBountyEnabled() {
        return this.factionBountyEnabled;
    }

    public boolean getFactionQuestEnabled() {
        return this.factionQuestEnabled;
    }

    public String getFactionTag() {
        return this.factionTag;
    }

    public String getMerchantFactionID() {
        return this.merchantFactionID;
    }

    public String getMerchantTableSetID() {
        return this.merchantTableSetID;
    }

    public List<String> getMerchantTableIDList() {
        return this.merchantTableIDs;
    }

    public List<String> getMerchantTableItemIDList() {
        return this.merchantItemIDs;
    }

    public int getPlayerBaseDex() {
        return this.playerBaseDex;
    }

    public int getPlayerBaseInt() {
        return this.playerBaseInt;
    }

    public int getPlayerBaseStr() {
        return this.playerBaseStr;
    }

    public int getPlayerBaseLife() {
        return this.playerBaseLife;
    }

    public int getPlayerBaseMana() {
        return this.playerBaseMana;
    }

    public int getPlayerIncDex() {
        return this.playerIncDex;
    }

    public int getPlayerIncInt() {
        return this.playerIncInt;
    }

    public int getPlayerIncStr() {
        return this.playerIncStr;
    }

    public int getPlayerIncLife() {
        return this.playerIncLife;
    }

    public int getPlayerIncMana() {
        return this.playerIncMana;
    }

    public int getPlayerMaxLevel() {
        return this.playerMaxLevel;
    }

    public String getXPFormula() {
        return this.xpFormula;
    }

    public List<DBEngineLevel.LevelStats> getLevelStatList() {
        return this.levelStats;
    }

    public String getConstellationNameTag() {
        return this.constellationNameTag;
    }

    public String getConstellationInfoTag() {
        return this.constellationInfoTag;
    }

    public List<DBConstellationAffinity> getConstellationAffinityList() {
        return this.constellationAffinities;
    }

    public List<DBConstellationStar> getConstellationStarList() {
        return this.constellationStars;
    }

    public String getButtonSkillID() {
        return this.buttonSkillID;
    }

    public String getSkillBuffID() {
        return this.skillBuffID;
    }

    public String getSkillDescription() {
        return this.skillDescription;
    }

    public String getSkillNameTag() {
        return this.skillNameTag;
    }

    public String getSkillName() {
        return this.skillName;
    }

    public boolean isMastery() {
        return this.mastery;
    }

    public boolean isDevotion() {
        return this.devotion;
    }

    public boolean hasSkillBonusIncrement() {
        return this.bonusIncrement;
    }

    public List<Integer> getSkillXPLevelList() {
        return this.skillXPLevels;
    }

    public int getLootRandomCost() {
        return this.lootRandomCost;
    }

    public String getLootRandomName() {
        return this.lootRandomName;
    }

    public String getConversionIn() {
        return this.convertIn;
    }

    public String getConversionOut() {
        return this.convertOut;
    }

    public String getItemSkillID() {
        return this.itemSkillID;
    }

    public int getItemSkillLevel() {
        return this.itemSkillLevel;
    }

    public int getOffensiveChance() {
        return this.offensiveChance;
    }

    public String getPetBonusID() {
        return this.petBonusID;
    }

    public String getRarity() {
        return this.rarity;
    }

    public int getRequiredLevel() {
        return this.reqLevel;
    }

    public int getRetaliationChance() {
        return this.retaliationChance;
    }

    public int getRNGPercent() {
        return this.rngPercent;
    }

    public List<DBAffixSet.DBEntry> getAffixSetRandomizerList() {
        return this.randomizers;
    }

    public List<String> getItemSetItemIDList() {
        return this.itemSetItemIDs;
    }

    public String getItemSetDescriptionTag() {
        return this.itemSetDescTag;
    }

    public String getItemSetNameTag() {
        return this.itemSetNameTag;
    }

    public boolean getTableNormalPrefixSuffix() {
        return this.nPre_nSuf;
    }

    public boolean getTableNormalPrefixRareSuffix() {
        return this.nPre_rSuf;
    }

    public boolean getTableRarePrefixNormalSuffix() {
        return this.rPre_nSuf;
    }

    public boolean getTableRarePrefixSuffix() {
        return this.rPre_rSuf;
    }

    public List<DBLootTableItemAlloc> getTableItemAllocList() {
        return this.tableItems;
    }

    public List<DBLootTableAffixSetAlloc> getTableAffixSetAllocList() {
        return this.tableAffixSets;
    }

    public List<DBLootTableSetAlloc> getTableSetAllocList() {
        return this.tableSetAllocs;
    }

    public List<DBFormula> getFormulaSetFormulaList() {
        return this.formulaSetFormulas;
    }

    public String getArmorClass() {
        return this.armorClass;
    }

    public String getArtifactClass() {
        return this.artifactClass;
    }

    public String getBitmapID() {
        return this.bitmapID;
    }

    public byte[] getBitmap() {
        return this.bitmap;
    }

    public String getShardBitmapID() {
        return this.shardBitmapID;
    }

    public byte[] getShardBitmap() {
        return this.shardBitmap;
    }

    public String getItemNameTag() {
        return this.itemNameTag;
    }

    public int getGenderCode() {
        return this.genderCode;
    }

    public String getItemDescription() {
        return this.itemDescription;
    }

    public String getItemName() {
        return this.itemName;
    }

    public String getQualityTag() {
        return this.qualityTag;
    }

    public String getStyleTag() {
        return this.styleTag;
    }

    public String getItemSetID() {
        return this.itemSetID;
    }

    public String getArtifactID() {
        return this.artifactID;
    }

    public String getBonusAffixSetID() {
        return this.bonusAffixSetID;
    }

    public String getCostFormulaSetID() {
        return this.costFormulaSetID;
    }

    public boolean isSoulbound() {
        return this.soulbound;
    }

    public boolean isHidePrefix() {
        return this.hidePrefix;
    }

    public boolean isHideSuffix() {
        return this.hideSuffix;
    }

    public boolean isQuestItem() {
        return this.questItem;
    }

    public int getItemLevel() {
        return this.itemLevel;
    }

    public int getPlusAllSkills() {
        return this.plusAllSkills;
    }

    public int getComponentPieces() {
        return this.componentPieces;
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public ItemSlots getItemSlots() {
        return this.slots;
    }

    public void setFileDescription(String filedesc) {
        this.fileDesc = filedesc;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setRecordClass(String recordClass) {
        this.recordClass = recordClass;
    }

    public void setTemplate(String template) {
        this.template = template;
        if (template != null) {
            this.mastery = template.equals("database/templates/skill_mastery.tpl");
        }
    }

    public void setDBFormulaSet(DBFormulaSet dbFormulaSet) {
        this.dbFormulaSet = dbFormulaSet;
    }

    public void addFactionReputationStateTag(int index, String stateTag) {
        boolean found = false;
        for (DBFactionReputation reputation : this.factionReputations) {
            if (reputation.getIndex() != index) continue;
            reputation.setStateTag(stateTag);
            found = true;
            break;
        }
        if (!found) {
            DBFactionReputation reputation;
            reputation = new DBFactionReputation();
            reputation.setIndex(index);
            reputation.setStateTag(stateTag);
            this.factionReputations.add(reputation);
        }
    }

    public void addFactionReputationValue(int index, int value) {
        boolean found = false;
        for (DBFactionReputation reputation : this.factionReputations) {
            if (reputation.getIndex() != index) continue;
            reputation.setValue(value);
            found = true;
            break;
        }
        if (!found) {
            DBFactionReputation reputation;
            reputation = new DBFactionReputation();
            reputation.setIndex(index);
            reputation.setValue(value);
            this.factionReputations.add(reputation);
        }
    }

    public void setFactionAltNeutralTag(String factionAltNeutralTag) {
        this.factionAltNeutralTag = factionAltNeutralTag;
    }

    public void setFactionBountyEnabled(boolean factionBountyEnabled) {
        this.factionBountyEnabled = factionBountyEnabled;
    }

    public void setFactionQuestEnabled(boolean factionQuestEnabled) {
        this.factionQuestEnabled = factionQuestEnabled;
    }

    public void setFactionTag(String factionTag) {
        this.factionTag = factionTag;
    }

    public void setMerchantFactionID(String merchantFactionID) {
        this.merchantFactionID = merchantFactionID;
    }

    public void setMerchantTableSetID(String merchantTableSetID) {
        this.merchantTableSetID = merchantTableSetID;
    }

    public void addMerchantTableSetTableID(String tableID) {
        this.merchantTableIDs.add(tableID);
    }

    public void addMerchantTableItemID(String itemID) {
        this.merchantItemIDs.add(itemID);
    }

    public void setPlayerBaseDex(int playerBaseDex) {
        this.playerBaseDex = playerBaseDex;
    }

    public void setPlayerBaseInt(int playerBaseInt) {
        this.playerBaseInt = playerBaseInt;
    }

    public void setPlayerBaseStr(int playerBaseStr) {
        this.playerBaseStr = playerBaseStr;
    }

    public void setPlayerBaseLife(int playerBaseLife) {
        this.playerBaseLife = playerBaseLife;
    }

    public void setPlayerBaseMana(int playerBaseMana) {
        this.playerBaseMana = playerBaseMana;
    }

    public void setPlayerIncDex(int playerIncDex) {
        this.playerIncDex = playerIncDex;
    }

    public void setPlayerIncInt(int playerIncInt) {
        this.playerIncInt = playerIncInt;
    }

    public void setPlayerIncStr(int playerIncStr) {
        this.playerIncStr = playerIncStr;
    }

    public void setPlayerIncLife(int playerIncLife) {
        this.playerIncLife = playerIncLife;
    }

    public void setPlayerIncMana(int playerIncMana) {
        this.playerIncMana = playerIncMana;
    }

    public void setPlayerMaxLevel(int playerMaxLevel) {
        this.playerMaxLevel = playerMaxLevel;
    }

    public void setXPFormula(String xpFormula) {
        this.xpFormula = xpFormula;
    }

    public void addLevelStatPoints(int points, int index) {
        DBEngineLevel.LevelStats stats2 = null;
        for (DBEngineLevel.LevelStats stats2 : this.levelStats) {
            if (stats2.getLevel() == index) break;
        }
        boolean statExists = false;
        if (stats2 == null) {
            statExists = false;
        } else {
            boolean bl = statExists = stats2.getLevel() == index;
        }
        if (statExists) {
            stats2.setStatPoints(points);
        } else {
            int skillPoints = 0;
            if (stats2 != null) {
                skillPoints = stats2.getSkillPoints();
            }
            stats2 = new DBEngineLevel.LevelStats();
            stats2.setLevel(index);
            stats2.setStatPoints(points);
            stats2.setSkillPoints(skillPoints);
            this.levelStats.add(stats2);
        }
    }

    public void addLevelSkillPoints(int points, int index) {
        DBEngineLevel.LevelStats stats2 = null;
        for (DBEngineLevel.LevelStats stats2 : this.levelStats) {
            if (stats2.getLevel() == index) break;
        }
        boolean statExists = false;
        if (stats2 == null) {
            statExists = false;
        } else {
            boolean bl = statExists = stats2.getLevel() == index;
        }
        if (statExists) {
            stats2.setSkillPoints(points);
        } else {
            int statPoints = 0;
            if (stats2 != null) {
                statPoints = stats2.getStatPoints();
            }
            stats2 = new DBEngineLevel.LevelStats();
            stats2.setLevel(index);
            stats2.setStatPoints(statPoints);
            stats2.setSkillPoints(points);
            this.levelStats.add(stats2);
        }
    }

    public void setConstellationNameTag(String constellationNameTag) {
        this.constellationNameTag = constellationNameTag;
    }

    public void getConstellationInfoTag(String constellationInfoTag) {
        this.constellationInfoTag = constellationInfoTag;
    }

    public void addConstellationAffinityName(String tag, String name) {
        boolean found = false;
        boolean required = tag.startsWith("affinityRequired");
        int index = 0;
        String s = null;
        s = required ? tag.substring("affinityRequiredName".length()) : tag.substring("affinityGivenName".length());
        try {
            index = Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            return;
        }
        for (DBConstellationAffinity dbAffinity : this.constellationAffinities) {
            if (dbAffinity.getIndex() != index || dbAffinity.isRequired() != required) continue;
            dbAffinity.setAffinity(name);
            found = true;
            break;
        }
        if (!found) {
            DBConstellationAffinity dbAffinity;
            dbAffinity = new DBConstellationAffinity();
            dbAffinity.setIndex(index);
            dbAffinity.setRequired(required);
            dbAffinity.setAffinity(name);
            this.constellationAffinities.add(dbAffinity);
        }
    }

    public void addConstellationAffinityPoints(String tag, int points) {
        boolean found = false;
        boolean required = tag.startsWith("affinityRequired");
        int index = 0;
        String s = null;
        s = required ? tag.substring("affinityRequired".length()) : tag.substring("affinityGiven".length());
        try {
            index = Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            return;
        }
        for (DBConstellationAffinity dbAffinity : this.constellationAffinities) {
            if (dbAffinity.getIndex() != index || dbAffinity.isRequired() != required) continue;
            dbAffinity.setPoints(points);
            found = true;
            break;
        }
        if (!found) {
            DBConstellationAffinity dbAffinity;
            dbAffinity = new DBConstellationAffinity();
            dbAffinity.setIndex(index);
            dbAffinity.setRequired(required);
            dbAffinity.setPoints(points);
            this.constellationAffinities.add(dbAffinity);
        }
    }

    public void addConstellationStar(String tag, String skillID) {
        int index = 0;
        String s = null;
        s = tag.substring("devotionButton".length());
        try {
            index = Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            return;
        }
        DBConstellationStar dbStar = new DBConstellationStar();
        dbStar.setIndex(index);
        dbStar.setButtonID(skillID);
        this.constellationStars.add(dbStar);
    }

    public void setButtonSkillID(String buttonSkillID) {
        this.buttonSkillID = buttonSkillID;
    }

    public void setSkillBuffID(String skillBuffID) {
        this.skillBuffID = skillBuffID;
    }

    public void setSkillDescription(String skillBaseDescription) {
        this.skillDescription = GDStashFrame.arcList.getTag("tags_skills.txt", skillBaseDescription);
    }

    public void setDevotion(boolean devotion) {
        this.devotion = devotion;
    }

    public void setSkillBonusIncrement(boolean bonusIncrement) {
        this.bonusIncrement = bonusIncrement;
    }

    public void addSkillXPLevel(String xp) {
        try {
            Integer i = new Integer(xp);
            this.skillXPLevels.add(i);
            if (i > 0) {
                this.devotion = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setSkillNameTag(String skillNameTag) {
        this.skillNameTag = skillNameTag;
        if (skillNameTag != null) {
            this.skillName = GDStashFrame.arcList.getTag("tags_skills.txt", skillNameTag);
        }
    }

    public void setLootRandomCost(int lootRandomCost) {
        this.lootRandomCost = lootRandomCost;
    }

    public void setLootRandomName(String lootRandomName) {
        this.lootRandomName = lootRandomName;
    }

    public void setConversionIn(String convertIn) {
        if (convertIn == null) {
            return;
        }
        if (convertIn.equals("Physical;Pierce;Elemental;Cold;Fire;Poison;Lightning;Life;Chaos;Aether;Stun")) {
            return;
        }
        this.convertIn = convertIn;
    }

    public void setConversionOut(String convertOut) {
        if (convertOut == null) {
            return;
        }
        if (convertOut.equals("Physical;Pierce;Elemental;Cold;Fire;Poison;Lightning;Life;Chaos;Aether;Stun")) {
            return;
        }
        this.convertOut = convertOut;
    }

    public void addRace(String tag, String name) {
        boolean found = false;
        for (DBStatBonusRace race : this.dbStatBonusRaces) {
            if (!race.getRaceTag().equals(tag)) continue;
            found = true;
            break;
        }
        if (!found) {
            DBStatBonusRace race;
            race = new DBStatBonusRace();
            race.setID(this.fileName);
            race.setRaceTag(tag);
            race.setRaceName(name);
            this.dbStatBonusRaces.add(race);
        }
    }

    public void setItemSkillID(String itemSkillID) {
        this.itemSkillID = itemSkillID;
    }

    public void setItemSkillLevel(int itemSkillLevel) {
        this.itemSkillLevel = itemSkillLevel;
    }

    public void setOffensiveChance(int offensiveChance) {
        this.offensiveChance = offensiveChance;
    }

    public void setPetBonusID(String petBonusID) {
        this.petBonusID = petBonusID;
    }

    public void setRarity(String rarity) {
        if (rarity == null) {
            return;
        }
        if (rarity.equals("Common;Magical;Rare;Epic;Legendary;Broken;")) {
            return;
        }
        this.rarity = rarity;
    }

    public void setRequiredLevel(int reqLevel) {
        this.reqLevel = reqLevel;
    }

    public void setRetaliationChance(int retaliationChance) {
        this.retaliationChance = retaliationChance;
    }

    public void setRNGPercent(int rngPercent) {
        this.rngPercent = rngPercent;
    }

    public void addRandomizerAffixIDEntry(int index, String affixID) {
        boolean found = false;
        for (DBAffixSet.DBEntry entry : this.randomizers) {
            if (entry.getIndex() != index) continue;
            entry.setAffixID(affixID);
            found = true;
            break;
        }
        if (!found) {
            DBAffixSet.DBEntry entry;
            entry = new DBAffixSet.DBEntry();
            entry.setIndex(index);
            entry.setAffixID(affixID);
            this.randomizers.add(entry);
        }
    }

    public void addRandomizerMaxLevelEntry(int index, int level) {
        boolean found = false;
        for (DBAffixSet.DBEntry entry : this.randomizers) {
            if (entry.getIndex() != index) continue;
            entry.setMaxLevel(level);
            found = true;
            break;
        }
        if (!found) {
            DBAffixSet.DBEntry entry;
            entry = new DBAffixSet.DBEntry();
            entry.setIndex(index);
            entry.setMaxLevel(level);
            this.randomizers.add(entry);
        }
    }

    public void addRandomizerMinLevelEntry(int index, int level) {
        boolean found = false;
        for (DBAffixSet.DBEntry entry : this.randomizers) {
            if (entry.getIndex() != index) continue;
            entry.setMinLevel(level);
            found = true;
            break;
        }
        if (!found) {
            DBAffixSet.DBEntry entry;
            entry = new DBAffixSet.DBEntry();
            entry.setIndex(index);
            entry.setMinLevel(level);
            this.randomizers.add(entry);
        }
    }

    public void addItemSetItemID(String itemID) {
        this.itemSetItemIDs.add(itemID);
    }

    public void setItemSetDescriptionTag(String itemSetDescTag) {
        this.itemSetDescTag = itemSetDescTag;
    }

    public void setItemSetNameTag(String itemSetNameTag) {
        this.itemSetNameTag = itemSetNameTag;
    }

    public void addTableItemID(String itemID) {
        DBLootTableItemAlloc alloc = new DBLootTableItemAlloc(this.fileName, itemID);
        this.tableItems.add(alloc);
    }

    public void addTableAffixSetID(int index, int type, String affixSetID) {
        boolean found = false;
        for (DBLootTableAffixSetAlloc affixSet : this.tableAffixSets) {
            if (affixSet.getIndex() != index || affixSet.getAffixType() != type) continue;
            affixSet.setAffixSetID(affixSetID);
            found = true;
            break;
        }
        if (!found) {
            DBLootTableAffixSetAlloc affixSet;
            affixSet = new DBLootTableAffixSetAlloc();
            affixSet.setIndex(index);
            affixSet.setAffixType(type);
            affixSet.setAffixSetID(affixSetID);
            this.tableAffixSets.add(affixSet);
        }
    }

    public void addTableMaxLevel(int index, int type, int levelMax) {
        boolean found = false;
        for (DBLootTableAffixSetAlloc affixSet : this.tableAffixSets) {
            if (affixSet.getIndex() != index || affixSet.getAffixType() != type) continue;
            affixSet.setMaxLevel(levelMax);
            found = true;
            break;
        }
        if (!found) {
            DBLootTableAffixSetAlloc affixSet;
            affixSet = new DBLootTableAffixSetAlloc();
            affixSet.setIndex(index);
            affixSet.setAffixType(type);
            affixSet.setMaxLevel(levelMax);
            this.tableAffixSets.add(affixSet);
        }
    }

    public void addTableMinLevel(int index, int type, int levelMin) {
        boolean found = false;
        for (DBLootTableAffixSetAlloc affixSet : this.tableAffixSets) {
            if (affixSet.getIndex() != index || affixSet.getAffixType() != type) continue;
            affixSet.setMinLevel(levelMin);
            found = true;
            break;
        }
        if (!found) {
            DBLootTableAffixSetAlloc affixSet;
            affixSet = new DBLootTableAffixSetAlloc();
            affixSet.setIndex(index);
            affixSet.setAffixType(type);
            affixSet.setMinLevel(levelMin);
            this.tableAffixSets.add(affixSet);
        }
    }

    public void setTableNormalPrefixSuffix(boolean nPre_nSuf) {
        this.nPre_nSuf = nPre_nSuf;
    }

    public void setTableNormalPrefixRareSuffix(boolean nPre_rSuf) {
        this.nPre_rSuf = nPre_rSuf;
    }

    public void setTableRarePrefixNormalSuffix(boolean rPre_nSuf) {
        this.rPre_nSuf = rPre_nSuf;
    }

    public void setTableRarePrefixSuffix(boolean rPre_rSuf) {
        this.rPre_rSuf = rPre_rSuf;
    }

    public void addTableSetTableID(String tableID) {
        boolean found = false;
        for (DBLootTableSetAlloc entry : this.tableSetAllocs) {
            if (entry.getTableID() != null) continue;
            entry.setTableID(tableID);
            found = true;
            break;
        }
        if (!found) {
            DBLootTableSetAlloc entry;
            entry = new DBLootTableSetAlloc();
            entry.setTableID(tableID);
            this.tableSetAllocs.add(entry);
        }
    }

    public void addTableSetMinLevel(int levelMin) {
        boolean found = false;
        for (DBLootTableSetAlloc entry : this.tableSetAllocs) {
            if (entry.getMinLevel() != -1) continue;
            entry.setMinLevel(levelMin);
            found = true;
            break;
        }
        if (!found) {
            DBLootTableSetAlloc entry;
            entry = new DBLootTableSetAlloc();
            entry.setMinLevel(levelMin);
            this.tableSetAllocs.add(entry);
        }
    }

    public void addFormulaSetFormula(String formulaID, String formula) {
        if (formula == null) {
            return;
        }
        if (formula.isEmpty()) {
            return;
        }
        DBFormula dbf = new DBFormula();
        dbf.setFormulaID(formulaID);
        dbf.setFormula(formula);
        this.formulaSetFormulas.add(dbf);
    }

    public void setArmorClass(String armorClass) {
        if (armorClass == null) {
            return;
        }
        if (armorClass.equals("Caster;Light;Heavy;")) {
            return;
        }
        this.armorClass = armorClass;
    }

    public void setArtifactClass(String artifactClass) {
        if (artifactClass == null) {
            return;
        }
        if (artifactClass.equals("Lesser;Greater;Divine;")) {
            return;
        }
        this.artifactClass = artifactClass;
    }

    public void setBitmapID(String bitmapID) {
        this.bitmapID = bitmapID;
    }

    public void setShardBitmapID(String shardBitmapID) {
        this.shardBitmapID = shardBitmapID;
    }

    public void setItemDescriptionTag(String itemDescriptionTag) {
        this.itemDescriptionTag = itemDescriptionTag;
        String s = GDStashFrame.arcList.getTag("tags_items.txt", itemDescriptionTag);
        if (s == null) {
            s = GDStashFrame.arcList.getTag("tags_storyelements.txt", itemDescriptionTag);
        }
        if (s == null) {
            this.itemDescription = null;
            return;
        }
        this.itemDescription = this.insertLineBreaks(s);
    }

    private String insertLineBreaks(String s) {
        String newS = "";
        int len = 0;
        int posBlank = s.indexOf(" ");
        while (posBlank != -1) {
            String word;
            int posBreak = s.indexOf("<br>");
            if (posBreak != -1 && posBreak < posBlank) {
                word = s.substring(0, posBreak + 4);
                s = s.substring(posBreak + 4);
                newS = newS + word;
                len = 0;
            } else {
                word = s.substring(0, posBlank);
                s = s.substring(posBlank + 1);
                newS = newS + word;
                if ((len += word.length()) < 80) {
                    newS = newS + " ";
                } else {
                    newS = newS + "<br>";
                    len = 0;
                }
            }
            posBlank = s.indexOf(" ");
        }
        newS = newS + s;
        return newS;
    }

    public void setItemNameTag(String itemNameTag) {
        this.itemNameTag = itemNameTag;
        String s = GDStashFrame.arcList.getTag("tags_items.txt", itemNameTag);
        if (s == null) {
            s = GDStashFrame.arcList.getTag("tags_storyelements.txt", itemNameTag);
        }
        this.genderCode = -1;
        if (s != null && s.startsWith("[")) {
            String code = s.substring(0, 4);
            s = s.substring(4);
            this.genderCode = ARZDecompress.getGenderCode(code);
        }
        if (this.genderCode == -1) {
            this.genderCode = 0;
        }
        this.itemName = s;
    }

    public void setQualityTag(String qualityTag) {
        this.qualityTag = qualityTag;
    }

    public void setStyleTag(String styleTag) {
        this.styleTag = styleTag;
    }

    public void setItemSetID(String itemSetID) {
        this.itemSetID = itemSetID;
    }

    public void setArtifactID(String artifactID) {
        this.artifactID = artifactID;
    }

    public void setBonusAffixSetID(String bonusAffixSetID) {
        this.bonusAffixSetID = bonusAffixSetID;
    }

    public void setCostFormulaSetID(String costFormulaSetID) {
        this.costFormulaSetID = costFormulaSetID;
    }

    public void setSoulbound(boolean soulbound) {
        this.soulbound = soulbound;
    }

    public void setHidePrefix(boolean hidePrefix) {
        this.hidePrefix = hidePrefix;
    }

    public void setHideSuffix(boolean hideSuffix) {
        this.hideSuffix = hideSuffix;
    }

    public void setQuestItem(boolean questItem) {
        this.questItem = questItem;
    }

    public void setItemLevel(int itemLevel) {
        this.itemLevel = itemLevel;
    }

    public void setPlusAllSkills(int plusAllSkills) {
        this.plusAllSkills = plusAllSkills;
    }

    public void setComponentPieces(int componentPieces) {
        this.componentPieces = componentPieces;
    }

    public void setMaxStackSize(int maxStackSize) {
        this.maxStackSize = maxStackSize;
    }

    public void setSlotAxe1H(boolean slotAxe1H) {
        this.slots.slotAxe1H = slotAxe1H;
    }

    public void setSlotAxe2H(boolean slotAxe2H) {
        this.slots.slotAxe2H = slotAxe2H;
    }

    public void setSlotDagger1H(boolean slotDagger1H) {
        this.slots.slotDagger1H = slotDagger1H;
    }

    public void setSlotMace1H(boolean slotMace1H) {
        this.slots.slotMace1H = slotMace1H;
    }

    public void setSlotMace2H(boolean slotMace2H) {
        this.slots.slotMace2H = slotMace2H;
    }

    public void setSlotScepter1H(boolean slotScepter1H) {
        this.slots.slotScepter1H = slotScepter1H;
    }

    public void setSlotSpear2H(boolean slotSpear2H) {
        this.slots.slotSpear1H = slotSpear2H;
    }

    public void setSlotStaff2H(boolean slotStaff2H) {
        this.slots.slotStaff2H = slotStaff2H;
    }

    public void setSlotSword1H(boolean slotSword1H) {
        this.slots.slotSword1H = slotSword1H;
    }

    public void setSlotSword2H(boolean slotSword2H) {
        this.slots.slotSword2H = slotSword2H;
    }

    public void setSlotRanged1H(boolean slotRanged1H) {
        this.slots.slotRanged1H = slotRanged1H;
    }

    public void setSlotRanged2H(boolean slotRanged2H) {
        this.slots.slotRanged2H = slotRanged2H;
    }

    public void setSlotShield(boolean slotShield) {
        this.slots.slotShield = slotShield;
    }

    public void setSlotOffhand(boolean slotOffhand) {
        this.slots.slotOffhand = slotOffhand;
    }

    public void setSlotAmulet(boolean slotAmulet) {
        this.slots.slotAmulet = slotAmulet;
    }

    public void setSlotBelt(boolean slotBelt) {
        this.slots.slotBelt = slotBelt;
    }

    public void setSlotMedal(boolean slotMedal) {
        this.slots.slotMedal = slotMedal;
    }

    public void setSlotRing(boolean slotRing) {
        this.slots.slotRing = slotRing;
    }

    public void setSlotHead(boolean slotHead) {
        this.slots.slotHead = slotHead;
    }

    public void setSlotShoulders(boolean slotShoulders) {
        this.slots.slotShoulders = slotShoulders;
    }

    public void setSlotChest(boolean slotChest) {
        this.slots.slotChest = slotChest;
    }

    public void setSlotHands(boolean slotHands) {
        this.slots.slotHands = slotHands;
    }

    public void setSlotLegs(boolean slotLegs) {
        this.slots.slotLegs = slotLegs;
    }

    public void setSlotFeet(boolean slotFeet) {
        this.slots.slotFeet = slotFeet;
    }

    public DBStat getCreateDBStat(String search, int index) {
        DBStat dbStat2 = null;
        DBStat first = null;
        boolean found = false;
        int level = index + 1;
        for (DBStat dbStat2 : this.dbStats) {
            if (dbStat2 == null || !dbStat2.getStatType().equals(search)) continue;
            if (first == null) {
                first = dbStat2;
            }
            if (dbStat2.getSkillLevel() != level) continue;
            found = true;
            break;
        }
        if (!found) {
            dbStat2 = first == null ? new DBStat() : first.clone();
            dbStat2.setStatType(search);
            dbStat2.setSkillLevel(level);
            this.dbStats.add(dbStat2);
        }
        return dbStat2;
    }

    public void fillImages(ARCDecompress arc) {
        String fn;
        int pos;
        String s;
        if (this.bitmapID != null && this.bitmap == null) {
            s = null;
            pos = this.bitmapID.indexOf("/");
            if (pos != -1) {
                s = GDConstants.FILE_SEPARATOR + this.bitmapID.substring(0, pos) + ".";
                s = s.toUpperCase(GDConstants.LOCALE_US);
            }
            if ((pos = (fn = arc.getFileName().toUpperCase(GDConstants.LOCALE_US)).indexOf(s)) != -1) {
                this.bitmap = arc.getTexture(this.bitmapID);
            }
        }
        if (this.shardBitmapID != null && this.shardBitmap == null) {
            s = null;
            pos = this.shardBitmapID.indexOf("/");
            if (pos != -1) {
                s = GDConstants.FILE_SEPARATOR + this.shardBitmapID.substring(0, pos) + ".";
                s = s.toUpperCase(GDConstants.LOCALE_US);
            }
            if ((pos = (fn = arc.getFileName().toUpperCase(GDConstants.LOCALE_US)).indexOf(s)) != -1) {
                this.shardBitmap = arc.getTexture(this.shardBitmapID);
            }
        }
    }

    public static boolean processDir(String dir) {
        if (dir.startsWith("records/controllers/itemskills/basetemplates/")) {
            return false;
        }
        if (dir.startsWith("records/creatures/pc/malepc01.dbr")) {
            return true;
        }
        if (dir.startsWith("records/creatures/pc/playerlevels.dbr")) {
            return true;
        }
        if (dir.startsWith("records/creatures/npcs/merchants/")) {
            return true;
        }
        if (dir.startsWith("records/creatures/")) {
            return false;
        }
        if (dir.startsWith("records/default/")) {
            return false;
        }
        if (dir.startsWith("records/fx/")) {
            return false;
        }
        if (dir.startsWith("records/game/old/")) {
            return false;
        }
        if (dir.startsWith("records/game/reqformula031116/")) {
            return false;
        }
        if (dir.startsWith("records/ingameui/")) {
            return false;
        }
        if (dir.startsWith("records/interactive/")) {
            return false;
        }
        if (dir.startsWith("records/items/lootchests/")) {
            return false;
        }
        if (dir.startsWith("records/items/testitems/")) {
            return false;
        }
        if (dir.startsWith("records/items/crafting/crafting_")) {
            return false;
        }
        if (dir.startsWith("records/level art/")) {
            return false;
        }
        if (dir.startsWith("records/proxies/")) {
            return false;
        }
        if (dir.startsWith("records/sandbox/")) {
            return false;
        }
        if (dir.startsWith("records/soundgenerators/")) {
            return false;
        }
        if (dir.startsWith("records/sounds/")) {
            return false;
        }
        if (dir.startsWith("records/terraintextures/")) {
            return false;
        }
        if (dir.startsWith("records/triggervolumes/")) {
            return false;
        }
        if (dir.startsWith("records/ui/skills/devotion/")) {
            return true;
        }
        if (dir.startsWith("records/ui/")) {
            return false;
        }
        if (dir.startsWith("records/ui load tables/")) {
            return false;
        }
        return !dir.startsWith("records/watertype/");
    }

    public static boolean processTemplate(String template) {
        if (template.equals("database/templates/armor_chest.tpl")) {
            return true;
        }
        if (template.equals("database/templates/armor_feet.tpl")) {
            return true;
        }
        if (template.equals("database/templates/armor_hands.tpl")) {
            return true;
        }
        if (template.equals("database/templates/armor_head.tpl")) {
            return true;
        }
        if (template.equals("database/templates/armor_legs.tpl")) {
            return true;
        }
        if (template.equals("database/templates/armor_shoulders.tpl")) {
            return true;
        }
        if (template.equals("database/templates/weapon_axe.tpl")) {
            return true;
        }
        if (template.equals("database/templates/weapon_mace.tpl")) {
            return true;
        }
        if (template.equals("database/templates/weapon_dagger.tpl")) {
            return true;
        }
        if (template.equals("database/templates/weapon_scepter.tpl")) {
            return true;
        }
        if (template.equals("database/templates/weapon_spear.tpl")) {
            return true;
        }
        if (template.equals("database/templates/weapon_staff.tpl")) {
            return true;
        }
        if (template.equals("database/templates/weapon_sword.tpl")) {
            return true;
        }
        if (template.equals("database/templates/weapon_ranged1h.tpl")) {
            return true;
        }
        if (template.equals("database/templates/weapon_ranged2h.tpl")) {
            return true;
        }
        if (template.equals("database/templates/weapon_axe2h.tpl")) {
            return true;
        }
        if (template.equals("database/templates/weapon_mace2h.tpl")) {
            return true;
        }
        if (template.equals("database/templates/weapon_sword2h.tpl")) {
            return true;
        }
        if (template.equals("database/templates/weapon_offhand.tpl")) {
            return true;
        }
        if (template.equals("database/templates/weaponarmor_shield.tpl")) {
            return true;
        }
        if (template.equals("database/templates/jewelry_amulet.tpl")) {
            return true;
        }
        if (template.equals("database/templates/jewelry_medal.tpl")) {
            return true;
        }
        if (template.equals("database/templates/jewelry_ring.tpl")) {
            return true;
        }
        if (template.equals("database/templates/armor_waist.tpl")) {
            return true;
        }
        if (template.equals("database/templates/itemusableskill.tpl")) {
            return true;
        }
        if (template.equals("database/templates/itemtransmuter.tpl")) {
            return true;
        }
        if (template.equals("database/templates/itemartifactformula.tpl")) {
            return true;
        }
        if (template.equals("database/templates/questitem.tpl")) {
            return true;
        }
        if (template.equals("database/templates/oneshot_scroll.tpl")) {
            return true;
        }
        if (template.equals("database/templates/itemenchantment.tpl")) {
            return true;
        }
        if (template.equals("database/templates/itemrelic.tpl")) {
            return true;
        }
        if (template.equals("database/templates/itemartifact.tpl")) {
            return true;
        }
        if (template.equals("database/templates/itemnote.tpl")) {
            return true;
        }
        if (template.equals("database/templates/itemfactionbooster.tpl")) {
            return true;
        }
        if (template.equals("database/templates/itemfactionwarrant.tpl")) {
            return true;
        }
        if (template.equals("database/templates/itemdifficultyunlock.tpl")) {
            return true;
        }
        if (template.equals("database/templates/oneshot_food.tpl")) {
            return true;
        }
        if (template.equals("database/templates/oneshot_potionmana.tpl")) {
            return true;
        }
        if (template.equals("database/templates/oneshot_potionhealth.tpl")) {
            return true;
        }
        if (template.equals("database/templates/itemdevotionreset.tpl")) {
            return true;
        }
        if (template.equals("database/templates/itemset.tpl")) {
            return true;
        }
        if (template.equals("database/templates/lootrandomizer.tpl")) {
            return true;
        }
        if (template.equals("database/templates/lootrandomizertabledynamic.tpl")) {
            return true;
        }
        if (template.equals("database/templates/leveltable.tpl")) {
            return true;
        }
        if (template.equals("database/templates/lootitemtable_dynweighted_dynaffix.tpl")) {
            return true;
        }
        if (template.startsWith("database/templates/skill")) {
            return true;
        }
        if (template.equals("database/templates/pet.tpl")) {
            return true;
        }
        if (template.equals("database/templates/monster.tpl")) {
            return true;
        }
        if (template.equals("database/templates/petbonus.tpl")) {
            return true;
        }
        if (template.equals("database/templates/petplayerscaling.tpl")) {
            return true;
        }
        if (template.equals("database/templates/fixeditemskill_buff.tpl")) {
            return true;
        }
        if (template.equals("database/templates/factionpack.tpl")) {
            return true;
        }
        if (template.equals("database/templates/npcmerchant.tpl")) {
            return true;
        }
        if (template.equals("database/templates/factionmarket.tpl")) {
            return true;
        }
        if (template.equals("database/templates/factiontier.tpl")) {
            return true;
        }
        if (template.equals("database/templates/gameengine.tpl")) {
            return true;
        }
        if (template.equals("database/templates/itemcost.tpl")) {
            return true;
        }
        if (template.equals("database/templates/player.tpl")) {
            return true;
        }
        if (template.equals("database/templates/experiencelevelcontrol.tpl")) {
            return true;
        }
        if (template.equals("database/templates/ingameui/devotionconstellation.tpl")) {
            return true;
        }
        return template.equals("database/templates/ingameui/skillbutton.tpl");
    }

    public static boolean processFile(String filename, String template) {
        if (template.equals("database/templates/gameengine.tpl")) {
            return filename.equals("records/game/gameengine.dbr");
        }
        return true;
    }

    public boolean isGameEngine() {
        return this.fileName.equals("records/game/gameengine.dbr");
    }

    public boolean isFaction() {
        if (this.template == null) {
            return true;
        }
        return this.template.equals("database/templates/factionpack.tpl");
    }

    public boolean isMerchant() {
        if (this.template == null) {
            return true;
        }
        return this.template.equals("database/templates/npcmerchant.tpl");
    }

    public boolean isMerchantTableSet() {
        if (this.template == null) {
            return true;
        }
        if (this.template.equals("database/templates/npcmerchant.tpl")) {
            return true;
        }
        if (this.template.equals("database/templates/factionmarket.tpl")) {
            return true;
        }
        return this.template.equals("database/templates/factiontier.tpl");
    }

    public boolean isMerchantTable() {
        if (this.template == null) {
            return true;
        }
        return this.template.equals("database/templates/factiontier.tpl");
    }

    public boolean isPlayerEngine() {
        if (this.fileName.equals("records/creatures/pc/playerlevels.dbr")) {
            return true;
        }
        return this.fileName.equals("records/creatures/pc/malepc01.dbr");
    }

    public boolean isConstellation() {
        if (this.template == null) {
            return true;
        }
        return this.template.equals("database/templates/ingameui/devotionconstellation.tpl");
    }

    public boolean isSkillButton() {
        if (this.template == null) {
            return true;
        }
        return this.template.equals("database/templates/ingameui/skillbutton.tpl");
    }

    public boolean isSkill() {
        if (this.template == null) {
            return true;
        }
        if (this.template.startsWith("database/templates/skill")) {
            return true;
        }
        if (this.template.equals("database/templates/pet.tpl")) {
            return true;
        }
        if (this.template.equals("database/templates/monster.tpl")) {
            return true;
        }
        if (this.template.equals("database/templates/petbonus.tpl") && !this.fileName.startsWith("records/items/lootaffixes/")) {
            return true;
        }
        if (this.template.equals("database/templates/petplayerscaling.tpl")) {
            return true;
        }
        return this.template.equals("database/templates/fixeditemskill_buff.tpl");
    }

    public boolean isAffix() {
        if (this.template == null) {
            return true;
        }
        if (this.template.equals("database/templates/lootrandomizer.tpl")) {
            return true;
        }
        return this.template.equals("database/templates/petbonus.tpl") && this.fileName.startsWith("records/items/lootaffixes/");
    }

    public boolean isAffixSet() {
        if (this.template == null) {
            return true;
        }
        return this.template.equals("database/templates/lootrandomizertabledynamic.tpl");
    }

    public boolean isFormulaSet() {
        if (this.template == null) {
            return true;
        }
        return this.template.equals("database/templates/itemcost.tpl");
    }

    public boolean isItemSet() {
        if (this.template == null) {
            return true;
        }
        return this.template.equals("database/templates/itemset.tpl");
    }

    public boolean isLootTable() {
        if (this.template == null) {
            return true;
        }
        return this.template.equals("database/templates/lootitemtable_dynweighted_dynaffix.tpl");
    }

    public boolean isLootTableSet() {
        if (this.template == null) {
            return true;
        }
        return this.template.equals("database/templates/leveltable.tpl");
    }

    public static class ImageTag {
        public String tagName;
        public String imageID;
    }
}

