/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.file;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.gdstash.file.DDSHeader;
import org.gdstash.file.DDSReader;
import org.gdstash.file.GDParseException;
import org.gdstash.file.GDReader;
import org.gdstash.file.TEXHeader;
import org.gdstash.util.GDMsgFormatter;
import org.gdstash.util.GDMsgLogger;

public class DDSLoader {
    public static void load(String filename) {
        File file = new File(filename);
        if (!file.exists()) {
            return;
        }
        if (!file.isFile()) {
            return;
        }
        int len = (int)file.length();
        byte[] bytes = new byte[len];
        try {
            BufferedInputStream reader = new BufferedInputStream(new FileInputStream(file));
            ((InputStream)reader).read(bytes, 0, len);
            DDSLoader.getImage(bytes);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        catch (GDParseException gDParseException) {
            // empty catch block
        }
    }

    public static BufferedImage getImage(byte[] bytes) throws GDParseException {
        BufferedImage image = null;
        try {
            TEXHeader texHdr = DDSLoader.getTEXHeader(bytes);
            byte[] ddsBytes = DDSLoader.getDDSBytes(bytes, texHdr);
            DDSHeader ddsHdr = DDSLoader.getDDSHeader(ddsBytes);
            DDSLoader.fixDDSHeader(ddsBytes, ddsHdr);
            int[] pixels = DDSReader.read(ddsBytes, DDSReader.ARGB, 0);
            int width = DDSReader.getWidth(ddsBytes);
            int height = DDSReader.getHeight(ddsBytes);
            image = new BufferedImage(width, height, 2);
            image.setRGB(0, 0, width, height, pixels, 0, width);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            image = null;
        }
        return image;
    }

    public static BufferedImage getScaledImage(BufferedImage image, int w, int h) {
        int finalW = w;
        int finalH = h;
        double factor = 1.0;
        if (image.getWidth() > image.getHeight()) {
            factor = (double)image.getHeight() / (double)image.getWidth();
            finalH = (int)((double)finalW * factor);
        } else {
            factor = (double)image.getWidth() / (double)image.getHeight();
            finalW = (int)((double)finalH * factor);
        }
        BufferedImage imgResized = new BufferedImage(finalW, finalH, 3);
        Graphics2D g2 = imgResized.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(image, 0, 0, finalW, finalH, null);
        g2.dispose();
        return imgResized;
    }

    private static TEXHeader getTEXHeader(byte[] bytes) throws GDParseException {
        TEXHeader header = new TEXHeader();
        header.version = GDReader.getBytes4(bytes, 0);
        header.unknown = GDReader.getUInt(bytes, 4);
        header.size = GDReader.getUInt(bytes, 8);
        if (header.version[3] > 2) {
            throw new GDParseException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_VERSION"), 0L);
        }
        return header;
    }

    private static byte[] getDDSBytes(byte[] bytes, TEXHeader texHdr) {
        byte[] b = GDReader.getBytes(bytes, 12, texHdr.size);
        return b;
    }

    private static DDSHeader getDDSHeader(byte[] bytes) throws GDParseException {
        DDSHeader header = new DDSHeader();
        int offset = 0;
        header.version = GDReader.getBytes4(bytes, offset);
        header.size = GDReader.getUInt(bytes, offset += 4);
        offset += 4;
        if (header.size != 124) {
            throw new GDParseException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_HD_SIZE"), 0L);
        }
        header.flags = GDReader.getUInt(bytes, offset);
        header.height = GDReader.getUInt(bytes, offset += 4);
        header.width = GDReader.getUInt(bytes, offset += 4);
        header.linearSize = GDReader.getUInt(bytes, offset += 4);
        header.depth = GDReader.getUInt(bytes, offset += 4);
        header.num_mipmap = GDReader.getUInt(bytes, offset += 4);
        offset += 4;
        for (int i = 0; i < header.reserved1.length; ++i) {
            header.reserved1[i] = GDReader.getUInt(bytes, offset);
            offset += 4;
        }
        header.pixelFormat.size = GDReader.getUInt(bytes, offset);
        offset += 4;
        if (header.pixelFormat.size != 32) {
            throw new GDParseException(GDMsgFormatter.getString(GDMsgFormatter.rbMsg, "ERR_UNSUPPORTED_PIX_SIZE"), 0L);
        }
        header.pixelFormat.flags = GDReader.getUInt(bytes, offset);
        header.pixelFormat.fourCC = GDReader.getUInt(bytes, offset += 4);
        header.pixelFormat.rgbBitCount = GDReader.getUInt(bytes, offset += 4);
        header.pixelFormat.rBitMask = GDReader.getUInt(bytes, offset += 4);
        header.pixelFormat.gBitMask = GDReader.getUInt(bytes, offset += 4);
        header.pixelFormat.bBitMask = GDReader.getUInt(bytes, offset += 4);
        header.pixelFormat.aBitMask = GDReader.getUInt(bytes, offset += 4);
        header.caps = GDReader.getUInt(bytes, offset += 4);
        header.caps2 = GDReader.getUInt(bytes, offset += 4);
        header.caps3 = GDReader.getUInt(bytes, offset += 4);
        header.caps4 = GDReader.getUInt(bytes, offset += 4);
        header.reserved2 = GDReader.getUInt(bytes, offset += 4);
        offset += 4;
        return header;
    }

    private static void fixDDSHeader(byte[] bytes, DDSHeader header) {
        if (header.version[3] == 82) {
            bytes[3] = 32;
        }
        int flags = header.flags | 1 | 2 | 4 | 0x1000;
        int caps = header.caps | 0x1000;
        if (header.num_mipmap > 1) {
            header.flags |= 0x20000;
            header.caps = header.caps | 8 | 0x400000;
        }
        if ((header.caps2 & 0x200) != 0) {
            caps |= 8;
        }
        if (header.depth > 1) {
            flags |= 0x800000;
            caps |= 8;
        }
        if ((header.pixelFormat.flags & 4) != 0 && header.linearSize != 0) {
            flags |= 0x80000;
        }
        if (((header.pixelFormat.flags & 0x40) == 64 || (header.pixelFormat.flags & 0x200) == 512 || (header.pixelFormat.flags & 0x20000) == 131072 || (header.pixelFormat.flags & 2) == 2) && header.linearSize != 0) {
            flags |= 8;
        }
        DDSLoader.writeBytes(bytes, 8, flags);
        DDSLoader.writeBytes(bytes, 80, header.pixelFormat.flags);
        DDSLoader.writeBytes(bytes, 92, 0xFF0000);
        DDSLoader.writeBytes(bytes, 96, 65280);
        DDSLoader.writeBytes(bytes, 100, 255);
        DDSLoader.writeBytes(bytes, 104, 255);
        DDSLoader.writeBytes(bytes, 108, caps);
    }

    private static void writeBytes(byte[] bytes, int offset, byte[] value) {
        for (int i = 0; i < value.length; ++i) {
            bytes[i + offset] = value[i];
        }
    }

    private static void writeBytes(byte[] bytes, int offset, int value) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(0, value);
        byte[] b = buffer.array();
        DDSLoader.writeBytes(bytes, offset, b);
    }

    private static void writeFile(String filename, byte[] data) {
        int pos = 0;
        pos = filename.lastIndexOf(".");
        if (pos == -1) {
            return;
        }
        String ddsname = filename.substring(0, pos) + ".dds";
        File file = new File(ddsname);
        try {
            file.createNewFile();
            FileOutputStream writer = new FileOutputStream(file);
            writer.write(data);
            writer.flush();
            writer.close();
        }
        catch (IOException ex) {
            GDMsgLogger.addError(ex);
        }
    }
}

