/*
 * Decompiled with CFR 0.152.
 */
package org.gdstash.file;

import java.io.IOException;
import org.gdstash.file.ARZString;
import org.gdstash.file.GDBuffer;

public abstract class GDAbstractBuffer
implements GDBuffer {
    @Override
    public byte[] getByteArray(int pos, int length) throws IOException {
        this.setPosition(pos);
        return this.getByteArray(length);
    }

    @Override
    public byte[] getBytes8() throws IOException {
        return this.getByteArray(8);
    }

    @Override
    public String getString(int len) throws IOException {
        if (len <= 0) {
            return "";
        }
        byte[] bytes = this.getByteArray(len);
        StringBuilder sb = new StringBuilder(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            sb.append((char)bytes[i]);
        }
        return sb.toString();
    }

    @Override
    public String getStringLB() throws IOException {
        byte len = this.getByte();
        return this.getString(len);
    }

    @Override
    public String getStringNT() throws IOException {
        StringBuilder sb = new StringBuilder(256);
        byte b = this.getByte();
        while (b != 0) {
            sb.append((char)b);
            b = this.getByte();
        }
        return sb.toString();
    }

    @Override
    public ARZString getARZString() throws IOException {
        ARZString str = new ARZString();
        str.len = this.getInt();
        str.str = this.getString(str.len);
        return str;
    }

    public static String bytesToString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            sb.append((char)bytes[i]);
        }
        return sb.toString();
    }
}

